/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.Container;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

public class IndexButtonGroup {
    private But[] bm;
    private int bs;
    private ButtonGroup g = null;
    private boolean bitwise;
    private ActionListener a;

    public IndexButtonGroup(int s, boolean exclusive, boolean bitwise, ActionListener a) {
        if (exclusive || !bitwise) {
            this.g = new ButtonGroup();
        }
        this.bm = new But[s];
        this.bs = 0;
        this.bitwise = bitwise;
        this.a = a;
    }

    public IndexButtonGroup(int s, boolean exclusive, boolean bitwise) {
        this(s, exclusive, bitwise, null);
    }

    public IndexButtonGroup(int s, boolean exclusive) {
        this(s, exclusive, true, null);
    }

    public IndexButtonGroup(int s) {
        this(s, true, true, null);
    }

    public void add(AbstractButton b, int value) {
        if (this.g != null) {
            this.g.add(b);
        }
        this.bm[this.bs++] = new But(b, value);
        if (this.a != null) {
            b.addActionListener(this.a);
        }
    }

    public void add(AbstractButton b) {
        if (this.bitwise) {
            this.add(b, 1 << this.bs);
        } else {
            this.add(b, this.bs);
        }
    }

    public int getValue() {
        int value = 0;
        But[] butArray = this.bm;
        int n = this.bm.length;
        int n2 = 0;
        while (n2 < n) {
            But b = butArray[n2];
            if (b.b.isSelected()) {
                value |= b.i;
            }
            ++n2;
        }
        return value;
    }

    public void setValue(int value) {
        But[] butArray = this.bm;
        int n = this.bm.length;
        int n2 = 0;
        while (n2 < n) {
            But b = butArray[n2];
            if (this.bitwise) {
                if ((b.i & value) != 0) {
                    b.b.setSelected(true);
                }
            } else if (b.i == value) {
                b.b.setSelected(true);
                return;
            }
            ++n2;
        }
    }

    public void populate(Container c) {
        But[] butArray = this.bm;
        int n = this.bm.length;
        int n2 = 0;
        while (n2 < n) {
            But b = butArray[n2];
            c.add(b.b);
            ++n2;
        }
    }

    private class But {
        AbstractButton b;
        int i;

        But(AbstractButton b, int i) {
            this.b = b;
            this.i = i;
        }
    }
}

