/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreePath;
import org.lateralgm.components.GmTreeGraphics;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.main.Prefs;

public class GmTreeEditor
extends DefaultTreeCellEditor {
    public GmTreeEditor(JTree tree, GmTreeGraphics renderer) {
        super(tree, renderer);
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        ResNode node;
        if (event != null && event.getSource() instanceof JTree && event instanceof MouseEvent) {
            TreePath path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY());
            if (path != null && path.getPathCount() <= 2 && !Prefs.renamableRoots) {
                return false;
            }
        } else if (event == null && (node = (ResNode)this.tree.getLastSelectedPathComponent()) != null) {
            if (Prefs.renamableRoots) {
                return true;
            }
            if (node.status != 1) {
                return node.isEditable();
            }
            return false;
        }
        return super.isCellEditable(event);
    }

    @Override
    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.renderer != null) {
            GmTreeGraphics g = (GmTreeGraphics)this.renderer;
            this.editingIcon = g.getNodeIcon(value, expanded, leaf);
            this.offset = this.renderer.getIconTextGap();
            if (this.editingIcon != null) {
                this.offset += this.editingIcon.getIconWidth();
            }
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }
}

