/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JFrame;
import org.lateralgm.main.PrefsStore;

public class FramePrefsHandler
implements ComponentListener,
WindowStateListener {
    private final JFrame frame;

    public FramePrefsHandler(JFrame frame) {
        this.frame = frame;
        frame.pack();
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setBounds(PrefsStore.getWindowBounds(frame.getBounds()));
        int state = frame.getExtendedState() | (PrefsStore.getWindowMaximized() ? 6 : 0);
        frame.setExtendedState(state);
        frame.addComponentListener(this);
        frame.addWindowStateListener(this);
    }

    private boolean isMaximized() {
        return (this.frame.getExtendedState() & 6) == 6;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (!this.isMaximized()) {
            PrefsStore.setWindowBounds(this.frame.getBounds());
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (!this.isMaximized()) {
            PrefsStore.setWindowBounds(this.frame.getBounds());
        }
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        PrefsStore.setWindowMaximized(this.isMaximized());
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

