/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import javax.swing.tree.DefaultMutableTreeNode;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.sub.Event;

public class EventNode
extends DefaultMutableTreeNode
implements Transferable {
    private static final long serialVersionUID = -8464210873818954481L;
    public static DataFlavor DATA_FLAVOR;
    public static final DataFlavor[] flavors;
    public int mainId;
    public int eventId;
    public ResourceReference<GmObject> other;

    static {
        try {
            DATA_FLAVOR = Util.createJVMLocalDataFlavor(EventNode.class);
        }
        catch (ClassNotFoundException e) {
            LGM.showDefaultExceptionHandler(e);
        }
        flavors = new DataFlavor[]{DATA_FLAVOR};
    }

    public EventNode(String text) {
        this(text, -1, 0);
    }

    public EventNode(int mainId) {
        this(Messages.getString("MainEvent.EVENT" + mainId), mainId, 0);
    }

    public EventNode(String text, int mainId, int eventId) {
        this.setUserObject(text);
        this.mainId = mainId;
        this.eventId = eventId;
    }

    public EventNode(int mainId, ResourceReference<GmObject> other) {
        GmObject r = Util.deRef(other);
        this.setUserObject(r == null ? "" : r.getName());
        this.mainId = mainId;
        this.other = other;
    }

    public void add(int mainId, int eventId) {
        this.add(new EventNode(Event.eventName(mainId, eventId), mainId, eventId));
    }

    public void add(int mainId, ResourceReference<GmObject> other) {
        this.add(new EventNode(mainId, other));
    }

    public void add(int mainId) {
        this.add(new EventNode(Messages.getString("MainEvent.EVENT" + mainId), mainId, 0));
    }

    public boolean isValid() {
        switch (this.mainId) {
            case 5: 
            case 9: 
            case 10: {
                return Event.KEYS.containsKey(this.eventId);
            }
            case 4: {
                return this.other != null;
            }
        }
        return true;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor != DATA_FLAVOR) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DATA_FLAVOR);
    }
}

