/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.lateralgm.main.Util;
import org.lateralgm.util.PropertyEditor;
import org.lateralgm.util.PropertyLink;
import org.lateralgm.util.PropertyMap;

public class EditorScrollPane
extends JScrollPane
implements PropertyEditor<Integer> {
    private static final long serialVersionUID = 1L;
    private ScrollLink<?> link;

    public EditorScrollPane() {
        this(null);
    }

    public EditorScrollPane(Component view) {
        super(view);
        this.verticalScrollBar.setUnitIncrement(16);
        this.verticalScrollBar.setBlockIncrement(64);
        this.horizontalScrollBar.setUnitIncrement(16);
        this.horizontalScrollBar.setBlockIncrement(64);
    }

    public EditorScrollPane(Component view, boolean transparencyBackground) {
        this(transparencyBackground ? null : view);
        if (transparencyBackground) {
            this.createTransparencyViewport(view);
        }
    }

    public void createTransparencyViewport(Component view) {
        JViewport viewport = new JViewport(){
            private static final long serialVersionUID = -488286791453210520L;
            private BufferedImage componentBackground = null;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                int width = (int)Math.ceil((float)this.getWidth() / 16.0f);
                int height = (int)Math.ceil((float)this.getHeight() / 16.0f);
                width = width < 1 ? 1 : width;
                int n = height = height < 1 ? 1 : height;
                if (this.componentBackground == null || this.componentBackground.getWidth() != width | this.componentBackground.getHeight() != height) {
                    this.componentBackground = Util.paintBackground(width, height);
                }
                g.drawImage(this.componentBackground, 0, 0, this.componentBackground.getWidth() * 16, this.componentBackground.getHeight() * 16, null);
            }
        };
        viewport.setView(view);
        this.setViewport(viewport);
    }

    @Override
    public void processMouseWheelEvent(MouseWheelEvent e) {
        if (this.link != null && e.isControlDown()) {
            ((ScrollLink)this.link).scroll(~e.getWheelRotation() >> 31 | 1);
        } else if (e.isShiftDown() || this.horizontalScrollBar.getMousePosition() != null) {
            int a = e.getScrollType() == 1 ? e.getWheelRotation() * this.horizontalScrollBar.getBlockIncrement() : e.getUnitsToScroll() * this.horizontalScrollBar.getUnitIncrement();
            this.horizontalScrollBar.setValue(this.horizontalScrollBar.getValue() + a);
        } else {
            super.processMouseWheelEvent(e);
        }
    }

    @Override
    public <K extends Enum<K>> PropertyLink<K, Integer> getLink(PropertyMap<K> m, K k) {
        return new ScrollLink(this, m, k);
    }

    private static class ScrollLink<K extends Enum<K>>
    extends PropertyLink<K, Integer> {
        final /* synthetic */ EditorScrollPane this$0;

        public ScrollLink(PropertyMap<K> m, K k) {
            this.this$0 = var1_1;
            super(m, k);
            this.reset();
            ((EditorScrollPane)var1_1).link = this;
        }

        @Override
        protected void setComponent(Integer i) {
        }

        @Override
        public void remove() {
            super.remove();
            if (this.this$0.link == this) {
                this.this$0.link = null;
            }
        }

        private void scroll(int i) {
            int v = (Integer)this.map.get(this.key);
            this.editProperty(v + i);
        }
    }
}

