/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;

public class DocumentUndoManager
extends UndoManager
implements CaretListener {
    private static final long serialVersionUID = 1L;
    protected final AbstractAction undoAction = new AbstractAction(Messages.getString("DocumentUndoManager.UNDO"), LGM.getIconForKey("DocumentUndoManager.UNDO")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            DocumentUndoManager.this.endGroupEdit();
            try {
                DocumentUndoManager.this.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            DocumentUndoManager.this.updateActions();
        }
    };
    protected final AbstractAction redoAction = new AbstractAction(Messages.getString("DocumentUndoManager.REDO"), LGM.getIconForKey("DocumentUndoManager.REDO")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                DocumentUndoManager.this.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            DocumentUndoManager.this.updateActions();
        }
    };
    protected int caretUpdates = 0;
    protected MarkerEdit modifiedMarker;

    public DocumentUndoManager() {
        this.resetModifiedMarker();
        this.updateActions();
    }

    public void resetModifiedMarker() {
        if (this.modifiedMarker != null) {
            this.modifiedMarker.die();
        }
        this.modifiedMarker = new MarkerEdit();
        super.addEdit(this.modifiedMarker);
    }

    public boolean isModified() {
        this.modifiedMarker.significant = true;
        boolean result = this.editToBeUndone() != this.modifiedMarker;
        this.modifiedMarker.significant = false;
        return result;
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        UndoableEdit le = this.lastEdit();
        try {
            GroupEdit ge;
            if (le instanceof GroupEdit && (ge = (GroupEdit)le).addEdit(anEdit)) {
                return true;
            }
            this.endGroupEdit();
            ge = new GroupEdit();
            if (ge.addEdit(anEdit) && super.addEdit(ge)) {
                return true;
            }
            boolean bl = super.addEdit(anEdit);
            return bl;
        }
        finally {
            this.updateActions();
        }
    }

    public void endGroupEdit() {
        UndoableEdit le = this.lastEdit();
        if (le instanceof GroupEdit) {
            ((GroupEdit)le).end();
        }
    }

    public void updateActions() {
        this.undoAction.setEnabled(this.canUndo());
        this.redoAction.setEnabled(this.canRedo());
    }

    public AbstractAction getRedoAction() {
        return this.redoAction;
    }

    public AbstractAction getUndoAction() {
        return this.undoAction;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.caretUpdates > 0) {
            this.endGroupEdit();
        }
        ++this.caretUpdates;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.caretUpdates = 0;
        this.addEdit(e.getEdit());
    }

    private class GroupEdit
    extends CompoundEdit {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canUndo() {
            return this.edits.size() == 0 || this.edits.lastElement() != null && ((UndoableEdit)this.edits.lastElement()).canUndo() || super.canUndo();
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            UndoableEdit le = this.lastEdit();
            if (!(anEdit instanceof AbstractDocument.DefaultDocumentEvent)) {
                return false;
            }
            AbstractDocument.DefaultDocumentEvent dde2 = (AbstractDocument.DefaultDocumentEvent)anEdit;
            DocumentEvent.EventType et = dde2.getType();
            if (le != null) {
                AbstractDocument.DefaultDocumentEvent dde1 = (AbstractDocument.DefaultDocumentEvent)le;
                if (dde1.getType().equals(et)) {
                    int o1 = dde1.getOffset();
                    int o2 = dde2.getOffset();
                    int l1 = dde1.getLength();
                    int l2 = dde2.getLength();
                    if (et.equals(DocumentEvent.EventType.INSERT) && o2 == o1 + l1) {
                        return super.addEdit(anEdit);
                    }
                    if (et.equals(DocumentEvent.EventType.REMOVE) && (o2 == o1 + l1 || o1 == o2 + l2)) {
                        return super.addEdit(anEdit);
                    }
                }
            } else if (et.equals(DocumentEvent.EventType.INSERT) || et.equals(DocumentEvent.EventType.REMOVE)) {
                return super.addEdit(anEdit);
            }
            return false;
        }
    }

    private class MarkerEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 1L;
        protected boolean significant = false;

        @Override
        public boolean isSignificant() {
            return this.significant;
        }
    }
}

