/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;
import org.lateralgm.main.Util;

public class CustomFileFilter
extends FileFilter
implements FilenameFilter {
    private ArrayList<String> ext = new ArrayList();
    private String desc;

    public static String getExtension(String filename) {
        int p = filename.lastIndexOf(".");
        if (p == -1) {
            return null;
        }
        return filename.substring(p).toLowerCase(Locale.ENGLISH);
    }

    public CustomFileFilter(String desc, String ... ext) {
        this.desc = desc;
        String[] stringArray = ext;
        int n = ext.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element != null) {
                this.ext.add(element);
            }
            ++n2;
        }
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return this.accept(f, f.getPath());
    }

    @Override
    public boolean accept(File dir, String name) {
        if (this.ext.size() == 0) {
            return true;
        }
        for (String e : this.ext) {
            if (!Util.stringEndsWith(name, e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public String[] getExtensions() {
        return this.ext.toArray(new String[0]);
    }
}

