/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Component;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.TransferHandler;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.components.visual.AbstractImagePreview;
import org.lateralgm.components.visual.ImageToolTip;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Listener;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.util.PropertyEditor;
import org.lateralgm.util.PropertyLink;
import org.lateralgm.util.PropertyMap;

public class ResourceMenu<R extends Resource<R, ?>>
extends JPanel
implements ActionListener,
UpdateSource.UpdateListener,
PropertyEditor<ResourceReference<R>> {
    private static final long serialVersionUID = 1L;
    private JLabel label;
    private JButton button;
    protected ResourceReference<R> selected;
    protected JPopupMenu pm;
    public JMenuItem noResource;
    protected String defStr;
    protected boolean onlyOpen;
    private ActionEvent actionEvent;
    protected Class<? extends Resource<?, ?>> kind;
    private MListener mListener = new MListener();
    protected static final ImageIcon GROUP_ICO = LGM.getIconForKey("GmTreeGraphics.GROUP");
    private final Preview rPreview;
    private final MenuBuilder builder = new MenuBuilder();

    public ResourceMenu(Class<? extends Resource<?, ?>> kind, String def, boolean showDef, int width, boolean onlyOpen, boolean preview) {
        this.setTransferHandler(new ResourceTransferHandler(this));
        this.kind = kind;
        this.onlyOpen = onlyOpen;
        this.defStr = def;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.label = new JLabel(def);
        this.label.setBorder(BorderFactory.createEtchedBorder(1));
        this.label.addMouseListener(this.mListener);
        this.button = new JButton(ResNode.ICON.get(kind));
        this.button.addMouseListener(this.mListener);
        this.button.setMaximumSize(this.button.getPreferredSize());
        int freeWidth = width - (preview ? 40 : 20);
        this.rPreview = preview ? new Preview() : null;
        GroupLayout.SequentialGroup hg = layout.createSequentialGroup();
        GroupLayout.ParallelGroup vg = layout.createParallelGroup(GroupLayout.Alignment.CENTER, false);
        if (preview) {
            hg.addComponent(this.rPreview, -2, 20, -2);
            vg.addComponent(this.rPreview, -2, 20, -2);
        }
        layout.setHorizontalGroup(hg.addComponent(this.label, -2, freeWidth, Integer.MAX_VALUE).addComponent(this.button, -2, 22, -2));
        layout.setVerticalGroup(vg.addComponent(this.label, -2, 20, -2).addComponent(this.button, -2, 22, -2));
        this.pm = new JPopupMenu();
        if (showDef) {
            this.noResource = this.pm.add(new JMenuItem(def));
            this.noResource.addActionListener(this);
        }
        this.populate(kind);
        LGM.root.updateSource.addListener(this);
    }

    public ResourceMenu(Class<? extends Resource<?, ?>> kind, String def, boolean showDef, int width) {
        this(kind, def, showDef, width, false, ResourceMenu.canPreview(kind));
    }

    public ResourceMenu(Class<? extends Resource<?, ?>> kind, String def, int width) {
        this(kind, def, true, width, false, ResourceMenu.canPreview(kind));
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.label.getBaseline(width, height);
    }

    public static boolean canPreview(Class<? extends Resource<?, ?>> kind) {
        Class<?>[] classArray = kind.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            if (i == Resource.Viewable.class) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void populate(Class<? extends Resource<?, ?>> kind) {
        if (Prefs.groupKind) {
            int m = 0;
            while (m < LGM.root.getChildCount()) {
                ResNode group = (ResNode)LGM.root.getChildAt(m);
                if (group.kind == kind) {
                    this.populate(this.pm, group, kind);
                    return;
                }
                ++m;
            }
        }
        this.populate(this.pm, LGM.root, kind);
    }

    private void populate(JComponent parent, ResNode group, Class<? extends Resource<?, ?>> kind) {
        int i = 0;
        while (i < group.getChildCount()) {
            JMenuItem newParent;
            ResNode child = (ResNode)group.getChildAt(i);
            if (child.status != 3) {
                newParent = child.getChildCount() == 0 ? new ResourceMenuItem(child) : new ResourceJMenu(child);
                newParent.setIcon(GROUP_ICO);
                parent.add(newParent);
                this.populate(newParent, child, kind);
            } else if (child.kind == kind) {
                newParent = new ResourceMenuItem(child);
                newParent.addActionListener(this);
                parent.add(newParent);
            }
            ++i;
        }
    }

    public void addActionListener(ActionListener il) {
        this.listenerList.add(ActionListener.class, il);
    }

    public void removeActionListener(ActionListener il) {
        this.listenerList.remove(ActionListener.class, il);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ActionListener.class) {
                if (this.actionEvent == null) {
                    this.actionEvent = new ActionEvent(this, 1001, "");
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(this.actionEvent);
            }
            i -= 2;
        }
    }

    public void showPopup(Component c, int x, int y) {
        if (this.pm.getComponentCount() == 0) {
            return;
        }
        this.pm.show(c, x, y);
    }

    public ResourceReference<R> getSelected() {
        return this.selected;
    }

    public void setSelected(ResourceReference<R> res) {
        this.selected = res;
        R r = Util.deRef(res);
        this.label.setText(r == null ? this.defStr : ((Resource)r).getName());
        if (this.rPreview != null) {
            this.rPreview.setResource(res);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.button.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source instanceof ResourceMenuItem) {
            this.setSelected(((ResourceMenuItem)source).node.getRes());
        } else {
            this.setSelected(null);
        }
        this.fireActionPerformed();
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        Util.invokeOnceLater(this.builder);
    }

    @Override
    public <K extends Enum<K>> PropertyLink<K, ResourceReference<R>> getLink(PropertyMap<K> m, K k) {
        return new ResourceMenuLink(this, m, k);
    }

    private class MListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (!ResourceMenu.this.isEnabled()) {
                return;
            }
            if (ResourceMenu.this.pm.getComponentCount() == 0) {
                return;
            }
            ResourceMenu.this.showPopup(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class MenuBuilder
    implements Runnable {
        private MenuBuilder() {
        }

        @Override
        public void run() {
            ResourceMenu.this.pm.removeAll();
            if (ResourceMenu.this.noResource != null) {
                ResourceMenu.this.pm.add(ResourceMenu.this.noResource);
            }
            ResourceMenu.this.populate(ResourceMenu.this.kind);
            if (ResourceMenu.this.selected == null || !Listener.getPrimaryParent(ResourceMenu.this.kind).contains(ResourceMenu.this.selected)) {
                ResourceMenu.this.setSelected(null);
            }
            ResourceMenu.this.setSelected(ResourceMenu.this.selected);
        }
    }

    public static class Preview
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private BufferedImage displayImage;

        public Preview() {
            this.setToolTipText(new String());
        }

        public <R extends Resource<R, ?>> void setResource(ResourceReference<R> r) {
            R res = Util.deRef(r);
            if (res == null || !(res instanceof Resource.Viewable)) {
                this.displayImage = null;
                this.setIcon(null);
                return;
            }
            this.displayImage = ((Resource.Viewable)res).getDisplayImage();
            ResNode rn = ((Resource)res).getNode();
            this.setIcon(rn == null ? null : rn.getIcon());
        }

        @Override
        public JToolTip createToolTip() {
            return new ImageToolTip(new AbstractImagePreview(){
                private static final long serialVersionUID = 1L;

                @Override
                public BufferedImage getImage() {
                    return Preview.this.displayImage;
                }
            });
        }
    }

    public class ResourceJMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;
        public ResNode node;

        public ResourceJMenu(ResNode node) {
            super(node.getUserObject().toString());
            this.node = node;
            node.updateSource.addListener(ResourceMenu.this);
        }

        public void update() {
            this.setText(this.node.getUserObject().toString());
            ResourceMenu.this.setSelected(ResourceMenu.this.selected);
        }

        @Override
        public boolean isVisible() {
            return !ResourceMenu.this.onlyOpen || this.hasVisibleChildren();
        }

        private boolean hasVisibleChildren() {
            int i = 0;
            while (i < this.getPopupMenu().getComponentCount()) {
                if (this.getPopupMenu().getComponent(i).isVisible()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public class ResourceMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        public ResNode node;

        public ResourceMenuItem(ResNode node) {
            super(node.getUserObject().toString());
            this.node = node;
            node.updateSource.addListener(ResourceMenu.this);
            this.setIcon(node.getIcon());
        }

        @Override
        public void setIcon(Icon ico) {
            super.setIcon(ico == null ? GROUP_ICO : ico);
        }

        public void update() {
            this.setIcon(this.node.getIcon());
            this.setText(this.node.getUserObject().toString());
            if (ResourceMenu.this.selected == this.node.getRes()) {
                ResourceMenu.this.setSelected(ResourceMenu.this.selected);
            }
        }

        @Override
        public boolean isVisible() {
            return !ResourceMenu.this.onlyOpen || this.node.frame != null;
        }
    }

    private static class ResourceMenuLink<K extends Enum<K>>
    extends PropertyLink<K, ResourceReference<R>>
    implements ActionListener {
        final /* synthetic */ ResourceMenu this$0;

        public ResourceMenuLink(PropertyMap<K> m, K k) {
            this.this$0 = var1_1;
            super(m, k);
            this.reset();
            var1_1.addActionListener(this);
        }

        @Override
        protected void setComponent(ResourceReference<R> r) {
            this.this$0.setSelected(r);
        }

        @Override
        public void remove() {
            super.remove();
            this.this$0.removeActionListener(this);
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<K> e) {
            this.editComponentIfChanged(this.this$0.getSelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.this$0.selected == null ? this.map.get(this.key) == null : this.this$0.selected.equals(this.map.get(this.key))) {
                return;
            }
            this.editProperty(this.this$0.selected);
        }
    }

    class ResourceTransferHandler<K extends Resource<K, ?>>
    extends TransferHandler {
        private static final long serialVersionUID = 1716244867900780500L;
        private ResourceMenu<K> menu;

        public ResourceTransferHandler(ResourceMenu<K> menu) {
            this.menu = menu;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport ts) {
            if (!ts.isDataFlavorSupported(ResNode.DATA_FLAVOR)) {
                return false;
            }
            try {
                ResNode data = (ResNode)ts.getTransferable().getTransferData(ResNode.DATA_FLAVOR);
                if (data.kind.equals(this.menu.kind) && data.status == 3) {
                    return true;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport ts) {
            try {
                ResNode data = (ResNode)ts.getTransferable().getTransferData(ResNode.DATA_FLAVOR);
                this.menu.setSelected(data.getRes());
                ResourceMenu.this.fireActionPerformed();
                return true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                LGM.showDefaultExceptionHandler(e);
                return false;
            }
        }
    }
}

