/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Resource;

public class PackageResourcesDialog
extends JDialog {
    private static final long serialVersionUID = 3642639396173517907L;
    private static PackageResourcesDialog instance;
    public JList<TypeCheckBox> typeList;

    public void setAllSelected(boolean selected) {
        ListModel<TypeCheckBox> model = this.typeList.getModel();
        int i = 0;
        while (i < model.getSize()) {
            TypeCheckBox cb = model.getElementAt(i);
            cb.setSelected(selected);
            ++i;
        }
        this.typeList.repaint();
    }

    public HashSet<Class<?>> getSelectedTypes() {
        HashSet ret = new HashSet();
        ListModel<TypeCheckBox> model = this.typeList.getModel();
        int i = 0;
        while (i < model.getSize()) {
            TypeCheckBox cb = model.getElementAt(i);
            if (cb.isSelected()) {
                ret.add(cb.kind);
            }
            ++i;
        }
        return ret;
    }

    public HashSet<Class<?>> getUnselectedTypes() {
        HashSet ret = new HashSet();
        ListModel<TypeCheckBox> model = this.typeList.getModel();
        int i = 0;
        while (i < model.getSize()) {
            TypeCheckBox cb = model.getElementAt(i);
            if (!cb.isSelected()) {
                ret.add(cb.kind);
            }
            ++i;
        }
        return ret;
    }

    public void populateKindList() {
        DefaultListModel<TypeCheckBox> model = new DefaultListModel<TypeCheckBox>();
        for (Class<? extends Resource<?, ?>> clazz : Resource.kinds) {
            model.addElement(new TypeCheckBox(clazz));
        }
        this.typeList.setModel(model);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.populateKindList();
        }
    }

    public PackageResourcesDialog(Frame parent) {
        super(parent);
        this.setTitle(Messages.getString("PackageResources.TITLE"));
        this.setIconImage(LGM.getIconForKey("PackageResources.ICON").getImage());
        this.setResizable(false);
        this.typeList = new JList();
        this.typeList.setCellRenderer(new CheckBoxListCellRenderer());
        this.typeList.setSelectionMode(0);
        this.typeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = PackageResourcesDialog.this.typeList.locationToIndex(e.getPoint());
                if (index != -1) {
                    TypeCheckBox checkbox;
                    checkbox.setSelected(!(checkbox = PackageResourcesDialog.this.typeList.getModel().getElementAt(index)).isSelected());
                    PackageResourcesDialog.this.repaint();
                }
            }
        });
        JScrollPane typeScroll = new JScrollPane(this.typeList);
        JButton selectAllButton = new JButton(Messages.getString("PackageResources.SELECTALL"));
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PackageResourcesDialog.this.setAllSelected(true);
            }
        });
        JButton selectNoneButton = new JButton(Messages.getString("PackageResources.SELECTNONE"));
        selectNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PackageResourcesDialog.this.setAllSelected(false);
            }
        });
        JButton importButton = new JButton(Messages.getString("PackageResources.IMPORT"));
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        JButton exportButton = new JButton(Messages.getString("PackageResources.EXPORT"));
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        JButton closeButton = new JButton(Messages.getString("PackageResources.CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PackageResourcesDialog.this.setVisible(false);
            }
        });
        GroupLayout gl = new GroupLayout(this.getContentPane());
        gl.setAutoCreateContainerGaps(true);
        gl.setAutoCreateGaps(true);
        gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(selectAllButton).addComponent(selectNoneButton)).addComponent(typeScroll).addGroup(gl.createSequentialGroup().addComponent(importButton).addComponent(exportButton).addComponent(closeButton)));
        gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(selectAllButton).addComponent(selectNoneButton)).addComponent(typeScroll).addGroup(gl.createParallelGroup().addComponent(importButton).addComponent(exportButton).addComponent(closeButton)));
        this.setLayout(gl);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public static PackageResourcesDialog getInstance() {
        return instance == null ? (instance = new PackageResourcesDialog(LGM.frame)) : instance;
    }

    protected class CheckBoxListCellRenderer
    implements ListCellRenderer<JCheckBox> {
        protected CheckBoxListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox checkbox, int index, boolean isSelected, boolean cellHasFocus) {
            checkbox.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            checkbox.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            checkbox.setEnabled(PackageResourcesDialog.this.isEnabled());
            checkbox.setFont(PackageResourcesDialog.this.getFont());
            checkbox.setFocusPainted(false);
            return checkbox;
        }
    }

    public class TypeCheckBox
    extends JCheckBox {
        private static final long serialVersionUID = -4523040009849657775L;
        public Class<?> kind;

        public TypeCheckBox(Class<?> k) {
            super(Resource.kindNamesPlural.get(k), true);
            this.kind = k;
        }
    }
}

