/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JFormattedTextField;
import javax.swing.text.Caret;
import javax.swing.text.NumberFormatter;

public class NumberField
extends JFormattedTextField {
    private static final long serialVersionUID = 1L;
    protected final NumberFormatter formatter;
    private PropertyChangeListener valListener = null;

    public NumberField(int value) {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE, value);
    }

    public NumberField(int min, int max) {
        this(min, max, 0);
    }

    public NumberField(int min, int max, int value) {
        this(Integer.valueOf(min), Integer.valueOf(max), Integer.valueOf(value), NumberField.getFormatter(NumberField.getIntegerFormat()));
        this.setColumns(1 + Math.max(NumberField.numDigits(min), NumberField.numDigits(max)));
    }

    public NumberField(double value) {
        this(Double.valueOf(Double.MIN_VALUE), Double.valueOf(Double.MAX_VALUE), Double.valueOf(value), NumberField.getFormatter(NumberField.getNumberFormat(0)));
    }

    public NumberField(double min, double max, double value) {
        this(Double.valueOf(min), Double.valueOf(max), Double.valueOf(value), NumberField.getFormatter(NumberField.getNumberFormat(0)));
    }

    public NumberField(double min, double max, double value, int fractionDigits) {
        this(Double.valueOf(min), Double.valueOf(max), Double.valueOf(value), NumberField.getFormatter(NumberField.getNumberFormat(fractionDigits)));
    }

    public <T extends Number> NumberField(T min, T max, T value, NumberFormatter f) {
        super(f);
        this.formatter = f;
        f.setMinimum((Comparable)((Object)min));
        f.setMaximum((Comparable)((Object)max));
        if (value != null) {
            this.setValue(((Comparable)((Object)value)).compareTo(min) < 0 ? min : (((Comparable)((Object)value)).compareTo(max) > 0 ? max : value));
        }
    }

    public <T extends Number> void setRange(T min, T max) {
        this.formatter.setMinimum((Comparable)((Object)min));
        this.formatter.setMaximum((Comparable)((Object)max));
        this.commitOrRevert();
    }

    public Integer getIntValue() {
        return (Integer)this.getValue();
    }

    public void revertEdit() {
        this.setValue(this.getValue());
    }

    public void setCommitsOnValidEdit(boolean val) {
        this.formatter.setCommitsOnValidEdit(val);
    }

    public void commitOrRevert() {
        try {
            this.commitEdit();
        }
        catch (ParseException e) {
            this.revertEdit();
        }
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        if (this.valListener == null) {
            this.valListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    NumberField.this.fireValueChange(evt.getOldValue(), evt.getNewValue());
                }
            };
            super.addPropertyChangeListener("value", this.valListener);
        }
        this.listenerList.add(ValueChangeListener.class, listener);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.listenerList.remove(ValueChangeListener.class, listener);
    }

    protected void fireValueChange(Object oldValue, Object newValue) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ValueChangeListener.class) {
                ((ValueChangeListener)listeners[i + 1]).valueChange(new ValueChangeEvent(this, oldValue, newValue));
            }
            i -= 2;
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            Caret c = this.getCaret();
            int cd = this.getCaret().getDot();
            int cm = this.getCaret().getMark();
            super.processFocusEvent(e);
            c.setDot(cm);
            c.moveDot(cd);
        } else {
            super.processFocusEvent(e);
        }
    }

    private static NumberFormatter getFormatter(NumberFormat f) {
        NumberFormatter nf = new NumberFormatter(f);
        nf.setCommitsOnValidEdit(true);
        return nf;
    }

    private static NumberFormat getIntegerFormat() {
        NumberFormat f = NumberFormat.getIntegerInstance();
        f.setGroupingUsed(false);
        return f;
    }

    private static NumberFormat getNumberFormat(int fractionDigits) {
        NumberFormat f = NumberFormat.getNumberInstance();
        if (fractionDigits != 0) {
            f.setMinimumFractionDigits(fractionDigits);
            f.setMaximumFractionDigits(fractionDigits);
        }
        f.setGroupingUsed(false);
        return f;
    }

    private static int numDigits(int n) {
        return n == 0 ? 1 : 1 + (int)Math.log10(Math.abs(n));
    }

    public static class ValueChangeEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private Object oldValue;
        private Object newValue;

        public ValueChangeEvent(Object source, Object oldValue, Object newValue) {
            super(source);
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }
    }

    public static interface ValueChangeListener
    extends EventListener {
        public void valueChange(ValueChangeEvent var1);
    }
}

