/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.util.HashMap;
import java.util.Map;
import org.lateralgm.joshedit.DefaultTokenMarker;
import org.lateralgm.joshedit.lexers.GLESTokenMarker;
import org.lateralgm.joshedit.lexers.GLSLTokenMarker;
import org.lateralgm.joshedit.lexers.GMLTokenMarker;
import org.lateralgm.joshedit.lexers.HLSLTokenMarker;

public final class MarkerCache {
    private static Map<String, DefaultTokenMarker> markers = new HashMap<String, DefaultTokenMarker>();

    public static DefaultTokenMarker getMarker(String language) {
        DefaultTokenMarker marker;
        block19: {
            marker = markers.get(language = language.toLowerCase());
            if (marker != null) break block19;
            switch (language) {
                case "glsles": {
                    marker = new GLESTokenMarker();
                    break;
                }
                case "glsl": {
                    marker = new GLSLTokenMarker();
                    break;
                }
                case "hlsl9": {
                    marker = new HLSLTokenMarker();
                    break;
                }
                case "hlsl11": {
                    marker = new HLSLTokenMarker();
                    break;
                }
                case "gml": {
                    marker = new GMLTokenMarker();
                }
            }
            markers.put(language, marker);
        }
        return marker;
    }
}

