/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.Kernel;
import java.awt.image.RGBImageFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lateralgm.components.ColorSelect;
import org.lateralgm.components.NumberField;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;

public class ImageEffects {
    public static double ColourDistance(Color c1, Color c2) {
        double rmean = (c1.getRed() + c2.getRed()) / 2;
        int r = c1.getRed() - c2.getRed();
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return Math.sqrt(weightR * (double)r * (double)r + weightG * (double)g * (double)g + weightB * (double)b * (double)b);
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float wrap(float val, float min, float max) {
        float dif = max - min;
        while (val < min) {
            val += dif;
        }
        while (val > max) {
            val -= dif;
        }
        return val;
    }

    public static class BlackAndWhiteEffect
    extends ImageEffect {
        private final String key = "BlackAndWhiteEffect";

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            BufferedImage dest = op.createCompatibleDestImage(img, img.getColorModel());
            return op.filter(img, dest);
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            return pane;
        }

        @Override
        public String getKey() {
            return "BlackAndWhiteEffect";
        }
    }

    public static class BlurEffect
    extends ImageEffect {
        private final String key = "BlurEffect";
        private JSlider repeatSlider;

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            img = Util.convertImage(img, 2);
            BufferedImage dst = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
            Kernel kernel = new Kernel(3, 3, new float[]{0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f});
            ConvolveOp op = new ConvolveOp(kernel, 0, null);
            dst = op.filter(img, dst);
            int i = 0;
            while (i < this.repeatSlider.getValue() - 1) {
                dst = op.filter(dst, null);
                ++i;
            }
            return dst;
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            JLabel alphaLabel = new JLabel(Messages.getString("ImageEffects.REPETITIONS"));
            this.repeatSlider = new JSlider(1, 20, 2);
            this.repeatSlider.setPaintTicks(true);
            this.repeatSlider.setSnapToTicks(true);
            this.repeatSlider.setMajorTickSpacing(5);
            this.repeatSlider.setMinorTickSpacing(1);
            this.repeatSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    BlurEffect.this.optionsUpdated();
                }
            });
            GroupLayout gl = new GroupLayout(pane);
            gl.setAutoCreateContainerGaps(true);
            gl.setAutoCreateGaps(true);
            gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(alphaLabel).addComponent(this.repeatSlider)));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(alphaLabel).addComponent(this.repeatSlider)));
            pane.setLayout(gl);
            return pane;
        }

        @Override
        public String getKey() {
            return "BlurEffect";
        }
    }

    public static class ColorizeEffect
    extends ImageEffect {
        private final String key = "ColorizeEffect";
        private JSlider hueSlider;
        private JCheckBox hueShift;
        private JSlider satSlider;
        private JCheckBox satShift;
        private JSlider valSlider;
        private JCheckBox valShift;

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            int width = img.getWidth();
            int height = img.getHeight();
            BufferedImage dst = new BufferedImage(width, height, 2);
            int i = 0;
            while (i < width) {
                int ii = 0;
                while (ii < height) {
                    int rgba = img.getRGB(i, ii);
                    Color col = new Color(rgba, true);
                    float[] hslVals = new float[3];
                    int alpha = col.getAlpha();
                    Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), hslVals);
                    col = new Color(Color.HSBtoRGB(ImageEffects.wrap((this.hueShift.isSelected() ? hslVals[0] : 0.0f) + (float)this.hueSlider.getValue() / 360.0f, 0.0f, 1.0f), this.satShift.isSelected() ? ImageEffects.clamp(hslVals[1] + (float)this.satSlider.getValue() / 100.0f, 0.0f, 1.0f) : (100.0f + (float)this.satSlider.getValue()) / 200.0f, this.valShift.isSelected() ? ImageEffects.clamp(hslVals[2] + (float)this.valSlider.getValue() / 100.0f, 0.0f, 1.0f) : (100.0f + (float)this.valSlider.getValue()) / 200.0f));
                    col = new Color(col.getRed(), col.getGreen(), col.getBlue(), alpha);
                    dst.setRGB(i, ii, col.getRGB());
                    ++ii;
                }
                ++i;
            }
            return dst;
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            JLabel hueLabel = new JLabel(Messages.getString("ImageEffects.HUE"));
            this.hueSlider = new JSlider(-180, 180, 0);
            this.hueSlider.setPaintTicks(true);
            this.hueSlider.setSnapToTicks(false);
            this.hueSlider.setMajorTickSpacing(45);
            this.hueSlider.setMinorTickSpacing(5);
            this.hueSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    ColorizeEffect.this.optionsUpdated();
                }
            });
            this.hueShift = new JCheckBox(Messages.getString("ImageEffects.RELATIVE"), true);
            this.hueShift.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    ColorizeEffect.this.optionsUpdated();
                }
            });
            JLabel satLabel = new JLabel(Messages.getString("ImageEffects.SATURATION"));
            this.satSlider = new JSlider(-100, 100, 0);
            this.satSlider.setPaintTicks(true);
            this.satSlider.setSnapToTicks(false);
            this.satSlider.setMajorTickSpacing(20);
            this.satSlider.setMinorTickSpacing(5);
            this.satSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    ColorizeEffect.this.optionsUpdated();
                }
            });
            this.satShift = new JCheckBox(Messages.getString("ImageEffects.RELATIVE"), true);
            this.satShift.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    ColorizeEffect.this.optionsUpdated();
                }
            });
            JLabel valLabel = new JLabel(Messages.getString("ImageEffects.VALUE"));
            this.valSlider = new JSlider(-100, 100, 0);
            this.valSlider.setPaintTicks(true);
            this.valSlider.setSnapToTicks(false);
            this.valSlider.setMajorTickSpacing(20);
            this.valSlider.setMinorTickSpacing(5);
            this.valSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    ColorizeEffect.this.optionsUpdated();
                }
            });
            this.valShift = new JCheckBox(Messages.getString("ImageEffects.RELATIVE"), true);
            this.valShift.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    ColorizeEffect.this.optionsUpdated();
                }
            });
            GroupLayout gl = new GroupLayout(pane);
            gl.setAutoCreateContainerGaps(true);
            gl.setAutoCreateGaps(true);
            gl.setHorizontalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(hueLabel).addComponent(satLabel).addComponent(valLabel)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl.createSequentialGroup().addComponent(this.hueSlider).addComponent(this.hueShift)).addGroup(gl.createSequentialGroup().addComponent(this.satSlider).addComponent(this.satShift)).addGroup(gl.createSequentialGroup().addComponent(this.valSlider).addComponent(this.valShift))));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(hueLabel).addComponent(this.hueSlider).addComponent(this.hueShift)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(satLabel).addComponent(this.satSlider).addComponent(this.satShift)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(valLabel).addComponent(this.valSlider).addComponent(this.valShift)));
            pane.setLayout(gl);
            return pane;
        }

        @Override
        public String getKey() {
            return "ColorizeEffect";
        }
    }

    public static class EdgeDetectEffect
    extends ImageEffect {
        private final String key = "EdgeDetectEffect";

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            img = Util.convertImage(img, 2);
            BufferedImage dst = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
            Kernel kernel = new Kernel(3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 8.0f, -1.0f, -1.0f, -1.0f, -1.0f});
            ConvolveOp op = new ConvolveOp(kernel, 0, null);
            return op.filter(img, dst);
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            return pane;
        }

        @Override
        public String getKey() {
            return "EdgeDetectEffect";
        }
    }

    public static interface EffectOptionListener {
        public void optionsUpdated();
    }

    public static class EmbossEffect
    extends ImageEffect {
        private final String key = "EmbossColorEffect";

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            int width = img.getWidth();
            int height = img.getHeight();
            BufferedImage dst = new BufferedImage(width, height, 1);
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int grayColor;
                    int upperLeft = 0;
                    int lowerRight = 0;
                    if (i > 0 && j > 0) {
                        upperLeft = img.getRGB(j - 1, i - 1);
                    }
                    if (i < height - 1 && j < width - 1) {
                        lowerRight = img.getRGB(j + 1, i + 1);
                    }
                    int redDiff = (lowerRight >> 16 & 0xFF) - (upperLeft >> 16 & 0xFF);
                    int greenDiff = (lowerRight >> 8 & 0xFF) - (upperLeft >> 8 & 0xFF);
                    int blueDiff = (lowerRight & 0xFF) - (upperLeft & 0xFF);
                    int diff = redDiff;
                    if (Math.abs(greenDiff) > Math.abs(diff)) {
                        diff = greenDiff;
                    }
                    if (Math.abs(blueDiff) > Math.abs(diff)) {
                        diff = blueDiff;
                    }
                    if ((grayColor = 128 + diff) > 255) {
                        grayColor = 255;
                    } else if (grayColor < 0) {
                        grayColor = 0;
                    }
                    int newColor = (grayColor << 16) + (grayColor << 8) + grayColor;
                    dst.setRGB(j, i, newColor);
                    ++j;
                }
                ++i;
            }
            return dst;
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            return pane;
        }

        @Override
        public String getKey() {
            return "EmbossColorEffect";
        }
    }

    public static class FadeColorEffect
    extends ImageEffect {
        private final String key = "FadeColorEffect";
        private ColorSelect colorSelect;
        private JSlider intensitySlider;

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            BufferedImage target = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            Graphics2D g = target.createGraphics();
            g.drawImage(img, null, 0, 0);
            g.setComposite(AlphaComposite.getInstance(10, (float)this.intensitySlider.getValue() / 255.0f));
            g.setColor(this.colorSelect.getSelectedColor());
            g.fillRect(0, 0, img.getWidth(), img.getHeight());
            g.dispose();
            return target;
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            JLabel colorLabel = new JLabel(Messages.getString("ImageEffects.COLOR"));
            this.colorSelect = new ColorSelect(Color.YELLOW, false);
            this.colorSelect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    FadeColorEffect.this.optionsUpdated();
                }
            });
            JLabel toleranceLabel = new JLabel(Messages.getString("ImageEffects.INTENSITY"));
            this.intensitySlider = new JSlider(0, 255, 155);
            this.intensitySlider.setPaintTicks(true);
            this.intensitySlider.setSnapToTicks(true);
            this.intensitySlider.setMajorTickSpacing(15);
            this.intensitySlider.setMinorTickSpacing(3);
            this.intensitySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    FadeColorEffect.this.optionsUpdated();
                }
            });
            GroupLayout gl = new GroupLayout(pane);
            gl.setAutoCreateContainerGaps(true);
            gl.setAutoCreateGaps(true);
            gl.setHorizontalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(colorLabel).addComponent(toleranceLabel)).addGroup(gl.createParallelGroup().addComponent(this.colorSelect).addComponent(this.intensitySlider)));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(colorLabel).addComponent(this.colorSelect)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(toleranceLabel).addComponent(this.intensitySlider)));
            pane.setLayout(gl);
            return pane;
        }

        @Override
        public String getKey() {
            return "FadeColorEffect";
        }
    }

    public static abstract class ImageEffect {
        private List<EffectOptionListener> listeners = new ArrayList<EffectOptionListener>();

        public abstract BufferedImage getAppliedImage(BufferedImage var1);

        public abstract JPanel getOptionsPanel();

        public String getName() {
            return Messages.getString("ImageEffects." + this.getKey());
        }

        public abstract String getKey();

        protected void optionsUpdated() {
            for (EffectOptionListener listener : this.listeners) {
                listener.optionsUpdated();
            }
        }

        public void addOptionUpdateListener(EffectOptionListener listener) {
            this.listeners.add(listener);
        }

        public void removeOptionUpdateListener(EffectOptionListener listener) {
            this.listeners.remove(listener);
        }
    }

    public static class IntensityEffect
    extends ImageEffect {
        private final String key = "IntensityEffect";
        private JSlider brightnessSlider;
        private JSlider contrastSlider;

        public BufferedImage applyBrightnessAndContrast(BufferedImage bi, double brightness, double contrast) {
            double gamma = 0.25;
            contrast = contrast > 0.0 ? 100.0 * Math.pow(contrast - 1.0, 4.0) / Math.pow(100.0, 4.0) + 1.0 : (contrast == 0.0 ? 1.0 : 1.0 / (100.0 * Math.pow(-contrast + 1.0, 4.0) / Math.pow(100.0, 4.0) + 1.0));
            brightness = brightness > 0.0 ? 100.0 * Math.pow(brightness, 4.0) / Math.pow(100.0, 4.0) + 1.0 : (brightness == 0.0 ? 1.0 : 1.0 / (100.0 * Math.pow(-brightness, 4.0) / Math.pow(100.0, 4.0) + 1.0));
            int w = bi.getWidth();
            int h = bi.getHeight();
            BufferedImage out = new BufferedImage(w, h, 2);
            int x = 0;
            while (x < w) {
                int y = 0;
                while (y < h) {
                    int rgb = bi.getRGB(x, y);
                    int alpha = (int)(((long)rgb & 0xFF000000L) >> 24);
                    int r = (rgb & 0xFF0000) >> 16;
                    int g = (rgb & 0xFF00) >> 8;
                    int b = rgb & 0xFF;
                    r = (int)((double)r * brightness);
                    g = (int)((double)g * brightness);
                    b = (int)((double)b * brightness);
                    double Y = (double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114;
                    double Cb = (double)r * -0.168736 + (double)g * -0.331264 + (double)b * 0.5;
                    double Cr = (double)r * 0.5 + (double)g * -0.418688 + (double)b * -0.081312;
                    Y = (Y + brightness - 127.0) * contrast + 127.0;
                    r = (int)(Y + (Cr *= contrast) * 1.402);
                    g = (int)(Y + (Cb *= contrast) * -0.344136 + Cr * -0.714136);
                    b = (int)(Y + Cb * 1.772);
                    if (alpha > 255) {
                        alpha = 255;
                    } else if (alpha < 0) {
                        alpha = 0;
                    }
                    if (g > 255) {
                        g = 255;
                    } else if (g < 0) {
                        g = 0;
                    }
                    if (r > 255) {
                        r = 255;
                    } else if (r < 0) {
                        r = 0;
                    }
                    if (b > 255) {
                        b = 255;
                    } else if (b < 0) {
                        b = 0;
                    }
                    rgb = (alpha & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                    out.setRGB(x, y, rgb);
                    ++y;
                }
                ++x;
            }
            return out;
        }

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            return this.applyBrightnessAndContrast(img, this.brightnessSlider.getValue(), this.contrastSlider.getValue());
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            JLabel hueLabel = new JLabel(Messages.getString("ImageEffects.BRIGHTNESS"));
            this.brightnessSlider = new JSlider(-100, 100, 0);
            this.brightnessSlider.setPaintTicks(true);
            this.brightnessSlider.setSnapToTicks(false);
            this.brightnessSlider.setMajorTickSpacing(20);
            this.brightnessSlider.setMinorTickSpacing(5);
            this.brightnessSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    IntensityEffect.this.optionsUpdated();
                }
            });
            JLabel satLabel = new JLabel(Messages.getString("ImageEffects.CONTRAST"));
            this.contrastSlider = new JSlider(-100, 100, 0);
            this.contrastSlider.setPaintTicks(true);
            this.contrastSlider.setSnapToTicks(false);
            this.contrastSlider.setMajorTickSpacing(20);
            this.contrastSlider.setMinorTickSpacing(5);
            this.contrastSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    IntensityEffect.this.optionsUpdated();
                }
            });
            GroupLayout gl = new GroupLayout(pane);
            gl.setAutoCreateContainerGaps(true);
            gl.setAutoCreateGaps(true);
            gl.setHorizontalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(hueLabel).addComponent(satLabel)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.brightnessSlider).addComponent(this.contrastSlider)));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(hueLabel).addComponent(this.brightnessSlider)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(satLabel).addComponent(this.contrastSlider)));
            pane.setLayout(gl);
            return pane;
        }

        @Override
        public String getKey() {
            return "IntensityEffect";
        }
    }

    public static class InvertEffect
    extends ImageEffect {
        private final String key = "InvertEffect";

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            int width = img.getWidth();
            int height = img.getHeight();
            BufferedImage dst = new BufferedImage(width, height, 2);
            int i = 0;
            while (i < width) {
                int ii = 0;
                while (ii < height) {
                    int rgba = img.getRGB(i, ii);
                    Color col = new Color(rgba, true);
                    col = new Color(255 - col.getRed(), 255 - col.getGreen(), 255 - col.getBlue(), col.getAlpha());
                    dst.setRGB(i, ii, col.getRGB());
                    ++ii;
                }
                ++i;
            }
            return dst;
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            return pane;
        }

        @Override
        public String getKey() {
            return "InvertEffect";
        }
    }

    public static class OpacityEffect
    extends ImageEffect {
        private final String key = "OpacityEffect";
        private JSlider alphaSlider = null;

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            BufferedImage target = new BufferedImage(img.getWidth(), img.getHeight(), 2);
            Graphics2D g = target.createGraphics();
            g.setComposite(AlphaComposite.getInstance(3, (float)this.alphaSlider.getValue() / 255.0f));
            g.drawImage(img, null, 0, 0);
            g.dispose();
            return target;
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            JLabel alphaLabel = new JLabel(Messages.getString("ImageEffects.TRANSPARENCY"));
            this.alphaSlider = new JSlider(0, 255, 155);
            this.alphaSlider.setPaintTicks(true);
            this.alphaSlider.setMajorTickSpacing(15);
            this.alphaSlider.setMinorTickSpacing(3);
            final NumberField alphaField = new NumberField(0, 255, 155);
            this.alphaSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    alphaField.setValue(OpacityEffect.this.alphaSlider.getValue());
                    OpacityEffect.this.optionsUpdated();
                }
            });
            alphaField.addValueChangeListener(new NumberField.ValueChangeListener(){

                @Override
                public void valueChange(NumberField.ValueChangeEvent evt) {
                    OpacityEffect.this.alphaSlider.setValue((Integer)evt.getNewValue());
                }
            });
            GroupLayout gl = new GroupLayout(pane);
            gl.setAutoCreateContainerGaps(true);
            gl.setAutoCreateGaps(true);
            gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(alphaLabel).addComponent(this.alphaSlider).addComponent(alphaField, -2, -2, -2)));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(alphaLabel).addComponent(this.alphaSlider).addComponent(alphaField, -2, -2, -2)));
            pane.setLayout(gl);
            return pane;
        }

        @Override
        public String getKey() {
            return "OpacityEffect";
        }
    }

    public static class RemoveColorEffect
    extends ImageEffect {
        private final String key = "RemoveColorEffect";
        private ColorSelect colorSelect;
        private JSlider toleranceSlider;

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            final int col = this.colorSelect.getSelectedColor().getRGB();
            RGBImageFilter filter = new RGBImageFilter(){

                @Override
                public int filterRGB(int x, int y, int rgb) {
                    Color color = new Color(rgb);
                    Color color2 = new Color(col);
                    if (ImageEffects.ColourDistance(color, color2) < (double)RemoveColorEffect.this.toleranceSlider.getValue()) {
                        return col & 0xFFFFFF;
                    }
                    return rgb;
                }
            };
            FilteredImageSource ip = new FilteredImageSource(img.getSource(), filter);
            return Util.toBufferedImage(Toolkit.getDefaultToolkit().createImage(ip));
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            JLabel colorLabel = new JLabel(Messages.getString("ImageEffects.COLOR"));
            this.colorSelect = new ColorSelect(Color.WHITE, true);
            this.colorSelect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    RemoveColorEffect.this.optionsUpdated();
                }
            });
            JLabel toleranceLabel = new JLabel(Messages.getString("ImageEffects.TOLERANCE"));
            this.toleranceSlider = new JSlider(0, 255, 15);
            this.toleranceSlider.setPaintTicks(true);
            this.toleranceSlider.setSnapToTicks(true);
            this.toleranceSlider.setMajorTickSpacing(15);
            this.toleranceSlider.setMinorTickSpacing(3);
            this.toleranceSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    RemoveColorEffect.this.optionsUpdated();
                }
            });
            GroupLayout gl = new GroupLayout(pane);
            gl.setAutoCreateContainerGaps(true);
            gl.setAutoCreateGaps(true);
            gl.setHorizontalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(colorLabel).addComponent(toleranceLabel)).addGroup(gl.createParallelGroup().addComponent(this.colorSelect).addComponent(this.toleranceSlider)));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(colorLabel).addComponent(this.colorSelect)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(toleranceLabel).addComponent(this.toleranceSlider)));
            pane.setLayout(gl);
            return pane;
        }

        @Override
        public String getKey() {
            return "RemoveColorEffect";
        }
    }

    public static class RemoveTransparencyEffect
    extends ImageEffect {
        private final String key = "RemoveTransparencyEffect";
        private ColorSelect colorSelect;

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            BufferedImage dst = Util.clearBackground(img, this.colorSelect.getSelectedColor());
            return dst;
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            JLabel colorLabel = new JLabel(Messages.getString("ImageEffects.COLOR"));
            this.colorSelect = new ColorSelect(Color.WHITE, true);
            this.colorSelect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    RemoveTransparencyEffect.this.optionsUpdated();
                }
            });
            GroupLayout gl = new GroupLayout(pane);
            gl.setAutoCreateContainerGaps(true);
            gl.setAutoCreateGaps(true);
            gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(colorLabel).addComponent(this.colorSelect)));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(colorLabel).addComponent(this.colorSelect)));
            pane.setLayout(gl);
            return pane;
        }

        @Override
        public String getKey() {
            return "RemoveTransparencyEffect";
        }
    }

    public static class SharpenEffect
    extends ImageEffect {
        private final String key = "SharpenEffect";
        private JSlider repeatSlider;

        @Override
        public BufferedImage getAppliedImage(BufferedImage img) {
            img = Util.convertImage(img, 2);
            BufferedImage dst = new BufferedImage(img.getWidth(), img.getHeight(), img.getType());
            Kernel kernel = new Kernel(3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
            ConvolveOp op = new ConvolveOp(kernel, 0, null);
            dst = op.filter(img, dst);
            int i = 0;
            while (i < this.repeatSlider.getValue() - 1) {
                dst = op.filter(dst, null);
                ++i;
            }
            return dst;
        }

        @Override
        public JPanel getOptionsPanel() {
            JPanel pane = new JPanel();
            JLabel alphaLabel = new JLabel(Messages.getString("ImageEffects.REPETITIONS"));
            this.repeatSlider = new JSlider(1, 20, 2);
            this.repeatSlider.setPaintTicks(true);
            this.repeatSlider.setSnapToTicks(true);
            this.repeatSlider.setMajorTickSpacing(5);
            this.repeatSlider.setMinorTickSpacing(1);
            this.repeatSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    SharpenEffect.this.optionsUpdated();
                }
            });
            GroupLayout gl = new GroupLayout(pane);
            gl.setAutoCreateContainerGaps(true);
            gl.setAutoCreateGaps(true);
            gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(alphaLabel).addComponent(this.repeatSlider)));
            gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(alphaLabel).addComponent(this.repeatSlider)));
            pane.setLayout(gl);
            return pane;
        }

        @Override
        public String getKey() {
            return "SharpenEffect";
        }
    }
}

