/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Map;
import javax.swing.JTextField;

public class HintTextField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = 1891424933399664075L;
    private String hint;
    private boolean hideOnFocus;
    private Color color;

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public boolean isHideOnFocus() {
        return this.hideOnFocus;
    }

    public void setHideOnFocus(boolean hideOnFocus) {
        this.hideOnFocus = hideOnFocus;
        this.repaint();
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.repaint();
    }

    public HintTextField(String hint) {
        this(hint, false);
    }

    public HintTextField(String hint, boolean hideOnFocus) {
        this(hint, hideOnFocus, null);
    }

    public HintTextField(String hint, boolean hideOnFocus, Color color) {
        this.hint = hint;
        this.hideOnFocus = hideOnFocus;
        this.color = color;
        this.addFocusListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.hint != null && this.getText().length() == 0 && this.hideOnFocus && !this.hasFocus()) {
            Shape clip = g.getClip();
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            g.clipRect(insets.left, insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
            Object map = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            if (map != null) {
                ((Graphics2D)g).addRenderingHints((Map)map);
            }
            g.drawString(this.hint, insets.left, g.getFontMetrics().getAscent() + insets.top);
            g.setClip(clip);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.hideOnFocus) {
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.hideOnFocus) {
            this.repaint();
        }
    }
}

