/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.lateralgm.components.impl.DefaultNode;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.Util;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.ResourceReference;

public class GmTreeGraphics
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static ImageIcon blankIcon;
    private DefaultNode last;
    private Color nonSelectColor;

    public GmTreeGraphics() {
        this.setOpenIcon(LGM.getIconForKey("GmTreeGraphics.GROUP_OPEN"));
        this.setClosedIcon(LGM.getIconForKey("GmTreeGraphics.GROUP"));
        this.setLeafIcon(this.getClosedIcon());
        this.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object val, boolean sel, boolean exp, boolean leaf, int row, boolean focus) {
        this.setTextNonSelectionColor(this.nonSelectColor);
        this.last = (DefaultNode)val;
        Component com = super.getTreeCellRendererComponent(tree, val, sel, exp, leaf, row, focus);
        if (val instanceof ResNode && com instanceof JLabel) {
            ResNode rn = (ResNode)val;
            JLabel label = (JLabel)com;
            if (rn.status == 1 && Prefs.boldPrimaryNodes) {
                label.setText("<html><b>" + this.getText() + "</b></html>");
            }
        }
        return com;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.nonSelectColor = this.getTextNonSelectionColor();
    }

    public static ImageIcon getBlankIcon() {
        if (blankIcon == null) {
            blankIcon = new ImageIcon(new BufferedImage(16, 16, 2));
        }
        return blankIcon;
    }

    public static Icon getScaledIcon(Image i) {
        int h;
        int w = i.getWidth(null);
        int m = Math.min(w, h = i.getHeight(null));
        if (m > 16) {
            i = i.getScaledInstance(w * 16 / m, h * 16 / m, 4);
        }
        BufferedImage i2 = new BufferedImage(16, 16, 2);
        int x = 0;
        int y = 0;
        if (w < 16) {
            x = 8 - w / 2;
        }
        if (h < 16) {
            y = 8 - h / 2;
        }
        ((Image)i2).getGraphics().drawImage(i, x, y, null);
        i = i2;
        return new ImageIcon(i);
    }

    public static Icon getResourceIcon(ResourceReference<?> r) {
        BufferedImage bi;
        Object res = Util.deRef(r);
        if (res != null && res instanceof Resource.Viewable && (bi = ((Resource.Viewable)res).getDisplayImage()) != null) {
            return GmTreeGraphics.getScaledIcon(bi);
        }
        return GmTreeGraphics.getBlankIcon();
    }

    @Override
    public Icon getLeafIcon() {
        Icon icon;
        if (this.last != null && (icon = this.last.getLeafIcon()) != null) {
            return icon;
        }
        return this.getClosedIcon();
    }

    @Override
    public Icon getClosedIcon() {
        Icon ico = this.getIconisedGroup();
        if (ico != null) {
            return ico;
        }
        return super.getClosedIcon();
    }

    @Override
    public Icon getOpenIcon() {
        Icon ico = this.getIconisedGroup();
        if (ico != null) {
            return ico;
        }
        return super.getOpenIcon();
    }

    private Icon getIconisedGroup() {
        if (Prefs.iconizeGroup && this.last != null) {
            return this.last.getIconisedGroup();
        }
        return null;
    }

    public Icon getNodeIcon(Object val, boolean exp, boolean leaf) {
        Icon icon;
        this.last = (DefaultNode)val;
        if (leaf && (icon = this.getLeafIcon()) != null) {
            return icon;
        }
        if (exp) {
            return this.getOpenIcon();
        }
        return this.getClosedIcon();
    }
}

