/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.lateralgm.components.GmMenu;
import org.lateralgm.components.impl.ResNode;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Listener;
import org.lateralgm.main.PrefsStore;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.InstantiableResource;
import org.lateralgm.resources.Resource;

public class GmMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private List<JMenuItem> recentFiles = new ArrayList<JMenuItem>();
    private GmMenu recentMenu;
    protected static final Map<Class<? extends Resource<?, ?>>, Character> MNEMONICS = new HashMap();

    static {
        for (Map.Entry<String, Class<Resource<?, ?>>> k : Resource.kindsByName3.entrySet()) {
            MNEMONICS.put(k.getValue(), Character.valueOf(Messages.getString("GmMenuBar.MNEMONIC_" + k.getKey()).toUpperCase().charAt(0)));
        }
    }

    public static final void setTextAndAlt(JMenuItem item, String input) {
        Matcher m = Pattern.compile("\t+([^\\s])$").matcher(input);
        if (m.find()) {
            char alt = m.group(1).toUpperCase(Locale.ENGLISH).charAt(0);
            item.setMnemonic((int)alt);
            item.setText(input.substring(0, m.start()));
        } else {
            item.setMnemonic(-1);
            item.setText(input);
        }
    }

    public void setRecentMenuEnabled(boolean enabled) {
        this.recentMenu.setEnabled(enabled);
        if (!enabled) {
            this.recentMenu.removeAll();
        }
    }

    public void updateRecentFiles() {
        ArrayList<String> recentList = PrefsStore.getRecentFiles();
        if (recentList.size() <= 0) {
            this.setRecentMenuEnabled(false);
            return;
        }
        this.setRecentMenuEnabled(true);
        this.recentMenu.removeAll();
        this.recentFiles.clear();
        for (String recentStr : recentList) {
            try {
                JMenuItem item;
                URI uri = new URI(recentStr);
                String number = Integer.toString(this.recentFiles.size() + 1);
                try {
                    File file = new File(uri).getAbsoluteFile();
                    item = new JMenuItem(String.format("%s %s  [%s]", number, file.getName(), file.getParent()), number.codePointAt(number.length() - 1));
                }
                catch (IllegalArgumentException e) {
                    item = new JMenuItem(String.format("%s %s", number, uri), number.codePointAt(number.length() - 1));
                }
                item.setActionCommand("GmMenuBar.OPENRECENT " + recentStr);
                item.addActionListener(Listener.getInstance());
                this.recentMenu.insert(item, this.recentFiles.size());
                this.recentFiles.add(item);
            }
            catch (URISyntaxException e) {
                LGM.showDefaultExceptionHandler(e);
            }
        }
        this.recentMenu.addSeparator();
        this.recentMenu.addItem("GmMenuBar.CLEARRECENT");
    }

    public GmMenuBar() {
        GmMenu menu = new GmMenu(Messages.getString("GmMenuBar.MENU_FILE"));
        this.add(menu);
        menu.addItem("GmMenuBar.NEW");
        menu.addItem("GmMenuBar.OPEN");
        this.recentMenu = menu.addMenu("GmMenuBar.RECENTFILES");
        menu.addItem("GmMenuBar.SAVE");
        menu.addItem("GmMenuBar.SAVEAS");
        menu.addSeparator();
        menu.addItem("GmMenuBar.PREFERENCES");
        menu.addSeparator();
        menu.addItem("GmMenuBar.EXIT");
        this.updateRecentFiles();
        menu = new GmMenu(Messages.getString("GmMenuBar.MENU_EDIT"));
        this.add(menu);
        GmMenu subIns = new GmMenu(Messages.getString("GmMenuBar.MENU_INSERT"));
        menu.add(subIns);
        subIns.addItem("GmMenuBar.INSERT_GROUP");
        subIns.addSeparator();
        GmMenu subAdd = new GmMenu(Messages.getString("GmMenuBar.MENU_ADD"));
        menu.add(subAdd);
        subAdd.addItem("GmMenuBar.ADD_GROUP");
        subAdd.addSeparator();
        for (Class<? extends Resource<?, ?>> clazz : Resource.kinds) {
            if (!InstantiableResource.class.isAssignableFrom(clazz)) continue;
            String nodeName = Resource.kindNames.get(clazz);
            Icon icon = ResNode.ICON.get(clazz);
            char mnemonic = MNEMONICS.get(clazz).charValue();
            String insNodeName = Messages.format("GmMenuBar.INSERT", nodeName);
            String addNodeName = Messages.format("GmMenuBar.ADD", nodeName);
            JMenuItem item = new JMenuItem(insNodeName, icon);
            if (mnemonic != '!') {
                item.setMnemonic((int)mnemonic);
            }
            item.addActionListener(new Listener.ResourceAdder(true, clazz));
            subIns.add(item);
            item = new JMenuItem(addNodeName, icon);
            if (mnemonic != '!') {
                item.setMnemonic((int)mnemonic);
            }
            item.addActionListener(new Listener.ResourceAdder(false, clazz));
            subAdd.add(item);
        }
        menu.addSeparator();
        menu.addItem("GmMenuBar.RENAME");
        menu.addItem("GmMenuBar.DELETE");
        menu.addItem("GmMenuBar.DUPLICATE");
        menu.addSeparator();
        menu.addItem("GmMenuBar.PROPERTIES");
        menu = new GmMenu(Messages.getString("GmMenuBar.MENU_RESOURCES"));
        this.add(menu);
        menu.addItem("GmMenuBar.CHECKNAMES");
        menu.addItem("GmMenuBar.CHECKIDS");
        menu.addSeparator();
        menu.addItem("GmMenuBar.FIND");
        menu.addSeparator();
        menu.addItem("GmMenuBar.EXPAND");
        menu.addItem("GmMenuBar.COLLAPSE");
        this.add(LGM.mdi.getMenu());
        menu = new GmMenu(Messages.getString("GmMenuBar.MENU_HELP"));
        this.add(menu);
        menu.addItem("GmMenuBar.DOCUMENTATION");
        menu.addSeparator();
        menu.addItem("GmMenuBar.WEBSITE");
        menu.addItem("GmMenuBar.COMMUNITY");
        menu.addItem("GmMenuBar.ISSUE");
        menu.addSeparator();
        menu.addItem("GmMenuBar.EXPLORELATERALGM");
        menu.addItem("GmMenuBar.EXPLOREPROJECT");
        menu.addSeparator();
        menu.addItem("GmMenuBar.ABOUT");
    }
}

