/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.messages.Messages;

public class ErrorDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int DEBUG_HEIGHT = 200;
    private static ErrorDialog INSTANCE = null;
    private String submitURI = Prefs.issueURI;
    protected JTextArea debugInfo;
    protected JButton copy;
    protected JButton submit;
    protected JButton cancel;
    protected JScrollPane scroll;
    protected JOptionPane optionpane;

    public static ErrorDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ErrorDialog((Frame)LGM.frame, Messages.getString("ErrorDialog.UNCAUGHT_TITLE"), Messages.getString("ErrorDialog.UNCAUGHT_MESSAGE"), Prefs.issueURI);
        }
        return INSTANCE;
    }

    public static String generateAgnosticInformation() {
        File[] roots;
        String ret = "LateralGM Version: 1.8.229";
        ret = String.valueOf(ret) + "\nWorking Directory: " + LGM.workDir;
        ret = String.valueOf(ret) + "\n\nOperating System: " + System.getProperty("os.name");
        ret = String.valueOf(ret) + "\nVersion: " + System.getProperty("os.version");
        ret = String.valueOf(ret) + "\nArchitecture: " + System.getProperty("os.arch");
        ret = String.valueOf(ret) + "\n\nJava Name: " + System.getProperty("java.vm.name");
        ret = String.valueOf(ret) + "\nJava Vendor: " + System.getProperty("java.vendor");
        ret = String.valueOf(ret) + "\nVersion: " + System.getProperty("java.version");
        ret = String.valueOf(ret) + "\n\nCurrent Thread: " + Thread.currentThread().getName();
        ret = String.valueOf(ret) + "\nAvailable processors (cores): " + Runtime.getRuntime().availableProcessors();
        ret = String.valueOf(ret) + "\nFree memory (bytes): " + Runtime.getRuntime().freeMemory();
        long maxMemory = Runtime.getRuntime().maxMemory();
        ret = String.valueOf(ret) + "\nMaximum memory (bytes): " + (maxMemory == Long.MAX_VALUE ? "no limit" : Long.valueOf(maxMemory));
        ret = String.valueOf(ret) + "\nTotal memory available to JVM (bytes): " + Runtime.getRuntime().totalMemory();
        File[] fileArray = roots = File.listRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            File root = fileArray[n2];
            ret = String.valueOf(ret) + "\n\nFile system root: " + root.getAbsolutePath();
            ret = String.valueOf(ret) + "\nTotal space (bytes): " + root.getTotalSpace();
            ret = String.valueOf(ret) + "\nFree space (bytes): " + root.getFreeSpace();
            ret = String.valueOf(ret) + "\nUsable space (bytes): " + root.getUsableSpace();
            ++n2;
        }
        ret = String.valueOf(ret) + "\n\nStack trace:";
        return ret;
    }

    public void setMessage(String message) {
        this.optionpane.setMessage(new Object[]{message, this.scroll});
    }

    public void setDebugInfo(String text) {
        this.debugInfo.setText("\n" + text);
        this.debugInfo.setCaretPosition(0);
    }

    public void setDebugInfo(Throwable e) {
        this.debugInfo.setText("\n" + ErrorDialog.throwableToString(e));
        this.debugInfo.setCaretPosition(0);
    }

    public void appendDebugInfo(String text) {
        this.debugInfo.append("\n" + text);
    }

    public void appendDebugInfo(Throwable e) {
        this.debugInfo.append("\n" + ErrorDialog.throwableToString(e));
    }

    private static JButton makeButton(String key, ActionListener listener) {
        JButton but = new JButton(Messages.getString(key), LGM.getIconForKey(key));
        but.addActionListener(listener);
        return but;
    }

    public ErrorDialog(Frame parent, String title, String message, String url) {
        this(parent, title, message, "", url);
    }

    public ErrorDialog(Frame parent, String title, String message, Throwable e, String url) {
        this(parent, title, message, ErrorDialog.throwableToString(e), url);
    }

    public ErrorDialog(Frame parent, String title, String message, Throwable e) {
        this(parent, title, message, ErrorDialog.throwableToString(e), Prefs.issueURI);
    }

    public ErrorDialog(Frame parent, String title, String message, String debugText, String uri) {
        super(parent, title);
        this.setResizable(false);
        this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
        this.submitURI = uri;
        this.debugInfo = new JTextArea();
        this.debugInfo.setEditable(false);
        this.debugInfo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ErrorDialog.this.debugInfo.getCaret().setVisible(true);
                ErrorDialog.this.debugInfo.getCaret().setSelectionVisible(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ErrorDialog.this.debugInfo.getCaret().setVisible(false);
                ErrorDialog.this.debugInfo.getCaret().setSelectionVisible(false);
            }
        });
        this.debugInfo.setText(ErrorDialog.generateAgnosticInformation());
        this.appendDebugInfo(debugText);
        this.scroll = new JScrollPane(this.debugInfo);
        Dimension dim = new Dimension(this.scroll.getWidth(), 200);
        this.scroll.setPreferredSize(dim);
        this.copy = ErrorDialog.makeButton("ErrorDialog.COPY", this);
        this.submit = ErrorDialog.makeButton("ErrorDialog.SUBMIT", this);
        this.cancel = ErrorDialog.makeButton("ErrorDialog.CANCEL", this);
        this.getRootPane().setDefaultButton(this.cancel);
        dim = new Dimension(Math.max(this.copy.getPreferredSize().width, this.cancel.getPreferredSize().width), this.copy.getPreferredSize().height);
        this.submit.setPreferredSize(dim);
        this.copy.setPreferredSize(dim);
        this.cancel.setPreferredSize(dim);
        this.optionpane = new JOptionPane(new Object[]{message, this.scroll}, 0, -1, null, new JButton[]{this.copy, this.submit, this.cancel});
        this.setContentPane(this.optionpane);
        this.setSize(640, 480);
        this.setLocationRelativeTo(parent);
    }

    protected static String throwableToString(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.submit) {
            try {
                Desktop.getDesktop().browse(URI.create(this.submitURI));
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, Messages.format("ErrorDialog.DESKTOP_MESSAGE", this.submitURI), Messages.getString("ErrorDialog.DESKTOP_TITLE"), 0);
            }
        } else if (e.getSource() == this.copy) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.debugInfo.getText()), null);
        } else if (e.getSource() == this.cancel) {
            this.dispose();
        }
    }
}

