/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import org.lateralgm.components.ImageEffects;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;

public class EffectsFrame
extends JFrame
implements ActionListener,
ImageEffects.EffectOptionListener {
    private static final long serialVersionUID = 4668913557919192011L;
    private static EffectsFrame INSTANCE = null;
    private static ImageEffects.ImageEffect[] effects = null;
    private JComboBox<ImageEffects.ImageEffect> effectsCombo = null;
    private List<BufferedImage> images = null;
    private JButton applyButton;
    private JButton closeButton;
    private EffectsFrameListener listener = null;
    private ImageEffectPreview beforePreview;
    private ImageEffectPreview afterPreview;

    public void setEffectsListener(EffectsFrameListener ln, List<BufferedImage> imgs) {
        this.listener = ln;
        INSTANCE.setImages(imgs);
    }

    public static EffectsFrame getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EffectsFrame();
        }
        return INSTANCE;
    }

    public EffectsFrame() {
        this.setAlwaysOnTop(false);
        this.setDefaultCloseOperation(1);
        this.setSize(700, 400);
        this.setLocationRelativeTo(LGM.frame);
        this.setTitle(Messages.getString("EffectsFrame.TITLE"));
        this.setIconImage(LGM.getIconForKey("EffectsFrame.ICON").getImage());
        this.setResizable(true);
        this.beforePreview = new ImageEffectPreview();
        this.beforePreview.setBorder(BorderFactory.createTitledBorder(Messages.getString("EffectsFrame.BEFORE")));
        this.afterPreview = new ImageEffectPreview();
        this.afterPreview.setBorder(BorderFactory.createTitledBorder(Messages.getString("EffectsFrame.AFTER")));
        effects = new ImageEffects.ImageEffect[12];
        EffectsFrame.effects[0] = new ImageEffects.BlackAndWhiteEffect();
        EffectsFrame.effects[1] = new ImageEffects.BlurEffect();
        EffectsFrame.effects[2] = new ImageEffects.ColorizeEffect();
        EffectsFrame.effects[3] = new ImageEffects.EdgeDetectEffect();
        EffectsFrame.effects[4] = new ImageEffects.EmbossEffect();
        EffectsFrame.effects[5] = new ImageEffects.FadeColorEffect();
        EffectsFrame.effects[6] = new ImageEffects.InvertEffect();
        EffectsFrame.effects[7] = new ImageEffects.IntensityEffect();
        EffectsFrame.effects[8] = new ImageEffects.OpacityEffect();
        EffectsFrame.effects[9] = new ImageEffects.RemoveColorEffect();
        EffectsFrame.effects[10] = new ImageEffects.RemoveTransparencyEffect();
        EffectsFrame.effects[11] = new ImageEffects.SharpenEffect();
        final JPanel effectsOptions = new JPanel(new CardLayout());
        ImageEffects.ImageEffect[] imageEffectArray = effects;
        int n = effects.length;
        int n2 = 0;
        while (n2 < n) {
            ImageEffects.ImageEffect effect = imageEffectArray[n2];
            effect.addOptionUpdateListener(this);
            effectsOptions.add((Component)effect.getOptionsPanel(), effect.getKey());
            ++n2;
        }
        this.effectsCombo = new JComboBox<ImageEffects.ImageEffect>(effects);
        this.effectsCombo.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -6761156840599766568L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object val = value;
                if (value instanceof ImageEffects.ImageEffect) {
                    val = ((ImageEffects.ImageEffect)value).getName();
                }
                return super.getListCellRendererComponent(list, val, index, isSelected, cellHasFocus);
            }
        });
        this.effectsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() != 1) {
                    return;
                }
                ImageEffects.ImageEffect effect = (ImageEffects.ImageEffect)ie.getItem();
                if (effect == null) {
                    return;
                }
                CardLayout cl = (CardLayout)effectsOptions.getLayout();
                cl.show(effectsOptions, effect.getKey());
                if (EffectsFrame.this.images == null || EffectsFrame.this.images.size() <= 0) {
                    return;
                }
                BufferedImage img = (BufferedImage)EffectsFrame.this.images.get(0);
                if (img == null) {
                    return;
                }
                EffectsFrame.this.afterPreview.setImage(effect.getAppliedImage(img));
            }
        });
        this.applyButton = new JButton(Messages.getString("EffectsFrame.APPLY"));
        this.applyButton.addActionListener(this);
        this.closeButton = new JButton(Messages.getString("EffectsFrame.CLOSE"));
        this.closeButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.closeButton);
        GroupLayout gl = new GroupLayout(this.getContentPane());
        gl.setAutoCreateContainerGaps(true);
        gl.setAutoCreateGaps(true);
        gl.setHorizontalGroup(gl.createParallelGroup().addGroup(gl.createSequentialGroup().addComponent(this.beforePreview).addComponent(this.afterPreview)).addGroup(gl.createSequentialGroup().addComponent(this.effectsCombo, -2, -2, -2).addComponent(this.applyButton).addComponent(this.closeButton)).addComponent(effectsOptions));
        gl.setVerticalGroup(gl.createSequentialGroup().addGroup(gl.createParallelGroup().addComponent(this.beforePreview).addComponent(this.afterPreview)).addGroup(gl.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.effectsCombo).addComponent(this.applyButton).addComponent(this.closeButton)).addComponent(effectsOptions, -2, -2, -2));
        this.setLayout(gl);
    }

    public void setImages(List<BufferedImage> imgs) {
        this.images = imgs;
        this.updatePreviews();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            int i = 0;
            while (i < this.images.size()) {
                ImageEffects.ImageEffect effect = (ImageEffects.ImageEffect)this.effectsCombo.getSelectedItem();
                this.images.set(i, effect.getAppliedImage(this.images.get(i)));
                ++i;
            }
            if (this.listener != null) {
                this.listener.applyEffects(this.images);
            }
            this.updatePreviews();
        } else if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.listener = null;
        }
    }

    @Override
    public void optionsUpdated() {
        this.updatePreviews();
    }

    public void updatePreviews() {
        ImageEffects.ImageEffect effect = (ImageEffects.ImageEffect)this.effectsCombo.getSelectedItem();
        if (effect == null) {
            return;
        }
        if (this.images == null || this.images.size() <= 0) {
            return;
        }
        BufferedImage img = this.images.get(0);
        if (img == null) {
            return;
        }
        this.beforePreview.setImage(img);
        this.afterPreview.setImage(effect.getAppliedImage(img));
    }

    public static interface EffectsFrameListener {
        public void applyEffects(List<BufferedImage> var1);
    }

    private class ImageEffectPreview
    extends JPanel {
        private static final long serialVersionUID = -3708532748005061371L;
        BufferedImage image = null;

        public ImageEffectPreview() {
            JPanel jp = new JPanel(){
                private static final long serialVersionUID = 1760158377097010861L;
                private BufferedImage transparentBackground;

                @Override
                public void paint(Graphics g) {
                    float factor;
                    if (ImageEffectPreview.this.image == null) {
                        return;
                    }
                    Rectangle bounds = this.getBounds();
                    int swidth = ImageEffectPreview.this.image.getWidth();
                    int sheight = ImageEffectPreview.this.image.getHeight();
                    if (ImageEffectPreview.this.image.getWidth() > bounds.width) {
                        factor = (float)(bounds.getWidth() / (double)ImageEffectPreview.this.image.getWidth());
                        swidth = bounds.width;
                        sheight = (int)(factor * (float)ImageEffectPreview.this.image.getHeight());
                    }
                    if (sheight > bounds.height) {
                        factor = (float)(bounds.getHeight() / (double)sheight);
                        swidth = (int)(factor * (float)swidth);
                        sheight = bounds.height;
                    }
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.translate((bounds.width - swidth) / 2, (bounds.height - sheight) / 2);
                    int width = (int)Math.ceil((float)swidth / 8.0f);
                    int height = (int)Math.ceil((float)sheight / 8.0f);
                    width = width < 1 ? 1 : width;
                    int n = height = height < 1 ? 1 : height;
                    if (this.transparentBackground == null || this.transparentBackground.getWidth() != width || this.transparentBackground.getHeight() != height) {
                        this.transparentBackground = Util.paintBackground(width, height);
                    }
                    Shape clip = g.getClip();
                    g.clipRect(0, 0, swidth, sheight);
                    g.drawImage(this.transparentBackground, 0, 0, this.transparentBackground.getWidth() * 8, this.transparentBackground.getHeight() * 8, null);
                    g.drawImage(ImageEffectPreview.this.image, 0, 0, swidth, sheight, null);
                    g.setClip(clip);
                }
            };
            GroupLayout bl = new GroupLayout(this);
            bl.setHorizontalGroup(bl.createParallelGroup().addComponent(jp));
            bl.setVerticalGroup(bl.createParallelGroup().addComponent(jp));
            this.setLayout(bl);
        }

        public void setImage(BufferedImage img) {
            this.image = img;
            if (this.image != null) {
                this.repaint();
            }
        }
    }
}

