/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.lateralgm.components.impl.CustomFileFilter;
import org.lateralgm.messages.Messages;

public class CustomFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private Preferences prefs;
    private String propertyName;
    private boolean fileMustExist = true;
    private boolean confirmOverwrite = true;

    public CustomFileChooser(String node, String propertyName) {
        this.propertyName = propertyName;
        this.prefs = Preferences.userRoot().node(node);
        this.setCurrentDirectory(new File(this.prefs.get(propertyName, this.getCurrentDirectory().getAbsolutePath())));
    }

    public void setConfirmOverwrite(boolean enable) {
        this.confirmOverwrite = enable;
    }

    public boolean getConfirmOverwrite() {
        return this.confirmOverwrite;
    }

    public boolean getFileExists() {
        boolean fileExists = false;
        if (this.isMultiSelectionEnabled()) {
            File[] fileArray = this.getSelectedFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.exists()) {
                    fileExists = true;
                    break;
                }
                ++n2;
            }
        } else {
            fileExists = this.getSelectedFile().exists();
        }
        return fileExists;
    }

    @Override
    public void approveSelection() {
        boolean fileExists;
        if (this.fileMustExist && this.getDialogType() == 0) {
            boolean fileExists2 = this.getFileExists();
            if (!fileExists2) {
                JOptionPane.showMessageDialog(this, Messages.getString("FileChooser.NOT_FOUND_MESSAGE"), Messages.getString("FileChooser.NOT_FOUND_TITLE"), 2);
                return;
            }
        } else if (this.confirmOverwrite && this.getDialogType() == 1 && (fileExists = this.getFileExists()) && JOptionPane.showConfirmDialog(this, Messages.getString("FileChooser.CONFIRM_OVERWRITE_MESSAGE"), Messages.getString("FileChooser.CONFIRM_OVERWRITE_TITLE"), 2) == 2) {
            return;
        }
        super.approveSelection();
        this.saveDir();
    }

    @Override
    public void cancelSelection() {
        super.cancelSelection();
        this.saveDir();
    }

    private void saveDir() {
        this.prefs.put(this.propertyName, this.getCurrentDirectory().getAbsolutePath());
    }

    public void setFileMustExist(boolean enable) {
        this.fileMustExist = enable;
    }

    public boolean getFileMustExist() {
        return this.fileMustExist;
    }

    public void setFilterSet(FilterSet fs) {
        if (fs == null) {
            throw new IllegalArgumentException("null FilterSet");
        }
        this.resetChoosableFileFilters();
        for (FileFilter filt : fs) {
            this.addChoosableFileFilter(filt);
        }
        if (fs.size() > 0) {
            this.setFileFilter((FileFilter)fs.get(0));
        }
    }

    public static class FilterSet
    extends ArrayList<FileFilter> {
        private static final long serialVersionUID = 1L;

        public void addFilter(String descKey, String ... exts) {
            this.add(new CustomFileFilter(Messages.getString(descKey), exts));
        }
    }
}

