/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JColorChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.text.MaskFormatter;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.util.PropertyEditor;
import org.lateralgm.util.PropertyLink;
import org.lateralgm.util.PropertyMap;

public class ColorSelect
extends JPanel
implements ItemSelectable,
PropertyEditor<Color> {
    private static final long serialVersionUID = 1L;
    private Color selectedColor;
    private boolean returnAlpha = true;
    private JPanel colorPanel;
    private JFormattedTextField textField;
    private static BufferedImage transparentImage;

    public ColorSelect(Color col) {
        if (transparentImage == null) {
            transparentImage = Util.paintBackground(2, 2);
        }
        this.colorPanel = new JPanel(){
            private static final long serialVersionUID = -948015130105405683L;

            @Override
            public void paint(Graphics g) {
                Rectangle clipBounds = g.getClipBounds();
                g.drawImage(transparentImage, 0, 0, clipBounds.width, clipBounds.height, null);
                super.paint(g);
            }
        };
        this.colorPanel.setBorder(BorderFactory.createSoftBevelBorder(0, Color.WHITE, Color.BLACK));
        this.colorPanel.setBackground(col);
        this.colorPanel.setOpaque(true);
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ColorSelect.this.colorPanel.setBorder(BorderFactory.createSoftBevelBorder(1, Color.WHITE, Color.BLACK));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ColorSelect.this.colorPanel.setBorder(BorderFactory.createSoftBevelBorder(0, Color.WHITE, Color.BLACK));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Color newcol = JColorChooser.showDialog(ColorSelect.this.getParent(), Messages.getString("ColorSelect.CHOOSE_TITLE"), ColorSelect.this.selectedColor);
                if (newcol != null) {
                    ColorSelect.this.setSelectedColor(newcol);
                    ColorSelect.this.fireItemChanged();
                }
            }
        });
        MaskFormatter formatter = new MaskFormatter();
        formatter.setPlaceholder("FFFFFFFF");
        formatter.setPlaceholderCharacter('F');
        try {
            formatter.setMask("HHHHHHHH");
        }
        catch (ParseException e) {
            LGM.showDefaultExceptionHandler(e);
        }
        this.textField = new JFormattedTextField(formatter);
        this.textField.setColumns(8);
        this.textField.setText(Util.formatColortoHex(col));
        this.textField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ColorSelect.this.selectedColor = new Color(Integer.rotateRight((int)Long.parseLong(ColorSelect.this.textField.getText(), 16), ColorSelect.this.textField.getText().length()), true);
                ColorSelect.this.colorPanel.setBackground(ColorSelect.this.selectedColor);
                ColorSelect.this.fireItemChanged();
            }
        });
        GroupLayout gl = new GroupLayout(this);
        gl.setAutoCreateGaps(true);
        gl.setAutoCreateContainerGaps(false);
        gl.setHorizontalGroup(gl.createSequentialGroup().addComponent(this.colorPanel, -2, -2, -2).addComponent(this.textField, -2, -2, -2));
        gl.setVerticalGroup(gl.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.colorPanel, -2, -2, -2).addComponent(this.textField));
        this.setLayout(gl);
        this.selectedColor = col;
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.textField.getBaseline(width, height);
    }

    public ColorSelect() {
        this(Color.BLACK);
    }

    public ColorSelect(Color col, boolean returnAlpha) {
        this(col);
        this.returnAlpha = returnAlpha;
    }

    protected void fireItemChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ItemEvent e = new ItemEvent(this, 701, this.selectedColor, 1);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ItemListener.class) {
                ((ItemListener)listeners[i + 1]).itemStateChanged(e);
            }
            i -= 2;
        }
    }

    public void setSelectedColor(Color selectedColor) {
        if (!this.returnAlpha) {
            selectedColor = new Color(selectedColor.getRed(), selectedColor.getGreen(), selectedColor.getBlue());
        }
        this.colorPanel.setBackground(selectedColor);
        this.textField.setText(Util.formatColortoHex(selectedColor));
        this.selectedColor = selectedColor;
    }

    public Color getSelectedColor() {
        if (this.returnAlpha) {
            return this.selectedColor;
        }
        Color selectedColorWithoutAlpha = new Color(this.selectedColor.getRed(), this.selectedColor.getGreen(), this.selectedColor.getBlue());
        return selectedColorWithoutAlpha;
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    @Override
    public Object[] getSelectedObjects() {
        return new Color[]{this.selectedColor};
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    @Override
    public <K extends Enum<K>> PropertyLink<K, Color> getLink(PropertyMap<K> m, K k) {
        return new ColorSelectLink(this, m, k);
    }

    private static class ColorSelectLink<K extends Enum<K>>
    extends PropertyLink<K, Color>
    implements ItemListener {
        final /* synthetic */ ColorSelect this$0;

        public ColorSelectLink(PropertyMap<K> m, K k) {
            this.this$0 = var1_1;
            super(m, k);
            this.reset();
            var1_1.addItemListener(this);
        }

        @Override
        protected void setComponent(Color c) {
            this.this$0.setSelectedColor(c);
        }

        @Override
        public void remove() {
            super.remove();
            this.this$0.removeItemListener(this);
        }

        @Override
        public void updated(PropertyMap.PropertyUpdateEvent<K> e) {
            this.editComponentIfChanged(this.this$0.selectedColor);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.this$0.selectedColor.equals(this.map.get(this.key))) {
                return;
            }
            this.editProperty(this.this$0.selectedColor);
        }
    }
}

