/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.lateralgm.components.MarkerCache;
import org.lateralgm.components.NumberField;
import org.lateralgm.file.ResourceList;
import org.lateralgm.joshedit.Code;
import org.lateralgm.joshedit.CompletionMenu;
import org.lateralgm.joshedit.DefaultKeywords;
import org.lateralgm.joshedit.DefaultTokenMarker;
import org.lateralgm.joshedit.JoshText;
import org.lateralgm.joshedit.JoshTextPanel;
import org.lateralgm.joshedit.Runner;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.Resource;
import org.lateralgm.resources.Script;

public class CodeTextArea
extends JoshTextPanel
implements UpdateSource.UpdateListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected static Timer timer;
    protected Integer lastUpdateTaskID = 0;
    private static Set<SortedSet<String>> resourceKeywords;
    protected static CompletionMenu.Completion[] completions;
    protected DefaultTokenMarker tokenMarker;
    private static final Color PURPLE;
    private static final Color FUNCTION;
    static DefaultTokenMarker.KeywordSet resNames;
    static DefaultTokenMarker.KeywordSet scrNames;
    AbstractAction completionAction = new AbstractAction("COMPLETE"){
        private static final long serialVersionUID = 1L;
        final Pattern W_BEFORE;
        final Pattern W_AFTER;
        {
            this.W_BEFORE = Pattern.compile("\\w+$");
            this.W_AFTER = Pattern.compile("^\\w+");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int pos = CodeTextArea.this.getCaretColumn();
            int row = CodeTextArea.this.getCaretLine();
            String lt = CodeTextArea.this.getLineText(row);
            int x1 = pos - CodeTextArea.find(lt.substring(0, pos), this.W_BEFORE).length();
            int x2 = pos + CodeTextArea.find(lt.substring(pos), this.W_AFTER).length();
            if (completions == null) {
                CodeTextArea.this.updateCompletions(CodeTextArea.this.tokenMarker);
            }
            new CompletionMenu(LGM.frame, CodeTextArea.this.text, row, x1, x2, pos, completions);
        }
    };

    static {
        Runner.editorInterface = new Runner.EditorInterface(){

            @Override
            public ImageIcon getIconForKey(String key) {
                return LGM.getIconForKey(key);
            }

            @Override
            public String getString(String key) {
                return Messages.getString(key);
            }

            @Override
            public String getString(String key, String def) {
                String str = this.getString(key);
                if (str.equals(String.valueOf('!') + key + '!')) {
                    return def;
                }
                return str;
            }
        };
        resourceKeywords = new HashSet<SortedSet<String>>();
        PURPLE = new Color(138, 54, 186);
        FUNCTION = new Color(0, 100, 150);
    }

    public CodeTextArea() {
        this(null, MarkerCache.getMarker("gml"));
    }

    public CodeTextArea(String code) {
        this(code, MarkerCache.getMarker("gml"));
    }

    public CodeTextArea(String code, DefaultTokenMarker marker) {
        super(code, Prefs.codeFont);
        this.tokenMarker = marker;
        this.setTabSize(Prefs.tabSize);
        this.setTokenMarker(this.tokenMarker);
        this.setupKeywords();
        CodeTextArea.updateResourceKeywords();
        this.text.getActionMap().put("COMPLETIONS", this.completionAction);
        LGM.currentFile.updateSource.addListener(this);
        JPopupMenu popup = new JPopupMenu();
        popup.add(CodeTextArea.makeContextButton(this.text.actCut));
        popup.add(CodeTextArea.makeContextButton(this.text.actCopy));
        popup.add(CodeTextArea.makeContextButton(this.text.actPaste));
        popup.addSeparator();
        final JMenuItem undoItem = CodeTextArea.makeContextButton(this.text.actUndo);
        popup.add(undoItem);
        final JMenuItem redoItem = CodeTextArea.makeContextButton(this.text.actRedo);
        popup.add(redoItem);
        popup.addSeparator();
        popup.add(CodeTextArea.makeContextButton(this.text.actSelAll));
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                undoItem.setEnabled(CodeTextArea.this.text.canUndo());
                redoItem.setEnabled(CodeTextArea.this.text.canRedo());
            }
        });
        this.text.setComponentPopupMenu(popup);
    }

    private JButton makeToolbarButton(String name) {
        String key = "JoshText." + name;
        JButton b = new JButton(LGM.getIconForKey(key));
        b.setToolTipText(Messages.getString(key));
        b.setRequestFocusEnabled(false);
        b.setActionCommand(key);
        b.addActionListener(this);
        return b;
    }

    private static JMenuItem makeContextButton(Action a) {
        String key = "JoshText." + a.getValue("Name");
        JMenuItem b = new JMenuItem();
        b.setIcon(LGM.getIconForKey(key));
        b.setText(Messages.getString(key));
        b.setRequestFocusEnabled(false);
        b.addActionListener(a);
        return b;
    }

    public void addEditorButtons(JToolBar tb) {
        tb.add(this.makeToolbarButton("LOAD"));
        tb.add(this.makeToolbarButton("SAVE"));
        tb.add(this.makeToolbarButton("PRINT"));
        tb.addSeparator();
        tb.add(this.makeToolbarButton("CUT"));
        tb.add(this.makeToolbarButton("COPY"));
        tb.add(this.makeToolbarButton("PASTE"));
        tb.addSeparator();
        final JButton undoButton = this.makeToolbarButton("UNDO");
        tb.add(undoButton);
        final JButton redoButton = this.makeToolbarButton("REDO");
        tb.add(redoButton);
        undoButton.setEnabled(this.text.canUndo());
        redoButton.setEnabled(this.text.canRedo());
        this.text.addLineChangeListener(new JoshText.LineChangeListener(){

            @Override
            public void linesChanged(Code code, int start, int end) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        undoButton.setEnabled((this).CodeTextArea.this.text.canUndo());
                        redoButton.setEnabled((this).CodeTextArea.this.text.canRedo());
                    }
                });
            }
        });
        tb.addSeparator();
        tb.add(this.makeToolbarButton("FIND"));
        tb.add(this.makeToolbarButton("GOTO"));
    }

    public void aGoto() {
        int line = CodeTextArea.showGotoDialog(this.getCaretLine());
        line = Math.max(0, Math.min(this.getLineCount() - 1, line));
        this.setCaretPosition(line, 0);
        this.repaint();
    }

    public static int showGotoDialog(int defVal) {
        final JDialog d = new JDialog(null, true);
        JPanel p = new JPanel();
        GroupLayout layout = new GroupLayout(p);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        p.setLayout(layout);
        JLabel l = new JLabel("Line: ");
        NumberField f = new NumberField(defVal);
        f.selectAll();
        JButton b = new JButton("Goto");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.setVisible(false);
            }
        });
        d.getRootPane().setDefaultButton(b);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(l).addComponent(f)).addComponent(b, GroupLayout.Alignment.CENTER));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(l).addComponent(f)).addComponent(b));
        d.setContentPane(p);
        d.pack();
        d.setResizable(false);
        d.setLocationRelativeTo(null);
        d.setVisible(true);
        return f.getIntValue();
    }

    private void setupKeywords() {
        resNames = this.tokenMarker.addKeywordSet("Resource Names", PURPLE, 0);
        scrNames = this.tokenMarker.addKeywordSet("Script Names", FUNCTION, 0);
    }

    public static void updateResourceKeywords() {
        CodeTextArea.resNames.words.clear();
        CodeTextArea.scrNames.words.clear();
        resourceKeywords.clear();
        for (Map.Entry e : LGM.currentFile.resMap.entrySet()) {
            ResourceList rl;
            if (!(e.getValue() instanceof ResourceList) || (rl = (ResourceList)e.getValue()).isEmpty()) continue;
            DefaultTokenMarker.KeywordSet ks = e.getKey() == Script.class ? scrNames : resNames;
            TreeSet<String> resSet = new TreeSet<String>();
            for (Resource r : rl) {
                ks.words.add(r.getName());
                resSet.add(r.getName());
            }
            resourceKeywords.add(resSet);
        }
        if (!resourceKeywords.isEmpty()) {
            completions = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void updateCompletions(DefaultTokenMarker tokenMarker2) {
        void var3_8;
        Object object;
        int l = 0;
        for (Set set : resourceKeywords) {
            l += set.size();
        }
        Object var3_6 = null;
        if (tokenMarker2 instanceof DefaultKeywords.HasKeywords) {
            DefaultKeywords.HasKeywords hk = (DefaultKeywords.HasKeywords)((Object)tokenMarker2);
            DefaultKeywords.Keyword[][] keywordArray = hk.getKeywords();
            object = keywordArray;
            int n = keywordArray.length;
            int n2 = 0;
            while (n2 < n) {
                DefaultKeywords.Keyword[] keywordArray2 = object[n2];
                l += keywordArray2.length;
                ++n2;
            }
        }
        completions = new CompletionMenu.Completion[l];
        int i = 0;
        for (Set set : resourceKeywords) {
            for (String string : set) {
                CodeTextArea.completions[i] = new CompletionMenu.WordCompletion(string);
                ++i;
            }
        }
        if (var3_8 == null) {
            return;
        }
        object = var3_8;
        int n = ((void)object).length;
        int n3 = 0;
        while (n3 < n) {
            Object object2;
            Object object3 = object2 = object[n3];
            int n4 = ((Object)object3).length;
            int n5 = 0;
            while (n5 < n4) {
                Object k = object3[n5];
                CodeTextArea.completions[i] = k instanceof DefaultKeywords.Function ? new FunctionCompletion((DefaultKeywords.Function)k) : (k instanceof DefaultKeywords.Variable ? new VariableCompletion((DefaultKeywords.Variable)k) : new CompletionMenu.WordCompletion(((DefaultKeywords.Keyword)k).getName()));
                ++i;
                ++n5;
            }
            ++n3;
        }
    }

    private static String find(String input, Pattern p) {
        Matcher m = p.matcher(input);
        if (m.find()) {
            return m.group();
        }
        return new String();
    }

    @Override
    public void updated(UpdateSource.UpdateEvent e) {
        if (timer == null) {
            timer = new Timer();
        }
        timer.schedule((TimerTask)new UpdateTask(), 500L);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.text.requestFocusInWindow();
    }

    public void markError(int line, int pos, int abs) {
        final ErrorHighlighter err = new ErrorHighlighter(line, pos);
        this.text.highlighters.add(err);
        this.text.addLineChangeListener(new JoshText.LineChangeListener(){

            @Override
            public void linesChanged(Code code, int start, int end) {
                CodeTextArea.this.text.highlighters.remove(err);
                CodeTextArea.this.text.removeLineChangeListener(this);
            }
        });
        this.text.repaint();
    }

    public void setTokenMarker(DefaultTokenMarker tokenMarker2) {
        this.tokenMarker = tokenMarker2;
        super.setTokenMarker(tokenMarker2);
        this.updateCompletions(tokenMarker2);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String com = ev.getActionCommand();
        if (com.equals("JoshText.LOAD")) {
            this.text.Load();
        } else if (com.equals("JoshText.SAVE")) {
            this.text.Save();
        } else if (com.equals("JoshText.PRINT")) {
            try {
                this.Print();
            }
            catch (PrinterException e) {
                LGM.showDefaultExceptionHandler(e);
            }
        } else if (com.equals("JoshText.UNDO")) {
            this.text.Undo();
        } else if (com.equals("JoshText.REDO")) {
            this.text.Redo();
        } else if (com.equals("JoshText.CUT")) {
            this.text.Cut();
        } else if (com.equals("JoshText.COPY")) {
            this.text.Copy();
        } else if (com.equals("JoshText.PASTE")) {
            this.text.Paste();
        } else if (com.equals("JoshText.FIND")) {
            this.text.ShowFind();
        } else if (com.equals("JoshText.GOTO")) {
            this.aGoto();
        } else if (com.equals("JoshText.SELALL")) {
            this.text.SelectAll();
        }
    }

    class ErrorHighlighter
    implements JoshText.Highlighter {
        protected final Color COL_SQ = Color.RED;
        protected final Color COL_HL = new Color(255, 240, 230);
        protected int line;
        protected int pos;
        protected int x2;

        public ErrorHighlighter(int line, int pos) {
            this.line = line;
            this.pos = pos;
            String code = CodeTextArea.this.getLineText(line);
            int otype = JoshText.selGetKind(code, pos);
            this.x2 = pos;
            do {
                ++this.x2;
            } while (JoshText.selOfKind(code, this.x2, otype));
        }

        @Override
        public void paint(Graphics g, Insets i, JoshText.CodeMetrics cm, int line_start, int line_end) {
            int gh = cm.lineHeight();
            g.setColor(this.COL_HL);
            g.fillRect(0, i.top + this.line * gh, g.getClipBounds().width, gh);
            g.setColor(this.COL_SQ);
            int y = i.top + this.line * gh + gh;
            int start = i.left + cm.lineWidth(this.line, this.pos);
            int end = i.left + cm.lineWidth(this.line, this.x2);
            int x = start;
            while (x < end) {
                g.drawLine(x, y, x + 1, y - 1);
                g.drawLine(x + 1, y - 1, x + 2, y);
                x += 2;
            }
        }
    }

    public class FunctionCompletion
    extends CompletionMenu.Completion {
        private final DefaultKeywords.Function function;

        public FunctionCompletion(DefaultKeywords.Function f) {
            this.function = f;
            this.name = f.getName();
        }

        @Override
        public boolean apply(JoshText a, char input, int row, int start, int end) {
            int p2;
            int p1;
            String s = String.valueOf(this.name) + "(" + this.getArguments() + ")";
            boolean argSel = true;
            switch (input) {
                case '\u0000': 
                case '(': {
                    break;
                }
                case ')': {
                    argSel = false;
                    break;
                }
                default: {
                    s = String.valueOf(s) + String.valueOf(input);
                }
            }
            if (argSel && this.function.arguments.length > 0) {
                p1 = this.name.length() + 1;
                p2 = p1 + this.getArgument(0).length();
            } else {
                p2 = p1 = s.length();
            }
            if (!FunctionCompletion.replace(a, row, start, end, s)) {
                return false;
            }
            CodeTextArea.this.setSelection(row, start + p1, row, start + p2);
            return true;
        }

        public String getArgument(int i) {
            if (i >= this.function.arguments.length) {
                return null;
            }
            return String.valueOf(this.function.arguments[i]) + (i == this.function.dynArgIndex ? "..." : "");
        }

        public String getArguments() {
            String s = "";
            int i = 0;
            while (i < this.function.arguments.length) {
                s = String.valueOf(s) + (i > 0 ? "," : "") + this.getArgument(i);
                ++i;
            }
            return s;
        }

        @Override
        public String toString() {
            return String.valueOf(this.name) + "(" + this.getArguments() + ")";
        }
    }

    private class UpdateTask
    extends TimerTask {
        private int id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UpdateTask() {
            Integer n = CodeTextArea.this.lastUpdateTaskID;
            synchronized (n) {
                CodeTextArea.this.lastUpdateTaskID = CodeTextArea.this.lastUpdateTaskID + 1;
                this.id = CodeTextArea.this.lastUpdateTaskID;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Integer n = CodeTextArea.this.lastUpdateTaskID;
            synchronized (n) {
                if (this.id != CodeTextArea.this.lastUpdateTaskID) {
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodeTextArea.updateResourceKeywords();
                    ((UpdateTask)UpdateTask.this).CodeTextArea.this.text.repaint();
                }
            });
        }
    }

    public class VariableCompletion
    extends CompletionMenu.Completion {
        private final DefaultKeywords.Variable variable;

        public VariableCompletion(DefaultKeywords.Variable v) {
            this.variable = v;
            this.name = v.getName();
        }

        @Override
        public boolean apply(JoshText a, char input, int row, int start, int end) {
            String s = this.name;
            int p = s.length();
            if (this.variable.arraySize > 0) {
                s = String.valueOf(s) + "[]";
                boolean ci = true;
                switch (input) {
                    case '\u0000': 
                    case '[': {
                        break;
                    }
                    case ']': {
                        ci = false;
                        break;
                    }
                    default: {
                        s = String.valueOf(s) + String.valueOf(input);
                    }
                }
                p = ci ? s.length() - 1 : s.length();
            }
            if (!VariableCompletion.replace(a, row, start, end, s)) {
                return false;
            }
            CodeTextArea.this.setCaretPosition(row, start + p);
            return true;
        }

        @Override
        public String toString() {
            String s = this.name;
            if (this.variable.arraySize > 0) {
                s = String.valueOf(s) + "[0.." + String.valueOf(this.variable.arraySize - 1) + "]";
            }
            if (this.variable.readOnly) {
                s = String.valueOf(s) + "*";
            }
            return s;
        }
    }
}

