/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoComboBox<T>
extends JComboBox<T> {
    private static final long serialVersionUID = -2358279864039989215L;
    JTextComponent editor = (JTextComponent)this.getEditor().getEditorComponent();
    DocumentFilter document = new DocumentFilter();
    boolean selecting = false;

    public AutoComboBox(T[] items) {
        super(items);
        this.editor.setDocument(this.document);
        this.setEditable(true);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AutoComboBox.this.selecting) {
                    AutoComboBox.this.document.highlightCompletedText(0);
                }
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (AutoComboBox.this.isDisplayable()) {
                    AutoComboBox.this.setPopupVisible(true);
                }
            }
        });
    }

    private Object lookupItem(String pattern) {
        Object selectedItem = this.getSelectedItem();
        Object ret = null;
        if (selectedItem != null) {
            if (selectedItem.toString().startsWith(pattern)) {
                return selectedItem;
            }
            if (selectedItem.toString().toUpperCase().startsWith(pattern.toUpperCase())) {
                ret = selectedItem;
            }
        }
        ComboBoxModel model = this.getModel();
        int i = 0;
        int n = model.getSize();
        while (i < n) {
            Object currentItem = model.getElementAt(i);
            if (currentItem.toString().startsWith(pattern)) {
                return currentItem;
            }
            if (currentItem.toString().toUpperCase().startsWith(pattern.toUpperCase())) {
                ret = currentItem;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public void setSelectedItem(Object item) {
        this.selecting = true;
        super.setSelectedItem(item);
        this.selecting = false;
    }

    public class DocumentFilter
    extends PlainDocument {
        private static final long serialVersionUID = 7860466445717335935L;

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
            if (AutoComboBox.this.selecting) {
                return;
            }
            Object item = AutoComboBox.this.lookupItem(this.getText(0, this.getLength()));
            if (item != null) {
                AutoComboBox.this.setSelectedItem(item);
            } else {
                item = AutoComboBox.this.getSelectedItem();
                offs -= str.length();
                AutoComboBox.this.getToolkit().beep();
            }
            this.setText(item.toString());
            this.highlightCompletedText(offs + str.length());
        }

        private void setText(String text) throws BadLocationException {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }

        private void highlightCompletedText(int start) {
            AutoComboBox.this.editor.setSelectionStart(start);
            AutoComboBox.this.editor.setSelectionEnd(this.getLength());
        }
    }
}

