/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.TransferHandler;
import org.lateralgm.components.ActionList;
import org.lateralgm.components.mdi.MDIFrame;
import org.lateralgm.components.visual.VTextIcon;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibManager;
import org.lateralgm.resources.library.Library;
import org.lateralgm.resources.sub.Action;

public class ActionListEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ActionList list;

    public ActionListEditor(ActionList list) {
        this.list = list;
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        JPanel labPane = Util.makeLabelPane(Messages.getString("GmObjectFrame.ACTIONS"));
        JScrollPane scroll = new JScrollPane(list);
        JTabbedPane actionTabs = ActionListEditor.makeLibraryTabs(list);
        GroupLayout.SequentialGroup orientationGroup = layout.createSequentialGroup();
        if (Prefs.rightOrientation) {
            orientationGroup.addComponent(actionTabs, -1, -1, -2);
        }
        orientationGroup.addGroup(layout.createParallelGroup().addComponent(labPane, -1, -2, Short.MAX_VALUE).addComponent(scroll, -1, 240, -1));
        if (!Prefs.rightOrientation) {
            orientationGroup.addComponent(actionTabs, -1, -1, -2);
        }
        layout.setHorizontalGroup(orientationGroup);
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(labPane, -1, -1, -2).addComponent(scroll)).addComponent(actionTabs));
    }

    private static JPanel makeLabelPane(String name) {
        return Util.makeLabelPane(name);
    }

    public static JTabbedPane makeLibraryTabs(ActionList actions) {
        JTabbedPane tp = new JTabbedPane(Prefs.rightOrientation ? 2 : 4);
        tp.setTabLayoutPolicy(1);
        for (Library l : LibManager.libs) {
            JPanel p = new JPanel();
            JPanel lp = null;
            GroupLayout layout = new GroupLayout(p);
            p.setLayout(layout);
            GroupLayout.ParallelGroup hg = layout.createParallelGroup();
            GroupLayout.SequentialGroup vg = layout.createSequentialGroup();
            layout.setHorizontalGroup(hg);
            layout.setVerticalGroup(vg);
            for (LibAction la : l.libActions) {
                if (la.hidden || la.actionKind == 9) continue;
                if (la.actionKind == 10) {
                    lp = ActionListEditor.makeLabelPane(la.name);
                    hg.addComponent(lp, -2, -2, -2);
                    vg.addComponent(lp, -2, -2, -2);
                    continue;
                }
                JLabel b = la.actionKind == 8 ? new JLabel() : new LibActionButton(la, actions);
                b.setHorizontalAlignment(2);
                b.setVerticalAlignment(1);
                b.setPreferredSize(new Dimension(30, 30));
                if (lp == null) {
                    lp = ActionListEditor.makeLabelPane(null);
                    hg.addComponent(lp, -2, -2, -2);
                    vg.addComponent(lp, -2, -2, -2);
                }
                lp.add(b);
            }
            tp.addTab(l.tabCaption, p);
            if (LGM.javaVersion < 10600) continue;
            tp.setTabComponentAt(tp.getTabCount() - 1, new JLabel(new VTextIcon(tp, l.tabCaption, tp.getTabPlacement() == 2 ? 2 : 0)));
        }
        return tp;
    }

    public void dispose() {
        this.list.dispose();
    }

    public static class LibActionButton
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private static ActionList.LibActionTransferHandler transferHandler = new ActionList.LibActionTransferHandler();
        private LibAction libAction;
        private ActionList list;

        public LibActionButton(LibAction la, ActionList list) {
            super(new ImageIcon(la.actImage));
            this.list = list;
            this.setToolTipText(la.description);
            this.libAction = la;
            this.setTransferHandler(transferHandler);
        }

        @Override
        public void processMouseEvent(MouseEvent e) {
            if (e.getID() == 501 && e.getButton() == 1) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, e, 1);
            } else if (e.getID() == 501 && e.getButton() == 3 && this.list.getActionContainer() != null) {
                Action act = new Action(this.libAction);
                ((ActionList.ActionListModel)this.list.getModel()).add(act);
                this.list.setSelectedValue(act, true);
                this.list.openActionFrame((MDIFrame)this.list.parent.get(), act);
            }
            super.processMouseEvent(e);
        }

        public LibAction getLibAction() {
            return this.libAction;
        }
    }
}

