/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.lateralgm.components.ActionListEditor;
import org.lateralgm.components.mdi.MDIFrame;
import org.lateralgm.main.LGM;
import org.lateralgm.main.Prefs;
import org.lateralgm.main.UpdateSource;
import org.lateralgm.main.Util;
import org.lateralgm.messages.Messages;
import org.lateralgm.resources.GmObject;
import org.lateralgm.resources.ResourceReference;
import org.lateralgm.resources.library.LibAction;
import org.lateralgm.resources.library.LibManager;
import org.lateralgm.resources.sub.Action;
import org.lateralgm.resources.sub.ActionContainer;
import org.lateralgm.resources.sub.Argument;
import org.lateralgm.subframes.ActionFrame;

public class ActionList
extends JList<Action>
implements ActionListener,
ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private static final ActionListKeyListener ALKL = new ActionListKeyListener();
    private final Map<Action, WeakReference<ActionFrame>> frames = new WeakHashMap<Action, WeakReference<ActionFrame>>();
    protected ActionContainer actionContainer;
    public ActionListModel model;
    private final ActionRenderer renderer = new ActionRenderer(this);
    public final WeakReference<MDIFrame> parent;
    private final ActionListMouseListener alml;
    public UndoManager undomanager;
    public static final DataFlavor ACTION_FLAVOR = new DataFlavor(Action.class, "Action");
    public static final DataFlavor ACTION_ARRAY_FLAVOR = new DataFlavor(List.class, "Action array");
    public static final DataFlavor LIB_ACTION_FLAVOR = new DataFlavor(LibAction.class, "Library action");

    private JMenuItem makeContextButton(String key) {
        JMenuItem b = new JMenuItem(Messages.getString(key));
        b.setActionCommand(key);
        b.setText(b.getText());
        b.setIcon(LGM.getIconForKey(key));
        b.setRequestFocusEnabled(false);
        b.addActionListener(this);
        return b;
    }

    public ActionList(MDIFrame parent) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = this.makeContextButton("ActionList.EDIT");
        popup.add(item);
        popup.addSeparator();
        item = this.makeContextButton("ActionList.CUT");
        popup.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("ActionList.CUT")));
        item = this.makeContextButton("ActionList.COPY");
        popup.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("ActionList.COPY")));
        item = this.makeContextButton("ActionList.PASTE");
        popup.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("ActionList.PASTE")));
        popup.addSeparator();
        this.undomanager = new UndoManager();
        final JMenuItem undoitem = this.makeContextButton("ActionList.UNDO");
        popup.add(undoitem);
        undoitem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("ActionList.UNDO")));
        final JMenuItem redoitem = this.makeContextButton("ActionList.REDO");
        popup.add(redoitem);
        redoitem.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("ActionList.REDO")));
        popup.addSeparator();
        item = this.makeContextButton("ActionList.SELECTALL");
        popup.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("ActionList.SELECTALL")));
        popup.addSeparator();
        item = this.makeContextButton("ActionList.DELETE");
        popup.add(item);
        item.setAccelerator(KeyStroke.getKeyStroke(Messages.getKeyboardString("ActionList.DELETE")));
        item = this.makeContextButton("ActionList.CLEAR");
        popup.add(item);
        this.setComponentPopupMenu(popup);
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
                undoitem.setEnabled(ActionList.this.undomanager.canUndo());
                redoitem.setEnabled(ActionList.this.undomanager.canRedo());
            }
        });
        this.parent = new WeakReference<MDIFrame>(parent);
        this.setActionContainer(null);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 24, 0));
        this.setTransferHandler(new ActionTransferHandler(this.parent, this));
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.alml = new ActionListMouseListener(this.parent);
        this.addMouseListener(this.alml);
        this.addKeyListener(ALKL);
        this.setCellRenderer(this.renderer);
    }

    public void setActionContainer(ActionContainer ac) {
        this.save();
        this.actionContainer = ac;
        this.model = new ActionListModel(this.undomanager);
        this.model.renderer = this.renderer;
        this.setModel(this.model);
        if (ac == null) {
            return;
        }
        this.model.addAll(ac.actions, false);
    }

    public ActionContainer getActionContainer() {
        return this.actionContainer;
    }

    public void save() {
        if (this.actionContainer == null) {
            return;
        }
        for (WeakReference<ActionFrame> a : this.frames.values()) {
            ActionFrame af;
            if (a == null || (af = (ActionFrame)a.get()) == null || af.isClosed()) continue;
            af.commitChanges();
        }
        this.actionContainer.actions = this.model.list;
    }

    public MDIFrame openActionFrame(MDIFrame parent, Action a) {
        ActionFrame af;
        LibAction la = a.getLibAction();
        if (!(la.libArguments != null && la.libArguments.length != 0 || la.canApplyTo || la.allowRelative || la.question)) {
            return null;
        }
        WeakReference<ActionFrame> fr = this.frames.get(a);
        ActionFrame actionFrame = af = fr == null ? null : (ActionFrame)fr.get();
        if (af == null || af.isClosed()) {
            af = new ActionFrame(a);
            LGM.mdi.add(af);
            if (parent != null) {
                LGM.mdi.addZChild(parent, af);
            }
            this.frames.put(a, new WeakReference<ActionFrame>(af));
        }
        af.setVisible(true);
        if (parent != null) {
            parent.toFront();
        }
        af.toFront();
        try {
            af.setIcon(false);
            af.setSelected(true);
        }
        catch (PropertyVetoException pve) {
            LGM.showDefaultExceptionHandler(pve);
        }
        return af;
    }

    public void closeFrames() {
        for (Map.Entry<Action, WeakReference<ActionFrame>> entry : this.frames.entrySet()) {
            ActionFrame frame = (ActionFrame)entry.getValue().get();
            if (frame == null) continue;
            frame.dispose();
        }
    }

    public void dispose() {
        this.closeFrames();
    }

    public void ActionsEdit(ActionList list) {
        int index = list.getSelectedIndex();
        if (index == -1) {
            return;
        }
        ActionListModel alm = (ActionListModel)list.getModel();
        list.openActionFrame((MDIFrame)this.parent.get(), alm.getElementAt(index));
    }

    public void ActionsCut(ActionList list) {
        if (list.isSelectionEmpty()) {
            return;
        }
        this.ActionsCopy(list);
        ActionList.ActionsDelete(list);
    }

    public void ActionsCopy(ActionList list) {
        if (list.isSelectionEmpty()) {
            return;
        }
        ArrayList actions = (ArrayList)list.getSelectedValuesList();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ActionTransferable at = new ActionTransferable(actions);
        clipboard.setContents(at, this);
    }

    public void ActionsPaste(ActionList list) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipboardContents = clipboard.getContents(this);
        DataFlavor[] dataFlavorArray = clipboardContents.getTransferDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor flavor = dataFlavorArray[n2];
            Object content = null;
            try {
                content = clipboardContents.getTransferData(flavor);
            }
            catch (UnsupportedFlavorException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            catch (IOException e) {
                LGM.showDefaultExceptionHandler(e);
            }
            if (flavor.equals(ACTION_ARRAY_FLAVOR)) {
                ActionListModel alm = (ActionListModel)list.getModel();
                ArrayList actions = (ArrayList)content;
                int ind = list.getSelectedIndex();
                if (ind < 0) {
                    ind = alm.getSize();
                }
                int i = 0;
                while (i < actions.size()) {
                    actions.set(i, ((Action)actions.get(i)).copy());
                    ++i;
                }
                alm.addAll(ind, (List<Action>)actions);
                list.setSelectionInterval(ind, ind += actions.size() - 1);
            }
            ++n2;
        }
    }

    public static void ActionsUndo(JList<Action> list) {
        if (!(list instanceof ActionList)) {
            return;
        }
        ActionList l = (ActionList)list;
        if (l.undomanager.canUndo()) {
            l.undomanager.undo();
        }
    }

    public static void ActionsRedo(JList<Action> list) {
        if (!(list instanceof ActionList)) {
            return;
        }
        ActionList l = (ActionList)list;
        if (l.undomanager.canRedo()) {
            l.undomanager.redo();
        }
    }

    public static void ActionsDelete(JList<Action> list) {
        int[] indices = list.getSelectedIndices();
        ActionListModel alm = (ActionListModel)list.getModel();
        ArrayList<Integer> inds = new ArrayList<Integer>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            inds.add(i);
            ++n2;
        }
        alm.removeAll(inds);
        if (indices.length != 0) {
            list.setSelectedIndex(Math.min(alm.getSize() - 1, indices[0]));
        }
    }

    public static void ActionsSelectAll(JList<Action> list) {
        int start = 0;
        int end = list.getModel().getSize() - 1;
        if (end >= 0) {
            list.setSelectionInterval(start, end);
        }
    }

    public static void ActionsClear(JList<Action> list) {
        ActionListModel alm = (ActionListModel)list.getModel();
        alm.clear();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String com = ev.getActionCommand();
        if (com.endsWith("EDIT")) {
            this.ActionsEdit(this);
        } else if (com.endsWith("CUT")) {
            this.ActionsCut(this);
        } else if (com.endsWith("COPY")) {
            this.ActionsCopy(this);
        } else if (com.endsWith("PASTE")) {
            this.ActionsPaste(this);
        } else if (com.endsWith("UNDO")) {
            ActionList.ActionsUndo(this);
        } else if (com.endsWith("REDO")) {
            ActionList.ActionsRedo(this);
        } else if (com.endsWith("SELECTALL")) {
            ActionList.ActionsSelectAll(this);
        } else if (com.endsWith("DELETE")) {
            ActionList.ActionsDelete(this);
        } else if (com.endsWith("CLEAR")) {
            ActionList.ActionsClear(this);
        }
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    private static class ActionListKeyListener
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
            if (!(e.getSource() instanceof ActionList)) {
                return;
            }
            JList l = (JList)e.getSource();
            KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
            if (stroke != null) {
                if (stroke.equals(KeyStroke.getKeyStroke(Messages.getKeyboardString("ActionList.UNDO")))) {
                    ActionList.ActionsUndo(l);
                } else if (stroke.equals(KeyStroke.getKeyStroke(Messages.getKeyboardString("ActionList.REDO")))) {
                    ActionList.ActionsRedo(l);
                }
            }
            switch (e.getKeyCode()) {
                case 127: {
                    ActionList.ActionsDelete(l);
                    e.consume();
                }
            }
        }
    }

    public class ActionListModel
    extends AbstractListModel<Action>
    implements UpdateSource.UpdateListener {
        private static final long serialVersionUID = 1L;
        public ArrayList<Action> list = new ArrayList();
        protected ArrayList<Integer> indents = new ArrayList();
        private ActionRenderer renderer;
        private UndoManager undoManager;

        public ActionListModel(UndoManager um) {
            this.undoManager = um;
        }

        public void add(Action a) {
            this.add(a, true);
        }

        public void add(Action a, boolean updateundo) {
            this.add(this.getSize(), a, updateundo);
        }

        public void add(int index, Action a) {
            this.add(index, a, true);
        }

        public void add(int index, Action a, boolean updateundo) {
            if (updateundo) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                ArrayList<Action> actions = new ArrayList<Action>();
                indices.add(index);
                actions.add(a);
                this.undoManager.addEdit(new UndoableActionEdit(0, indices, actions));
            }
            a.updateSource.addListener(this);
            this.list.add(index, a);
            this.updateIndentation();
            this.fireIntervalAdded(this, index, index);
        }

        public void addAll(int index, List<Action> c, boolean updateundo) {
            int s = c.size();
            if (s <= 0) {
                return;
            }
            ArrayList<Integer> indices = new ArrayList<Integer>();
            int i = index;
            for (Action a : c) {
                indices.add(i++);
                a.updateSource.addListener(this);
            }
            this.list.addAll(index, c);
            this.updateIndentation();
            this.fireIntervalAdded(this, index, index + s - 1);
            if (updateundo) {
                this.undoManager.addEdit(new UndoableActionEdit(0, indices, c));
            }
        }

        public void addAll(int index, List<Action> c) {
            this.addAll(index, c, true);
        }

        public void addAll(List<Action> c, boolean updateundo) {
            int s = c.size();
            if (s <= 0) {
                return;
            }
            for (Action a : c) {
                a.updateSource.addListener(this);
            }
            this.list.addAll(c);
            this.updateIndentation();
            this.fireIntervalAdded(this, 0, this.list.size());
            if (updateundo) {
                this.undoManager.addEdit(new UndoableActionEdit(0, c));
            }
        }

        public void addAll(List<Action> c) {
            this.addAll(c, true);
        }

        public void addAll(List<Integer> indices, List<Action> c, boolean updateundo) {
            int s = c.size();
            if (s <= 0) {
                return;
            }
            TreeMap<Integer, Action> map = new TreeMap<Integer, Action>();
            int i = 0;
            while (i < indices.size()) {
                Integer ind = indices.get(i);
                Action act = c.get(i);
                map.put(ind, act);
                ++i;
            }
            for (Map.Entry entry : map.entrySet()) {
                Action a = (Action)entry.getValue();
                Integer ind = (Integer)entry.getKey();
                a.updateSource.addListener(this);
                this.list.add(ind, a);
                this.fireIntervalAdded(this, ind, ind);
            }
            this.updateIndentation();
            if (updateundo) {
                this.undoManager.addEdit(new UndoableActionEdit(0, indices, c));
            }
        }

        public void addAll(List<Integer> indices, List<Action> c) {
            this.addAll(indices, c, true);
        }

        public void remove(int index, boolean updateundo) {
            if (updateundo) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                ArrayList<Action> actions = new ArrayList<Action>();
                indices.add(index);
                actions.add(this.list.get(index));
                this.undoManager.addEdit(new UndoableActionEdit(1, indices, actions));
            }
            this.list.remove((int)index).updateSource.removeListener(this);
            this.updateIndentation();
            this.fireIntervalRemoved(this, index, index);
        }

        public void remove(int index) {
            this.remove(index, true);
        }

        public void removeAll(List<Integer> indices, boolean updateundo) {
            int ind;
            ArrayList<Action> removed = new ArrayList<Action>();
            ArrayList<Integer> copy = new ArrayList<Integer>(indices);
            Collections.sort(copy, new Comparator<Integer>(){

                @Override
                public int compare(Integer a, Integer b) {
                    return b.compareTo(a);
                }
            });
            int i = 0;
            while (i < indices.size()) {
                ind = indices.get(i);
                removed.add(this.list.get(ind));
                ++i;
            }
            i = 0;
            while (i < copy.size()) {
                ind = (Integer)copy.get(i);
                this.list.remove((int)ind).updateSource.removeListener(this);
                this.fireIntervalRemoved(this, ind, ind);
                ++i;
            }
            if (updateundo) {
                this.undoManager.addEdit(new UndoableActionEdit(1, indices, removed));
            }
            this.updateIndentation();
        }

        public void removeAll(List<Integer> indices) {
            this.removeAll(indices, true);
        }

        public void clear(boolean updateundo) {
            ArrayList<Action> removed = new ArrayList<Action>(this.list);
            this.list.clear();
            this.fireIntervalRemoved(this, 0, removed.size());
            if (updateundo) {
                this.undoManager.addEdit(new UndoableActionEdit(1, removed));
            }
        }

        public void clear() {
            this.clear(true);
        }

        public int move(int prev, int next, ArrayList<Action> unchanged, boolean updateundo) {
            Action a = unchanged.get(prev);
            this.list.remove((int)prev).updateSource.removeListener(this);
            this.fireIntervalRemoved(this, prev, prev);
            if (next > this.list.size()) {
                next = this.list.size();
            }
            a.updateSource.addListener(this);
            this.list.add(next, a);
            this.fireIntervalAdded(this, next, next);
            if (updateundo) {
                ArrayList<Integer> indices = new ArrayList<Integer>(1);
                ArrayList<Integer> indicesmoved = new ArrayList<Integer>(1);
                indices.add(prev);
                indicesmoved.add(next);
                this.undoManager.addEdit(new UndoableActionEdit(2, indices, indicesmoved, null));
            }
            return next;
        }

        public void move(int prev, int next) {
            this.move(prev, next, new ArrayList<Action>(this.list), true);
        }

        public void moveAll(List<Integer> indices, List<Integer> indicesmoved, boolean updateundo) {
            ArrayList<Action> unchanged = new ArrayList<Action>(this.list);
            this.removeAll(indices, false);
            int i = 0;
            while (i < indices.size()) {
                Integer prev = indices.get(i);
                Integer next = indicesmoved.get(i);
                this.add(next, unchanged.get(prev), false);
                ++i;
            }
            this.fireContentsChanged(this, 0, this.list.size());
            if (updateundo) {
                this.undoManager.addEdit(new UndoableActionEdit(2, indices, indicesmoved, null));
            }
        }

        public void moveAll(List<Integer> indices, List<Integer> indicesmoved) {
            this.moveAll(indices, indicesmoved, true);
        }

        public void moveAll(List<Integer> indices, int index) {
            ArrayList<Integer> indicesmoved = new ArrayList<Integer>();
            int i = 0;
            while (i < indices.size()) {
                indicesmoved.add(index + i);
                ++i;
            }
            this.moveAll(indices, indicesmoved, true);
        }

        @Override
        public Action getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        private void updateIndentation() {
            int lms = this.list.size();
            this.indents.clear();
            this.indents.ensureCapacity(lms);
            Stack<Integer> levelIndents = new Stack<Integer>();
            Stack questions = new Stack();
            levelIndents.push(0);
            questions.push(new Stack());
            int nextIndent = 0;
            int i = 0;
            while (i < lms) {
                Action a = this.list.get(i);
                LibAction la = a.getLibAction();
                int indent = nextIndent++;
                switch (la.actionKind) {
                    case 1: {
                        levelIndents.push(indent);
                        questions.push(new Stack());
                        break;
                    }
                    case 2: {
                        indent = (Integer)levelIndents.peek();
                        if (levelIndents.size() > 1) {
                            levelIndents.pop();
                            questions.pop();
                        }
                        nextIndent = (Integer)levelIndents.peek();
                        break;
                    }
                    case 3: {
                        try {
                            int j = (Integer)((Stack)questions.peek()).pop();
                            if (j >= 0) {
                                indent = this.indents.get(j);
                            }
                        }
                        catch (EmptyStackException emptyStackException) {
                            // empty catch block
                        }
                        nextIndent = indent + 1;
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 4: {
                        nextIndent = (Integer)levelIndents.peek();
                        break;
                    }
                    default: {
                        if (la.question) {
                            ((Stack)questions.peek()).push(i);
                            ++nextIndent;
                            break;
                        }
                        if (la.execType == 0) break;
                        nextIndent = (Integer)levelIndents.peek();
                    }
                }
                this.indents.add(indent);
                ++i;
            }
        }

        @Override
        public void updated(UpdateSource.UpdateEvent e) {
            if (this.renderer != null) {
                this.renderer.clearCache();
            }
        }
    }

    private static class ActionListMouseListener
    extends MouseAdapter {
        public final WeakReference<MDIFrame> parent;

        public ActionListMouseListener(WeakReference<MDIFrame> parent) {
            this.parent = parent;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2 || !(e.getSource() instanceof ActionList)) {
                return;
            }
            ActionList l = (ActionList)e.getSource();
            Object o = l.getSelectedValue();
            if (o == null && l.getModel().getSize() == 0 && l.getActionContainer() != null) {
                o = new Action(LibManager.codeAction);
                ((ActionListModel)l.getModel()).add((Action)o);
                l.setSelectedValue(o, true);
            }
            if (o == null || !(o instanceof Action)) {
                return;
            }
            l.openActionFrame((MDIFrame)this.parent.get(), (Action)o);
        }
    }

    private static class ActionRenderer
    implements ListCellRenderer<Action> {
        private final WeakHashMap<Action, SoftReference<ActionRendererComponent>> lcrMap = new WeakHashMap();
        private final ActionList list;

        public ActionRenderer(ActionList l) {
            this.list = l;
        }

        public void clearCache() {
            this.lcrMap.clear();
        }

        public static String parse(String s, Action a) {
            String escape = "FrNw01234567";
            StringBuilder ret = new StringBuilder();
            int k = 0;
            int p = s.indexOf(64);
            while (p != -1) {
                ret.append(s.substring(k, p));
                char c = s.charAt(p + 1);
                if (!escape.contains(String.valueOf(c))) {
                    ret.append('@');
                    k = p + 1;
                    p = s.indexOf(64, k);
                    continue;
                }
                if (c == 'F') {
                    if (s.charAt(p + 2) == 'B' || s.charAt(p + 2) == 'I') {
                        p += 2;
                    } else {
                        ret.append('@');
                    }
                    k = p + 1;
                    p = s.indexOf(64, k);
                    continue;
                }
                if (c == 'r' && a.isRelative()) {
                    ret.append(Messages.getString("Action.RELATIVE"));
                }
                if (c == 'N' && a.isNot()) {
                    ret.append(Messages.getString("Action.NOT"));
                }
                ResourceReference<GmObject> at = a.getAppliesTo();
                if (c == 'w' && !at.equals(GmObject.OBJECT_SELF)) {
                    if (at.equals(GmObject.OBJECT_OTHER)) {
                        ret.append(Messages.getString("Action.APPLIES_OTHER"));
                    } else {
                        GmObject applies = Util.deRef(at);
                        ret.append(Messages.format("Action.APPLIES", applies == null ? at.toString() : applies.getName()));
                    }
                }
                if (c >= '0' && c < '8') {
                    int arg = c - 48;
                    List<Argument> args = a.getArguments();
                    if (arg >= args.size()) {
                        ret.append('0');
                    } else {
                        Argument aa = args.get(arg);
                        ret.append(aa.toString(a.getLibAction().libArguments[arg]));
                    }
                }
                k = p + 2;
                p = s.indexOf(64, k);
            }
            return ret + s.substring(k);
        }

        public static String escape(String s) {
            s = s.replaceAll("&", "&amp;");
            s = s.replaceAll("<", "&lt;");
            s = s.replaceAll(">", "&gt;");
            s = s.replaceAll("\n", "<br>");
            s = s.replaceAll("\\\\#", "\n");
            s = s.replaceAll("#", "<br>");
            s = s.replaceAll("\n", "&#35;");
            return s.replaceAll(" ", "&nbsp;");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Action> l, Action cell, int index, boolean isSelected, boolean hasFocus) {
            Action cellAction = cell;
            SoftReference<ActionRendererComponent> arcref = this.lcrMap.get(cellAction);
            ActionRendererComponent arc = null;
            if (arcref != null) {
                arc = arcref.get();
            }
            if (arc == null) {
                arc = new ActionRendererComponent(index, this.list);
                this.lcrMap.put(cellAction, new SoftReference<ActionRendererComponent>(arc));
            }
            ListModel lm = this.list.getModel();
            try {
                if (lm instanceof ActionListModel) {
                    arc.setIndent(((ActionListModel)lm).indents.get(index));
                }
                arc.setIndex(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            arc.setSelected(isSelected);
            return arc;
        }

        private static class ActionLineComponent
        extends JLabel {
            private static final long serialVersionUID = 4152567649770789101L;
            private JList<Action> list = null;
            private int index = 0;
            private int maxwidth = 0;

            public ActionLineComponent(int ind, JList<Action> l) {
                this.setText(Integer.toString(ind));
                this.index = ind;
                this.list = l;
            }

            @Override
            public void paintComponent(Graphics g) {
                int width = g.getFontMetrics().stringWidth(this.getText());
                int height = g.getFontMetrics().getHeight();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(this.getForeground());
                g.drawString(this.getText(), 5 + this.maxwidth - width, (int)((this.getPreferredSize().getHeight() - (double)height) / 2.0 + (double)this.getFontMetrics(this.getFont()).getAscent()));
                g.fillRect(5 + this.maxwidth + 5, 0, 2, this.getPreferredSize().height);
            }

            public void setIndex(int ind) {
                this.index = ind;
                this.setText(Integer.toString(this.index));
            }

            public void updatePreferredSize() {
                this.maxwidth = this.getFontMetrics(this.getFont()).stringWidth(Integer.toString(this.list.getModel().getSize() - 1));
                this.setPreferredSize(new Dimension(5 + this.maxwidth + 7, this.getPreferredSize().height));
            }
        }

        private static class ActionRendererComponent
        extends JPanel {
            private static final long serialVersionUID = 1L;
            private boolean selected;
            private final JList<Action> list;
            JLabel actlabel = null;
            ActionLineComponent linelabel = null;

            public ActionRendererComponent(int index, JList<Action> l) {
                this.list = l;
                this.setLayout(new FlowLayout(0, 0, 0));
                this.actlabel = new JLabel();
                this.linelabel = new ActionLineComponent(index, l);
                this.setOpaque(true);
                this.setBackground(this.selected ? this.list.getSelectionBackground() : this.list.getBackground());
                this.actlabel.setForeground(this.selected ? this.list.getSelectionForeground() : this.list.getForeground());
                this.linelabel.setBackground(this.list.getBackground());
                this.linelabel.setForeground(this.list.getForeground());
                Action a = l.getModel().getElementAt(index);
                LibAction la = a.getLibAction();
                if (la.actImage == null) {
                    this.actlabel.setText(Messages.getString("Action.UNKNOWN"));
                } else {
                    Pattern r;
                    Matcher m;
                    StringBuilder sb = null;
                    if (a.getLibAction().actionKind == 7 && (m = (r = Pattern.compile("^\\s*//[/!]+\\s*(.+)([\r\n]|$)")).matcher(a.getArguments().get(0).getVal())).find()) {
                        sb = new StringBuilder(m.group(1));
                    }
                    if (sb == null) {
                        sb = new StringBuilder("<html>");
                        if (la.listText.contains("@FI")) {
                            sb.append("<i>");
                        }
                        if (la.listText.contains("@FB")) {
                            sb.append("<b>");
                        }
                        sb.append(ActionRenderer.escape(ActionRenderer.parse(la.listText, a)));
                    }
                    this.actlabel.setText(sb.toString());
                    this.actlabel.setIcon(new ImageIcon(la.actImage));
                    if (Prefs.actionToolTipLines > 0 && Prefs.actionToolTipColumns > 0) {
                        sb = new StringBuilder();
                        String snip = ActionRenderer.parse(la.hintText.replaceAll("(?<!\\\\)#", "\n"), a);
                        int next = -1;
                        int i = 0;
                        while (i < Prefs.actionToolTipLines) {
                            int last = next + 1;
                            if ((next = snip.indexOf(10, last)) == -1) {
                                sb.append(snip.substring(last));
                                break;
                            }
                            if (next > last + Prefs.actionToolTipColumns) {
                                sb.append(snip.substring(last, last + Prefs.actionToolTipColumns));
                                sb.append("...");
                            } else {
                                sb.append(snip.substring(last, next));
                            }
                            sb.append('\n');
                            ++i;
                        }
                        if (next != -1) {
                            sb.append(Messages.getString("Action.HINT_MORE"));
                        }
                        this.setToolTipText("<html><font face=\"Courier\">" + ActionRenderer.escape(sb.toString()));
                    }
                }
                this.linelabel.setPreferredSize(new Dimension(this.linelabel.getPreferredSize().width, this.actlabel.getPreferredSize().height + 4));
                this.add(this.linelabel);
                this.add(this.actlabel);
            }

            @Override
            public boolean isVisible() {
                return false;
            }

            public void setIndent(int indent) {
                this.actlabel.setBorder(new EmptyBorder(2, 2 + 8 * indent, 2, 2));
                this.linelabel.updatePreferredSize();
            }

            public void setSelected(boolean selected) {
                if (this.selected == selected) {
                    return;
                }
                this.selected = selected;
                if (selected) {
                    this.setBackground(this.list.getSelectionBackground());
                    this.actlabel.setForeground(this.list.getSelectionForeground());
                } else {
                    this.setBackground(this.list.getBackground());
                    this.actlabel.setForeground(this.list.getForeground());
                }
            }

            public void setIndex(int index) {
                this.linelabel.setIndex(index);
            }
        }
    }

    public static class ActionTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        private int[] indices = null;
        private int addIndex = -1;
        private final WeakReference<MDIFrame> parent;
        private ActionList list = null;

        public ActionTransferHandler(WeakReference<MDIFrame> parent, ActionList l) {
            this.parent = parent;
            this.list = l;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            if (this.indices != null) {
                ActionListModel model = (ActionListModel)this.list.getModel();
                ArrayList<Integer> inds = new ArrayList<Integer>(this.indices.length);
                int index = this.addIndex;
                int i = 0;
                while (i < this.indices.length) {
                    inds.add(this.indices[i]);
                    if (this.indices[i] < this.addIndex) {
                        --index;
                    }
                    ++i;
                }
                if (action == 2) {
                    if (this.addIndex != -1) {
                        model.moveAll(inds, index);
                        this.list.setSelectionInterval(index, index + inds.size() - 1);
                    } else {
                        model.removeAll(inds);
                    }
                }
            }
            this.indices = null;
            this.addIndex = -1;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            DataFlavor[] f = info.getDataFlavors();
            boolean supported = false;
            DataFlavor[] dataFlavorArray = f;
            int n = f.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor flav = dataFlavorArray[n2];
                if (flav == ACTION_FLAVOR || flav == ACTION_ARRAY_FLAVOR || flav == LIB_ACTION_FLAVOR) {
                    supported = true;
                }
                ++n2;
            }
            if (!supported) {
                return false;
            }
            ActionList list = (ActionList)info.getComponent();
            if (list.actionContainer == null) {
                return false;
            }
            return !info.isDrop() || ((JList.DropLocation)info.getDropLocation()).getIndex() != -1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!this.canImport(info)) {
                return false;
            }
            ActionList list = (ActionList)info.getComponent();
            ActionListModel alm = (ActionListModel)list.getModel();
            Transferable t = info.getTransferable();
            int index = list.getSelectedIndex();
            int n = index = index < 0 ? alm.getSize() : index;
            if (info.isDrop()) {
                index = ((JList.DropLocation)info.getDropLocation()).getIndex();
            }
            if (info.isDataFlavorSupported(ACTION_FLAVOR)) {
                Action a;
                try {
                    a = (Action)t.getTransferData(ACTION_FLAVOR);
                }
                catch (Exception e) {
                    LGM.showDefaultExceptionHandler(e);
                    return false;
                }
                if (!info.isDrop() || info.getDropAction() == 1) {
                    a = a.copy();
                }
                if (info.isDrop() && info.getDropAction() == 2 && this.indices != null) {
                    this.addIndex = index;
                } else {
                    alm.add(index, a);
                    list.setSelectionInterval(index, index);
                }
                return true;
            }
            if (info.isDataFlavorSupported(ACTION_ARRAY_FLAVOR)) {
                List a;
                try {
                    a = (List)t.getTransferData(ACTION_ARRAY_FLAVOR);
                }
                catch (Exception e) {
                    LGM.showDefaultExceptionHandler(e);
                    return false;
                }
                if (!info.isDrop() || info.getDropAction() == 1) {
                    int i = 0;
                    while (i < a.size()) {
                        a.set(i, ((Action)a.get(i)).copy());
                        ++i;
                    }
                }
                if (info.isDrop() && info.getDropAction() == 2 && this.indices != null) {
                    this.addIndex = index;
                } else {
                    alm.addAll(index, (List<Action>)a);
                    list.setSelectionInterval(index, index + a.size() - 1);
                }
                return true;
            }
            if (info.isDataFlavorSupported(LIB_ACTION_FLAVOR)) {
                Action a;
                try {
                    LibAction la = (LibAction)t.getTransferData(LIB_ACTION_FLAVOR);
                    a = new Action(la);
                    list.openActionFrame((MDIFrame)this.parent.get(), a);
                }
                catch (Exception e) {
                    LGM.showDefaultExceptionHandler(e);
                    return false;
                }
                alm.add(index, a);
                list.setSelectionInterval(index, index);
                return true;
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (this.list.isSelectionEmpty()) {
                return null;
            }
            this.indices = this.list.getSelectedIndices();
            return new ActionTransferable((ArrayList)this.list.getSelectedValuesList());
        }
    }

    public static class ActionTransferable
    implements Transferable {
        private final ArrayList<Action> actions;
        private final DataFlavor[] flavors;

        public ActionTransferable(ArrayList<Action> a) {
            this.actions = a;
            ArrayList<DataFlavor> fl = new ArrayList<DataFlavor>(2);
            fl.add(ACTION_ARRAY_FLAVOR);
            if (a.size() == 1) {
                fl.add(ACTION_FLAVOR);
            }
            this.flavors = fl.toArray(new DataFlavor[fl.size()]);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor == ACTION_FLAVOR && this.actions.size() == 1) {
                return this.actions.get(0);
            }
            if (flavor == ACTION_ARRAY_FLAVOR) {
                return this.actions;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] dataFlavorArray = this.flavors;
            int n = this.flavors.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor f = dataFlavorArray[n2];
                if (f == flavor) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static class LibActionTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            return false;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            ActionListEditor.LibActionButton lab = (ActionListEditor.LibActionButton)c;
            LibAction la = lab.getLibAction();
            return new LibActionTransferable(la);
        }
    }

    public static class LibActionTransferable
    implements Transferable {
        private static final DataFlavor[] FLAVORS = new DataFlavor[]{LIB_ACTION_FLAVOR};
        private final LibAction libAction;

        public LibActionTransferable(LibAction la) {
            this.libAction = la;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor == LIB_ACTION_FLAVOR) {
                return this.libAction;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == LIB_ACTION_FLAVOR;
        }
    }

    public class UndoableActionEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = 3005489569659632528L;
        public static final byte ACTION_ADD = 0;
        public static final byte ACTION_REMOVE = 1;
        public static final byte ACTION_MOVE = 2;
        public static final byte ACTION_EDIT = 3;
        public int type;
        List<Action> actions = null;
        List<Integer> indices = null;
        List<Integer> indicesmoved = null;

        public UndoableActionEdit(int t, List<Action> acts) {
            this.type = t;
            this.actions = acts;
        }

        public UndoableActionEdit(int t, List<Integer> inds, List<Action> acts) {
            this.type = t;
            this.actions = acts;
            this.indices = inds;
        }

        public UndoableActionEdit(int t, List<Integer> inds, List<Integer> moved, List<Action> acts) {
            this.type = t;
            this.indices = inds;
            this.indicesmoved = moved;
        }

        @Override
        public String getPresentationName() {
            return "Action " + this.type;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (this.type == 0) {
                if (this.indices != null) {
                    ActionList.this.model.addAll(this.indices, this.actions, false);
                } else {
                    ActionList.this.model.addAll(this.actions, false);
                }
            } else if (this.type == 1) {
                if (this.indices != null) {
                    ActionList.this.model.removeAll(this.indices, false);
                } else {
                    ActionList.this.model.clear(false);
                }
            } else if (this.type == 2) {
                ActionList.this.model.moveAll(this.indices, this.indicesmoved, false);
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.type == 0) {
                if (this.indices != null) {
                    ActionList.this.model.removeAll(this.indices, false);
                } else {
                    ActionList.this.model.clear(false);
                }
            } else if (this.type == 1) {
                if (this.indices != null) {
                    ActionList.this.model.addAll(this.indices, this.actions, false);
                } else {
                    ActionList.this.model.addAll(this.actions, false);
                }
            } else if (this.type == 2) {
                ActionList.this.model.moveAll(this.indicesmoved, this.indices, false);
            }
        }
    }
}

