/*
 * Decompiled with CFR 0.152.
 */
package org.lateralgm.components;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.lateralgm.main.LGM;
import org.lateralgm.messages.Messages;

public class AboutBox
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private LicenseDialog licenseDialog;

    public AboutBox(Frame owner) {
        super(owner, Messages.getString("AboutBox.TITLE"), true);
        this.setResizable(false);
        JEditorPane ep = new JEditorPane("text/html", Messages.format("AboutBox.ABOUT", "1.8.229"));
        AboutBox.addSSRules(((HTMLDocument)ep.getDocument()).getStyleSheet());
        ep.setOpaque(false);
        ep.setEditable(false);
        AboutBox.setLinkHandler(ep);
        AboutBox.lockWidth(ep, Math.max(ep.getMinimumSize().width, 400));
        JOptionPane op = new JOptionPane(ep, -1, -1, null, (Object[])Option.values(), (Object)Option.CLOSE);
        op.addPropertyChangeListener("value", this);
        this.add(op);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    protected static void addSSRules(StyleSheet s) {
        s.addRule("body { font-size: 12pt; font-family: Dialog; }");
    }

    protected static void lockWidth(JTextComponent c, int width) {
        Dimension max = new Dimension(width, Integer.MAX_VALUE);
        c.setSize(max);
        Dimension min = new Dimension(max.width, c.getPreferredSize().height);
        c.setMaximumSize(max);
        c.setMinimumSize(min);
        c.setPreferredSize(min);
    }

    protected static void setLinkHandler(JEditorPane ep) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                ep.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                            Desktop desktop = Desktop.getDesktop();
                            try {
                                desktop.browse(e.getURL().toURI());
                            }
                            catch (URISyntaxException use) {
                                LGM.showDefaultExceptionHandler(use);
                            }
                            catch (IOException ioe) {
                                LGM.showDefaultExceptionHandler(ioe);
                            }
                        }
                    }
                });
                return;
            }
        }
        catch (NoClassDefFoundError e) {
            LGM.showDefaultExceptionHandler(e);
        }
    }

    private void showLicense() {
        if (this.licenseDialog == null) {
            this.licenseDialog = new LicenseDialog(this);
        }
        this.licenseDialog.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.isVisible()) {
            Object v = e.getNewValue();
            if (!(v instanceof Option)) {
                return;
            }
            switch ((Option)((Object)v)) {
                case CLOSE: {
                    this.dispose();
                    break;
                }
                case LICENSE: {
                    this.showLicense();
                }
            }
            Object s = e.getSource();
            if (s instanceof JOptionPane) {
                ((JOptionPane)s).setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        }
    }

    private static class LicenseDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public LicenseDialog(JDialog owner) {
            super(owner, Messages.getString("AboutBox.LICENSE_TITLE"), true);
            this.setDefaultCloseOperation(1);
            this.setResizable(false);
            JEditorPane ep = new JEditorPane("text/html", Messages.getString("AboutBox.LICENSE"));
            AboutBox.addSSRules(((HTMLDocument)ep.getDocument()).getStyleSheet());
            ep.setOpaque(false);
            ep.setEditable(false);
            AboutBox.setLinkHandler(ep);
            AboutBox.lockWidth(ep, 400);
            JOptionPane op = new JOptionPane(ep, -1);
            op.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue().equals(0)) {
                        LicenseDialog.this.setVisible(false);
                    }
                    ((JOptionPane)evt.getSource()).setValue(JOptionPane.UNINITIALIZED_VALUE);
                }
            });
            this.add(op);
            this.pack();
            this.setLocationRelativeTo(owner);
        }
    }

    private static enum Option {
        LICENSE,
        CLOSE;


        public String toString() {
            return Messages.getString("AboutBox.OPTION_" + this.name());
        }
    }
}

