/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabStop;
import javax.swing.text.rtf.MockAttributeSetExt;
import javax.swing.text.rtf.RTFAttributeExt;
import javax.swing.text.rtf.RTFAttributesExt;
import javax.swing.text.rtf.RTFParserExt;

class RTFReaderExt
extends RTFParserExt {
    StyledDocument target;
    Dictionary<String, Object> parserState;
    Destination rtfDestination;
    MutableAttributeSet documentAttributes;
    Dictionary<Object, String> fontTable;
    Color[] colorTable;
    Style[] characterStyles;
    Style[] paragraphStyles;
    Style[] sectionStyles;
    int rtfversion;
    boolean ignoreGroupIfUnknownKeyword;
    int skippingCharacters;
    private static Dictionary<?, ?> straightforwardAttributes = RTFAttributesExt.attributesByKeyword();
    private MockAttributeSetExt mockery;
    static Dictionary<String, String> textKeywords = null;
    static final String TabAlignmentKey = "tab_alignment";
    static final String TabLeaderKey = "tab_leader";
    static Dictionary<String, char[]> characterSets;
    static boolean useNeXTForAnsi;

    static {
        textKeywords = new Hashtable<String, String>();
        textKeywords.put("\\", "\\");
        textKeywords.put("{", "{");
        textKeywords.put("}", "}");
        textKeywords.put(" ", "\u00a0");
        textKeywords.put("~", "\u00a0");
        textKeywords.put("_", "\u2011");
        textKeywords.put("bullet", "\u2022");
        textKeywords.put("emdash", "\u2014");
        textKeywords.put("emspace", "\u2003");
        textKeywords.put("endash", "\u2013");
        textKeywords.put("enspace", "\u2002");
        textKeywords.put("ldblquote", "\u201c");
        textKeywords.put("lquote", "\u2018");
        textKeywords.put("ltrmark", "\u200e");
        textKeywords.put("rdblquote", "\u201d");
        textKeywords.put("rquote", "\u2019");
        textKeywords.put("rtlmark", "\u200f");
        textKeywords.put("tab", "\t");
        textKeywords.put("zwj", "\u200d");
        textKeywords.put("zwnj", "\u200c");
        textKeywords.put("-", "\u2027");
        useNeXTForAnsi = false;
        characterSets = new Hashtable<String, char[]>();
    }

    public RTFReaderExt(StyledDocument destination) {
        this.target = destination;
        this.parserState = new Hashtable<String, Object>();
        this.fontTable = new Hashtable<Object, String>();
        this.rtfversion = -1;
        this.mockery = new MockAttributeSetExt();
        this.documentAttributes = new SimpleAttributeSet();
    }

    @Override
    public void handleBinaryBlob(byte[] data) {
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return;
        }
    }

    @Override
    public void handleText(String text) {
        if (this.skippingCharacters > 0) {
            if (this.skippingCharacters >= text.length()) {
                this.skippingCharacters -= text.length();
                return;
            }
            text = text.substring(this.skippingCharacters);
            this.skippingCharacters = 0;
        }
        if (this.rtfDestination != null) {
            this.rtfDestination.handleText(text);
            return;
        }
        this.warning("Text with no destination. oops.");
    }

    Color defaultColor() {
        return Color.black;
    }

    @Override
    public void begingroup() {
        Object oldSaveState;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((oldSaveState = this.parserState.get("_savedState")) != null) {
            this.parserState.remove("_savedState");
        }
        Dictionary saveState = (Dictionary)((Hashtable)this.parserState).clone();
        if (oldSaveState != null) {
            saveState.put("_savedState", oldSaveState);
        }
        this.parserState.put("_savedState", saveState);
        if (this.rtfDestination != null) {
            this.rtfDestination.begingroup();
        }
    }

    @Override
    public void endgroup() {
        Dictionary restoredState;
        Destination restoredDestination;
        if (this.skippingCharacters > 0) {
            this.skippingCharacters = 0;
        }
        if ((restoredDestination = (Destination)(restoredState = (Dictionary)this.parserState.get("_savedState")).get("dst")) != this.rtfDestination) {
            this.rtfDestination.close();
            this.rtfDestination = restoredDestination;
        }
        Dictionary<String, Object> oldParserState = this.parserState;
        this.parserState = restoredState;
        if (this.rtfDestination != null) {
            this.rtfDestination.endgroup(oldParserState);
        }
    }

    protected void setRTFDestination(Destination newDestination) {
        Dictionary previousState = (Dictionary)this.parserState.get("_savedState");
        if (previousState != null && this.rtfDestination != previousState.get("dst")) {
            this.warning("Warning, RTF destination overridden, invalid RTF.");
            this.rtfDestination.close();
        }
        this.rtfDestination = newDestination;
        this.parserState.put("dst", this.rtfDestination);
    }

    @Override
    public void close() throws IOException {
        Enumeration<?> docProps = this.documentAttributes.getAttributeNames();
        while (docProps.hasMoreElements()) {
            Object propName = docProps.nextElement();
            this.target.putProperty(propName, this.documentAttributes.getAttribute((String)propName));
        }
        this.warning("RTF filter done.");
        super.close();
    }

    @Override
    public boolean handleKeyword(String keyword) {
        boolean ignoreGroupIfUnknownKeywordSave = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        String item = textKeywords.get(keyword);
        if (item != null) {
            this.handleText(item);
            return true;
        }
        if (keyword.equals("fonttbl")) {
            this.setRTFDestination(new FonttblDestination());
            return true;
        }
        if (keyword.equals("colortbl")) {
            this.setRTFDestination(new ColortblDestination());
            return true;
        }
        if (keyword.equals("stylesheet")) {
            this.setRTFDestination(new StylesheetDestination());
            return true;
        }
        if (keyword.equals("info")) {
            this.setRTFDestination(new InfoDestination());
            return false;
        }
        if (keyword.equals("mac")) {
            this.setCharacterSet("mac");
            return true;
        }
        if (keyword.equals("ansi")) {
            if (useNeXTForAnsi) {
                this.setCharacterSet("NeXT");
            } else {
                this.setCharacterSet("ansi");
            }
            return true;
        }
        if (keyword.equals("next")) {
            this.setCharacterSet("NeXT");
            return true;
        }
        if (keyword.equals("pc")) {
            this.setCharacterSet("cpg437");
            return true;
        }
        if (keyword.equals("pca")) {
            this.setCharacterSet("cpg850");
            return true;
        }
        if (keyword.equals("*")) {
            this.ignoreGroupIfUnknownKeyword = true;
            return true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(keyword)) {
            return true;
        }
        if (keyword.equals("aftncn") || keyword.equals("aftnsep") || keyword.equals("aftnsepc") || keyword.equals("annotation") || keyword.equals("atnauthor") || keyword.equals("atnicn") || keyword.equals("atnid") || keyword.equals("atnref") || keyword.equals("atntime") || keyword.equals("atrfend") || keyword.equals("atrfstart") || keyword.equals("bkmkend") || keyword.equals("bkmkstart") || keyword.equals("datafield") || keyword.equals("do") || keyword.equals("dptxbxtext") || keyword.equals("falt") || keyword.equals("field") || keyword.equals("file") || keyword.equals("filetbl") || keyword.equals("fname") || keyword.equals("fontemb") || keyword.equals("fontfile") || keyword.equals("footer") || keyword.equals("footerf") || keyword.equals("footerl") || keyword.equals("footerr") || keyword.equals("footnote") || keyword.equals("ftncn") || keyword.equals("ftnsep") || keyword.equals("ftnsepc") || keyword.equals("header") || keyword.equals("headerf") || keyword.equals("headerl") || keyword.equals("headerr") || keyword.equals("keycode") || keyword.equals("nextfile") || keyword.equals("object") || keyword.equals("pict") || keyword.equals("pn") || keyword.equals("pnseclvl") || keyword.equals("pntxtb") || keyword.equals("pntxta") || keyword.equals("revtbl") || keyword.equals("rxe") || keyword.equals("tc") || keyword.equals("template") || keyword.equals("txe") || keyword.equals("xe")) {
            ignoreGroupIfUnknownKeywordSave = true;
        }
        if (ignoreGroupIfUnknownKeywordSave) {
            this.setRTFDestination(new DiscardingDestination());
        }
        return false;
    }

    @Override
    public boolean handleKeyword(String keyword, int parameter) {
        boolean ignoreGroupIfUnknownKeywordSave = this.ignoreGroupIfUnknownKeyword;
        if (this.skippingCharacters > 0) {
            --this.skippingCharacters;
            return true;
        }
        this.ignoreGroupIfUnknownKeyword = false;
        if (keyword.equals("uc")) {
            this.parserState.put("UnicodeSkip", parameter);
            return true;
        }
        if (keyword.equals("u")) {
            if (parameter < 0) {
                parameter += 65536;
            }
            this.handleText((char)parameter);
            Number skip = (Number)this.parserState.get("UnicodeSkip");
            this.skippingCharacters = skip != null ? skip.intValue() : 1;
            return true;
        }
        if (keyword.equals("rtf")) {
            this.rtfversion = parameter;
            this.setRTFDestination(new DocumentDestination());
            return true;
        }
        if (keyword.startsWith("NeXT") || keyword.equals("private")) {
            ignoreGroupIfUnknownKeywordSave = true;
        }
        if (this.rtfDestination != null && this.rtfDestination.handleKeyword(keyword, parameter)) {
            return true;
        }
        if (ignoreGroupIfUnknownKeywordSave) {
            this.setRTFDestination(new DiscardingDestination());
        }
        return false;
    }

    private void setTargetAttribute(String name, Object value) {
    }

    public void setCharacterSet(String name) {
        Object set;
        try {
            set = RTFReaderExt.getCharacterSet(name);
        }
        catch (Exception e) {
            this.warning("Exception loading RTF character set \"" + name + "\": " + e);
            set = null;
        }
        if (set != null) {
            this.translationTable = (char[])set;
        } else {
            this.warning("Unknown RTF character set \"" + name + "\"");
            if (!name.equals("ansi")) {
                try {
                    this.translationTable = (char[])RTFReaderExt.getCharacterSet("ansi");
                }
                catch (IOException e) {
                    throw new InternalError("RTFReader: Unable to find character set resources (" + e + ")");
                }
            }
        }
        this.setTargetAttribute("rtfCharacterSet", name);
    }

    public static void defineCharacterSet(String name, char[] table) {
        if (table.length < 256) {
            throw new IllegalArgumentException("Translation table must have 256 entries.");
        }
        characterSets.put(name, table);
    }

    public static Object getCharacterSet(final String name) throws IOException {
        char[] set = characterSets.get(name);
        if (set == null) {
            InputStream charsetStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return RTFReaderExt.class.getResourceAsStream("charsets/" + name + ".txt");
                }
            });
            set = RTFReaderExt.readCharset(charsetStream);
            RTFReaderExt.defineCharacterSet(name, set);
        }
        return set;
    }

    static char[] readCharset(InputStream strm) throws IOException {
        char[] values = new char[256];
        StreamTokenizer in = new StreamTokenizer(new BufferedReader(new InputStreamReader(strm, "ISO-8859-1")));
        in.eolIsSignificant(false);
        in.commentChar(35);
        in.slashSlashComments(true);
        in.slashStarComments(true);
        int i = 0;
        while (i < 256) {
            int ttype;
            try {
                ttype = in.nextToken();
            }
            catch (Exception e) {
                throw new IOException("Unable to read from character set file (" + e + ")");
            }
            if (ttype != -2) {
                throw new IOException("Unexpected token in character set file");
            }
            values[i] = (char)in.nval;
            ++i;
        }
        return values;
    }

    static char[] readCharset(URL href) throws IOException {
        return RTFReaderExt.readCharset(href.openStream());
    }

    abstract class AttributeTrackingDestination
    implements Destination {
        MutableAttributeSet characterAttributes = this.rootCharacterAttributes();
        MutableAttributeSet paragraphAttributes;
        MutableAttributeSet sectionAttributes;

        public AttributeTrackingDestination() {
            RTFReaderExt.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = this.rootParagraphAttributes();
            RTFReaderExt.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = this.rootSectionAttributes();
            RTFReaderExt.this.parserState.put("sec", this.sectionAttributes);
        }

        @Override
        public abstract void handleText(String var1);

        @Override
        public void handleBinaryBlob(byte[] data) {
            RTFReaderExt.this.warning("Unexpected binary data in RTF file.");
        }

        @Override
        public void begingroup() {
            MutableAttributeSet characterParent = this.currentTextAttributes();
            MutableAttributeSet paragraphParent = this.currentParagraphAttributes();
            AttributeSet sectionParent = this.currentSectionAttributes();
            this.characterAttributes = new SimpleAttributeSet();
            this.characterAttributes.addAttributes(characterParent);
            RTFReaderExt.this.parserState.put("chr", this.characterAttributes);
            this.paragraphAttributes = new SimpleAttributeSet();
            this.paragraphAttributes.addAttributes(paragraphParent);
            RTFReaderExt.this.parserState.put("pgf", this.paragraphAttributes);
            this.sectionAttributes = new SimpleAttributeSet();
            this.sectionAttributes.addAttributes(sectionParent);
            RTFReaderExt.this.parserState.put("sec", this.sectionAttributes);
        }

        @Override
        public void endgroup(Dictionary<String, Object> oldState) {
            this.characterAttributes = (MutableAttributeSet)RTFReaderExt.this.parserState.get("chr");
            this.paragraphAttributes = (MutableAttributeSet)RTFReaderExt.this.parserState.get("pgf");
            this.sectionAttributes = (MutableAttributeSet)RTFReaderExt.this.parserState.get("sec");
        }

        @Override
        public void close() {
        }

        @Override
        public boolean handleKeyword(String keyword) {
            if (keyword.equals("ulnone")) {
                return this.handleKeyword("ul", 0);
            }
            Object item = straightforwardAttributes.get(keyword);
            if (item != null) {
                boolean ok;
                RTFAttributeExt attr = (RTFAttributeExt)item;
                switch (attr.domain()) {
                    case 0: {
                        ok = attr.set(this.characterAttributes);
                        break;
                    }
                    case 1: {
                        ok = attr.set(this.paragraphAttributes);
                        break;
                    }
                    case 2: {
                        ok = attr.set(this.sectionAttributes);
                        break;
                    }
                    case 4: {
                        ((RTFReaderExt)RTFReaderExt.this).mockery.backing = RTFReaderExt.this.parserState;
                        ok = attr.set(RTFReaderExt.this.mockery);
                        ((RTFReaderExt)RTFReaderExt.this).mockery.backing = null;
                        break;
                    }
                    case 3: {
                        ok = attr.set(RTFReaderExt.this.documentAttributes);
                        break;
                    }
                    default: {
                        ok = false;
                    }
                }
                if (ok) {
                    return true;
                }
            }
            if (keyword.equals("plain")) {
                this.resetCharacterAttributes();
                return true;
            }
            if (keyword.equals("pard")) {
                this.resetParagraphAttributes();
                return true;
            }
            if (keyword.equals("sectd")) {
                this.resetSectionAttributes();
                return true;
            }
            return false;
        }

        @Override
        public boolean handleKeyword(String keyword, int parameter) {
            boolean booleanParameter;
            boolean bl = booleanParameter = parameter != 0;
            if (keyword.equals("fc")) {
                keyword = "cf";
            }
            if (keyword.equals("f")) {
                RTFReaderExt.this.parserState.put(keyword, parameter);
                return true;
            }
            if (keyword.equals("cf")) {
                RTFReaderExt.this.parserState.put(keyword, parameter);
                return true;
            }
            Object item = straightforwardAttributes.get(keyword);
            if (item != null) {
                boolean ok;
                RTFAttributeExt attr = (RTFAttributeExt)item;
                switch (attr.domain()) {
                    case 0: {
                        ok = attr.set(this.characterAttributes, parameter);
                        break;
                    }
                    case 1: {
                        ok = attr.set(this.paragraphAttributes, parameter);
                        break;
                    }
                    case 2: {
                        ok = attr.set(this.sectionAttributes, parameter);
                        break;
                    }
                    case 4: {
                        ((RTFReaderExt)RTFReaderExt.this).mockery.backing = RTFReaderExt.this.parserState;
                        ok = attr.set(RTFReaderExt.this.mockery, parameter);
                        ((RTFReaderExt)RTFReaderExt.this).mockery.backing = null;
                        break;
                    }
                    case 3: {
                        ok = attr.set(RTFReaderExt.this.documentAttributes, parameter);
                        break;
                    }
                    default: {
                        ok = false;
                    }
                }
                if (ok) {
                    return true;
                }
            }
            if (keyword.equals("fs")) {
                StyleConstants.setFontSize(this.characterAttributes, parameter / 2);
                return true;
            }
            if (keyword.equals("sl")) {
                if (parameter == 1000) {
                    this.characterAttributes.removeAttribute(StyleConstants.LineSpacing);
                } else {
                    StyleConstants.setLineSpacing(this.characterAttributes, (float)parameter / 20.0f);
                }
                return true;
            }
            if (keyword.equals("tx") || keyword.equals("tb")) {
                Integer stopCount;
                float tabPosition = (float)parameter / 20.0f;
                int tabAlignment = 0;
                Number item2 = (Number)RTFReaderExt.this.parserState.get(RTFReaderExt.TabAlignmentKey);
                if (item2 != null) {
                    tabAlignment = item2.intValue();
                }
                int tabLeader = 0;
                item2 = (Number)RTFReaderExt.this.parserState.get(RTFReaderExt.TabLeaderKey);
                if (item2 != null) {
                    tabLeader = item2.intValue();
                }
                if (keyword.equals("tb")) {
                    tabAlignment = 5;
                }
                RTFReaderExt.this.parserState.remove(RTFReaderExt.TabAlignmentKey);
                RTFReaderExt.this.parserState.remove(RTFReaderExt.TabLeaderKey);
                TabStop newStop = new TabStop(tabPosition, tabAlignment, tabLeader);
                Hashtable<Object, Serializable> tabs = (Hashtable<Object, Serializable>)RTFReaderExt.this.parserState.get("_tabs");
                if (tabs == null) {
                    tabs = new Hashtable<Object, Serializable>();
                    RTFReaderExt.this.parserState.put("_tabs", tabs);
                    stopCount = 1;
                } else {
                    stopCount = (Integer)((Dictionary)tabs).get("stop count");
                    stopCount = 1 + stopCount;
                }
                ((Dictionary)tabs).put(stopCount, newStop);
                ((Dictionary)tabs).put("stop count", stopCount);
                RTFReaderExt.this.parserState.remove("_tabs_immutable");
                return true;
            }
            if (keyword.equals("s") && RTFReaderExt.this.paragraphStyles != null) {
                RTFReaderExt.this.parserState.put("paragraphStyle", RTFReaderExt.this.paragraphStyles[parameter]);
                return true;
            }
            if (keyword.equals("cs") && RTFReaderExt.this.characterStyles != null) {
                RTFReaderExt.this.parserState.put("characterStyle", RTFReaderExt.this.characterStyles[parameter]);
                return true;
            }
            if (keyword.equals("ds") && RTFReaderExt.this.sectionStyles != null) {
                RTFReaderExt.this.parserState.put("sectionStyle", RTFReaderExt.this.sectionStyles[parameter]);
                return true;
            }
            return false;
        }

        protected MutableAttributeSet rootCharacterAttributes() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            StyleConstants.setItalic(set, false);
            StyleConstants.setBold(set, false);
            StyleConstants.setUnderline(set, false);
            StyleConstants.setForeground(set, RTFReaderExt.this.defaultColor());
            return set;
        }

        protected MutableAttributeSet rootParagraphAttributes() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            StyleConstants.setLeftIndent(set, 0.0f);
            StyleConstants.setRightIndent(set, 0.0f);
            StyleConstants.setFirstLineIndent(set, 0.0f);
            set.setResolveParent(RTFReaderExt.this.target.getStyle("default"));
            return set;
        }

        protected MutableAttributeSet rootSectionAttributes() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            return set;
        }

        MutableAttributeSet currentTextAttributes() {
            Style characterStyle;
            Integer stateItem;
            SimpleAttributeSet attributes = new SimpleAttributeSet(this.characterAttributes);
            Integer fontnum = (Integer)RTFReaderExt.this.parserState.get("f");
            String fontFamily = fontnum != null ? RTFReaderExt.this.fontTable.get(fontnum) : null;
            if (fontFamily != null) {
                StyleConstants.setFontFamily(attributes, fontFamily);
            } else {
                attributes.removeAttribute(StyleConstants.FontFamily);
            }
            if (RTFReaderExt.this.colorTable != null) {
                stateItem = (Integer)RTFReaderExt.this.parserState.get("cf");
                if (stateItem != null) {
                    Color fg = RTFReaderExt.this.colorTable[stateItem];
                    StyleConstants.setForeground(attributes, fg);
                } else {
                    attributes.removeAttribute(StyleConstants.Foreground);
                }
            }
            if (RTFReaderExt.this.colorTable != null) {
                stateItem = (Integer)RTFReaderExt.this.parserState.get("cb");
                if (stateItem != null) {
                    Color bg = RTFReaderExt.this.colorTable[stateItem];
                    attributes.addAttribute(StyleConstants.Background, bg);
                } else {
                    attributes.removeAttribute(StyleConstants.Background);
                }
            }
            if ((characterStyle = (Style)RTFReaderExt.this.parserState.get("characterStyle")) != null) {
                attributes.setResolveParent(characterStyle);
            }
            return attributes;
        }

        MutableAttributeSet currentParagraphAttributes() {
            Style paragraphStyle;
            Dictionary workingTabs;
            SimpleAttributeSet bld = new SimpleAttributeSet(this.paragraphAttributes);
            TabStop[] tabs = (TabStop[])RTFReaderExt.this.parserState.get("_tabs_immutable");
            if (tabs == null && (workingTabs = (Dictionary)RTFReaderExt.this.parserState.get("_tabs")) != null) {
                int count = (Integer)workingTabs.get("stop count");
                tabs = new TabStop[count];
                int ix = 1;
                while (ix <= count) {
                    tabs[ix - 1] = (TabStop)workingTabs.get(ix);
                    ++ix;
                }
                RTFReaderExt.this.parserState.put("_tabs_immutable", tabs);
            }
            if (tabs != null) {
                bld.addAttribute("tabs", tabs);
            }
            if ((paragraphStyle = (Style)RTFReaderExt.this.parserState.get("paragraphStyle")) != null) {
                bld.setResolveParent(paragraphStyle);
            }
            return bld;
        }

        public AttributeSet currentSectionAttributes() {
            SimpleAttributeSet attributes = new SimpleAttributeSet(this.sectionAttributes);
            Style sectionStyle = (Style)RTFReaderExt.this.parserState.get("sectionStyle");
            if (sectionStyle != null) {
                attributes.setResolveParent(sectionStyle);
            }
            return attributes;
        }

        protected void resetCharacterAttributes() {
            this.handleKeyword("f", 0);
            this.handleKeyword("cf", 0);
            this.handleKeyword("fs", 24);
            Enumeration attributes = straightforwardAttributes.elements();
            while (attributes.hasMoreElements()) {
                RTFAttributeExt attr = (RTFAttributeExt)attributes.nextElement();
                if (attr.domain() != 0) continue;
                attr.setDefault(this.characterAttributes);
            }
            this.handleKeyword("sl", 1000);
            RTFReaderExt.this.parserState.remove("characterStyle");
        }

        protected void resetParagraphAttributes() {
            RTFReaderExt.this.parserState.remove("_tabs");
            RTFReaderExt.this.parserState.remove("_tabs_immutable");
            RTFReaderExt.this.parserState.remove("paragraphStyle");
            StyleConstants.setAlignment(this.paragraphAttributes, 0);
            Enumeration attributes = straightforwardAttributes.elements();
            while (attributes.hasMoreElements()) {
                RTFAttributeExt attr = (RTFAttributeExt)attributes.nextElement();
                if (attr.domain() != 1) continue;
                attr.setDefault(this.characterAttributes);
            }
        }

        protected void resetSectionAttributes() {
            Enumeration attributes = straightforwardAttributes.elements();
            while (attributes.hasMoreElements()) {
                RTFAttributeExt attr = (RTFAttributeExt)attributes.nextElement();
                if (attr.domain() != 2) continue;
                attr.setDefault(this.characterAttributes);
            }
            RTFReaderExt.this.parserState.remove("sectionStyle");
        }
    }

    class ColortblDestination
    implements Destination {
        int red = 0;
        int green = 0;
        int blue = 0;
        Vector<Color> proTemTable = new Vector();

        @Override
        public void handleText(String text) {
            int index = 0;
            index = 0;
            while (index < text.length()) {
                if (text.charAt(index) == ';') {
                    Color newColor = new Color(this.red, this.green, this.blue);
                    this.proTemTable.addElement(newColor);
                }
                ++index;
            }
        }

        @Override
        public void close() {
            int count = this.proTemTable.size();
            RTFReaderExt.this.warning("Done reading color table, " + count + " entries.");
            RTFReaderExt.this.colorTable = new Color[count];
            this.proTemTable.copyInto(RTFReaderExt.this.colorTable);
        }

        @Override
        public boolean handleKeyword(String keyword, int parameter) {
            if (keyword.equals("red")) {
                this.red = parameter;
            } else if (keyword.equals("green")) {
                this.green = parameter;
            } else if (keyword.equals("blue")) {
                this.blue = parameter;
            } else {
                return false;
            }
            return true;
        }

        @Override
        public boolean handleKeyword(String keyword) {
            return false;
        }

        @Override
        public void begingroup() {
        }

        @Override
        public void endgroup(Dictionary<String, Object> oldState) {
        }

        @Override
        public void handleBinaryBlob(byte[] data) {
        }
    }

    static interface Destination {
        public void handleBinaryBlob(byte[] var1);

        public void handleText(String var1);

        public boolean handleKeyword(String var1);

        public boolean handleKeyword(String var1, int var2);

        public void begingroup();

        public void endgroup(Dictionary<String, Object> var1);

        public void close();
    }

    class DiscardingDestination
    implements Destination {
        DiscardingDestination() {
        }

        @Override
        public void handleBinaryBlob(byte[] data) {
        }

        @Override
        public void handleText(String text) {
        }

        @Override
        public boolean handleKeyword(String text) {
            return true;
        }

        @Override
        public boolean handleKeyword(String text, int parameter) {
            return true;
        }

        @Override
        public void begingroup() {
        }

        @Override
        public void endgroup(Dictionary<String, Object> oldState) {
        }

        @Override
        public void close() {
        }
    }

    class DocumentDestination
    extends TextHandlingDestination
    implements Destination {
        DocumentDestination() {
        }

        @Override
        public void deliverText(String text, AttributeSet characterAttributes) {
            try {
                RTFReaderExt.this.target.insertString(RTFReaderExt.this.target.getLength(), text, this.currentTextAttributes());
            }
            catch (BadLocationException ble) {
                throw new InternalError(ble.getMessage());
            }
        }

        @Override
        public void finishParagraph(AttributeSet pgfAttributes, AttributeSet chrAttributes) {
            int pgfEndPosition = RTFReaderExt.this.target.getLength();
            try {
                RTFReaderExt.this.target.insertString(pgfEndPosition, "\n", chrAttributes);
                RTFReaderExt.this.target.setParagraphAttributes(pgfEndPosition, 1, pgfAttributes, true);
            }
            catch (BadLocationException ble) {
                throw new InternalError(ble.getMessage());
            }
        }

        @Override
        public void endSection() {
        }
    }

    class FonttblDestination
    implements Destination {
        int nextFontNumber;
        Object fontNumberKey = null;
        String nextFontFamily;

        FonttblDestination() {
        }

        @Override
        public void handleBinaryBlob(byte[] data) {
        }

        @Override
        public void handleText(String text) {
            int semicolon = text.indexOf(59);
            String fontName = semicolon > -1 ? text.substring(0, semicolon) : text;
            if (this.nextFontNumber == -1 && this.fontNumberKey != null) {
                fontName = String.valueOf(RTFReaderExt.this.fontTable.get(this.fontNumberKey)) + fontName;
            } else {
                this.fontNumberKey = this.nextFontNumber;
            }
            RTFReaderExt.this.fontTable.put(this.fontNumberKey, fontName);
            this.nextFontNumber = -1;
            this.nextFontFamily = null;
        }

        @Override
        public boolean handleKeyword(String keyword) {
            if (keyword.charAt(0) == 'f') {
                this.nextFontFamily = keyword.substring(1);
                return true;
            }
            return false;
        }

        @Override
        public boolean handleKeyword(String keyword, int parameter) {
            if (keyword.equals("f")) {
                this.nextFontNumber = parameter;
                return true;
            }
            return false;
        }

        @Override
        public void begingroup() {
        }

        @Override
        public void endgroup(Dictionary<String, Object> oldState) {
        }

        @Override
        public void close() {
            Enumeration<Object> nums = RTFReaderExt.this.fontTable.keys();
            RTFReaderExt.this.warning("Done reading font table.");
            while (nums.hasMoreElements()) {
                Integer num = (Integer)nums.nextElement();
                RTFReaderExt.this.warning("Number " + num + ": " + RTFReaderExt.this.fontTable.get(num));
            }
        }
    }

    class InfoDestination
    extends DiscardingDestination
    implements Destination {
        InfoDestination() {
        }
    }

    class StylesheetDestination
    extends DiscardingDestination
    implements Destination {
        Dictionary<Integer, StyleDefiningDestination> definedStyles = new Hashtable<Integer, StyleDefiningDestination>();

        @Override
        public void begingroup() {
            RTFReaderExt.this.setRTFDestination(new StyleDefiningDestination());
        }

        @Override
        public void close() {
            Object[] styleArray;
            Vector chrStyles = new Vector();
            Vector pgfStyles = new Vector();
            Vector<Style> secStyles = new Vector<Style>();
            Enumeration<StyleDefiningDestination> styles = this.definedStyles.elements();
            while (styles.hasMoreElements()) {
                StyleDefiningDestination style = styles.nextElement();
                Style defined = style.realize();
                RTFReaderExt.this.warning("Style " + style.number + " (" + style.styleName + "): " + defined);
                String stype = (String)defined.getAttribute("style:type");
                Vector<Style> toSet = stype.equals("section") ? secStyles : (stype.equals("character") ? chrStyles : pgfStyles);
                if (toSet.size() <= style.number) {
                    toSet.setSize(style.number + 1);
                }
                toSet.setElementAt(defined, style.number);
            }
            if (!chrStyles.isEmpty()) {
                styleArray = new Style[chrStyles.size()];
                chrStyles.copyInto(styleArray);
                RTFReaderExt.this.characterStyles = styleArray;
            }
            if (!pgfStyles.isEmpty()) {
                styleArray = new Style[pgfStyles.size()];
                pgfStyles.copyInto(styleArray);
                RTFReaderExt.this.paragraphStyles = styleArray;
            }
            if (!secStyles.isEmpty()) {
                styleArray = new Style[secStyles.size()];
                secStyles.copyInto(styleArray);
                RTFReaderExt.this.sectionStyles = styleArray;
            }
        }

        class StyleDefiningDestination
        extends AttributeTrackingDestination
        implements Destination {
            final int STYLENUMBER_NONE = 222;
            boolean additive = false;
            boolean characterStyle = false;
            boolean sectionStyle = false;
            public String styleName = null;
            public int number = 0;
            int basedOn = 222;
            int nextStyle = 222;
            boolean hidden = false;
            Style realizedStyle;

            @Override
            public void handleText(String text) {
                this.styleName = this.styleName != null ? String.valueOf(this.styleName) + text : text;
            }

            @Override
            public void close() {
                int semicolon;
                int n = semicolon = this.styleName == null ? 0 : this.styleName.indexOf(59);
                if (semicolon > 0) {
                    this.styleName = this.styleName.substring(0, semicolon);
                }
                StylesheetDestination.this.definedStyles.put(this.number, this);
                super.close();
            }

            @Override
            public boolean handleKeyword(String keyword) {
                if (keyword.equals("additive")) {
                    this.additive = true;
                    return true;
                }
                if (keyword.equals("shidden")) {
                    this.hidden = true;
                    return true;
                }
                return super.handleKeyword(keyword);
            }

            @Override
            public boolean handleKeyword(String keyword, int parameter) {
                if (keyword.equals("s")) {
                    this.characterStyle = false;
                    this.sectionStyle = false;
                    this.number = parameter;
                } else if (keyword.equals("cs")) {
                    this.characterStyle = true;
                    this.sectionStyle = false;
                    this.number = parameter;
                } else if (keyword.equals("ds")) {
                    this.characterStyle = false;
                    this.sectionStyle = true;
                    this.number = parameter;
                } else if (keyword.equals("sbasedon")) {
                    this.basedOn = parameter;
                } else if (keyword.equals("snext")) {
                    this.nextStyle = parameter;
                } else {
                    return super.handleKeyword(keyword, parameter);
                }
                return true;
            }

            public Style realize() {
                StyleDefiningDestination styleDest;
                Style basis = null;
                Style next = null;
                if (this.realizedStyle != null) {
                    return this.realizedStyle;
                }
                if (this.basedOn != 222 && (styleDest = StylesheetDestination.this.definedStyles.get(this.basedOn)) != null && styleDest != this) {
                    basis = styleDest.realize();
                }
                this.realizedStyle = ((StylesheetDestination)StylesheetDestination.this).RTFReaderExt.this.target.addStyle(this.styleName, basis);
                if (this.characterStyle) {
                    this.realizedStyle.addAttributes(this.currentTextAttributes());
                    this.realizedStyle.addAttribute("style:type", "character");
                } else if (this.sectionStyle) {
                    this.realizedStyle.addAttributes(this.currentSectionAttributes());
                    this.realizedStyle.addAttribute("style:type", "section");
                } else {
                    this.realizedStyle.addAttributes(this.currentParagraphAttributes());
                    this.realizedStyle.addAttribute("style:type", "paragraph");
                }
                if (this.nextStyle != 222 && (styleDest = StylesheetDestination.this.definedStyles.get(this.nextStyle)) != null) {
                    next = styleDest.realize();
                }
                if (next != null) {
                    this.realizedStyle.addAttribute("style:nextStyle", next);
                }
                this.realizedStyle.addAttribute("style:additive", this.additive);
                this.realizedStyle.addAttribute("style:hidden", this.hidden);
                return this.realizedStyle;
            }
        }
    }

    abstract class TextHandlingDestination
    extends AttributeTrackingDestination
    implements Destination {
        boolean inParagraph = false;

        @Override
        public void handleText(String text) {
            if (!this.inParagraph) {
                this.beginParagraph();
            }
            this.deliverText(text, this.currentTextAttributes());
        }

        abstract void deliverText(String var1, AttributeSet var2);

        @Override
        public void close() {
            if (this.inParagraph) {
                this.endParagraph();
            }
            super.close();
        }

        @Override
        public boolean handleKeyword(String keyword) {
            if (keyword.equals("\r") || keyword.equals("\n")) {
                keyword = "par";
            }
            if (keyword.equals("par")) {
                this.endParagraph();
                return true;
            }
            if (keyword.equals("sect")) {
                this.endSection();
                return true;
            }
            return super.handleKeyword(keyword);
        }

        protected void beginParagraph() {
            this.inParagraph = true;
        }

        protected void endParagraph() {
            MutableAttributeSet pgfAttributes = this.currentParagraphAttributes();
            MutableAttributeSet chrAttributes = this.currentTextAttributes();
            this.finishParagraph(pgfAttributes, chrAttributes);
            this.inParagraph = false;
        }

        abstract void finishParagraph(AttributeSet var1, AttributeSet var2);

        abstract void endSection();
    }
}

