/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.text.rtf.AbstractFilterExt;

abstract class RTFParserExt
extends AbstractFilterExt {
    public int level = 0;
    private int state = 0;
    private StringBuffer currentCharacters = new StringBuffer();
    private String pendingKeyword = null;
    private int pendingCharacter;
    private long binaryBytesLeft;
    ByteArrayOutputStream binaryBuf;
    private boolean[] savedSpecials;
    protected PrintStream warnings;
    private final int S_text = 0;
    private final int S_backslashed = 1;
    private final int S_token = 2;
    private final int S_parameter = 3;
    private final int S_aftertick = 4;
    private final int S_aftertickc = 5;
    private final int S_inblob = 6;
    static final boolean[] rtfSpecialsTable = (boolean[])noSpecialsTable.clone();

    static {
        RTFParserExt.rtfSpecialsTable[10] = true;
        RTFParserExt.rtfSpecialsTable[13] = true;
        RTFParserExt.rtfSpecialsTable[123] = true;
        RTFParserExt.rtfSpecialsTable[125] = true;
        RTFParserExt.rtfSpecialsTable[92] = true;
    }

    public abstract boolean handleKeyword(String var1);

    public abstract boolean handleKeyword(String var1, int var2);

    public abstract void handleText(String var1);

    public void handleText(char ch) {
        this.handleText(String.valueOf(ch));
    }

    public abstract void handleBinaryBlob(byte[] var1);

    public abstract void begingroup();

    public abstract void endgroup();

    public RTFParserExt() {
        this.specialsTable = rtfSpecialsTable;
    }

    @Override
    public void writeSpecial(int b) throws IOException {
        this.write((char)b);
    }

    protected void warning(String s) {
        if (this.warnings != null) {
            this.warnings.println(s);
        }
    }

    @Override
    public void write(String s) throws IOException {
        if (this.state != 0) {
            int index = 0;
            int length = s.length();
            while (index < length && this.state != 0) {
                this.write(s.charAt(index));
                ++index;
            }
            if (index >= length) {
                return;
            }
            s = s.substring(index);
        }
        if (this.currentCharacters.length() > 0) {
            this.currentCharacters.append(s);
        } else {
            this.handleText(s);
        }
    }

    @Override
    public void write(char ch) throws IOException {
        switch (this.state) {
            case 0: {
                if (ch == '\n' || ch == '\r') break;
                if (ch == '{') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    ++this.level;
                    this.begingroup();
                    break;
                }
                if (ch == '}') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    if (this.level == 0) {
                        throw new IOException("Too many close-groups in RTF text");
                    }
                    this.endgroup();
                    --this.level;
                    break;
                }
                if (ch == '\\') {
                    if (this.currentCharacters.length() > 0) {
                        this.handleText(this.currentCharacters.toString());
                        this.currentCharacters = new StringBuffer();
                    }
                    this.state = 1;
                    break;
                }
                this.currentCharacters.append(ch);
                break;
            }
            case 1: {
                if (ch == '\'') {
                    this.state = 4;
                    break;
                }
                if (!Character.isLetter(ch)) {
                    char[] newstring = new char[]{ch};
                    if (!this.handleKeyword(new String(newstring))) {
                        this.warning("Unknown keyword: " + new String(newstring) + " (" + (byte)ch + ")");
                    }
                    this.state = 0;
                    this.pendingKeyword = null;
                    break;
                }
                this.state = 2;
            }
            case 2: {
                if (Character.isLetter(ch)) {
                    this.currentCharacters.append(ch);
                    break;
                }
                this.pendingKeyword = this.currentCharacters.toString();
                this.currentCharacters = new StringBuffer();
                if (Character.isDigit(ch) || ch == '-') {
                    this.state = 3;
                    this.currentCharacters.append(ch);
                    break;
                }
                boolean ok = this.handleKeyword(this.pendingKeyword);
                if (!ok) {
                    this.warning("Unknown keyword: " + this.pendingKeyword);
                }
                this.pendingKeyword = null;
                this.state = 0;
                if (Character.isWhitespace(ch)) break;
                this.write(ch);
                break;
            }
            case 3: {
                if (Character.isDigit(ch)) {
                    this.currentCharacters.append(ch);
                    break;
                }
                if (this.pendingKeyword.equals("bin")) {
                    long parameter = Long.parseLong(this.currentCharacters.toString());
                    this.pendingKeyword = null;
                    this.state = 6;
                    this.binaryBytesLeft = parameter;
                    this.binaryBuf = this.binaryBytesLeft > Integer.MAX_VALUE ? new ByteArrayOutputStream(Integer.MAX_VALUE) : new ByteArrayOutputStream((int)this.binaryBytesLeft);
                    this.savedSpecials = this.specialsTable;
                    this.specialsTable = allSpecialsTable;
                    break;
                }
                int parameter = Integer.parseInt(this.currentCharacters.toString());
                boolean ok = this.handleKeyword(this.pendingKeyword, parameter);
                if (!ok) {
                    this.warning("Unknown keyword: " + this.pendingKeyword + " (param " + this.currentCharacters + ")");
                }
                this.pendingKeyword = null;
                this.currentCharacters = new StringBuffer();
                this.state = 0;
                if (Character.isWhitespace(ch)) break;
                this.write(ch);
                break;
            }
            case 4: {
                if (Character.digit(ch, 16) == -1) {
                    this.state = 0;
                    break;
                }
                this.pendingCharacter = Character.digit(ch, 16);
                this.state = 5;
                break;
            }
            case 5: {
                this.state = 0;
                if (Character.digit(ch, 16) == -1) break;
                this.pendingCharacter = this.pendingCharacter * 16 + Character.digit(ch, 16);
                ch = this.translationTable[this.pendingCharacter];
                if (ch == '\u0000') break;
                this.handleText(ch);
                break;
            }
            case 6: {
                this.binaryBuf.write(ch);
                --this.binaryBytesLeft;
                if (this.binaryBytesLeft != 0L) break;
                this.state = 0;
                this.specialsTable = this.savedSpecials;
                this.savedSpecials = null;
                this.handleBinaryBlob(this.binaryBuf.toByteArray());
                this.binaryBuf = null;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.state == 0 && this.currentCharacters.length() > 0) {
            this.handleText(this.currentCharacters.toString());
            this.currentCharacters = new StringBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.state != 0 || this.level > 0) {
            this.warning("Truncated RTF file.");
            while (this.level > 0) {
                this.endgroup();
                --this.level;
            }
        }
        super.close();
    }
}

