/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabStop;
import javax.swing.text.rtf.RTFAttributeExt;
import javax.swing.text.rtf.RTFAttributesExt;
import javax.swing.text.rtf.RTFReaderExt;

class RTFGeneratorExt {
    Dictionary<Object, Integer> colorTable = new Hashtable<Object, Integer>();
    int colorCount;
    Dictionary<String, Integer> fontTable;
    int fontCount;
    Dictionary<AttributeSet, Integer> styleTable;
    int styleCount;
    OutputStream outputStream;
    boolean afterKeyword;
    MutableAttributeSet outputAttributes;
    int unicodeCount;
    private Segment workingSegment;
    int[] outputConversion;
    public static final Color defaultRTFColor = Color.black;
    public static final float defaultFontSize = 12.0f;
    public static final String defaultFontFamily = "Helvetica";
    protected static Integer One = new Integer(1);
    protected static Integer Zero = new Integer(0);
    protected static Boolean False = false;
    protected static Float ZeroPointZero;
    private static Object MagicToken;
    protected static CharacterKeywordPair[] textKeywords;
    static final char[] hexdigits;

    static {
        MagicToken = new Object();
        ZeroPointZero = new Float(0.0f);
        Dictionary<String, String> textKeywordDictionary = RTFReaderExt.textKeywords;
        Enumeration<String> keys = textKeywordDictionary.keys();
        Vector<CharacterKeywordPair> tempPairs = new Vector<CharacterKeywordPair>();
        while (keys.hasMoreElements()) {
            CharacterKeywordPair pair = new CharacterKeywordPair();
            pair.keyword = keys.nextElement();
            pair.character = textKeywordDictionary.get(pair.keyword).charAt(0);
            tempPairs.addElement(pair);
        }
        textKeywords = new CharacterKeywordPair[tempPairs.size()];
        tempPairs.copyInto(textKeywords);
        hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static void writeDocument(Document d, OutputStream to) throws IOException {
        RTFGeneratorExt gen = new RTFGeneratorExt(to);
        Element root = d.getDefaultRootElement();
        gen.examineElement(root);
        gen.writeRTFHeader();
        gen.writeDocumentProperties(d);
        int max = root.getElementCount();
        int idx = 0;
        while (idx < max) {
            gen.writeParagraphElement(root.getElement(idx));
            ++idx;
        }
        gen.writeRTFTrailer();
    }

    public RTFGeneratorExt(OutputStream to) {
        this.colorTable.put(defaultRTFColor, new Integer(0));
        this.colorCount = 1;
        this.fontTable = new Hashtable<String, Integer>();
        this.fontCount = 0;
        this.styleTable = new Hashtable<AttributeSet, Integer>();
        this.styleCount = 0;
        this.workingSegment = new Segment();
        this.outputStream = to;
        this.unicodeCount = 1;
    }

    public void examineElement(Element el) {
        AttributeSet a = el.getAttributes();
        this.tallyStyles(a);
        if (a != null) {
            String fontName;
            Object backgroundColor;
            Color foregroundColor = StyleConstants.getForeground(a);
            if (foregroundColor != null && this.colorTable.get(foregroundColor) == null) {
                this.colorTable.put(foregroundColor, new Integer(this.colorCount));
                ++this.colorCount;
            }
            if ((backgroundColor = a.getAttribute(StyleConstants.Background)) != null && this.colorTable.get(backgroundColor) == null) {
                this.colorTable.put(backgroundColor, new Integer(this.colorCount));
                ++this.colorCount;
            }
            if ((fontName = StyleConstants.getFontFamily(a)) == null) {
                fontName = defaultFontFamily;
            }
            if (fontName != null && this.fontTable.get(fontName) == null) {
                this.fontTable.put(fontName, new Integer(this.fontCount));
                ++this.fontCount;
            }
        }
        int el_count = el.getElementCount();
        int el_idx = 0;
        while (el_idx < el_count) {
            this.examineElement(el.getElement(el_idx));
            ++el_idx;
        }
    }

    private void tallyStyles(AttributeSet a) {
        while (a != null) {
            Integer aNum;
            if (a instanceof Style && (aNum = this.styleTable.get(a)) == null) {
                ++this.styleCount;
                aNum = new Integer(this.styleCount);
                this.styleTable.put(a, aNum);
            }
            a = a.getResolveParent();
        }
    }

    private Style findStyle(AttributeSet a) {
        while (a != null) {
            Integer aNum;
            if (a instanceof Style && (aNum = this.styleTable.get(a)) != null) {
                return (Style)a;
            }
            a = a.getResolveParent();
        }
        return null;
    }

    private Integer findStyleNumber(AttributeSet a, String domain) {
        while (a != null) {
            Integer aNum;
            if (a instanceof Style && (aNum = this.styleTable.get(a)) != null && (domain == null || domain.equals(a.getAttribute("style:type")))) {
                return aNum;
            }
            a = a.getResolveParent();
        }
        return null;
    }

    private static Object attrDiff(MutableAttributeSet oldAttrs, AttributeSet newAttrs, Object key, Object value, Object dfl) {
        Object oldValue = oldAttrs.getAttribute(key);
        Object newValue = newAttrs.getAttribute(key);
        if (value != null && !value.equals(newValue)) {
            return null;
        }
        if (newValue == oldValue) {
            return null;
        }
        if (newValue == null) {
            oldAttrs.removeAttribute(key);
            if (dfl != null && !dfl.equals(oldValue)) {
                return dfl;
            }
            return null;
        }
        if (oldValue == null || !RTFGeneratorExt.equalArraysOK(oldValue, newValue)) {
            oldAttrs.addAttribute(key, newValue);
            return newValue;
        }
        return null;
    }

    private static boolean equalArraysOK(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (!a.getClass().isArray() || !b.getClass().isArray()) {
            return false;
        }
        Object[] aa = (Object[])a;
        Object[] bb = (Object[])b;
        if (aa.length != bb.length) {
            return false;
        }
        int l = aa.length;
        int i = 0;
        while (i < l) {
            if (!RTFGeneratorExt.equalArraysOK(aa[i], bb[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void writeLineBreak() throws IOException {
        this.writeRawString("\n");
        this.afterKeyword = false;
    }

    public void writeRTFHeader() throws IOException {
        this.writeBegingroup();
        this.writeControlWord("rtf", 1);
        this.writeControlWord("ansi");
        this.outputConversion = RTFGeneratorExt.outputConversionForName("ansi");
        this.writeLineBreak();
        String[] sortedFontTable = new String[this.fontCount];
        Enumeration<String> fonts = this.fontTable.keys();
        while (fonts.hasMoreElements()) {
            String font = fonts.nextElement();
            Integer num = this.fontTable.get(font);
            sortedFontTable[num.intValue()] = font;
        }
        this.writeBegingroup();
        this.writeControlWord("fonttbl");
        int index = 0;
        while (index < this.fontCount) {
            this.writeControlWord("f", index);
            this.writeControlWord("fnil");
            this.writeText(sortedFontTable[index]);
            this.writeText(";");
            ++index;
        }
        this.writeEndgroup();
        this.writeLineBreak();
        if (this.colorCount > 1) {
            Color color;
            Color[] sortedColorTable = new Color[this.colorCount];
            Enumeration<Object> colors = this.colorTable.keys();
            while (colors.hasMoreElements()) {
                color = (Color)colors.nextElement();
                Integer num = this.colorTable.get(color);
                sortedColorTable[num.intValue()] = color;
            }
            this.writeBegingroup();
            this.writeControlWord("colortbl");
            index = 0;
            while (index < this.colorCount) {
                color = sortedColorTable[index];
                if (color != null) {
                    this.writeControlWord("red", color.getRed());
                    this.writeControlWord("green", color.getGreen());
                    this.writeControlWord("blue", color.getBlue());
                }
                this.writeRawString(";");
                ++index;
            }
            this.writeEndgroup();
            this.writeLineBreak();
        }
        if (this.styleCount > 1) {
            this.writeBegingroup();
            this.writeControlWord("stylesheet");
            Enumeration<AttributeSet> styles = this.styleTable.keys();
            while (styles.hasMoreElements()) {
                Boolean additive;
                Boolean hidden;
                Integer nextNum;
                Style nextStyle;
                Integer basedOn;
                Style style = (Style)styles.nextElement();
                int styleNumber = this.styleTable.get(style);
                this.writeBegingroup();
                String styleType = (String)style.getAttribute("style:type");
                if (styleType == null) {
                    styleType = "paragraph";
                }
                if (styleType.equals("character")) {
                    this.writeControlWord("*");
                    this.writeControlWord("cs", styleNumber);
                } else if (styleType.equals("section")) {
                    this.writeControlWord("*");
                    this.writeControlWord("ds", styleNumber);
                } else {
                    this.writeControlWord("s", styleNumber);
                }
                AttributeSet basis = style.getResolveParent();
                SimpleAttributeSet goat = basis == null ? new SimpleAttributeSet() : new SimpleAttributeSet(basis);
                this.updateSectionAttributes(goat, style, false);
                this.updateParagraphAttributes(goat, style, false);
                this.updateCharacterAttributes(goat, style, false);
                basis = style.getResolveParent();
                if (basis != null && basis instanceof Style && (basedOn = this.styleTable.get(basis)) != null) {
                    this.writeControlWord("sbasedon", basedOn);
                }
                if ((nextStyle = (Style)style.getAttribute("style:nextStyle")) != null && (nextNum = this.styleTable.get(nextStyle)) != null) {
                    this.writeControlWord("snext", nextNum);
                }
                if ((hidden = (Boolean)style.getAttribute("style:hidden")) != null && hidden.booleanValue()) {
                    this.writeControlWord("shidden");
                }
                if ((additive = (Boolean)style.getAttribute("style:additive")) != null && additive.booleanValue()) {
                    this.writeControlWord("additive");
                }
                this.writeText(style.getName());
                this.writeText(";");
                this.writeEndgroup();
            }
            this.writeEndgroup();
            this.writeLineBreak();
        }
        this.outputAttributes = new SimpleAttributeSet();
    }

    void writeDocumentProperties(Document doc) throws IOException {
        boolean wroteSomething = false;
        int i = 0;
        while (i < RTFAttributesExt.attributes.length) {
            Object prop;
            boolean ok;
            RTFAttributeExt attr = RTFAttributesExt.attributes[i];
            if (attr.domain() == 3 && (ok = attr.writeValue(prop = doc.getProperty(attr.swingName()), this, false))) {
                wroteSomething = true;
            }
            ++i;
        }
        if (wroteSomething) {
            this.writeLineBreak();
        }
    }

    public void writeRTFTrailer() throws IOException {
        this.writeEndgroup();
        this.writeLineBreak();
    }

    protected void checkNumericControlWord(MutableAttributeSet currentAttributes, AttributeSet newAttributes, Object attrName, String controlWord, float dflt, float scale) throws IOException {
        Object parm = RTFGeneratorExt.attrDiff(currentAttributes, newAttributes, attrName, null, MagicToken);
        if (parm != null) {
            float targ = parm == MagicToken ? dflt : ((Number)parm).floatValue();
            this.writeControlWord(controlWord, Math.round(targ * scale));
        }
    }

    protected void checkControlWord(MutableAttributeSet currentAttributes, AttributeSet newAttributes, RTFAttributeExt word) throws IOException {
        Object parm;
        Object value = null;
        if (word instanceof RTFAttributesExt.AssertiveAttribute) {
            value = ((RTFAttributesExt.AssertiveAttribute)word).swingValue;
        }
        if ((parm = RTFGeneratorExt.attrDiff(currentAttributes, newAttributes, word.swingName(), value, MagicToken)) != null) {
            if (parm == MagicToken) {
                parm = null;
            }
            word.writeValue(parm, this, true);
        }
    }

    protected void checkControlWords(MutableAttributeSet currentAttributes, AttributeSet newAttributes, RTFAttributeExt[] words, int domain) throws IOException {
        int wordCount = words.length;
        int wordIndex = 0;
        while (wordIndex < wordCount) {
            RTFAttributeExt attr = words[wordIndex];
            if (attr.domain() == domain) {
                this.checkControlWord(currentAttributes, newAttributes, attr);
            }
            ++wordIndex;
        }
    }

    void updateSectionAttributes(MutableAttributeSet current, AttributeSet newAttributes, boolean emitStyleChanges) throws IOException {
        Integer newStyle;
        Object oldStyle;
        if (emitStyleChanges && (oldStyle = current.getAttribute("sectionStyle")) != (newStyle = this.findStyleNumber(newAttributes, "section"))) {
            if (oldStyle != null) {
                this.resetSectionAttributes(current);
            }
            if (newStyle != null) {
                this.writeControlWord("ds", newStyle);
                current.addAttribute("sectionStyle", newStyle);
            } else {
                current.removeAttribute("sectionStyle");
            }
        }
        this.checkControlWords(current, newAttributes, RTFAttributesExt.attributes, 2);
    }

    protected void resetSectionAttributes(MutableAttributeSet currentAttributes) throws IOException {
        this.writeControlWord("sectd");
        int wordCount = RTFAttributesExt.attributes.length;
        int wordIndex = 0;
        while (wordIndex < wordCount) {
            RTFAttributeExt attr = RTFAttributesExt.attributes[wordIndex];
            if (attr.domain() == 2) {
                attr.setDefault(currentAttributes);
            }
            ++wordIndex;
        }
        currentAttributes.removeAttribute("sectionStyle");
    }

    void updateParagraphAttributes(MutableAttributeSet current, AttributeSet newAttributes, boolean emitStyleChanges) throws IOException {
        Object newTabs;
        Object oldTabs;
        Integer newStyle;
        Object oldStyle;
        if (emitStyleChanges) {
            oldStyle = current.getAttribute("paragraphStyle");
            if (oldStyle != (newStyle = this.findStyleNumber(newAttributes, "paragraph")) && oldStyle != null) {
                this.resetParagraphAttributes(current);
                oldStyle = null;
            }
        } else {
            oldStyle = null;
            newStyle = null;
        }
        if ((oldTabs = current.getAttribute("tabs")) != (newTabs = newAttributes.getAttribute("tabs")) && oldTabs != null) {
            this.resetParagraphAttributes(current);
            oldTabs = null;
            oldStyle = null;
        }
        if (oldStyle != newStyle && newStyle != null) {
            this.writeControlWord("s", newStyle);
            current.addAttribute("paragraphStyle", newStyle);
        }
        this.checkControlWords(current, newAttributes, RTFAttributesExt.attributes, 1);
        if (oldTabs != newTabs && newTabs != null) {
            TabStop[] tabs = (TabStop[])newTabs;
            int index = 0;
            while (index < tabs.length) {
                TabStop tab = tabs[index];
                switch (tab.getAlignment()) {
                    case 0: 
                    case 5: {
                        break;
                    }
                    case 1: {
                        this.writeControlWord("tqr");
                        break;
                    }
                    case 2: {
                        this.writeControlWord("tqc");
                        break;
                    }
                    case 4: {
                        this.writeControlWord("tqdec");
                    }
                }
                switch (tab.getLeader()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.writeControlWord("tldot");
                        break;
                    }
                    case 2: {
                        this.writeControlWord("tlhyph");
                        break;
                    }
                    case 3: {
                        this.writeControlWord("tlul");
                        break;
                    }
                    case 4: {
                        this.writeControlWord("tlth");
                        break;
                    }
                    case 5: {
                        this.writeControlWord("tleq");
                    }
                }
                int twips = Math.round(20.0f * tab.getPosition());
                if (tab.getAlignment() == 5) {
                    this.writeControlWord("tb", twips);
                } else {
                    this.writeControlWord("tx", twips);
                }
                ++index;
            }
            current.addAttribute("tabs", tabs);
        }
    }

    public void writeParagraphElement(Element el) throws IOException {
        this.updateParagraphAttributes(this.outputAttributes, el.getAttributes(), true);
        int sub_count = el.getElementCount();
        int idx = 0;
        while (idx < sub_count) {
            this.writeTextElement(el.getElement(idx));
            ++idx;
        }
        this.writeControlWord("par");
        this.writeLineBreak();
    }

    protected void resetParagraphAttributes(MutableAttributeSet currentAttributes) throws IOException {
        this.writeControlWord("pard");
        currentAttributes.addAttribute(StyleConstants.Alignment, Zero);
        int wordCount = RTFAttributesExt.attributes.length;
        int wordIndex = 0;
        while (wordIndex < wordCount) {
            RTFAttributeExt attr = RTFAttributesExt.attributes[wordIndex];
            if (attr.domain() == 1) {
                attr.setDefault(currentAttributes);
            }
            ++wordIndex;
        }
        currentAttributes.removeAttribute("paragraphStyle");
        currentAttributes.removeAttribute("tabs");
    }

    void updateCharacterAttributes(MutableAttributeSet current, AttributeSet newAttributes, boolean updateStyleChanges) throws IOException {
        Object parm;
        Integer newStyle;
        Object oldStyle;
        if (updateStyleChanges && (oldStyle = current.getAttribute("characterStyle")) != (newStyle = this.findStyleNumber(newAttributes, "character"))) {
            if (oldStyle != null) {
                this.resetCharacterAttributes(current);
            }
            if (newStyle != null) {
                this.writeControlWord("cs", newStyle);
                current.addAttribute("characterStyle", newStyle);
            } else {
                current.removeAttribute("characterStyle");
            }
        }
        if ((parm = RTFGeneratorExt.attrDiff(current, newAttributes, StyleConstants.FontFamily, null, null)) != null) {
            Number fontNum = this.fontTable.get(parm);
            this.writeControlWord("f", fontNum.intValue());
        }
        this.checkNumericControlWord(current, newAttributes, StyleConstants.FontSize, "fs", 12.0f, 2.0f);
        this.checkControlWords(current, newAttributes, RTFAttributesExt.attributes, 0);
        this.checkNumericControlWord(current, newAttributes, StyleConstants.LineSpacing, "sl", 0.0f, 20.0f);
        parm = RTFGeneratorExt.attrDiff(current, newAttributes, StyleConstants.Background, null, MagicToken);
        if (parm != null) {
            int colorNum = parm == MagicToken ? 0 : ((Number)this.colorTable.get(parm)).intValue();
            this.writeControlWord("cb", colorNum);
        }
        if ((parm = RTFGeneratorExt.attrDiff(current, newAttributes, StyleConstants.Foreground, null, null)) != null) {
            int colorNum = parm == MagicToken ? 0 : ((Number)this.colorTable.get(parm)).intValue();
            this.writeControlWord("cf", colorNum);
        }
    }

    protected void resetCharacterAttributes(MutableAttributeSet currentAttributes) throws IOException {
        this.writeControlWord("plain");
        int wordCount = RTFAttributesExt.attributes.length;
        int wordIndex = 0;
        while (wordIndex < wordCount) {
            RTFAttributeExt attr = RTFAttributesExt.attributes[wordIndex];
            if (attr.domain() == 0) {
                attr.setDefault(currentAttributes);
            }
            ++wordIndex;
        }
        StyleConstants.setFontFamily(currentAttributes, defaultFontFamily);
        currentAttributes.removeAttribute(StyleConstants.FontSize);
        currentAttributes.removeAttribute(StyleConstants.Background);
        currentAttributes.removeAttribute(StyleConstants.Foreground);
        currentAttributes.removeAttribute(StyleConstants.LineSpacing);
        currentAttributes.removeAttribute("characterStyle");
    }

    public void writeTextElement(Element el) throws IOException {
        this.updateCharacterAttributes(this.outputAttributes, el.getAttributes(), true);
        if (el.isLeaf()) {
            try {
                el.getDocument().getText(el.getStartOffset(), el.getEndOffset() - el.getStartOffset(), this.workingSegment);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                throw new InternalError(ble.getMessage());
            }
            this.writeText(this.workingSegment);
        } else {
            int sub_count = el.getElementCount();
            int idx = 0;
            while (idx < sub_count) {
                this.writeTextElement(el.getElement(idx));
                ++idx;
            }
        }
    }

    public void writeText(Segment s) throws IOException {
        int pos = s.offset;
        int end = pos + s.count;
        char[] array = s.array;
        while (pos < end) {
            this.writeCharacter(array[pos]);
            ++pos;
        }
    }

    public void writeText(String s) throws IOException {
        int pos = 0;
        int end = s.length();
        while (pos < end) {
            this.writeCharacter(s.charAt(pos));
            ++pos;
        }
    }

    public void writeRawString(String str) throws IOException {
        int strlen = str.length();
        int offset = 0;
        while (offset < strlen) {
            this.outputStream.write(str.charAt(offset));
            ++offset;
        }
    }

    public void writeControlWord(String keyword) throws IOException {
        this.outputStream.write(92);
        this.writeRawString(keyword);
        this.afterKeyword = true;
    }

    public void writeControlWord(String keyword, int arg) throws IOException {
        this.outputStream.write(92);
        this.writeRawString(keyword);
        this.writeRawString(String.valueOf(arg));
        this.afterKeyword = true;
    }

    public void writeBegingroup() throws IOException {
        this.outputStream.write(123);
        this.afterKeyword = false;
    }

    public void writeEndgroup() throws IOException {
        this.outputStream.write(125);
        this.afterKeyword = false;
    }

    public void writeCharacter(char ch) throws IOException {
        if (ch == '\u00a0') {
            this.outputStream.write(92);
            this.outputStream.write(126);
            this.afterKeyword = false;
            return;
        }
        if (ch == '\t') {
            this.writeControlWord("tab");
            return;
        }
        if (ch == '\n' || ch == '\r') {
            return;
        }
        int b = RTFGeneratorExt.convertCharacter(this.outputConversion, ch);
        if (b == 0) {
            int i = 0;
            while (i < textKeywords.length) {
                if (RTFGeneratorExt.textKeywords[i].character == ch) {
                    this.writeControlWord(RTFGeneratorExt.textKeywords[i].keyword);
                    return;
                }
                ++i;
            }
            String approximation = this.approximationForUnicode(ch);
            if (approximation.length() != this.unicodeCount) {
                this.unicodeCount = approximation.length();
                this.writeControlWord("uc", this.unicodeCount);
            }
            this.writeControlWord("u", ch);
            this.writeRawString(" ");
            this.writeRawString(approximation);
            this.afterKeyword = false;
            return;
        }
        if (b > 127) {
            this.outputStream.write(92);
            this.outputStream.write(39);
            int nybble = (b & 0xF0) >>> 4;
            this.outputStream.write(hexdigits[nybble]);
            nybble = b & 0xF;
            this.outputStream.write(hexdigits[nybble]);
            this.afterKeyword = false;
            return;
        }
        switch (b) {
            case 92: 
            case 123: 
            case 125: {
                this.outputStream.write(92);
                this.afterKeyword = false;
            }
        }
        if (this.afterKeyword) {
            this.outputStream.write(32);
            this.afterKeyword = false;
        }
        this.outputStream.write(b);
    }

    String approximationForUnicode(char ch) {
        return "?";
    }

    static int[] outputConversionFromTranslationTable(char[] table) {
        int[] conversion = new int[2 * table.length];
        int index = 0;
        while (index < table.length) {
            conversion[index * 2] = table[index];
            conversion[index * 2 + 1] = index;
            ++index;
        }
        return conversion;
    }

    static int[] outputConversionForName(String name) throws IOException {
        char[] table = (char[])RTFReaderExt.getCharacterSet(name);
        return RTFGeneratorExt.outputConversionFromTranslationTable(table);
    }

    protected static int convertCharacter(int[] conversion, char ch) {
        int index = 0;
        while (index < conversion.length) {
            if (conversion[index] == ch) {
                return conversion[index + 1];
            }
            index += 2;
        }
        return 0;
    }

    static class CharacterKeywordPair {
        public char character;
        public String keyword;

        CharacterKeywordPair() {
        }
    }
}

