#include "patch_types.h"

// Memory patch: literally just turn on the IMAGE_FILE_LARGE_ADDRESS_AWARE flag
PatchByte mempatch[] = {
	{0x116, 0x8e, 0xae},
	{-1,0,0}
};


// UPX fix
// Fixes the file offset GM8 tries to load game data at in de-UPX'd games
PatchByte upx_80[] = {
	{0x144ac1, 0xa4, 0xf0},
	{0x144ac2, 0x0a, 0x1c},
	{-1,0,0}
};

// JOYSTICK PATCHES
// How to create:
// 1. Find all calls to joystick functions (joyGetPos, joyGetPosEx, joyGetDevCapsW)
// 2. Replace with "mov eax, 0xa5" to emulate joystick being unplugged

PatchByte joypatch_80[] = {
	{ 0x1399df, 0x53, 0xb8 },
	{ 0x1399e0, 0x6a, 0xa5 },
	{ 0x1399e2, 0xe8, 0x0 },
	{ 0x1399e3, 0x61, 0x0 },
	{ 0x1399e4, 0x7b, 0x90 },
	{ 0x1399e5, 0xf4, 0x90 },
	{ 0x1399e6, 0xff, 0x90 },
	{ 0x139ae0, 0x53, 0xb8 },
	{ 0x139ae1, 0x6a, 0xa5 },
	{ 0x139ae2, 0x1, 0x0 },
	{ 0x139ae3, 0xe8, 0x0 },
	{ 0x139ae4, 0x60, 0x0 },
	{ 0x139ae5, 0x7a, 0x90 },
	{ 0x139ae6, 0xf4, 0x90 },
	{ 0x139ae7, 0xff, 0x90 },
	{ 0x16466d, 0x50, 0xb8 },
	{ 0x16466e, 0x53, 0xa5 },
	{ 0x16466f, 0xe8, 0x0 },
	{ 0x164670, 0xcc, 0x0 },
	{ 0x164671, 0xce, 0x0 },
	{ 0x164672, 0xf1, 0x90 },
	{ 0x164673, 0xff, 0x90 },
	{ 0x1646cd, 0x50, 0xb8 },
	{ 0x1646ce, 0x56, 0xa5 },
	{ 0x1646cf, 0xe8, 0x0 },
	{ 0x1646d0, 0x6c, 0x0 },
	{ 0x1646d1, 0xce, 0x0 },
	{ 0x1646d2, 0xf1, 0x90 },
	{ 0x1646d3, 0xff, 0x90 },
	{ 0x164767, 0x68, 0xb8 },
	{ 0x164768, 0x94, 0xa5 },
	{ 0x164769, 0x1, 0x0 },
	{ 0x16476c, 0x8d, 0x90 },
	{ 0x16476d, 0x85, 0x90 },
	{ 0x16476e, 0x6c, 0x90 },
	{ 0x16476f, 0xfe, 0x90 },
	{ 0x164770, 0xff, 0x90 },
	{ 0x164771, 0xff, 0x90 },
	{ 0x164772, 0x50, 0x90 },
	{ 0x164773, 0x56, 0x90 },
	{ 0x164774, 0xe8, 0x90 },
	{ 0x164775, 0xbf, 0x90 },
	{ 0x164776, 0xcd, 0x90 },
	{ 0x164777, 0xf1, 0x90 },
	{ 0x164778, 0xff, 0x90 },
	{ 0x1647d1, 0x68, 0xb8 },
	{ 0x1647d2, 0x94, 0xa5 },
	{ 0x1647d3, 0x1, 0x0 },
	{ 0x1647d6, 0x8d, 0x90 },
	{ 0x1647d7, 0x85, 0x90 },
	{ 0x1647d8, 0x6c, 0x90 },
	{ 0x1647d9, 0xfe, 0x90 },
	{ 0x1647da, 0xff, 0x90 },
	{ 0x1647db, 0xff, 0x90 },
	{ 0x1647dc, 0x50, 0x90 },
	{ 0x1647dd, 0x56, 0x90 },
	{ 0x1647de, 0xe8, 0x90 },
	{ 0x1647df, 0x55, 0x90 },
	{ 0x1647e0, 0xcd, 0x90 },
	{ 0x1647e1, 0xf1, 0x90 },
	{ 0x1647e2, 0xff, 0x90 },
	{ 0x164849, 0x68, 0xb8 },
	{ 0x16484a, 0x94, 0xa5 },
	{ 0x16484b, 0x1, 0x0 },
	{ 0x16484e, 0x8d, 0x90 },
	{ 0x16484f, 0x85, 0x90 },
	{ 0x164850, 0x6c, 0x90 },
	{ 0x164851, 0xfe, 0x90 },
	{ 0x164852, 0xff, 0x90 },
	{ 0x164853, 0xff, 0x90 },
	{ 0x164854, 0x50, 0x90 },
	{ 0x164855, 0x56, 0x90 },
	{ 0x164856, 0xe8, 0x90 },
	{ 0x164857, 0xdd, 0x90 },
	{ 0x164858, 0xcc, 0x90 },
	{ 0x164859, 0xf1, 0x90 },
	{ 0x16485a, 0xff, 0x90 },
	{ 0x1648c1, 0x68, 0xb8 },
	{ 0x1648c2, 0x94, 0xa5 },
	{ 0x1648c3, 0x1, 0x0 },
	{ 0x1648c6, 0x8d, 0x90 },
	{ 0x1648c7, 0x85, 0x90 },
	{ 0x1648c8, 0x6c, 0x90 },
	{ 0x1648c9, 0xfe, 0x90 },
	{ 0x1648ca, 0xff, 0x90 },
	{ 0x1648cb, 0xff, 0x90 },
	{ 0x1648cc, 0x50, 0x90 },
	{ 0x1648cd, 0x56, 0x90 },
	{ 0x1648ce, 0xe8, 0x90 },
	{ 0x1648cf, 0x65, 0x90 },
	{ 0x1648d0, 0xcc, 0x90 },
	{ 0x1648d1, 0xf1, 0x90 },
	{ 0x1648d2, 0xff, 0x90 },
	{ 0x164948, 0x50, 0xb8 },
	{ 0x164949, 0x56, 0xa5 },
	{ 0x16494a, 0xe8, 0x0 },
	{ 0x16494b, 0xf9, 0x0 },
	{ 0x16494c, 0xcb, 0x0 },
	{ 0x16494d, 0xf1, 0x90 },
	{ 0x16494e, 0xff, 0x90 },
	{ 0x164daf, 0x50, 0xb8 },
	{ 0x164db0, 0x56, 0xa5 },
	{ 0x164db1, 0xe8, 0x0 },
	{ 0x164db2, 0x92, 0x0 },
	{ 0x164db3, 0xc7, 0x0 },
	{ 0x164db4, 0xf1, 0x90 },
	{ 0x164db5, 0xff, 0x90 },
	{ 0x164e2f, 0x50, 0xb8 },
	{ 0x164e30, 0x56, 0xa5 },
	{ 0x164e31, 0xe8, 0x0 },
	{ 0x164e32, 0x12, 0x0 },
	{ 0x164e33, 0xc7, 0x0 },
	{ 0x164e34, 0xf1, 0x90 },
	{ 0x164e35, 0xff, 0x90 },
	{ 0x164eaf, 0x50, 0xb8 },
	{ 0x164eb0, 0x56, 0xa5 },
	{ 0x164eb1, 0xe8, 0x0 },
	{ 0x164eb2, 0x92, 0x0 },
	{ 0x164eb3, 0xc6, 0x0 },
	{ 0x164eb4, 0xf1, 0x90 },
	{ 0x164eb5, 0xff, 0x90 },
	{ 0x164f2f, 0x50, 0xb8 },
	{ 0x164f30, 0x56, 0xa5 },
	{ 0x164f31, 0xe8, 0x0 },
	{ 0x164f32, 0x12, 0x0 },
	{ 0x164f33, 0xc6, 0x0 },
	{ 0x164f34, 0xf1, 0x90 },
	{ 0x164f35, 0xff, 0x90 },
	{ 0x164faf, 0x50, 0xb8 },
	{ 0x164fb0, 0x56, 0xa5 },
	{ 0x164fb1, 0xe8, 0x0 },
	{ 0x164fb2, 0x92, 0x0 },
	{ 0x164fb3, 0xc5, 0x0 },
	{ 0x164fb4, 0xf1, 0x90 },
	{ 0x164fb5, 0xff, 0x90 },
	{ 0x16502f, 0x50, 0xb8 },
	{ 0x165030, 0x56, 0xa5 },
	{ 0x165031, 0xe8, 0x0 },
	{ 0x165032, 0x12, 0x0 },
	{ 0x165033, 0xc5, 0x0 },
	{ 0x165034, 0xf1, 0x90 },
	{ 0x165035, 0xff, 0x90 },
	{ 0x1650b3, 0x50, 0xb8 },
	{ 0x1650b4, 0x56, 0xa5 },
	{ 0x1650b5, 0xe8, 0x0 },
	{ 0x1650b6, 0x8e, 0x0 },
	{ 0x1650b7, 0xc4, 0x0 },
	{ 0x1650b8, 0xf1, 0x90 },
	{ 0x1650b9, 0xff, 0x90 },
	{-1,0,0}
};

PatchByte joypatch_81_65[] = {
	{ 0x1cefb3, 0x53, 0xb8 },
	{ 0x1cefb4, 0x6a, 0xa5 },
	{ 0x1cefb6, 0xe8, 0x00 },
	{ 0x1cefb7, 0x4d, 0x00 },
	{ 0x1cefb8, 0xa2, 0x90 },
	{ 0x1cefb9, 0xf3, 0x90 },
	{ 0x1cefba, 0xff, 0x90 },
	{ 0x1cf0b4, 0x53, 0xb8 },
	{ 0x1cf0b5, 0x6a, 0xa5 },
	{ 0x1cf0b6, 0x01, 0x00 },
	{ 0x1cf0b7, 0xe8, 0x00 },
	{ 0x1cf0b8, 0x4c, 0x00 },
	{ 0x1cf0b9, 0xa1, 0x90 },
	{ 0x1cf0ba, 0xf3, 0x90 },
	{ 0x1cf0bb, 0xff, 0x90 },
	{ 0x20a5ea, 0x8d, 0xb8 },
	{ 0x20a5eb, 0x45, 0xa5 },
	{ 0x20a5ec, 0xf0, 0x00 },
	{ 0x20a5ed, 0x50, 0x00 },
	{ 0x20a5ee, 0x53, 0x00 },
	{ 0x20a5ef, 0xe8, 0x90 },
	{ 0x20a5f0, 0x0c, 0x90 },
	{ 0x20a5f1, 0xec, 0x90 },
	{ 0x20a5f2, 0xef, 0x90 },
	{ 0x20a5f3, 0xff, 0x90 },
	{ 0x20a64a, 0x8d, 0xb8 },
	{ 0x20a64b, 0x45, 0xa5 },
	{ 0x20a64c, 0xf0, 0x00 },
	{ 0x20a64d, 0x50, 0x00 },
	{ 0x20a64e, 0x56, 0x00 },
	{ 0x20a64f, 0xe8, 0x90 },
	{ 0x20a650, 0xac, 0x90 },
	{ 0x20a651, 0xeb, 0x90 },
	{ 0x20a652, 0xef, 0x90 },
	{ 0x20a653, 0xff, 0x90 },
	{ 0x20a6e9, 0x68, 0xb8 },
	{ 0x20a6ea, 0xd8, 0xa5 },
	{ 0x20a6eb, 0x02, 0x00 },
	{ 0x20a6ee, 0x8d, 0x90 },
	{ 0x20a6ef, 0x85, 0x90 },
	{ 0x20a6f0, 0x28, 0x90 },
	{ 0x20a6f1, 0xfd, 0x90 },
	{ 0x20a6f2, 0xff, 0x90 },
	{ 0x20a6f3, 0xff, 0x90 },
	{ 0x20a6f4, 0x50, 0x90 },
	{ 0x20a6f5, 0x56, 0x90 },
	{ 0x20a6f6, 0xe8, 0x90 },
	{ 0x20a6f7, 0xfd, 0x90 },
	{ 0x20a6f8, 0xea, 0x90 },
	{ 0x20a6f9, 0xef, 0x90 },
	{ 0x20a6fa, 0xff, 0x90 },
	{ 0x20a755, 0x68, 0xb8 },
	{ 0x20a756, 0xd8, 0xa5 },
	{ 0x20a757, 0x02, 0x00 },
	{ 0x20a75a, 0x8d, 0x90 },
	{ 0x20a75b, 0x85, 0x90 },
	{ 0x20a75c, 0x28, 0x90 },
	{ 0x20a75d, 0xfd, 0x90 },
	{ 0x20a75e, 0xff, 0x90 },
	{ 0x20a75f, 0xff, 0x90 },
	{ 0x20a760, 0x50, 0x90 },
	{ 0x20a761, 0x56, 0x90 },
	{ 0x20a762, 0xe8, 0x90 },
	{ 0x20a763, 0x91, 0x90 },
	{ 0x20a764, 0xea, 0x90 },
	{ 0x20a765, 0xef, 0x90 },
	{ 0x20a766, 0xff, 0x90 },
	{ 0x20a7cd, 0x68, 0xb8 },
	{ 0x20a7ce, 0xd8, 0xa5 },
	{ 0x20a7cf, 0x02, 0x00 },
	{ 0x20a7d2, 0x8d, 0x90 },
	{ 0x20a7d3, 0x85, 0x90 },
	{ 0x20a7d4, 0x28, 0x90 },
	{ 0x20a7d5, 0xfd, 0x90 },
	{ 0x20a7d6, 0xff, 0x90 },
	{ 0x20a7d7, 0xff, 0x90 },
	{ 0x20a7d8, 0x50, 0x90 },
	{ 0x20a7d9, 0x56, 0x90 },
	{ 0x20a7da, 0xe8, 0x90 },
	{ 0x20a7db, 0x19, 0x90 },
	{ 0x20a7dc, 0xea, 0x90 },
	{ 0x20a7dd, 0xef, 0x90 },
	{ 0x20a7de, 0xff, 0x90 },
	{ 0x20a845, 0x68, 0xb8 },
	{ 0x20a846, 0xd8, 0xa5 },
	{ 0x20a847, 0x02, 0x00 },
	{ 0x20a84a, 0x8d, 0x90 },
	{ 0x20a84b, 0x85, 0x90 },
	{ 0x20a84c, 0x28, 0x90 },
	{ 0x20a84d, 0xfd, 0x90 },
	{ 0x20a84e, 0xff, 0x90 },
	{ 0x20a84f, 0xff, 0x90 },
	{ 0x20a850, 0x50, 0x90 },
	{ 0x20a851, 0x56, 0x90 },
	{ 0x20a852, 0xe8, 0x90 },
	{ 0x20a853, 0xa1, 0x90 },
	{ 0x20a854, 0xe9, 0x90 },
	{ 0x20a855, 0xef, 0x90 },
	{ 0x20a856, 0xff, 0x90 },
	{ 0x20a8c9, 0x8d, 0xb8 },
	{ 0x20a8ca, 0x45, 0xa5 },
	{ 0x20a8cb, 0xcc, 0x00 },
	{ 0x20a8cc, 0x50, 0x00 },
	{ 0x20a8cd, 0x56, 0x00 },
	{ 0x20a8ce, 0xe8, 0x90 },
	{ 0x20a8cf, 0x35, 0x90 },
	{ 0x20a8d0, 0xe9, 0x90 },
	{ 0x20a8d1, 0xef, 0x90 },
	{ 0x20a8d2, 0xff, 0x90 },
	{ 0x20ad30, 0x8d, 0xb8 },
	{ 0x20ad31, 0x45, 0xa5 },
	{ 0x20ad32, 0xcc, 0x00 },
	{ 0x20ad33, 0x50, 0x00 },
	{ 0x20ad34, 0x56, 0x00 },
	{ 0x20ad35, 0xe8, 0x90 },
	{ 0x20ad36, 0xce, 0x90 },
	{ 0x20ad37, 0xe4, 0x90 },
	{ 0x20ad38, 0xef, 0x90 },
	{ 0x20ad39, 0xff, 0x90 },
	{ 0x20adb0, 0x8d, 0xb8 },
	{ 0x20adb1, 0x45, 0xa5 },
	{ 0x20adb2, 0xcc, 0x00 },
	{ 0x20adb3, 0x50, 0x00 },
	{ 0x20adb4, 0x56, 0x00 },
	{ 0x20adb5, 0xe8, 0x90 },
	{ 0x20adb6, 0x4e, 0x90 },
	{ 0x20adb7, 0xe4, 0x90 },
	{ 0x20adb8, 0xef, 0x90 },
	{ 0x20adb9, 0xff, 0x90 },
	{ 0x20ae30, 0x8d, 0xb8 },
	{ 0x20ae31, 0x45, 0xa5 },
	{ 0x20ae32, 0xcc, 0x00 },
	{ 0x20ae33, 0x50, 0x00 },
	{ 0x20ae34, 0x56, 0x00 },
	{ 0x20ae35, 0xe8, 0x90 },
	{ 0x20ae36, 0xce, 0x90 },
	{ 0x20ae37, 0xe3, 0x90 },
	{ 0x20ae38, 0xef, 0x90 },
	{ 0x20ae39, 0xff, 0x90 },
	{ 0x20aeb0, 0x8d, 0xb8 },
	{ 0x20aeb1, 0x45, 0xa5 },
	{ 0x20aeb2, 0xcc, 0x00 },
	{ 0x20aeb3, 0x50, 0x00 },
	{ 0x20aeb4, 0x56, 0x00 },
	{ 0x20aeb5, 0xe8, 0x90 },
	{ 0x20aeb6, 0x4e, 0x90 },
	{ 0x20aeb7, 0xe3, 0x90 },
	{ 0x20aeb8, 0xef, 0x90 },
	{ 0x20aeb9, 0xff, 0x90 },
	{ 0x20af30, 0x8d, 0xb8 },
	{ 0x20af31, 0x45, 0xa5 },
	{ 0x20af32, 0xcc, 0x00 },
	{ 0x20af33, 0x50, 0x00 },
	{ 0x20af34, 0x56, 0x00 },
	{ 0x20af35, 0xe8, 0x90 },
	{ 0x20af36, 0xce, 0x90 },
	{ 0x20af37, 0xe2, 0x90 },
	{ 0x20af38, 0xef, 0x90 },
	{ 0x20af39, 0xff, 0x90 },
	{ 0x20afb0, 0x8d, 0xb8 },
	{ 0x20afb1, 0x45, 0xa5 },
	{ 0x20afb2, 0xcc, 0x00 },
	{ 0x20afb3, 0x50, 0x00 },
	{ 0x20afb4, 0x56, 0x00 },
	{ 0x20afb5, 0xe8, 0x90 },
	{ 0x20afb6, 0x4e, 0x90 },
	{ 0x20afb7, 0xe2, 0x90 },
	{ 0x20afb8, 0xef, 0x90 },
	{ 0x20afb9, 0xff, 0x90 },
	{ 0x20b034, 0x8d, 0xb8 },
	{ 0x20b035, 0x45, 0xa5 },
	{ 0x20b036, 0xcc, 0x00 },
	{ 0x20b037, 0x50, 0x00 },
	{ 0x20b038, 0x56, 0x00 },
	{ 0x20b039, 0xe8, 0x90 },
	{ 0x20b03a, 0xca, 0x90 },
	{ 0x20b03b, 0xe1, 0x90 },
	{ 0x20b03c, 0xef, 0x90 },
	{ 0x20b03d, 0xff, 0x90 },
	{-1,0,0}
};

PatchByte joypatch_81_71[] = {
	{ 0x1cf0f7, 0x53, 0xb8 },
	{ 0x1cf0f8, 0x6a, 0xa5 },
	{ 0x1cf0fa, 0xe8, 0x0 },
	{ 0x1cf0fb, 0x9, 0x0 },
	{ 0x1cf0fc, 0xa1, 0x90 },
	{ 0x1cf0fd, 0xf3, 0x90 },
	{ 0x1cf0fe, 0xff, 0x90 },
	{ 0x1cf1f8, 0x53, 0xb8 },
	{ 0x1cf1f9, 0x6a, 0xa5 },
	{ 0x1cf1fa, 0x1, 0x0 },
	{ 0x1cf1fb, 0xe8, 0x0 },
	{ 0x1cf1fc, 0x8, 0x0 },
	{ 0x1cf1fd, 0xa0, 0x90 },
	{ 0x1cf1fe, 0xf3, 0x90 },
	{ 0x1cf1ff, 0xff, 0x90 },
	{ 0x20a821, 0x50, 0xb8 },
	{ 0x20a822, 0x53, 0xa5 },
	{ 0x20a823, 0xe8, 0x0 },
	{ 0x20a824, 0xd8, 0x0 },
	{ 0x20a825, 0xe9, 0x0 },
	{ 0x20a826, 0xef, 0x90 },
	{ 0x20a827, 0xff, 0x90 },
	{ 0x20a881, 0x50, 0xb8 },
	{ 0x20a882, 0x56, 0xa5 },
	{ 0x20a883, 0xe8, 0x0 },
	{ 0x20a884, 0x78, 0x0 },
	{ 0x20a885, 0xe9, 0x0 },
	{ 0x20a886, 0xef, 0x90 },
	{ 0x20a887, 0xff, 0x90 },
	{ 0x20a928, 0x50, 0xb8 },
	{ 0x20a929, 0x56, 0xa5 },
	{ 0x20a92a, 0xe8, 0x0 },
	{ 0x20a92b, 0xc9, 0x0 },
	{ 0x20a92c, 0xe8, 0x0 },
	{ 0x20a92d, 0xef, 0x90 },
	{ 0x20a92e, 0xff, 0x90 },
	{ 0x20a994, 0x50, 0xb8 },
	{ 0x20a995, 0x56, 0xa5 },
	{ 0x20a996, 0xe8, 0x0 },
	{ 0x20a997, 0x5d, 0x0 },
	{ 0x20a998, 0xe8, 0x0 },
	{ 0x20a999, 0xef, 0x90 },
	{ 0x20a99a, 0xff, 0x90 },
	{ 0x20aa0c, 0x50, 0xb8 },
	{ 0x20aa0d, 0x56, 0xa5 },
	{ 0x20aa0e, 0xe8, 0x0 },
	{ 0x20aa0f, 0xe5, 0x0 },
	{ 0x20aa10, 0xe7, 0x0 },
	{ 0x20aa11, 0xef, 0x90 },
	{ 0x20aa12, 0xff, 0x90 },
	{ 0x20aa84, 0x50, 0xb8 },
	{ 0x20aa85, 0x56, 0xa5 },
	{ 0x20aa86, 0xe8, 0x0 },
	{ 0x20aa87, 0x6d, 0x0 },
	{ 0x20aa88, 0xe7, 0x0 },
	{ 0x20aa89, 0xef, 0x90 },
	{ 0x20aa8a, 0xff, 0x90 },
	{ 0x20ab00, 0x50, 0xb8 },
	{ 0x20ab01, 0x56, 0xa5 },
	{ 0x20ab02, 0xe8, 0x0 },
	{ 0x20ab03, 0x1, 0x0 },
	{ 0x20ab04, 0xe7, 0x0 },
	{ 0x20ab05, 0xef, 0x90 },
	{ 0x20ab06, 0xff, 0x90 },
	{ 0x20af67, 0x50, 0xb8 },
	{ 0x20af68, 0x56, 0xa5 },
	{ 0x20af69, 0xe8, 0x0 },
	{ 0x20af6a, 0x9a, 0x0 },
	{ 0x20af6b, 0xe2, 0x0 },
	{ 0x20af6c, 0xef, 0x90 },
	{ 0x20af6d, 0xff, 0x90 },
	{ 0x20afe7, 0x50, 0xb8 },
	{ 0x20afe8, 0x56, 0xa5 },
	{ 0x20afe9, 0xe8, 0x0 },
	{ 0x20afea, 0x1a, 0x0 },
	{ 0x20afeb, 0xe2, 0x0 },
	{ 0x20afec, 0xef, 0x90 },
	{ 0x20afed, 0xff, 0x90 },
	{ 0x20b067, 0x50, 0xb8 },
	{ 0x20b068, 0x56, 0xa5 },
	{ 0x20b069, 0xe8, 0x0 },
	{ 0x20b06a, 0x9a, 0x0 },
	{ 0x20b06b, 0xe1, 0x0 },
	{ 0x20b06c, 0xef, 0x90 },
	{ 0x20b06d, 0xff, 0x90 },
	{ 0x20b0e7, 0x50, 0xb8 },
	{ 0x20b0e8, 0x56, 0xa5 },
	{ 0x20b0e9, 0xe8, 0x0 },
	{ 0x20b0ea, 0x1a, 0x0 },
	{ 0x20b0eb, 0xe1, 0x0 },
	{ 0x20b0ec, 0xef, 0x90 },
	{ 0x20b0ed, 0xff, 0x90 },
	{ 0x20b167, 0x50, 0xb8 },
	{ 0x20b168, 0x56, 0xa5 },
	{ 0x20b169, 0xe8, 0x0 },
	{ 0x20b16a, 0x9a, 0x0 },
	{ 0x20b16b, 0xe0, 0x0 },
	{ 0x20b16c, 0xef, 0x90 },
	{ 0x20b16d, 0xff, 0x90 },
	{ 0x20b1e7, 0x50, 0xb8 },
	{ 0x20b1e8, 0x56, 0xa5 },
	{ 0x20b1e9, 0xe8, 0x0 },
	{ 0x20b1ea, 0x1a, 0x0 },
	{ 0x20b1eb, 0xe0, 0x0 },
	{ 0x20b1ec, 0xef, 0x90 },
	{ 0x20b1ed, 0xff, 0x90 },
	{ 0x20b26b, 0x50, 0xb8 },
	{ 0x20b26c, 0x56, 0xa5 },
	{ 0x20b26d, 0xe8, 0x0 },
	{ 0x20b26e, 0x96, 0x0 },
	{ 0x20b26f, 0xdf, 0x0 },
	{ 0x20b270, 0xef, 0x90 },
	{ 0x20b271, 0xff, 0x90 },
{-1,0,0}
};

PatchByte joypatch_81_135[] = {
	{ 0x1c5eb3, 0x53, 0xb8 },
	{ 0x1c5eb4, 0x6a, 0xa5 },
	{ 0x1c5eb6, 0xe8, 0x00 },
	{ 0x1c5eb7, 0x61, 0x00 },
	{ 0x1c5eb8, 0x67, 0x90 },
	{ 0x1c5eb9, 0xf4, 0x90 },
	{ 0x1c5eba, 0xff, 0x90 },
	{ 0x1c5fb4, 0x53, 0xb8 },
	{ 0x1c5fb5, 0x6a, 0xa5 },
	{ 0x1c5fb6, 0x01, 0x00 },
	{ 0x1c5fb7, 0xe8, 0x00 },
	{ 0x1c5fb8, 0x60, 0x00 },
	{ 0x1c5fb9, 0x66, 0x90 },
	{ 0x1c5fba, 0xf4, 0x90 },
	{ 0x1c5fbb, 0xff, 0x90 },
	{ 0x212f59, 0x50, 0xb8 },
	{ 0x212f5a, 0x53, 0xa5 },
	{ 0x212f5b, 0xe8, 0x00 },
	{ 0x212f5c, 0xb4, 0x00 },
	{ 0x212f5d, 0x96, 0x00 },
	{ 0x212f5e, 0xef, 0x90 },
	{ 0x212f5f, 0xff, 0x90 },
	{ 0x212fb9, 0x50, 0xb8 },
	{ 0x212fba, 0x56, 0xa5 },
	{ 0x212fbb, 0xe8, 0x00 },
	{ 0x212fbc, 0x54, 0x00 },
	{ 0x212fbd, 0x96, 0x00 },
	{ 0x212fbe, 0xef, 0x90 },
	{ 0x212fbf, 0xff, 0x90 },
	{ 0x21305e, 0x50, 0xb8 },
	{ 0x21305f, 0x56, 0xa5 },
	{ 0x213060, 0xe8, 0x00 },
	{ 0x213061, 0xa7, 0x00 },
	{ 0x213062, 0x95, 0x00 },
	{ 0x213063, 0xef, 0x90 },
	{ 0x213064, 0xff, 0x90 },
	{ 0x2130d0, 0x50, 0xb8 },
	{ 0x2130d1, 0x56, 0xa5 },
	{ 0x2130d2, 0xe8, 0x00 },
	{ 0x2130d3, 0x35, 0x00 },
	{ 0x2130d4, 0x95, 0x00 },
	{ 0x2130d5, 0xef, 0x90 },
	{ 0x2130d6, 0xff, 0x90 },
	{ 0x213148, 0x50, 0xb8 },
	{ 0x213149, 0x56, 0xa5 },
	{ 0x21314a, 0xe8, 0x00 },
	{ 0x21314b, 0xbd, 0x00 },
	{ 0x21314c, 0x94, 0x00 },
	{ 0x21314d, 0xef, 0x90 },
	{ 0x21314e, 0xff, 0x90 },
	{ 0x2131c0, 0x50, 0xb8 },
	{ 0x2131c1, 0x56, 0xa5 },
	{ 0x2131c2, 0xe8, 0x00 },
	{ 0x2131c3, 0x45, 0x00 },
	{ 0x2131c4, 0x94, 0x00 },
	{ 0x2131c5, 0xef, 0x90 },
	{ 0x2131c6, 0xff, 0x90 },
	{ 0x21323c, 0x50, 0xb8 },
	{ 0x21323d, 0x56, 0xa5 },
	{ 0x21323e, 0xe8, 0x00 },
	{ 0x21323f, 0xd9, 0x00 },
	{ 0x213240, 0x93, 0x00 },
	{ 0x213241, 0xef, 0x90 },
	{ 0x213242, 0xff, 0x90 },
	{ 0x2136a3, 0x50, 0xb8 },
	{ 0x2136a4, 0x56, 0xa5 },
	{ 0x2136a5, 0xe8, 0x00 },
	{ 0x2136a6, 0x72, 0x00 },
	{ 0x2136a7, 0x8f, 0x00 },
	{ 0x2136a8, 0xef, 0x90 },
	{ 0x2136a9, 0xff, 0x90 },
	{ 0x213723, 0x50, 0xb8 },
	{ 0x213724, 0x56, 0xa5 },
	{ 0x213725, 0xe8, 0x00 },
	{ 0x213726, 0xf2, 0x00 },
	{ 0x213727, 0x8e, 0x00 },
	{ 0x213728, 0xef, 0x90 },
	{ 0x213729, 0xff, 0x90 },
	{ 0x2137a3, 0x50, 0xb8 },
	{ 0x2137a4, 0x56, 0xa5 },
	{ 0x2137a5, 0xe8, 0x00 },
	{ 0x2137a6, 0x72, 0x00 },
	{ 0x2137a7, 0x8e, 0x00 },
	{ 0x2137a8, 0xef, 0x90 },
	{ 0x2137a9, 0xff, 0x90 },
	{ 0x213823, 0x50, 0xb8 },
	{ 0x213824, 0x56, 0xa5 },
	{ 0x213825, 0xe8, 0x00 },
	{ 0x213826, 0xf2, 0x00 },
	{ 0x213827, 0x8d, 0x00 },
	{ 0x213828, 0xef, 0x90 },
	{ 0x213829, 0xff, 0x90 },
	{ 0x2138a3, 0x50, 0xb8 },
	{ 0x2138a4, 0x56, 0xa5 },
	{ 0x2138a5, 0xe8, 0x00 },
	{ 0x2138a6, 0x72, 0x00 },
	{ 0x2138a7, 0x8d, 0x00 },
	{ 0x2138a8, 0xef, 0x90 },
	{ 0x2138a9, 0xff, 0x90 },
	{ 0x213923, 0x50, 0xb8 },
	{ 0x213924, 0x56, 0xa5 },
	{ 0x213925, 0xe8, 0x00 },
	{ 0x213926, 0xf2, 0x00 },
	{ 0x213927, 0x8c, 0x00 },
	{ 0x213928, 0xef, 0x90 },
	{ 0x213929, 0xff, 0x90 },
	{ 0x2139a7, 0x50, 0xb8 },
	{ 0x2139a8, 0x56, 0xa5 },
	{ 0x2139a9, 0xe8, 0x00 },
	{ 0x2139aa, 0x6e, 0x00 },
	{ 0x2139ab, 0x8c, 0x00 },
	{ 0x2139ac, 0xef, 0x90 },
	{ 0x2139ad, 0xff, 0x90 },
	{-1,0,0}
};

PatchByte joypatch_81_140[] = {
	{ 0x1f6cdb, 0x53, 0xb8 },
	{ 0x1f6cdc, 0x6a, 0xa5 },
	{ 0x1f6cde, 0xe8, 0x0 },
	{ 0x1f6cdf, 0x39, 0x0 },
	{ 0x1f6ce0, 0x59, 0x90 },
	{ 0x1f6ce1, 0xf1, 0x90 },
	{ 0x1f6ce2, 0xff, 0x90 },
	{ 0x1f6ddc, 0x53, 0xb8 },
	{ 0x1f6ddd, 0x6a, 0xa5 },
	{ 0x1f6dde, 0x1, 0x0 },
	{ 0x1f6ddf, 0xe8, 0x0 },
	{ 0x1f6de0, 0x38, 0x0 },
	{ 0x1f6de1, 0x58, 0x90 },
	{ 0x1f6de2, 0xf1, 0x90 },
	{ 0x1f6de3, 0xff, 0x90 },
	{ 0x2444e1, 0x50, 0xb8 },
	{ 0x2444e2, 0x53, 0xa5 },
	{ 0x2444e3, 0xe8, 0x0 },
	{ 0x2444e4, 0x2c, 0x0 },
	{ 0x2444e5, 0x81, 0x0 },
	{ 0x2444e6, 0xec, 0x90 },
	{ 0x2444e7, 0xff, 0x90 },
	{ 0x244541, 0x50, 0xb8 },
	{ 0x244542, 0x56, 0xa5 },
	{ 0x244543, 0xe8, 0x0 },
	{ 0x244544, 0xcc, 0x0 },
	{ 0x244545, 0x80, 0x0 },
	{ 0x244546, 0xec, 0x90 },
	{ 0x244547, 0xff, 0x90 },
	{ 0x2445e6, 0x50, 0xb8 },
	{ 0x2445e7, 0x56, 0xa5 },
	{ 0x2445e8, 0xe8, 0x0 },
	{ 0x2445e9, 0x1f, 0x0 },
	{ 0x2445ea, 0x80, 0x0 },
	{ 0x2445eb, 0xec, 0x90 },
	{ 0x2445ec, 0xff, 0x90 },
	{ 0x244658, 0x50, 0xb8 },
	{ 0x244659, 0x56, 0xa5 },
	{ 0x24465a, 0xe8, 0x0 },
	{ 0x24465b, 0xad, 0x0 },
	{ 0x24465c, 0x7f, 0x0 },
	{ 0x24465d, 0xec, 0x90 },
	{ 0x24465e, 0xff, 0x90 },
	{ 0x2446d0, 0x50, 0xb8 },
	{ 0x2446d1, 0x56, 0xa5 },
	{ 0x2446d2, 0xe8, 0x0 },
	{ 0x2446d3, 0x35, 0x0 },
	{ 0x2446d4, 0x7f, 0x0 },
	{ 0x2446d5, 0xec, 0x90 },
	{ 0x2446d6, 0xff, 0x90 },
	{ 0x244748, 0x50, 0xb8 },
	{ 0x244749, 0x56, 0xa5 },
	{ 0x24474a, 0xe8, 0x0 },
	{ 0x24474b, 0xbd, 0x0 },
	{ 0x24474c, 0x7e, 0x0 },
	{ 0x24474d, 0xec, 0x90 },
	{ 0x24474e, 0xff, 0x90 },
	{ 0x2447c4, 0x50, 0xb8 },
	{ 0x2447c5, 0x56, 0xa5 },
	{ 0x2447c6, 0xe8, 0x0 },
	{ 0x2447c7, 0x51, 0x0 },
	{ 0x2447c8, 0x7e, 0x0 },
	{ 0x2447c9, 0xec, 0x90 },
	{ 0x2447ca, 0xff, 0x90 },
	{ 0x244c2b, 0x50, 0xb8 },
	{ 0x244c2c, 0x56, 0xa5 },
	{ 0x244c2d, 0xe8, 0x0 },
	{ 0x244c2e, 0xea, 0x0 },
	{ 0x244c2f, 0x79, 0x0 },
	{ 0x244c30, 0xec, 0x90 },
	{ 0x244c31, 0xff, 0x90 },
	{ 0x244cab, 0x50, 0xb8 },
	{ 0x244cac, 0x56, 0xa5 },
	{ 0x244cad, 0xe8, 0x0 },
	{ 0x244cae, 0x6a, 0x0 },
	{ 0x244caf, 0x79, 0x0 },
	{ 0x244cb0, 0xec, 0x90 },
	{ 0x244cb1, 0xff, 0x90 },
	{ 0x244d2b, 0x50, 0xb8 },
	{ 0x244d2c, 0x56, 0xa5 },
	{ 0x244d2d, 0xe8, 0x0 },
	{ 0x244d2e, 0xea, 0x0 },
	{ 0x244d2f, 0x78, 0x0 },
	{ 0x244d30, 0xec, 0x90 },
	{ 0x244d31, 0xff, 0x90 },
	{ 0x244dab, 0x50, 0xb8 },
	{ 0x244dac, 0x56, 0xa5 },
	{ 0x244dad, 0xe8, 0x0 },
	{ 0x244dae, 0x6a, 0x0 },
	{ 0x244daf, 0x78, 0x0 },
	{ 0x244db0, 0xec, 0x90 },
	{ 0x244db1, 0xff, 0x90 },
	{ 0x244e2b, 0x50, 0xb8 },
	{ 0x244e2c, 0x56, 0xa5 },
	{ 0x244e2d, 0xe8, 0x0 },
	{ 0x244e2e, 0xea, 0x0 },
	{ 0x244e2f, 0x77, 0x0 },
	{ 0x244e30, 0xec, 0x90 },
	{ 0x244e31, 0xff, 0x90 },
	{ 0x244eab, 0x50, 0xb8 },
	{ 0x244eac, 0x56, 0xa5 },
	{ 0x244ead, 0xe8, 0x0 },
	{ 0x244eae, 0x6a, 0x0 },
	{ 0x244eaf, 0x77, 0x0 },
	{ 0x244eb0, 0xec, 0x90 },
	{ 0x244eb1, 0xff, 0x90 },
	{ 0x244f2f, 0x50, 0xb8 },
	{ 0x244f30, 0x56, 0xa5 },
	{ 0x244f31, 0xe8, 0x0 },
	{ 0x244f32, 0xe6, 0x0 },
	{ 0x244f33, 0x76, 0x0 },
	{ 0x244f34, 0xec, 0x90 },
	{ 0x244f35, 0xff, 0x90 },
	{-1,0,0}
};

PatchByte joypatch_81_141[] = {
	{ 0x1f6ce7, 0x53, 0xb8 },
	{ 0x1f6ce8, 0x6a, 0xa5 },
	{ 0x1f6cea, 0xe8, 0x0 },
	{ 0x1f6ceb, 0x2d, 0x0 },
	{ 0x1f6cec, 0x59, 0x90 },
	{ 0x1f6ced, 0xf1, 0x90 },
	{ 0x1f6cee, 0xff, 0x90 },
	{ 0x1f6de8, 0x53, 0xb8 },
	{ 0x1f6de9, 0x6a, 0xa5 },
	{ 0x1f6dea, 0x1, 0x0 },
	{ 0x1f6deb, 0xe8, 0x0 },
	{ 0x1f6dec, 0x2c, 0x0 },
	{ 0x1f6ded, 0x58, 0x90 },
	{ 0x1f6dee, 0xf1, 0x90 },
	{ 0x1f6def, 0xff, 0x90 },
	{ 0x244711, 0x50, 0xb8 },
	{ 0x244712, 0x53, 0xa5 },
	{ 0x244713, 0xe8, 0x0 },
	{ 0x244714, 0xfc, 0x0 },
	{ 0x244715, 0x7e, 0x0 },
	{ 0x244716, 0xec, 0x90 },
	{ 0x244717, 0xff, 0x90 },
	{ 0x244771, 0x50, 0xb8 },
	{ 0x244772, 0x56, 0xa5 },
	{ 0x244773, 0xe8, 0x0 },
	{ 0x244774, 0x9c, 0x0 },
	{ 0x244775, 0x7e, 0x0 },
	{ 0x244776, 0xec, 0x90 },
	{ 0x244777, 0xff, 0x90 },
	{ 0x24480b, 0x68, 0xb8 },
	{ 0x24480c, 0xd8, 0xa5 },
	{ 0x24480d, 0x2, 0x0 },
	{ 0x244810, 0x8d, 0x90 },
	{ 0x244811, 0x85, 0x90 },
	{ 0x244812, 0x28, 0x90 },
	{ 0x244813, 0xfd, 0x90 },
	{ 0x244814, 0xff, 0x90 },
	{ 0x244815, 0xff, 0x90 },
	{ 0x244816, 0x50, 0x90 },
	{ 0x244817, 0x56, 0x90 },
	{ 0x244818, 0xe8, 0x90 },
	{ 0x244819, 0xef, 0x90 },
	{ 0x24481a, 0x7d, 0x90 },
	{ 0x24481b, 0xec, 0x90 },
	{ 0x24481c, 0xff, 0x90 },
	{ 0x24487d, 0x68, 0xb8 },
	{ 0x24487e, 0xd8, 0xa5 },
	{ 0x24487f, 0x2, 0x0 },
	{ 0x244882, 0x8d, 0x90 },
	{ 0x244883, 0x85, 0x90 },
	{ 0x244884, 0x28, 0x90 },
	{ 0x244885, 0xfd, 0x90 },
	{ 0x244886, 0xff, 0x90 },
	{ 0x244887, 0xff, 0x90 },
	{ 0x244888, 0x50, 0x90 },
	{ 0x244889, 0x56, 0x90 },
	{ 0x24488a, 0xe8, 0x90 },
	{ 0x24488b, 0x7d, 0x90 },
	{ 0x24488c, 0x7d, 0x90 },
	{ 0x24488d, 0xec, 0x90 },
	{ 0x24488e, 0xff, 0x90 },
	{ 0x2448f5, 0x68, 0xb8 },
	{ 0x2448f6, 0xd8, 0xa5 },
	{ 0x2448f7, 0x2, 0x0 },
	{ 0x2448fa, 0x8d, 0x90 },
	{ 0x2448fb, 0x85, 0x90 },
	{ 0x2448fc, 0x28, 0x90 },
	{ 0x2448fd, 0xfd, 0x90 },
	{ 0x2448fe, 0xff, 0x90 },
	{ 0x2448ff, 0xff, 0x90 },
	{ 0x244900, 0x50, 0x90 },
	{ 0x244901, 0x56, 0x90 },
	{ 0x244902, 0xe8, 0x90 },
	{ 0x244903, 0x5, 0x90 },
	{ 0x244904, 0x7d, 0x90 },
	{ 0x244905, 0xec, 0x90 },
	{ 0x244906, 0xff, 0x90 },
	{ 0x24496d, 0x68, 0xb8 },
	{ 0x24496e, 0xd8, 0xa5 },
	{ 0x24496f, 0x2, 0x0 },
	{ 0x244972, 0x8d, 0x90 },
	{ 0x244973, 0x85, 0x90 },
	{ 0x244974, 0x28, 0x90 },
	{ 0x244975, 0xfd, 0x90 },
	{ 0x244976, 0xff, 0x90 },
	{ 0x244977, 0xff, 0x90 },
	{ 0x244978, 0x50, 0x90 },
	{ 0x244979, 0x56, 0x90 },
	{ 0x24497a, 0xe8, 0x90 },
	{ 0x24497b, 0x8d, 0x90 },
	{ 0x24497c, 0x7c, 0x90 },
	{ 0x24497d, 0xec, 0x90 },
	{ 0x24497e, 0xff, 0x90 },
	{ 0x2449f4, 0x50, 0xb8 },
	{ 0x2449f5, 0x56, 0xa5 },
	{ 0x2449f6, 0xe8, 0x0 },
	{ 0x2449f7, 0x21, 0x0 },
	{ 0x2449f8, 0x7c, 0x0 },
	{ 0x2449f9, 0xec, 0x90 },
	{ 0x2449fa, 0xff, 0x90 },
	{ 0x244e5b, 0x50, 0xb8 },
	{ 0x244e5c, 0x56, 0xa5 },
	{ 0x244e5d, 0xe8, 0x0 },
	{ 0x244e5e, 0xba, 0x0 },
	{ 0x244e5f, 0x77, 0x0 },
	{ 0x244e60, 0xec, 0x90 },
	{ 0x244e61, 0xff, 0x90 },
	{ 0x244edb, 0x50, 0xb8 },
	{ 0x244edc, 0x56, 0xa5 },
	{ 0x244edd, 0xe8, 0x0 },
	{ 0x244ede, 0x3a, 0x0 },
	{ 0x244edf, 0x77, 0x0 },
	{ 0x244ee0, 0xec, 0x90 },
	{ 0x244ee1, 0xff, 0x90 },
	{ 0x244f5b, 0x50, 0xb8 },
	{ 0x244f5c, 0x56, 0xa5 },
	{ 0x244f5d, 0xe8, 0x0 },
	{ 0x244f5e, 0xba, 0x0 },
	{ 0x244f5f, 0x76, 0x0 },
	{ 0x244f60, 0xec, 0x90 },
	{ 0x244f61, 0xff, 0x90 },
	{ 0x244fdb, 0x50, 0xb8 },
	{ 0x244fdc, 0x56, 0xa5 },
	{ 0x244fdd, 0xe8, 0x0 },
	{ 0x244fde, 0x3a, 0x0 },
	{ 0x244fdf, 0x76, 0x0 },
	{ 0x244fe0, 0xec, 0x90 },
	{ 0x244fe1, 0xff, 0x90 },
	{ 0x24505b, 0x50, 0xb8 },
	{ 0x24505c, 0x56, 0xa5 },
	{ 0x24505d, 0xe8, 0x0 },
	{ 0x24505e, 0xba, 0x0 },
	{ 0x24505f, 0x75, 0x0 },
	{ 0x245060, 0xec, 0x90 },
	{ 0x245061, 0xff, 0x90 },
	{ 0x2450db, 0x50, 0xb8 },
	{ 0x2450dc, 0x56, 0xa5 },
	{ 0x2450dd, 0xe8, 0x0 },
	{ 0x2450de, 0x3a, 0x0 },
	{ 0x2450df, 0x75, 0x0 },
	{ 0x2450e0, 0xec, 0x90 },
	{ 0x2450e1, 0xff, 0x90 },
	{ 0x24515f, 0x50, 0xb8 },
	{ 0x245160, 0x56, 0xa5 },
	{ 0x245161, 0xe8, 0x0 },
	{ 0x245162, 0xb6, 0x0 },
	{ 0x245163, 0x74, 0x0 },
	{ 0x245164, 0xec, 0x90 },
	{ 0x245165, 0xff, 0x90 },
	{-1,0,0}
};

// DPLAY PATCHES
// How to create:
// 1. Find L"DPlayX.dll"
// 2. Replace the 'D' with a null byte

PatchByte dplaypatch_80[] = {
	{ 0x187380, 'D', 0 },
	{ 0x187381, 'P', 'P' },
	{ 0x187382, 'l', 'l' },
	{ 0x187383, 'a', 'a' },
	{ 0x187384, 'y', 'y' },
	{ 0x187385, 'X', 'X' },
	{-1,0,0}
};

PatchByte dplaypatch_81_65[] = {
	{ 0x23d184, 'D', 0 },
	{ 0x23d186, 'P', 'P' },
	{ 0x23d188, 'l', 'l' },
	{ 0x23d18a, 'a', 'a' },
	{ 0x23d18c, 'y', 'y' },
	{ 0x23d18e, 'X', 'X' },
	{-1,0,0}
};

PatchByte dplaypatch_81_71[] = {
	{0x23d384, 'D', 0},
	{0x23d386, 'P', 'P'},
	{0x23d388, 'l', 'l'},
	{0x23d38a, 'a', 'a'},
	{0x23d38c, 'y', 'y'},
	{0x23d38e, 'X', 'X'},
	{-1,0,0}
};

PatchByte dplaypatch_81_135[] = {
	{ 0x2761ac, 'D', 0 },
	{ 0x2761ae, 'P', 'P' },
	{ 0x2761b0, 'l', 'l' },
	{ 0x2761b2, 'a', 'a' },
	{ 0x2761b4, 'y', 'y' },
	{ 0x2761b6, 'X', 'X' },
	{-1,0,0}
};

PatchByte dplaypatch_81_140[] = {
	{ 0x279a10, 'D', 0 },
	{ 0x279a12, 'P', 'P' },
	{ 0x279a14, 'l', 'l' },
	{ 0x279a16, 'a', 'a' },
	{ 0x279a18, 'y', 'y' },
	{ 0x279a1a, 'X', 'X' },
	{-1,0,0}
};

PatchByte dplaypatch_81_141[] = {
	{ 0x279c10, 'D', 0 },
	{ 0x279c12, 'P', 'P' },
	{ 0x279c14, 'l', 'l' },
	{ 0x279c16, 'a', 'a' },
	{ 0x279c18, 'y', 'y' },
	{ 0x279c1a, 'X', 'X' },
	{-1,0,0}
};

// SCHEDULER PATCHES
// How to create:
// 1. replace "joyGetDevCapsW" (or A, for 8.0) with "timeBeginPeriod"
// 2. call the JMP wrapper for timeBeginPeriod instead of writing "Loading help..."

PatchByte schedpatch_80[] = {
	{0x14461a, 0xb8, 0x6a},
	{0x14461b, 0x2d, 0x01},
	{0x14461c, 0x00, 0xe8},
	{0x14461d, 0x00, 0x17},
	{0x14461e, 0x00, 0xcf},
	{0x14461f, 0xe8, 0xf3},
	{0x144620, 0x18, 0xff},
	{0x144621, 0xef, 0x90},
	{0x144622, 0xff, 0x90},
	{0x144623, 0xff, 0x90},
	{0x191e82, 'j', 't'},
	{0x191e83, 'o', 'i'},
	{0x191e84, 'y', 'm'},
	{0x191e85, 'G', 'e'},
	{0x191e86, 'e', 'B'},
	{0x191e87, 't', 'e'},
	{0x191e88, 'D', 'g'},
	{0x191e89, 'e', 'i'},
	{0x191e8a, 'v', 'n'},
	{0x191e8b, 'C', 'P'},
	{0x191e8c, 'a', 'e'},
	{0x191e8d, 'p', 'r'},
	{0x191e8e, 's', 'i'},
	{0x191e8f, 'A', 'o'},
	{0x191e90, 0x0, 'd'},
	{-1,0,0}
};

PatchByte schedpatch_80upx[] = {
	{0x14461a, 0xb8, 0x6a},
	{0x14461b, 0x2d, 0x01},
	{0x14461c, 0x00, 0xe8},
	{0x14461d, 0x00, 0x17},
	{0x14461e, 0x00, 0xcf},
	{0x14461f, 0xe8, 0xf3},
	{0x144620, 0x18, 0xff},
	{0x144621, 0xef, 0x90},
	{0x144622, 0xff, 0x90},
	{0x144623, 0xff, 0x90},
	{0x191c4e, 'j', 't'},
	{0x191c4f, 'o', 'i'},
	{0x191c50, 'y', 'm'},
	{0x191c51, 'G', 'e'},
	{0x191c52, 'e', 'B'},
	{0x191c53, 't', 'e'},
	{0x191c54, 'D', 'g'},
	{0x191c55, 'e', 'i'},
	{0x191c56, 'v', 'n'},
	{0x191c57, 'C', 'P'},
	{0x191c58, 'a', 'e'},
	{0x191c59, 'p', 'r'},
	{0x191c5a, 's', 'i'},
	{0x191c5b, 'A', 'o'},
	{0x191c5c, 0x0, 'd'},
	{-1,0,0}
};

PatchByte schedpatch_81_65[] = {
	{ 0x1e3fd6, 0xb8, 0x6a },
	{ 0x1e3fd7, 0x2d, 0x01 },
	{ 0x1e3fd8, 0x00, 0xe8 },
	{ 0x1e3fd9, 0x00, 0x1b },
	{ 0x1e3fda, 0x00, 0x52 },
	{ 0x1e3fdb, 0xe8, 0xf2 },
	{ 0x1e3fdc, 0x98, 0xff },
	{ 0x1e3fdd, 0xe7, 0x90 },
	{ 0x1e3fde, 0xff, 0x90 },
	{ 0x1e3fdf, 0xff, 0x90 },
	{ 0x24cb5e, 'j', 't' },
	{ 0x24cb5f, 'o', 'i' },
	{ 0x24cb60, 'y', 'm' },
	{ 0x24cb61, 'G', 'e' },
	{ 0x24cb62, 'e', 'B' },
	{ 0x24cb63, 't', 'e' },
	{ 0x24cb64, 'D', 'g' },
	{ 0x24cb65, 'e', 'i' },
	{ 0x24cb66, 'v', 'n' },
	{ 0x24cb67, 'C', 'P' },
	{ 0x24cb68, 'a', 'e' },
	{ 0x24cb69, 'p', 'r' },
	{ 0x24cb6a, 's', 'i' },
	{ 0x24cb6b, 'W', 'o' },
	{ 0x24cb6c, 0x0, 'd' },
		{-1,0,0}
};

PatchByte schedpatch_81_71[] = {
	{ 0x1e4126, 0xb8, 0x6a },
	{ 0x1e4127, 0x2d, 0x1 },
	{ 0x1e4128, 0x0, 0xe8 },
	{ 0x1e4129, 0x0, 0xcb },
	{ 0x1e412a, 0x0, 0x50 },
	{ 0x1e412b, 0xe8, 0xf2 },
	{ 0x1e412c, 0x98, 0xff },
	{ 0x1e412d, 0xe7, 0x90 },
	{ 0x1e412e, 0xff, 0x90 },
	{ 0x1e412f, 0xff, 0x90 },
	{ 0x24cd5e, 'j', 't' },
	{ 0x24cd5f, 'o', 'i' },
	{ 0x24cd60, 'y', 'm' },
	{ 0x24cd61, 'G', 'e' },
	{ 0x24cd62, 'e', 'B' },
	{ 0x24cd63, 't', 'e' },
	{ 0x24cd64, 'D', 'g' },
	{ 0x24cd65, 'e', 'i' },
	{ 0x24cd66, 'v', 'n' },
	{ 0x24cd67, 'C', 'P' },
	{ 0x24cd68, 'a', 'e' },
	{ 0x24cd69, 'p', 'r' },
	{ 0x24cd6a, 's', 'i' },
	{ 0x24cd6b, 'W', 'o' },
	{ 0x24cd6c, 0x0, 'd' },
	{-1,0,0}
};

PatchByte schedpatch_81_135[] = {
	{ 0x1f52be, 0xb8, 0x6a },
	{ 0x1f52bf, 0x2d, 0x01 },
	{ 0x1f52c0, 0x00, 0xe8 },
	{ 0x1f52c1, 0x00, 0x47 },
	{ 0x1f52c2, 0x00, 0x73 },
	{ 0x1f52c3, 0xe8, 0xf1 },
	{ 0x1f52c4, 0x90, 0xff },
	{ 0x1f52c5, 0xe7, 0x90 },
	{ 0x1f52c6, 0xff, 0x90 },
	{ 0x1f52c7, 0xff, 0x90 },
	{ 0x288688, 'j', 't' },
	{ 0x288689, 'o', 'i' },
	{ 0x28868a, 'y', 'm' },
	{ 0x28868b, 'G', 'e' },
	{ 0x28868c, 'e', 'B' },
	{ 0x28868d, 't', 'e' },
	{ 0x28868e, 'D', 'g' },
	{ 0x28868f, 'e', 'i' },
	{ 0x288690, 'v', 'n' },
	{ 0x288691, 'C', 'P' },
	{ 0x288692, 'a', 'e' },
	{ 0x288693, 'p', 'r' },
	{ 0x288694, 's', 'i' },
	{ 0x288695, 'W', 'o' },
	{ 0x288696, 0x0, 'd' },
	{-1,0,0}
};

PatchByte schedpatch_81_140[] = {
	{ 0x279d23, 0xb8, 0x6a },
	{ 0x279d24, 0x20, 0x1 },
	{ 0x279d25, 0xb1, 0xe8 },
	{ 0x279d26, 0x67, 0xe2 },
	{ 0x279d27, 0x0, 0x22 },
	{ 0x279d28, 0xe8, 0xe9 },
	{ 0x279d29, 0xd7, 0xff },
	{ 0x279d2a, 0x67, 0x90 },
	{ 0x279d2b, 0xee, 0x90 },
	{ 0x279d2c, 0xff, 0x90 },
	{ 0x28bc88, 'j', 't' },
	{ 0x28bc89, 'o', 'i' },
	{ 0x28bc8a, 'y', 'm' },
	{ 0x28bc8b, 'G', 'e' },
	{ 0x28bc8c, 'e', 'B' },
	{ 0x28bc8d, 't', 'e' },
	{ 0x28bc8e, 'D', 'g' },
	{ 0x28bc8f, 'e', 'i' },
	{ 0x28bc90, 'v', 'n' },
	{ 0x28bc91, 'C', 'P' },
	{ 0x28bc92, 'a', 'e' },
	{ 0x28bc93, 'p', 'r' },
	{ 0x28bc94, 's', 'i' },
	{ 0x28bc95, 'W', 'o' },
	{ 0x28bc96, 0x0, 'd' },
	{-1,0,0}
};

PatchByte schedpatch_81_141[] = {
	{0x279f23, 0xb8, 0x6a},
	{0x279f24, 0x20, 0x01},
	{0x279f25, 0xb1, 0xe8},
	{0x279f26, 0x67, 0xe2},
	{0x279f27, 0x00, 0x22},
	{0x279f28, 0xe8, 0xe9},
	{0x279f29, 0xd7, 0xff},
	{0x279f2a, 0x67, 0x90},
	{0x279f2b, 0xee, 0x90},
	{0x279f2c, 0xff, 0x90},
	{0x28be88, 'j', 't'},
	{0x28be89, 'o', 'i'},
	{0x28be8a, 'y', 'm'},
	{0x28be8b, 'G', 'e'},
	{0x28be8c, 'e', 'B'},
	{0x28be8d, 't', 'e'},
	{0x28be8e, 'D', 'g'},
	{0x28be8f, 'e', 'i'},
	{0x28be90, 'v', 'n'},
	{0x28be91, 'C', 'P'},
	{0x28be92, 'a', 'e'},
	{0x28be93, 'p', 'r'},
	{0x28be94, 's', 'i'},
	{0x28be95, 'W', 'o'},
	{0x28be96, 0x0, 'd'},
	{-1,0,0}
};

// INPUT LAG PATCHES
// How to create:
// 1. Find where the timing code and screen presenting is done (search via GML sleep)
// 2. Swap timing with presenting
// 3. Fix call instructions

PatchByte inputlagpatch_80[] = {
	{ 0x13dcbd, 0xe8, 0xff },
	{ 0x13dcbe, 0xfe, 0x45 },
	{ 0x13dcbf, 0xbc, 0xdc },
	{ 0x13dcc0, 0xf5, 0xa1 },
	{ 0x13dcc1, 0xff, 0x4 },
	{ 0x13dcc2, 0x89, 0xf6 },
	{ 0x13dcc3, 0x45, 0x58 },
	{ 0x13dcc4, 0xf0, 0x0 },
	{ 0x13dcc5, 0x89, 0x83 },
	{ 0x13dcc6, 0x55, 0x38 },
	{ 0x13dcc7, 0xf4, 0xff },
	{ 0x13dcc8, 0x8b, 0x75 },
	{ 0x13dcc9, 0x45, 0x14 },
	{ 0x13dcca, 0xf0, 0xa1 },
	{ 0x13dccb, 0x8b, 0x84 },
	{ 0x13dccc, 0x55, 0xf9 },
	{ 0x13dccd, 0xf4, 0x58 },
	{ 0x13dcce, 0x3b, 0x0 },
	{ 0x13dccf, 0x55, 0x80 },
	{ 0x13dcd0, 0xfc, 0x38 },
	{ 0x13dcd1, 0x75, 0x0 },
	{ 0x13dcd2, 0x7, 0x74 },
	{ 0x13dcd3, 0x3b, 0xa },
	{ 0x13dcd4, 0x45, 0xe8 },
	{ 0x13dcd5, 0xf8, 0x2f },
	{ 0x13dcd6, 0x73, 0x3e },
	{ 0x13dcd7, 0x10, 0xf6 },
	{ 0x13dcd8, 0xeb, 0xff },
	{ 0x13dcd9, 0x2, 0xe8 },
	{ 0x13dcda, 0x7d, 0xa },
	{ 0x13dcdb, 0xc, 0x3e },
	{ 0x13dcdc, 0x8b, 0xf6 },
	{ 0x13dcdd, 0x45, 0xff },
	{ 0x13dcde, 0xf0, 0xe8 },
	{ 0x13dcdf, 0x89, 0xdd },
	{ 0x13dce0, 0x45, 0xbc },
	{ 0x13dce1, 0xf8, 0xf5 },
	{ 0x13dce2, 0x8b, 0xff },
	{ 0x13dce3, 0x45, 0x89 },
	{ 0x13dce4, 0xf4, 0x45 },
	{ 0x13dce5, 0x89, 0xf0 },
	{ 0x13dce6, 0x45, 0x89 },
	{ 0x13dce7, 0xfc, 0x55 },
	{ 0x13dce8, 0xa1, 0xf4 },
	{ 0x13dce9, 0xc4, 0x8b },
	{ 0x13dcea, 0xfa, 0x45 },
	{ 0x13dceb, 0x58, 0xf0 },
	{ 0x13dcec, 0x0, 0x8b },
	{ 0x13dced, 0x8b, 0x55 },
	{ 0x13dcee, 0x0, 0xf4 },
	{ 0x13dcef, 0x83, 0x3b },
	{ 0x13dcf0, 0x78, 0x55 },
	{ 0x13dcf1, 0x8, 0xfc },
	{ 0x13dcf2, 0x0, 0x75 },
	{ 0x13dcf3, 0x7f, 0x7 },
	{ 0x13dcf4, 0xe, 0x3b },
	{ 0x13dcf5, 0xa1, 0x45 },
	{ 0x13dcf6, 0xc4, 0xf8 },
	{ 0x13dcf7, 0xfa, 0x73 },
	{ 0x13dcf8, 0x58, 0x10 },
	{ 0x13dcf9, 0x0, 0xeb },
	{ 0x13dcfa, 0x8b, 0x2 },
	{ 0x13dcfb, 0x0, 0x7d },
	{ 0x13dcfc, 0xc7, 0xc },
	{ 0x13dcfd, 0x40, 0x8b },
	{ 0x13dcfe, 0x8, 0x45 },
	{ 0x13dcff, 0x1, 0xf0 },
	{ 0x13dd00, 0x0, 0x89 },
	{ 0x13dd01, 0x0, 0x45 },
	{ 0x13dd02, 0x0, 0xf8 },
	{ 0x13dd03, 0xa1, 0x8b },
	{ 0x13dd04, 0xc4, 0x45 },
	{ 0x13dd05, 0xfa, 0xf4 },
	{ 0x13dd06, 0x58, 0x89 },
	{ 0x13dd07, 0x0, 0x45 },
	{ 0x13dd08, 0x8b, 0xfc },
	{ 0x13dd09, 0x0, 0xa1 },
	{ 0x13dd0a, 0xff, 0xc4 },
	{ 0x13dd0b, 0x70, 0xfa },
	{ 0x13dd0c, 0x8, 0x58 },
	{ 0x13dd0d, 0xb8, 0x0 },
	{ 0x13dd0e, 0x40, 0x8b },
	{ 0x13dd0f, 0x42, 0x0 },
	{ 0x13dd10, 0xf, 0x83 },
	{ 0x13dd11, 0x0, 0x78 },
	{ 0x13dd12, 0x5a, 0x8 },
	{ 0x13dd13, 0x8b, 0x0 },
	{ 0x13dd14, 0xca, 0x7f },
	{ 0x13dd15, 0x99, 0xe },
	{ 0x13dd16, 0xf7, 0xa1 },
	{ 0x13dd17, 0xf9, 0xc4 },
	{ 0x13dd18, 0x99, 0xfa },
	{ 0x13dd19, 0x52, 0x58 },
	{ 0x13dd1a, 0x50, 0x0 },
	{ 0x13dd1c, 0x45, 0x0 },
	{ 0x13dd1d, 0xf0, 0xc7 },
	{ 0x13dd1e, 0x8b, 0x40 },
	{ 0x13dd1f, 0x55, 0x8 },
	{ 0x13dd20, 0xf4, 0x1 },
	{ 0x13dd21, 0x2b, 0x0 },
	{ 0x13dd22, 0x45, 0x0 },
	{ 0x13dd23, 0xf8, 0x0 },
	{ 0x13dd24, 0x1b, 0xa1 },
	{ 0x13dd25, 0x55, 0xc4 },
	{ 0x13dd26, 0xfc, 0xfa },
	{ 0x13dd27, 0x29, 0x58 },
	{ 0x13dd28, 0x4, 0x0 },
	{ 0x13dd29, 0x24, 0x8b },
	{ 0x13dd2a, 0x19, 0x0 },
	{ 0x13dd2b, 0x54, 0xff },
	{ 0x13dd2c, 0x24, 0x70 },
	{ 0x13dd2d, 0x4, 0x8 },
	{ 0x13dd2e, 0x58, 0xb8 },
	{ 0x13dd2f, 0x5a, 0x40 },
	{ 0x13dd30, 0x89, 0x42 },
	{ 0x13dd31, 0x45, 0xf },
	{ 0x13dd32, 0xd0, 0x0 },
	{ 0x13dd33, 0x89, 0x5a },
	{ 0x13dd34, 0x55, 0x8b },
	{ 0x13dd35, 0xd4, 0xca },
	{ 0x13dd36, 0x83, 0x99 },
	{ 0x13dd37, 0x7d, 0xf7 },
	{ 0x13dd38, 0xd4, 0xf9 },
	{ 0x13dd39, 0x0, 0x99 },
	{ 0x13dd3a, 0x75, 0x52 },
	{ 0x13dd3b, 0x8, 0x50 },
	{ 0x13dd3c, 0x83, 0x8b },
	{ 0x13dd3d, 0x7d, 0x45 },
	{ 0x13dd3e, 0xd0, 0xf0 },
	{ 0x13dd3f, 0x0, 0x8b },
	{ 0x13dd40, 0x73, 0x55 },
	{ 0x13dd41, 0x14, 0xf4 },
	{ 0x13dd42, 0xeb, 0x2b },
	{ 0x13dd43, 0x2, 0x45 },
	{ 0x13dd44, 0x7d, 0xf8 },
	{ 0x13dd45, 0x10, 0x1b },
	{ 0x13dd46, 0xc7, 0x55 },
	{ 0x13dd47, 0x45, 0xfc },
	{ 0x13dd48, 0xc8, 0x29 },
	{ 0x13dd49, 0x0, 0x4 },
	{ 0x13dd4a, 0x0, 0x24 },
	{ 0x13dd4b, 0x0, 0x19 },
	{ 0x13dd4c, 0x0, 0x54 },
	{ 0x13dd4d, 0xc7, 0x24 },
	{ 0x13dd4e, 0x45, 0x4 },
	{ 0x13dd4f, 0xcc, 0x58 },
	{ 0x13dd50, 0x0, 0x5a },
	{ 0x13dd51, 0x0, 0x89 },
	{ 0x13dd52, 0x0, 0x45 },
	{ 0x13dd53, 0x0, 0xd0 },
	{ 0x13dd54, 0xeb, 0x89 },
	{ 0x13dd55, 0xc, 0x55 },
	{ 0x13dd56, 0x8b, 0xd4 },
	{ 0x13dd57, 0x45, 0x83 },
	{ 0x13dd58, 0xd0, 0x7d },
	{ 0x13dd59, 0x89, 0xd4 },
	{ 0x13dd5a, 0x45, 0x0 },
	{ 0x13dd5b, 0xc8, 0x75 },
	{ 0x13dd5c, 0x8b, 0x8 },
	{ 0x13dd5d, 0x45, 0x83 },
	{ 0x13dd5e, 0xd4, 0x7d },
	{ 0x13dd5f, 0x89, 0xd0 },
	{ 0x13dd60, 0x45, 0x0 },
	{ 0x13dd61, 0xcc, 0x73 },
	{ 0x13dd62, 0x8b, 0x14 },
	{ 0x13dd63, 0x45, 0xeb },
	{ 0x13dd64, 0xc8, 0x2 },
	{ 0x13dd65, 0x89, 0x7d },
	{ 0x13dd66, 0x45, 0x10 },
	{ 0x13dd67, 0xe8, 0xc7 },
	{ 0x13dd68, 0x8b, 0x45 },
	{ 0x13dd69, 0x45, 0xc8 },
	{ 0x13dd6a, 0xcc, 0x0 },
	{ 0x13dd6b, 0x89, 0x0 },
	{ 0x13dd6c, 0x45, 0x0 },
	{ 0x13dd6d, 0xec, 0x0 },
	{ 0x13dd6e, 0x83, 0xc7 },
	{ 0x13dd6f, 0x7d, 0x45 },
	{ 0x13dd70, 0xec, 0xcc },
	{ 0x13dd72, 0x75, 0x0 },
	{ 0x13dd73, 0xb, 0x0 },
	{ 0x13dd74, 0x81, 0x0 },
	{ 0x13dd75, 0x7d, 0xeb },
	{ 0x13dd76, 0xe8, 0xc },
	{ 0x13dd77, 0x40, 0x8b },
	{ 0x13dd78, 0x42, 0x45 },
	{ 0x13dd79, 0xf, 0xd0 },
	{ 0x13dd7a, 0x0, 0x89 },
	{ 0x13dd7b, 0x73, 0x45 },
	{ 0x13dd7c, 0x12, 0xc8 },
	{ 0x13dd7d, 0xeb, 0x8b },
	{ 0x13dd7e, 0x2, 0x45 },
	{ 0x13dd7f, 0x7d, 0xd4 },
	{ 0x13dd80, 0xe, 0x89 },
	{ 0x13dd81, 0x8b, 0x45 },
	{ 0x13dd82, 0x45, 0xcc },
	{ 0x13dd83, 0xe8, 0x8b },
	{ 0x13dd84, 0x89, 0x45 },
	{ 0x13dd85, 0x45, 0xc8 },
	{ 0x13dd86, 0xc0, 0x89 },
	{ 0x13dd87, 0x8b, 0x45 },
	{ 0x13dd88, 0x45, 0xe8 },
	{ 0x13dd89, 0xec, 0x8b },
	{ 0x13dd8a, 0x89, 0x45 },
	{ 0x13dd8b, 0x45, 0xcc },
	{ 0x13dd8c, 0xc4, 0x89 },
	{ 0x13dd8d, 0xeb, 0x45 },
	{ 0x13dd8e, 0xe, 0xec },
	{ 0x13dd8f, 0xc7, 0x83 },
	{ 0x13dd90, 0x45, 0x7d },
	{ 0x13dd91, 0xc0, 0xec },
	{ 0x13dd92, 0x40, 0x0 },
	{ 0x13dd93, 0x42, 0x75 },
	{ 0x13dd94, 0xf, 0xb },
	{ 0x13dd95, 0x0, 0x81 },
	{ 0x13dd96, 0xc7, 0x7d },
	{ 0x13dd97, 0x45, 0xe8 },
	{ 0x13dd98, 0xc4, 0x40 },
	{ 0x13dd99, 0x0, 0x42 },
	{ 0x13dd9a, 0x0, 0xf },
	{ 0x13dd9c, 0x0, 0x73 },
	{ 0x13dd9d, 0x8b, 0x12 },
	{ 0x13dd9e, 0x45, 0xeb },
	{ 0x13dd9f, 0xc0, 0x2 },
	{ 0x13dda0, 0x89, 0x7d },
	{ 0x13dda1, 0x45, 0xe },
	{ 0x13dda2, 0xe8, 0x8b },
	{ 0x13dda3, 0x8b, 0x45 },
	{ 0x13dda4, 0x45, 0xe8 },
	{ 0x13dda5, 0xc4, 0x89 },
	{ 0x13dda6, 0x89, 0x45 },
	{ 0x13dda7, 0x45, 0xc0 },
	{ 0x13dda8, 0xec, 0x8b },
	{ 0x13dda9, 0xff, 0x45 },
	{ 0x13ddaa, 0x75, 0xec },
	{ 0x13ddab, 0xec, 0x89 },
	{ 0x13ddac, 0xff, 0x45 },
	{ 0x13ddad, 0x75, 0xc4 },
	{ 0x13ddae, 0xe8, 0xeb },
	{ 0x13ddaf, 0xe8, 0xe },
	{ 0x13ddb0, 0x98, 0xc7 },
	{ 0x13ddb1, 0xbc, 0x45 },
	{ 0x13ddb2, 0xf5, 0xc0 },
	{ 0x13ddb3, 0xff, 0x40 },
	{ 0x13ddb4, 0x8b, 0x42 },
	{ 0x13ddb5, 0x45, 0xf },
	{ 0x13ddb6, 0xf0, 0x0 },
	{ 0x13ddb7, 0x8b, 0xc7 },
	{ 0x13ddb8, 0x55, 0x45 },
	{ 0x13ddb9, 0xf4, 0xc4 },
	{ 0x13ddba, 0x3, 0x0 },
	{ 0x13ddbb, 0x45, 0x0 },
	{ 0x13ddbc, 0xe8, 0x0 },
	{ 0x13ddbd, 0x13, 0x0 },
	{ 0x13ddbe, 0x55, 0x8b },
	{ 0x13ddbf, 0xec, 0x45 },
	{ 0x13ddc0, 0x89, 0xc0 },
	{ 0x13ddc1, 0x45, 0x89 },
	{ 0x13ddc2, 0xf8, 0x45 },
	{ 0x13ddc3, 0x89, 0xe8 },
	{ 0x13ddc4, 0x55, 0x8b },
	{ 0x13ddc5, 0xfc, 0x45 },
	{ 0x13ddc6, 0x8b, 0xc4 },
	{ 0x13ddc7, 0x45, 0x89 },
	{ 0x13ddc8, 0xf8, 0x45 },
	{ 0x13ddc9, 0x8b, 0xec },
	{ 0x13ddca, 0x55, 0xff },
	{ 0x13ddcb, 0xfc, 0x75 },
	{ 0x13ddcc, 0x3b, 0xec },
	{ 0x13ddcd, 0x55, 0xff },
	{ 0x13ddce, 0xe4, 0x75 },
	{ 0x13ddcf, 0x75, 0xe8 },
	{ 0x13ddd0, 0x7, 0xe8 },
	{ 0x13ddd1, 0x3b, 0x77 },
	{ 0x13ddd2, 0x45, 0xbc },
	{ 0x13ddd3, 0xe0, 0xf5 },
	{ 0x13ddd4, 0x73, 0xff },
	{ 0x13ddd5, 0x10, 0x8b },
	{ 0x13ddd6, 0xeb, 0x45 },
	{ 0x13ddd7, 0x2, 0xf0 },
	{ 0x13ddd8, 0x7d, 0x8b },
	{ 0x13ddd9, 0xc, 0x55 },
	{ 0x13ddda, 0x8b, 0xf4 },
	{ 0x13dddb, 0x45, 0x3 },
	{ 0x13dddc, 0xf8, 0x45 },
	{ 0x13dddd, 0x89, 0xe8 },
	{ 0x13ddde, 0x45, 0x13 },
	{ 0x13dddf, 0xe0, 0x55 },
	{ 0x13dde0, 0x8b, 0xec },
	{ 0x13dde1, 0x45, 0x89 },
	{ 0x13dde2, 0xfc, 0x45 },
	{ 0x13dde3, 0x89, 0xf8 },
	{ 0x13dde4, 0x45, 0x89 },
	{ 0x13dde5, 0xe4, 0x55 },
	{ 0x13dde6, 0x6a, 0xfc },
	{ 0x13dde7, 0x0, 0x8b },
	{ 0x13dde8, 0x68, 0x45 },
	{ 0x13dde9, 0x40, 0xf8 },
	{ 0x13ddea, 0x42, 0x8b },
	{ 0x13ddeb, 0xf, 0x55 },
	{ 0x13ddec, 0x0, 0xfc },
	{ 0x13dded, 0x8b, 0x3b },
	{ 0x13ddee, 0x45, 0x55 },
	{ 0x13ddef, 0xf8, 0xe4 },
	{ 0x13ddf0, 0x8b, 0x75 },
	{ 0x13ddf1, 0x55, 0x7 },
	{ 0x13ddf2, 0xfc, 0x3b },
	{ 0x13ddf3, 0xe8, 0x45 },
	{ 0x13ddf4, 0x4, 0xe0 },
	{ 0x13ddf5, 0x80, 0x73 },
	{ 0x13ddf6, 0xec, 0x10 },
	{ 0x13ddf7, 0xff, 0xeb },
	{ 0x13ddf8, 0x52, 0x2 },
	{ 0x13ddf9, 0x50, 0x7d },
	{ 0x13ddfa, 0x6a, 0xc },
	{ 0x13ddfb, 0x0, 0x8b },
	{ 0x13ddfc, 0x68, 0x45 },
	{ 0x13ddfd, 0x40, 0xf8 },
	{ 0x13ddfe, 0x42, 0x89 },
	{ 0x13ddff, 0xf, 0x45 },
	{ 0x13de00, 0x0, 0xe0 },
	{ 0x13de03, 0xe0, 0xfc },
	{ 0x13de04, 0x8b, 0x89 },
	{ 0x13de05, 0x55, 0x45 },
	{ 0x13de07, 0xe8, 0x6a },
	{ 0x13de08, 0xf0, 0x0 },
	{ 0x13de09, 0x7f, 0x68 },
	{ 0x13de0a, 0xec, 0x40 },
	{ 0x13de0b, 0xff, 0x42 },
	{ 0x13de0c, 0x3b, 0xf },
	{ 0x13de0d, 0x54, 0x0 },
	{ 0x13de0e, 0x24, 0x8b },
	{ 0x13de0f, 0x4, 0x45 },
	{ 0x13de10, 0x75, 0xf8 },
	{ 0x13de11, 0x9, 0x8b },
	{ 0x13de12, 0x3b, 0x55 },
	{ 0x13de13, 0x4, 0xfc },
	{ 0x13de14, 0x24, 0xe8 },
	{ 0x13de15, 0x5a, 0xe3 },
	{ 0x13de16, 0x58, 0x7f },
	{ 0x13de17, 0x73, 0xec },
	{ 0x13de18, 0x21, 0xff },
	{ 0x13de19, 0xeb, 0x52 },
	{ 0x13de1a, 0x4, 0x50 },
	{ 0x13de1b, 0x5a, 0x6a },
	{ 0x13de1c, 0x58, 0x0 },
	{ 0x13de1d, 0x7d, 0x68 },
	{ 0x13de1e, 0x1b, 0x40 },
	{ 0x13de1f, 0xa1, 0x42 },
	{ 0x13de20, 0xd8, 0xf },
	{ 0x13de21, 0xf3, 0x0 },
	{ 0x13de22, 0x58, 0x8b },
	{ 0x13de23, 0x0, 0x45 },
	{ 0x13de24, 0x8b, 0xe0 },
	{ 0x13de25, 0x55, 0x8b },
	{ 0x13de26, 0xdc, 0x55 },
	{ 0x13de27, 0x89, 0xe4 },
	{ 0x13de28, 0x10, 0xe8 },
	{ 0x13de29, 0x33, 0xcf },
	{ 0x13de2a, 0xc0, 0x7f },
	{ 0x13de2b, 0x89, 0xec },
	{ 0x13de2c, 0x45, 0xff },
	{ 0x13de2d, 0xdc, 0x3b },
	{ 0x13de2e, 0x8b, 0x54 },
	{ 0x13de2f, 0x45, 0x24 },
	{ 0x13de30, 0xf8, 0x4 },
	{ 0x13de31, 0x89, 0x75 },
	{ 0x13de32, 0x45, 0x9 },
	{ 0x13de33, 0xe0, 0x3b },
	{ 0x13de34, 0x8b, 0x4 },
	{ 0x13de35, 0x45, 0x24 },
	{ 0x13de36, 0xfc, 0x5a },
	{ 0x13de37, 0x89, 0x58 },
	{ 0x13de38, 0x45, 0x73 },
	{ 0x13de39, 0xe4, 0x21 },
	{ 0x13de3a, 0xff, 0xeb },
	{ 0x13de3b, 0x45, 0x4 },
	{ 0x13de3c, 0xdc, 0x5a },
	{ 0x13de3d, 0xa1, 0x58 },
	{ 0x13de3e, 0x4, 0x7d },
	{ 0x13de3f, 0xf6, 0x1b },
	{ 0x13de40, 0x58, 0xa1 },
	{ 0x13de41, 0x0, 0xd8 },
	{ 0x13de42, 0x83, 0xf3 },
	{ 0x13de43, 0x38, 0x58 },
	{ 0x13de44, 0xff, 0x0 },
	{ 0x13de45, 0x75, 0x8b },
	{ 0x13de46, 0x14, 0x55 },
	{ 0x13de47, 0xa1, 0xdc },
	{ 0x13de48, 0x84, 0x89 },
	{ 0x13de49, 0xf9, 0x10 },
	{ 0x13de4a, 0x58, 0x33 },
	{ 0x13de4b, 0x0, 0xc0 },
	{ 0x13de4c, 0x80, 0x89 },
	{ 0x13de4d, 0x38, 0x45 },
	{ 0x13de4e, 0x0, 0xdc },
	{ 0x13de4f, 0x74, 0x8b },
	{ 0x13de50, 0xa, 0x45 },
	{ 0x13de51, 0xe8, 0xf8 },
	{ 0x13de52, 0xb2, 0x89 },
	{ 0x13de53, 0x3c, 0x45 },
	{ 0x13de54, 0xf6, 0xe0 },
	{ 0x13de55, 0xff, 0x8b },
	{ 0x13de56, 0xe8, 0x45 },
	{ 0x13de57, 0x8d, 0xfc },
	{ 0x13de58, 0x3c, 0x89 },
	{ 0x13de59, 0xf6, 0x45 },
	{ 0x13de5a, 0xff, 0xe4 },
	{-1,0,0}
};

PatchByte inputlagpatch_81_65[] = {
	{ 0x1d45eb, 0xe8, 0xa1 },
	{ 0x1d45ec, 0x0, 0x78 },
	{ 0x1d45ed, 0x8c, 0x9d },
	{ 0x1d45ee, 0xf5, 0x64 },
	{ 0x1d45ef, 0xff, 0x0 },
	{ 0x1d45f0, 0x89, 0x83 },
	{ 0x1d45f1, 0x45, 0x38 },
	{ 0x1d45f2, 0xf0, 0xff },
	{ 0x1d45f3, 0x89, 0x75 },
	{ 0x1d45f4, 0x55, 0x14 },
	{ 0x1d45f5, 0xf4, 0xa1 },
	{ 0x1d45f6, 0x8b, 0xb0 },
	{ 0x1d45f7, 0x45, 0xa1 },
	{ 0x1d45f8, 0xf0, 0x64 },
	{ 0x1d45f9, 0x8b, 0x0 },
	{ 0x1d45fa, 0x55, 0x80 },
	{ 0x1d45fb, 0xf4, 0x38 },
	{ 0x1d45fc, 0x3b, 0x0 },
	{ 0x1d45fd, 0x55, 0x74 },
	{ 0x1d45fe, 0xfc, 0xa },
	{ 0x1d45ff, 0x75, 0xe8 },
	{ 0x1d4600, 0x7, 0x8c },
	{ 0x1d4601, 0x3b, 0x12 },
	{ 0x1d4602, 0x45, 0xf6 },
	{ 0x1d4603, 0xf8, 0xff },
	{ 0x1d4604, 0x73, 0xe8 },
	{ 0x1d4605, 0x10, 0x67 },
	{ 0x1d4606, 0xeb, 0x12 },
	{ 0x1d4607, 0x2, 0xf6 },
	{ 0x1d4608, 0x7d, 0xff },
	{ 0x1d4609, 0xc, 0xe8 },
	{ 0x1d460a, 0x8b, 0xe2 },
	{ 0x1d460b, 0x45, 0x8b },
	{ 0x1d460c, 0xf0, 0xf5 },
	{ 0x1d460d, 0x89, 0xff },
	{ 0x1d460e, 0x45, 0x89 },
	{ 0x1d460f, 0xf8, 0x45 },
	{ 0x1d4610, 0x8b, 0xf0 },
	{ 0x1d4611, 0x45, 0x89 },
	{ 0x1d4612, 0xf4, 0x55 },
	{ 0x1d4613, 0x89, 0xf4 },
	{ 0x1d4614, 0x45, 0x8b },
	{ 0x1d4615, 0xfc, 0x45 },
	{ 0x1d4616, 0xa1, 0xf0 },
	{ 0x1d4617, 0x18, 0x8b },
	{ 0x1d4618, 0xa3, 0x55 },
	{ 0x1d4619, 0x64, 0xf4 },
	{ 0x1d461a, 0x0, 0x3b },
	{ 0x1d461b, 0x8b, 0x55 },
	{ 0x1d461c, 0x0, 0xfc },
	{ 0x1d461d, 0x83, 0x75 },
	{ 0x1d461e, 0x78, 0x7 },
	{ 0x1d461f, 0x8, 0x3b },
	{ 0x1d4620, 0x0, 0x45 },
	{ 0x1d4621, 0x7f, 0xf8 },
	{ 0x1d4622, 0xe, 0x73 },
	{ 0x1d4623, 0xa1, 0x10 },
	{ 0x1d4624, 0x18, 0xeb },
	{ 0x1d4625, 0xa3, 0x2 },
	{ 0x1d4626, 0x64, 0x7d },
	{ 0x1d4627, 0x0, 0xc },
	{ 0x1d4629, 0x0, 0x45 },
	{ 0x1d462a, 0xc7, 0xf0 },
	{ 0x1d462b, 0x40, 0x89 },
	{ 0x1d462c, 0x8, 0x45 },
	{ 0x1d462d, 0x1, 0xf8 },
	{ 0x1d462e, 0x0, 0x8b },
	{ 0x1d462f, 0x0, 0x45 },
	{ 0x1d4630, 0x0, 0xf4 },
	{ 0x1d4631, 0xa1, 0x89 },
	{ 0x1d4632, 0x18, 0x45 },
	{ 0x1d4633, 0xa3, 0xfc },
	{ 0x1d4634, 0x64, 0xa1 },
	{ 0x1d4635, 0x0, 0x18 },
	{ 0x1d4636, 0x8b, 0xa3 },
	{ 0x1d4637, 0x0, 0x64 },
	{ 0x1d4638, 0xff, 0x0 },
	{ 0x1d4639, 0x70, 0x8b },
	{ 0x1d463a, 0x8, 0x0 },
	{ 0x1d463b, 0xb8, 0x83 },
	{ 0x1d463c, 0x40, 0x78 },
	{ 0x1d463d, 0x42, 0x8 },
	{ 0x1d463e, 0xf, 0x0 },
	{ 0x1d463f, 0x0, 0x7f },
	{ 0x1d4640, 0x5a, 0xe },
	{ 0x1d4641, 0x8b, 0xa1 },
	{ 0x1d4642, 0xca, 0x18 },
	{ 0x1d4643, 0x99, 0xa3 },
	{ 0x1d4644, 0xf7, 0x64 },
	{ 0x1d4645, 0xf9, 0x0 },
	{ 0x1d4646, 0x99, 0x8b },
	{ 0x1d4647, 0x52, 0x0 },
	{ 0x1d4648, 0x50, 0xc7 },
	{ 0x1d4649, 0x8b, 0x40 },
	{ 0x1d464a, 0x45, 0x8 },
	{ 0x1d464b, 0xf0, 0x1 },
	{ 0x1d464c, 0x8b, 0x0 },
	{ 0x1d464d, 0x55, 0x0 },
	{ 0x1d464e, 0xf4, 0x0 },
	{ 0x1d464f, 0x2b, 0xa1 },
	{ 0x1d4650, 0x45, 0x18 },
	{ 0x1d4651, 0xf8, 0xa3 },
	{ 0x1d4652, 0x1b, 0x64 },
	{ 0x1d4653, 0x55, 0x0 },
	{ 0x1d4654, 0xfc, 0x8b },
	{ 0x1d4655, 0x29, 0x0 },
	{ 0x1d4656, 0x4, 0xff },
	{ 0x1d4657, 0x24, 0x70 },
	{ 0x1d4658, 0x19, 0x8 },
	{ 0x1d4659, 0x54, 0xb8 },
	{ 0x1d465a, 0x24, 0x40 },
	{ 0x1d465b, 0x4, 0x42 },
	{ 0x1d465c, 0x58, 0xf },
	{ 0x1d465d, 0x5a, 0x0 },
	{ 0x1d465e, 0x89, 0x5a },
	{ 0x1d465f, 0x45, 0x8b },
	{ 0x1d4660, 0xd0, 0xca },
	{ 0x1d4661, 0x89, 0x99 },
	{ 0x1d4662, 0x55, 0xf7 },
	{ 0x1d4663, 0xd4, 0xf9 },
	{ 0x1d4664, 0x83, 0x99 },
	{ 0x1d4665, 0x7d, 0x52 },
	{ 0x1d4666, 0xd4, 0x50 },
	{ 0x1d4667, 0x0, 0x8b },
	{ 0x1d4668, 0x75, 0x45 },
	{ 0x1d4669, 0x8, 0xf0 },
	{ 0x1d466a, 0x83, 0x8b },
	{ 0x1d466b, 0x7d, 0x55 },
	{ 0x1d466c, 0xd0, 0xf4 },
	{ 0x1d466d, 0x0, 0x2b },
	{ 0x1d466e, 0x73, 0x45 },
	{ 0x1d466f, 0x14, 0xf8 },
	{ 0x1d4670, 0xeb, 0x1b },
	{ 0x1d4671, 0x2, 0x55 },
	{ 0x1d4672, 0x7d, 0xfc },
	{ 0x1d4673, 0x10, 0x29 },
	{ 0x1d4674, 0xc7, 0x4 },
	{ 0x1d4675, 0x45, 0x24 },
	{ 0x1d4676, 0xc8, 0x19 },
	{ 0x1d4677, 0x0, 0x54 },
	{ 0x1d4678, 0x0, 0x24 },
	{ 0x1d4679, 0x0, 0x4 },
	{ 0x1d467a, 0x0, 0x58 },
	{ 0x1d467b, 0xc7, 0x5a },
	{ 0x1d467c, 0x45, 0x89 },
	{ 0x1d467d, 0xcc, 0x45 },
	{ 0x1d467e, 0x0, 0xd0 },
	{ 0x1d467f, 0x0, 0x89 },
	{ 0x1d4680, 0x0, 0x55 },
	{ 0x1d4681, 0x0, 0xd4 },
	{ 0x1d4682, 0xeb, 0x83 },
	{ 0x1d4683, 0xc, 0x7d },
	{ 0x1d4684, 0x8b, 0xd4 },
	{ 0x1d4685, 0x45, 0x0 },
	{ 0x1d4686, 0xd0, 0x75 },
	{ 0x1d4687, 0x89, 0x8 },
	{ 0x1d4688, 0x45, 0x83 },
	{ 0x1d4689, 0xc8, 0x7d },
	{ 0x1d468a, 0x8b, 0xd0 },
	{ 0x1d468b, 0x45, 0x0 },
	{ 0x1d468c, 0xd4, 0x73 },
	{ 0x1d468d, 0x89, 0x14 },
	{ 0x1d468e, 0x45, 0xeb },
	{ 0x1d468f, 0xcc, 0x2 },
	{ 0x1d4690, 0x8b, 0x7d },
	{ 0x1d4691, 0x45, 0x10 },
	{ 0x1d4692, 0xc8, 0xc7 },
	{ 0x1d4693, 0x89, 0x45 },
	{ 0x1d4694, 0x45, 0xc8 },
	{ 0x1d4695, 0xe8, 0x0 },
	{ 0x1d4696, 0x8b, 0x0 },
	{ 0x1d4697, 0x45, 0x0 },
	{ 0x1d4698, 0xcc, 0x0 },
	{ 0x1d4699, 0x89, 0xc7 },
	{ 0x1d469b, 0xec, 0xcc },
	{ 0x1d469c, 0x83, 0x0 },
	{ 0x1d469d, 0x7d, 0x0 },
	{ 0x1d469e, 0xec, 0x0 },
	{ 0x1d46a0, 0x75, 0xeb },
	{ 0x1d46a1, 0xb, 0xc },
	{ 0x1d46a2, 0x81, 0x8b },
	{ 0x1d46a3, 0x7d, 0x45 },
	{ 0x1d46a4, 0xe8, 0xd0 },
	{ 0x1d46a5, 0x40, 0x89 },
	{ 0x1d46a6, 0x42, 0x45 },
	{ 0x1d46a7, 0xf, 0xc8 },
	{ 0x1d46a8, 0x0, 0x8b },
	{ 0x1d46a9, 0x73, 0x45 },
	{ 0x1d46aa, 0x12, 0xd4 },
	{ 0x1d46ab, 0xeb, 0x89 },
	{ 0x1d46ac, 0x2, 0x45 },
	{ 0x1d46ad, 0x7d, 0xcc },
	{ 0x1d46ae, 0xe, 0x8b },
	{ 0x1d46af, 0x8b, 0x45 },
	{ 0x1d46b0, 0x45, 0xc8 },
	{ 0x1d46b1, 0xe8, 0x89 },
	{ 0x1d46b2, 0x89, 0x45 },
	{ 0x1d46b3, 0x45, 0xe8 },
	{ 0x1d46b4, 0xc0, 0x8b },
	{ 0x1d46b5, 0x8b, 0x45 },
	{ 0x1d46b6, 0x45, 0xcc },
	{ 0x1d46b7, 0xec, 0x89 },
	{ 0x1d46b8, 0x89, 0x45 },
	{ 0x1d46b9, 0x45, 0xec },
	{ 0x1d46ba, 0xc4, 0x83 },
	{ 0x1d46bb, 0xeb, 0x7d },
	{ 0x1d46bc, 0xe, 0xec },
	{ 0x1d46bd, 0xc7, 0x0 },
	{ 0x1d46be, 0x45, 0x75 },
	{ 0x1d46bf, 0xc0, 0xb },
	{ 0x1d46c0, 0x40, 0x81 },
	{ 0x1d46c1, 0x42, 0x7d },
	{ 0x1d46c2, 0xf, 0xe8 },
	{ 0x1d46c3, 0x0, 0x40 },
	{ 0x1d46c4, 0xc7, 0x42 },
	{ 0x1d46c5, 0x45, 0xf },
	{ 0x1d46c6, 0xc4, 0x0 },
	{ 0x1d46c7, 0x0, 0x73 },
	{ 0x1d46c8, 0x0, 0x12 },
	{ 0x1d46c9, 0x0, 0xeb },
	{ 0x1d46ca, 0x0, 0x2 },
	{ 0x1d46cb, 0x8b, 0x7d },
	{ 0x1d46cc, 0x45, 0xe },
	{ 0x1d46cd, 0xc0, 0x8b },
	{ 0x1d46ce, 0x89, 0x45 },
	{ 0x1d46cf, 0x45, 0xe8 },
	{ 0x1d46d0, 0xe8, 0x89 },
	{ 0x1d46d1, 0x8b, 0x45 },
	{ 0x1d46d2, 0x45, 0xc0 },
	{ 0x1d46d3, 0xc4, 0x8b },
	{ 0x1d46d4, 0x89, 0x45 },
	{ 0x1d46d5, 0x45, 0xec },
	{ 0x1d46d6, 0xec, 0x89 },
	{ 0x1d46d7, 0xff, 0x45 },
	{ 0x1d46d8, 0x75, 0xc4 },
	{ 0x1d46d9, 0xec, 0xeb },
	{ 0x1d46da, 0xff, 0xe },
	{ 0x1d46db, 0x75, 0xc7 },
	{ 0x1d46dc, 0xe8, 0x45 },
	{ 0x1d46dd, 0xe8, 0xc0 },
	{ 0x1d46de, 0x9a, 0x40 },
	{ 0x1d46df, 0x8b, 0x42 },
	{ 0x1d46e0, 0xf5, 0xf },
	{ 0x1d46e1, 0xff, 0x0 },
	{ 0x1d46e2, 0x8b, 0xc7 },
	{ 0x1d46e4, 0xf0, 0xc4 },
	{ 0x1d46e5, 0x8b, 0x0 },
	{ 0x1d46e6, 0x55, 0x0 },
	{ 0x1d46e7, 0xf4, 0x0 },
	{ 0x1d46e8, 0x3, 0x0 },
	{ 0x1d46e9, 0x45, 0x8b },
	{ 0x1d46ea, 0xe8, 0x45 },
	{ 0x1d46eb, 0x13, 0xc0 },
	{ 0x1d46ec, 0x55, 0x89 },
	{ 0x1d46ed, 0xec, 0x45 },
	{ 0x1d46ee, 0x89, 0xe8 },
	{ 0x1d46ef, 0x45, 0x8b },
	{ 0x1d46f0, 0xf8, 0x45 },
	{ 0x1d46f1, 0x89, 0xc4 },
	{ 0x1d46f2, 0x55, 0x89 },
	{ 0x1d46f3, 0xfc, 0x45 },
	{ 0x1d46f4, 0x8b, 0xec },
	{ 0x1d46f5, 0x45, 0xff },
	{ 0x1d46f6, 0xf8, 0x75 },
	{ 0x1d46f7, 0x8b, 0xec },
	{ 0x1d46f8, 0x55, 0xff },
	{ 0x1d46f9, 0xfc, 0x75 },
	{ 0x1d46fa, 0x3b, 0xe8 },
	{ 0x1d46fb, 0x55, 0xe8 },
	{ 0x1d46fc, 0xe4, 0x7c },
	{ 0x1d46fd, 0x75, 0x8b },
	{ 0x1d46fe, 0x7, 0xf5 },
	{ 0x1d46ff, 0x3b, 0xff },
	{ 0x1d4700, 0x45, 0x8b },
	{ 0x1d4701, 0xe0, 0x45 },
	{ 0x1d4702, 0x73, 0xf0 },
	{ 0x1d4703, 0x10, 0x8b },
	{ 0x1d4704, 0xeb, 0x55 },
	{ 0x1d4705, 0x2, 0xf4 },
	{ 0x1d4706, 0x7d, 0x3 },
	{ 0x1d4707, 0xc, 0x45 },
	{ 0x1d4708, 0x8b, 0xe8 },
	{ 0x1d4709, 0x45, 0x13 },
	{ 0x1d470a, 0xf8, 0x55 },
	{ 0x1d470b, 0x89, 0xec },
	{ 0x1d470c, 0x45, 0x89 },
	{ 0x1d470d, 0xe0, 0x45 },
	{ 0x1d470e, 0x8b, 0xf8 },
	{ 0x1d470f, 0x45, 0x89 },
	{ 0x1d4710, 0xfc, 0x55 },
	{ 0x1d4711, 0x89, 0xfc },
	{ 0x1d4712, 0x45, 0x8b },
	{ 0x1d4713, 0xe4, 0x45 },
	{ 0x1d4714, 0x6a, 0xf8 },
	{ 0x1d4715, 0x0, 0x8b },
	{ 0x1d4716, 0x68, 0x55 },
	{ 0x1d4717, 0x40, 0xfc },
	{ 0x1d4718, 0x42, 0x3b },
	{ 0x1d4719, 0xf, 0x55 },
	{ 0x1d471a, 0x0, 0xe4 },
	{ 0x1d471b, 0x8b, 0x75 },
	{ 0x1d471c, 0x45, 0x7 },
	{ 0x1d471d, 0xf8, 0x3b },
	{ 0x1d471e, 0x8b, 0x45 },
	{ 0x1d471f, 0x55, 0xe0 },
	{ 0x1d4720, 0xfc, 0x73 },
	{ 0x1d4721, 0xe8, 0x10 },
	{ 0x1d4722, 0x2a, 0xeb },
	{ 0x1d4723, 0x40, 0x2 },
	{ 0x1d4724, 0xe3, 0x7d },
	{ 0x1d4725, 0xff, 0xc },
	{ 0x1d4726, 0x52, 0x8b },
	{ 0x1d4727, 0x50, 0x45 },
	{ 0x1d4728, 0x6a, 0xf8 },
	{ 0x1d4729, 0x0, 0x89 },
	{ 0x1d472a, 0x68, 0x45 },
	{ 0x1d472b, 0x40, 0xe0 },
	{ 0x1d472c, 0x42, 0x8b },
	{ 0x1d472d, 0xf, 0x45 },
	{ 0x1d472e, 0x0, 0xfc },
	{ 0x1d472f, 0x8b, 0x89 },
	{ 0x1d4731, 0xe0, 0xe4 },
	{ 0x1d4732, 0x8b, 0x6a },
	{ 0x1d4733, 0x55, 0x0 },
	{ 0x1d4734, 0xe4, 0x68 },
	{ 0x1d4735, 0xe8, 0x40 },
	{ 0x1d4736, 0x16, 0x42 },
	{ 0x1d4737, 0x40, 0xf },
	{ 0x1d4738, 0xe3, 0x0 },
	{ 0x1d4739, 0xff, 0x8b },
	{ 0x1d473a, 0x3b, 0x45 },
	{ 0x1d473b, 0x54, 0xf8 },
	{ 0x1d473c, 0x24, 0x8b },
	{ 0x1d473d, 0x4, 0x55 },
	{ 0x1d473e, 0x75, 0xfc },
	{ 0x1d473f, 0x9, 0xe8 },
	{ 0x1d4740, 0x3b, 0xc },
	{ 0x1d4741, 0x4, 0x40 },
	{ 0x1d4742, 0x24, 0xe3 },
	{ 0x1d4743, 0x5a, 0xff },
	{ 0x1d4744, 0x58, 0x52 },
	{ 0x1d4745, 0x73, 0x50 },
	{ 0x1d4746, 0x21, 0x6a },
	{ 0x1d4747, 0xeb, 0x0 },
	{ 0x1d4748, 0x4, 0x68 },
	{ 0x1d4749, 0x5a, 0x40 },
	{ 0x1d474a, 0x58, 0x42 },
	{ 0x1d474b, 0x7d, 0xf },
	{ 0x1d474c, 0x1b, 0x0 },
	{ 0x1d474d, 0xa1, 0x8b },
	{ 0x1d474e, 0x10, 0x45 },
	{ 0x1d474f, 0x9b, 0xe0 },
	{ 0x1d4750, 0x64, 0x8b },
	{ 0x1d4751, 0x0, 0x55 },
	{ 0x1d4752, 0x8b, 0xe4 },
	{ 0x1d4753, 0x55, 0xe8 },
	{ 0x1d4754, 0xdc, 0xf8 },
	{ 0x1d4755, 0x89, 0x3f },
	{ 0x1d4756, 0x10, 0xe3 },
	{ 0x1d4757, 0x33, 0xff },
	{ 0x1d4758, 0xc0, 0x3b },
	{ 0x1d4759, 0x89, 0x54 },
	{ 0x1d475a, 0x45, 0x24 },
	{ 0x1d475b, 0xdc, 0x4 },
	{ 0x1d475c, 0x8b, 0x75 },
	{ 0x1d475d, 0x45, 0x9 },
	{ 0x1d475e, 0xf8, 0x3b },
	{ 0x1d475f, 0x89, 0x4 },
	{ 0x1d4760, 0x45, 0x24 },
	{ 0x1d4761, 0xe0, 0x5a },
	{ 0x1d4762, 0x8b, 0x58 },
	{ 0x1d4763, 0x45, 0x73 },
	{ 0x1d4764, 0xfc, 0x21 },
	{ 0x1d4765, 0x89, 0xeb },
	{ 0x1d4766, 0x45, 0x4 },
	{ 0x1d4767, 0xe4, 0x5a },
	{ 0x1d4768, 0xff, 0x58 },
	{ 0x1d4769, 0x45, 0x7d },
	{ 0x1d476a, 0xdc, 0x1b },
	{ 0x1d476c, 0x78, 0x10 },
	{ 0x1d476d, 0x9d, 0x9b },
	{ 0x1d4770, 0x83, 0x8b },
	{ 0x1d4771, 0x38, 0x55 },
	{ 0x1d4772, 0xff, 0xdc },
	{ 0x1d4773, 0x75, 0x89 },
	{ 0x1d4774, 0x14, 0x10 },
	{ 0x1d4775, 0xa1, 0x33 },
	{ 0x1d4776, 0xb0, 0xc0 },
	{ 0x1d4777, 0xa1, 0x89 },
	{ 0x1d4778, 0x64, 0x45 },
	{ 0x1d4779, 0x0, 0xdc },
	{ 0x1d477a, 0x80, 0x8b },
	{ 0x1d477b, 0x38, 0x45 },
	{ 0x1d477c, 0x0, 0xf8 },
	{ 0x1d477d, 0x74, 0x89 },
	{ 0x1d477e, 0xa, 0x45 },
	{ 0x1d477f, 0xe8, 0xe0 },
	{ 0x1d4780, 0xc, 0x8b },
	{ 0x1d4781, 0x11, 0x45 },
	{ 0x1d4782, 0xf6, 0xfc },
	{ 0x1d4783, 0xff, 0x89 },
	{ 0x1d4784, 0xe8, 0x45 },
	{ 0x1d4785, 0xe7, 0xe4 },
	{ 0x1d4786, 0x10, 0xff },
	{ 0x1d4787, 0xf6, 0x45 },
	{ 0x1d4788, 0xff, 0xdc },
	{-1,0,0}
};

PatchByte inputlagpatch_81_71[] = {
	{ 0x1d4733, 0xe8, 0xa1 },
	{ 0x1d4734, 0xb8, 0x80 },
	{ 0x1d4735, 0x8a, 0x9d },
	{ 0x1d4736, 0xf5, 0x64 },
	{ 0x1d4737, 0xff, 0x0 },
	{ 0x1d4738, 0x89, 0x83 },
	{ 0x1d4739, 0x45, 0x38 },
	{ 0x1d473a, 0xf0, 0xff },
	{ 0x1d473b, 0x89, 0x75 },
	{ 0x1d473c, 0x55, 0x14 },
	{ 0x1d473d, 0xf4, 0xa1 },
	{ 0x1d473e, 0x8b, 0xb8 },
	{ 0x1d473f, 0x45, 0xa1 },
	{ 0x1d4740, 0xf0, 0x64 },
	{ 0x1d4741, 0x8b, 0x0 },
	{ 0x1d4742, 0x55, 0x80 },
	{ 0x1d4743, 0xf4, 0x38 },
	{ 0x1d4744, 0x3b, 0x0 },
	{ 0x1d4745, 0x55, 0x74 },
	{ 0x1d4746, 0xfc, 0xa },
	{ 0x1d4747, 0x75, 0xe8 },
	{ 0x1d4748, 0x7, 0x44 },
	{ 0x1d4749, 0x3b, 0x11 },
	{ 0x1d474a, 0x45, 0xf6 },
	{ 0x1d474b, 0xf8, 0xff },
	{ 0x1d474c, 0x73, 0xe8 },
	{ 0x1d474d, 0x10, 0x1f },
	{ 0x1d474e, 0xeb, 0x11 },
	{ 0x1d474f, 0x2, 0xf6 },
	{ 0x1d4750, 0x7d, 0xff },
	{ 0x1d4751, 0xc, 0xe8 },
	{ 0x1d4752, 0x8b, 0x9a },
	{ 0x1d4753, 0x45, 0x8a },
	{ 0x1d4754, 0xf0, 0xf5 },
	{ 0x1d4755, 0x89, 0xff },
	{ 0x1d4756, 0x45, 0x89 },
	{ 0x1d4757, 0xf8, 0x45 },
	{ 0x1d4758, 0x8b, 0xf0 },
	{ 0x1d4759, 0x45, 0x89 },
	{ 0x1d475a, 0xf4, 0x55 },
	{ 0x1d475b, 0x89, 0xf4 },
	{ 0x1d475c, 0x45, 0x8b },
	{ 0x1d475d, 0xfc, 0x45 },
	{ 0x1d475e, 0xa1, 0xf0 },
	{ 0x1d475f, 0x24, 0x8b },
	{ 0x1d4760, 0xa3, 0x55 },
	{ 0x1d4761, 0x64, 0xf4 },
	{ 0x1d4762, 0x0, 0x3b },
	{ 0x1d4763, 0x8b, 0x55 },
	{ 0x1d4764, 0x0, 0xfc },
	{ 0x1d4765, 0x83, 0x75 },
	{ 0x1d4766, 0x78, 0x7 },
	{ 0x1d4767, 0x8, 0x3b },
	{ 0x1d4768, 0x0, 0x45 },
	{ 0x1d4769, 0x7f, 0xf8 },
	{ 0x1d476a, 0xe, 0x73 },
	{ 0x1d476b, 0xa1, 0x10 },
	{ 0x1d476c, 0x24, 0xeb },
	{ 0x1d476d, 0xa3, 0x2 },
	{ 0x1d476e, 0x64, 0x7d },
	{ 0x1d476f, 0x0, 0xc },
	{ 0x1d4771, 0x0, 0x45 },
	{ 0x1d4772, 0xc7, 0xf0 },
	{ 0x1d4773, 0x40, 0x89 },
	{ 0x1d4774, 0x8, 0x45 },
	{ 0x1d4775, 0x1, 0xf8 },
	{ 0x1d4776, 0x0, 0x8b },
	{ 0x1d4777, 0x0, 0x45 },
	{ 0x1d4778, 0x0, 0xf4 },
	{ 0x1d4779, 0xa1, 0x89 },
	{ 0x1d477a, 0x24, 0x45 },
	{ 0x1d477b, 0xa3, 0xfc },
	{ 0x1d477c, 0x64, 0xa1 },
	{ 0x1d477d, 0x0, 0x24 },
	{ 0x1d477e, 0x8b, 0xa3 },
	{ 0x1d477f, 0x0, 0x64 },
	{ 0x1d4780, 0xff, 0x0 },
	{ 0x1d4781, 0x70, 0x8b },
	{ 0x1d4782, 0x8, 0x0 },
	{ 0x1d4783, 0xb8, 0x83 },
	{ 0x1d4784, 0x40, 0x78 },
	{ 0x1d4785, 0x42, 0x8 },
	{ 0x1d4786, 0xf, 0x0 },
	{ 0x1d4787, 0x0, 0x7f },
	{ 0x1d4788, 0x5a, 0xe },
	{ 0x1d4789, 0x8b, 0xa1 },
	{ 0x1d478a, 0xca, 0x24 },
	{ 0x1d478b, 0x99, 0xa3 },
	{ 0x1d478c, 0xf7, 0x64 },
	{ 0x1d478d, 0xf9, 0x0 },
	{ 0x1d478e, 0x99, 0x8b },
	{ 0x1d478f, 0x52, 0x0 },
	{ 0x1d4790, 0x50, 0xc7 },
	{ 0x1d4791, 0x8b, 0x40 },
	{ 0x1d4792, 0x45, 0x8 },
	{ 0x1d4793, 0xf0, 0x1 },
	{ 0x1d4794, 0x8b, 0x0 },
	{ 0x1d4795, 0x55, 0x0 },
	{ 0x1d4796, 0xf4, 0x0 },
	{ 0x1d4797, 0x2b, 0xa1 },
	{ 0x1d4798, 0x45, 0x24 },
	{ 0x1d4799, 0xf8, 0xa3 },
	{ 0x1d479a, 0x1b, 0x64 },
	{ 0x1d479b, 0x55, 0x0 },
	{ 0x1d479c, 0xfc, 0x8b },
	{ 0x1d479d, 0x29, 0x0 },
	{ 0x1d479e, 0x4, 0xff },
	{ 0x1d479f, 0x24, 0x70 },
	{ 0x1d47a0, 0x19, 0x8 },
	{ 0x1d47a1, 0x54, 0xb8 },
	{ 0x1d47a2, 0x24, 0x40 },
	{ 0x1d47a3, 0x4, 0x42 },
	{ 0x1d47a4, 0x58, 0xf },
	{ 0x1d47a5, 0x5a, 0x0 },
	{ 0x1d47a6, 0x89, 0x5a },
	{ 0x1d47a7, 0x45, 0x8b },
	{ 0x1d47a8, 0xd0, 0xca },
	{ 0x1d47a9, 0x89, 0x99 },
	{ 0x1d47aa, 0x55, 0xf7 },
	{ 0x1d47ab, 0xd4, 0xf9 },
	{ 0x1d47ac, 0x83, 0x99 },
	{ 0x1d47ad, 0x7d, 0x52 },
	{ 0x1d47ae, 0xd4, 0x50 },
	{ 0x1d47af, 0x0, 0x8b },
	{ 0x1d47b0, 0x75, 0x45 },
	{ 0x1d47b1, 0x8, 0xf0 },
	{ 0x1d47b2, 0x83, 0x8b },
	{ 0x1d47b3, 0x7d, 0x55 },
	{ 0x1d47b4, 0xd0, 0xf4 },
	{ 0x1d47b5, 0x0, 0x2b },
	{ 0x1d47b6, 0x73, 0x45 },
	{ 0x1d47b7, 0x14, 0xf8 },
	{ 0x1d47b8, 0xeb, 0x1b },
	{ 0x1d47b9, 0x2, 0x55 },
	{ 0x1d47ba, 0x7d, 0xfc },
	{ 0x1d47bb, 0x10, 0x29 },
	{ 0x1d47bc, 0xc7, 0x4 },
	{ 0x1d47bd, 0x45, 0x24 },
	{ 0x1d47be, 0xc8, 0x19 },
	{ 0x1d47bf, 0x0, 0x54 },
	{ 0x1d47c0, 0x0, 0x24 },
	{ 0x1d47c1, 0x0, 0x4 },
	{ 0x1d47c2, 0x0, 0x58 },
	{ 0x1d47c3, 0xc7, 0x5a },
	{ 0x1d47c4, 0x45, 0x89 },
	{ 0x1d47c5, 0xcc, 0x45 },
	{ 0x1d47c6, 0x0, 0xd0 },
	{ 0x1d47c7, 0x0, 0x89 },
	{ 0x1d47c8, 0x0, 0x55 },
	{ 0x1d47c9, 0x0, 0xd4 },
	{ 0x1d47ca, 0xeb, 0x83 },
	{ 0x1d47cb, 0xc, 0x7d },
	{ 0x1d47cc, 0x8b, 0xd4 },
	{ 0x1d47cd, 0x45, 0x0 },
	{ 0x1d47ce, 0xd0, 0x75 },
	{ 0x1d47cf, 0x89, 0x8 },
	{ 0x1d47d0, 0x45, 0x83 },
	{ 0x1d47d1, 0xc8, 0x7d },
	{ 0x1d47d2, 0x8b, 0xd0 },
	{ 0x1d47d3, 0x45, 0x0 },
	{ 0x1d47d4, 0xd4, 0x73 },
	{ 0x1d47d5, 0x89, 0x14 },
	{ 0x1d47d6, 0x45, 0xeb },
	{ 0x1d47d7, 0xcc, 0x2 },
	{ 0x1d47d8, 0x8b, 0x7d },
	{ 0x1d47d9, 0x45, 0x10 },
	{ 0x1d47da, 0xc8, 0xc7 },
	{ 0x1d47db, 0x89, 0x45 },
	{ 0x1d47dc, 0x45, 0xc8 },
	{ 0x1d47dd, 0xe8, 0x0 },
	{ 0x1d47de, 0x8b, 0x0 },
	{ 0x1d47df, 0x45, 0x0 },
	{ 0x1d47e0, 0xcc, 0x0 },
	{ 0x1d47e1, 0x89, 0xc7 },
	{ 0x1d47e3, 0xec, 0xcc },
	{ 0x1d47e4, 0x83, 0x0 },
	{ 0x1d47e5, 0x7d, 0x0 },
	{ 0x1d47e6, 0xec, 0x0 },
	{ 0x1d47e8, 0x75, 0xeb },
	{ 0x1d47e9, 0xb, 0xc },
	{ 0x1d47ea, 0x81, 0x8b },
	{ 0x1d47eb, 0x7d, 0x45 },
	{ 0x1d47ec, 0xe8, 0xd0 },
	{ 0x1d47ed, 0x40, 0x89 },
	{ 0x1d47ee, 0x42, 0x45 },
	{ 0x1d47ef, 0xf, 0xc8 },
	{ 0x1d47f0, 0x0, 0x8b },
	{ 0x1d47f1, 0x73, 0x45 },
	{ 0x1d47f2, 0x12, 0xd4 },
	{ 0x1d47f3, 0xeb, 0x89 },
	{ 0x1d47f4, 0x2, 0x45 },
	{ 0x1d47f5, 0x7d, 0xcc },
	{ 0x1d47f6, 0xe, 0x8b },
	{ 0x1d47f7, 0x8b, 0x45 },
	{ 0x1d47f8, 0x45, 0xc8 },
	{ 0x1d47f9, 0xe8, 0x89 },
	{ 0x1d47fa, 0x89, 0x45 },
	{ 0x1d47fb, 0x45, 0xe8 },
	{ 0x1d47fc, 0xc0, 0x8b },
	{ 0x1d47fd, 0x8b, 0x45 },
	{ 0x1d47fe, 0x45, 0xcc },
	{ 0x1d47ff, 0xec, 0x89 },
	{ 0x1d4800, 0x89, 0x45 },
	{ 0x1d4801, 0x45, 0xec },
	{ 0x1d4802, 0xc4, 0x83 },
	{ 0x1d4803, 0xeb, 0x7d },
	{ 0x1d4804, 0xe, 0xec },
	{ 0x1d4805, 0xc7, 0x0 },
	{ 0x1d4806, 0x45, 0x75 },
	{ 0x1d4807, 0xc0, 0xb },
	{ 0x1d4808, 0x40, 0x81 },
	{ 0x1d4809, 0x42, 0x7d },
	{ 0x1d480a, 0xf, 0xe8 },
	{ 0x1d480b, 0x0, 0x40 },
	{ 0x1d480c, 0xc7, 0x42 },
	{ 0x1d480d, 0x45, 0xf },
	{ 0x1d480e, 0xc4, 0x0 },
	{ 0x1d480f, 0x0, 0x73 },
	{ 0x1d4810, 0x0, 0x12 },
	{ 0x1d4811, 0x0, 0xeb },
	{ 0x1d4812, 0x0, 0x2 },
	{ 0x1d4813, 0x8b, 0x7d },
	{ 0x1d4814, 0x45, 0xe },
	{ 0x1d4815, 0xc0, 0x8b },
	{ 0x1d4816, 0x89, 0x45 },
	{ 0x1d4817, 0x45, 0xe8 },
	{ 0x1d4818, 0xe8, 0x89 },
	{ 0x1d4819, 0x8b, 0x45 },
	{ 0x1d481a, 0x45, 0xc0 },
	{ 0x1d481b, 0xc4, 0x8b },
	{ 0x1d481c, 0x89, 0x45 },
	{ 0x1d481d, 0x45, 0xec },
	{ 0x1d481e, 0xec, 0x89 },
	{ 0x1d481f, 0xff, 0x45 },
	{ 0x1d4820, 0x75, 0xc4 },
	{ 0x1d4821, 0xec, 0xeb },
	{ 0x1d4822, 0xff, 0xe },
	{ 0x1d4823, 0x75, 0xc7 },
	{ 0x1d4824, 0xe8, 0x45 },
	{ 0x1d4825, 0xe8, 0xc0 },
	{ 0x1d4826, 0x52, 0x40 },
	{ 0x1d4827, 0x8a, 0x42 },
	{ 0x1d4828, 0xf5, 0xf },
	{ 0x1d4829, 0xff, 0x0 },
	{ 0x1d482a, 0x8b, 0xc7 },
	{ 0x1d482c, 0xf0, 0xc4 },
	{ 0x1d482d, 0x8b, 0x0 },
	{ 0x1d482e, 0x55, 0x0 },
	{ 0x1d482f, 0xf4, 0x0 },
	{ 0x1d4830, 0x3, 0x0 },
	{ 0x1d4831, 0x45, 0x8b },
	{ 0x1d4832, 0xe8, 0x45 },
	{ 0x1d4833, 0x13, 0xc0 },
	{ 0x1d4834, 0x55, 0x89 },
	{ 0x1d4835, 0xec, 0x45 },
	{ 0x1d4836, 0x89, 0xe8 },
	{ 0x1d4837, 0x45, 0x8b },
	{ 0x1d4838, 0xf8, 0x45 },
	{ 0x1d4839, 0x89, 0xc4 },
	{ 0x1d483a, 0x55, 0x89 },
	{ 0x1d483b, 0xfc, 0x45 },
	{ 0x1d483c, 0x8b, 0xec },
	{ 0x1d483d, 0x45, 0xff },
	{ 0x1d483e, 0xf8, 0x75 },
	{ 0x1d483f, 0x8b, 0xec },
	{ 0x1d4840, 0x55, 0xff },
	{ 0x1d4841, 0xfc, 0x75 },
	{ 0x1d4842, 0x3b, 0xe8 },
	{ 0x1d4843, 0x55, 0xe8 },
	{ 0x1d4844, 0xe4, 0x34 },
	{ 0x1d4845, 0x75, 0x8a },
	{ 0x1d4846, 0x7, 0xf5 },
	{ 0x1d4847, 0x3b, 0xff },
	{ 0x1d4848, 0x45, 0x8b },
	{ 0x1d4849, 0xe0, 0x45 },
	{ 0x1d484a, 0x73, 0xf0 },
	{ 0x1d484b, 0x10, 0x8b },
	{ 0x1d484c, 0xeb, 0x55 },
	{ 0x1d484d, 0x2, 0xf4 },
	{ 0x1d484e, 0x7d, 0x3 },
	{ 0x1d484f, 0xc, 0x45 },
	{ 0x1d4850, 0x8b, 0xe8 },
	{ 0x1d4851, 0x45, 0x13 },
	{ 0x1d4852, 0xf8, 0x55 },
	{ 0x1d4853, 0x89, 0xec },
	{ 0x1d4854, 0x45, 0x89 },
	{ 0x1d4855, 0xe0, 0x45 },
	{ 0x1d4856, 0x8b, 0xf8 },
	{ 0x1d4857, 0x45, 0x89 },
	{ 0x1d4858, 0xfc, 0x55 },
	{ 0x1d4859, 0x89, 0xfc },
	{ 0x1d485a, 0x45, 0x8b },
	{ 0x1d485b, 0xe4, 0x45 },
	{ 0x1d485c, 0x6a, 0xf8 },
	{ 0x1d485d, 0x0, 0x8b },
	{ 0x1d485e, 0x68, 0x55 },
	{ 0x1d485f, 0x40, 0xfc },
	{ 0x1d4860, 0x42, 0x3b },
	{ 0x1d4861, 0xf, 0x55 },
	{ 0x1d4862, 0x0, 0xe4 },
	{ 0x1d4863, 0x8b, 0x75 },
	{ 0x1d4864, 0x45, 0x7 },
	{ 0x1d4865, 0xf8, 0x3b },
	{ 0x1d4866, 0x8b, 0x45 },
	{ 0x1d4867, 0x55, 0xe0 },
	{ 0x1d4868, 0xfc, 0x73 },
	{ 0x1d4869, 0xe8, 0x10 },
	{ 0x1d486a, 0xe2, 0xeb },
	{ 0x1d486b, 0x3e, 0x2 },
	{ 0x1d486c, 0xe3, 0x7d },
	{ 0x1d486d, 0xff, 0xc },
	{ 0x1d486e, 0x52, 0x8b },
	{ 0x1d486f, 0x50, 0x45 },
	{ 0x1d4870, 0x6a, 0xf8 },
	{ 0x1d4871, 0x0, 0x89 },
	{ 0x1d4872, 0x68, 0x45 },
	{ 0x1d4873, 0x40, 0xe0 },
	{ 0x1d4874, 0x42, 0x8b },
	{ 0x1d4875, 0xf, 0x45 },
	{ 0x1d4876, 0x0, 0xfc },
	{ 0x1d4877, 0x8b, 0x89 },
	{ 0x1d4879, 0xe0, 0xe4 },
	{ 0x1d487a, 0x8b, 0x6a },
	{ 0x1d487b, 0x55, 0x0 },
	{ 0x1d487c, 0xe4, 0x68 },
	{ 0x1d487d, 0xe8, 0x40 },
	{ 0x1d487e, 0xce, 0x42 },
	{ 0x1d487f, 0x3e, 0xf },
	{ 0x1d4880, 0xe3, 0x0 },
	{ 0x1d4881, 0xff, 0x8b },
	{ 0x1d4882, 0x3b, 0x45 },
	{ 0x1d4883, 0x54, 0xf8 },
	{ 0x1d4884, 0x24, 0x8b },
	{ 0x1d4885, 0x4, 0x55 },
	{ 0x1d4886, 0x75, 0xfc },
	{ 0x1d4887, 0x9, 0xe8 },
	{ 0x1d4888, 0x3b, 0xc4 },
	{ 0x1d4889, 0x4, 0x3e },
	{ 0x1d488a, 0x24, 0xe3 },
	{ 0x1d488b, 0x5a, 0xff },
	{ 0x1d488c, 0x58, 0x52 },
	{ 0x1d488d, 0x73, 0x50 },
	{ 0x1d488e, 0x21, 0x6a },
	{ 0x1d488f, 0xeb, 0x0 },
	{ 0x1d4890, 0x4, 0x68 },
	{ 0x1d4891, 0x5a, 0x40 },
	{ 0x1d4892, 0x58, 0x42 },
	{ 0x1d4893, 0x7d, 0xf },
	{ 0x1d4894, 0x1b, 0x0 },
	{ 0x1d4895, 0xa1, 0x8b },
	{ 0x1d4896, 0x18, 0x45 },
	{ 0x1d4897, 0x9b, 0xe0 },
	{ 0x1d4898, 0x64, 0x8b },
	{ 0x1d4899, 0x0, 0x55 },
	{ 0x1d489a, 0x8b, 0xe4 },
	{ 0x1d489b, 0x55, 0xe8 },
	{ 0x1d489c, 0xdc, 0xb0 },
	{ 0x1d489d, 0x89, 0x3e },
	{ 0x1d489e, 0x10, 0xe3 },
	{ 0x1d489f, 0x33, 0xff },
	{ 0x1d48a0, 0xc0, 0x3b },
	{ 0x1d48a1, 0x89, 0x54 },
	{ 0x1d48a2, 0x45, 0x24 },
	{ 0x1d48a3, 0xdc, 0x4 },
	{ 0x1d48a4, 0x8b, 0x75 },
	{ 0x1d48a5, 0x45, 0x9 },
	{ 0x1d48a6, 0xf8, 0x3b },
	{ 0x1d48a7, 0x89, 0x4 },
	{ 0x1d48a8, 0x45, 0x24 },
	{ 0x1d48a9, 0xe0, 0x5a },
	{ 0x1d48aa, 0x8b, 0x58 },
	{ 0x1d48ab, 0x45, 0x73 },
	{ 0x1d48ac, 0xfc, 0x21 },
	{ 0x1d48ad, 0x89, 0xeb },
	{ 0x1d48ae, 0x45, 0x4 },
	{ 0x1d48af, 0xe4, 0x5a },
	{ 0x1d48b0, 0xff, 0x58 },
	{ 0x1d48b1, 0x45, 0x7d },
	{ 0x1d48b2, 0xdc, 0x1b },
	{ 0x1d48b4, 0x80, 0x18 },
	{ 0x1d48b5, 0x9d, 0x9b },
	{ 0x1d48b8, 0x83, 0x8b },
	{ 0x1d48b9, 0x38, 0x55 },
	{ 0x1d48ba, 0xff, 0xdc },
	{ 0x1d48bb, 0x75, 0x89 },
	{ 0x1d48bc, 0x14, 0x10 },
	{ 0x1d48bd, 0xa1, 0x33 },
	{ 0x1d48be, 0xb8, 0xc0 },
	{ 0x1d48bf, 0xa1, 0x89 },
	{ 0x1d48c0, 0x64, 0x45 },
	{ 0x1d48c1, 0x0, 0xdc },
	{ 0x1d48c2, 0x80, 0x8b },
	{ 0x1d48c3, 0x38, 0x45 },
	{ 0x1d48c4, 0x0, 0xf8 },
	{ 0x1d48c5, 0x74, 0x89 },
	{ 0x1d48c6, 0xa, 0x45 },
	{ 0x1d48c7, 0xe8, 0xe0 },
	{ 0x1d48c8, 0xc4, 0x8b },
	{ 0x1d48c9, 0xf, 0x45 },
	{ 0x1d48ca, 0xf6, 0xfc },
	{ 0x1d48cb, 0xff, 0x89 },
	{ 0x1d48cc, 0xe8, 0x45 },
	{ 0x1d48cd, 0x9f, 0xe4 },
	{ 0x1d48ce, 0xf, 0xff },
	{ 0x1d48cf, 0xf6, 0x45 },
	{ 0x1d48d0, 0xff, 0xdc },
	{-1,0,0}
};

PatchByte inputlagpatch_81_135[] = {
	{ 0x1d607b, 0xe8, 0xa1 },
	{ 0x1d607c, 0x70, 0x44 },
	{ 0x1d607d, 0xa8, 0x4c },
	{ 0x1d607e, 0xf5, 0x68 },
	{ 0x1d607f, 0xff, 0x00 },
	{ 0x1d6080, 0x89, 0x83 },
	{ 0x1d6081, 0x45, 0x38 },
	{ 0x1d6082, 0xf0, 0xff },
	{ 0x1d6083, 0x89, 0x75 },
	{ 0x1d6084, 0x55, 0x30 },
	{ 0x1d6085, 0xf4, 0xa1 },
	{ 0x1d6086, 0x8b, 0xc0 },
	{ 0x1d6087, 0x45, 0x51 },
	{ 0x1d6088, 0xf0, 0x68 },
	{ 0x1d6089, 0x8b, 0x00 },
	{ 0x1d608a, 0x55, 0x80 },
	{ 0x1d608b, 0xf4, 0x38 },
	{ 0x1d608c, 0x3b, 0x00 },
	{ 0x1d608d, 0x55, 0x74 },
	{ 0x1d608e, 0xfc, 0x26 },
	{ 0x1d608f, 0x75, 0xe8 },
	{ 0x1d6090, 0x07, 0xdc },
	{ 0x1d6091, 0x3b, 0x82 },
	{ 0x1d6092, 0x45, 0x01 },
	{ 0x1d6093, 0xf8, 0x00 },
	{ 0x1d6094, 0x73, 0xa1 },
	{ 0x1d6095, 0x10, 0x28 },
	{ 0x1d6096, 0xeb, 0x4a },
	{ 0x1d6097, 0x02, 0x68 },
	{ 0x1d6098, 0x7d, 0x00 },
	{ 0x1d6099, 0x0c, 0x80 },
	{ 0x1d609a, 0x8b, 0x38 },
	{ 0x1d609b, 0x45, 0x00 },
	{ 0x1d609c, 0xf0, 0x74 },
	{ 0x1d609d, 0x89, 0x12 },
	{ 0x1d609e, 0x45, 0xe8 },
	{ 0x1d609f, 0xf8, 0x59 },
	{ 0x1d60a0, 0x8b, 0xb1 },
	{ 0x1d60a1, 0x45, 0xf5 },
	{ 0x1d60a2, 0xf4, 0xff },
	{ 0x1d60a3, 0x89, 0xe8 },
	{ 0x1d60a4, 0x45, 0x74 },
	{ 0x1d60a5, 0xfc, 0x7d },
	{ 0x1d60a6, 0xa1, 0x01 },
	{ 0x1d60a7, 0x84, 0x00 },
	{ 0x1d60a8, 0x53, 0xa1 },
	{ 0x1d60a9, 0x68, 0x28 },
	{ 0x1d60aa, 0x00, 0x4a },
	{ 0x1d60ab, 0x8b, 0x68 },
	{ 0x1d60ad, 0x83, 0xc6 },
	{ 0x1d60ae, 0x78, 0x00 },
	{ 0x1d60af, 0x08, 0x00 },
	{ 0x1d60b0, 0x00, 0xe8 },
	{ 0x1d60b1, 0x7f, 0x9b },
	{ 0x1d60b2, 0x0e, 0x82 },
	{ 0x1d60b3, 0xa1, 0x01 },
	{ 0x1d60b4, 0x84, 0x00 },
	{ 0x1d60b5, 0x53, 0xe8 },
	{ 0x1d60b6, 0x68, 0x36 },
	{ 0x1d60b7, 0x00, 0xa8 },
	{ 0x1d60b8, 0x8b, 0xf5 },
	{ 0x1d60b9, 0x00, 0xff },
	{ 0x1d60ba, 0xc7, 0x89 },
	{ 0x1d60bb, 0x40, 0x45 },
	{ 0x1d60bc, 0x08, 0xf0 },
	{ 0x1d60bd, 0x01, 0x89 },
	{ 0x1d60be, 0x00, 0x55 },
	{ 0x1d60bf, 0x00, 0xf4 },
	{ 0x1d60c0, 0x00, 0x8b },
	{ 0x1d60c1, 0xa1, 0x45 },
	{ 0x1d60c2, 0x84, 0xf0 },
	{ 0x1d60c3, 0x53, 0x8b },
	{ 0x1d60c4, 0x68, 0x55 },
	{ 0x1d60c5, 0x00, 0xf4 },
	{ 0x1d60c6, 0x8b, 0x3b },
	{ 0x1d60c7, 0x00, 0x55 },
	{ 0x1d60c8, 0xff, 0xfc },
	{ 0x1d60c9, 0x70, 0x75 },
	{ 0x1d60ca, 0x08, 0x07 },
	{ 0x1d60cb, 0xb8, 0x3b },
	{ 0x1d60cc, 0x40, 0x45 },
	{ 0x1d60cd, 0x42, 0xf8 },
	{ 0x1d60ce, 0x0f, 0x73 },
	{ 0x1d60cf, 0x00, 0x10 },
	{ 0x1d60d0, 0x5a, 0xeb },
	{ 0x1d60d1, 0x8b, 0x02 },
	{ 0x1d60d2, 0xca, 0x7d },
	{ 0x1d60d3, 0x99, 0x0c },
	{ 0x1d60d4, 0xf7, 0x8b },
	{ 0x1d60d5, 0xf9, 0x45 },
	{ 0x1d60d6, 0x99, 0xf0 },
	{ 0x1d60d7, 0x52, 0x89 },
	{ 0x1d60d8, 0x50, 0x45 },
	{ 0x1d60d9, 0x8b, 0xf8 },
	{ 0x1d60da, 0x45, 0x8b },
	{ 0x1d60db, 0xf0, 0x45 },
	{ 0x1d60dc, 0x8b, 0xf4 },
	{ 0x1d60dd, 0x55, 0x89 },
	{ 0x1d60de, 0xf4, 0x45 },
	{ 0x1d60df, 0x2b, 0xfc },
	{ 0x1d60e0, 0x45, 0xa1 },
	{ 0x1d60e1, 0xf8, 0x84 },
	{ 0x1d60e2, 0x1b, 0x53 },
	{ 0x1d60e3, 0x55, 0x68 },
	{ 0x1d60e4, 0xfc, 0x00 },
	{ 0x1d60e5, 0x29, 0x8b },
	{ 0x1d60e6, 0x04, 0x00 },
	{ 0x1d60e7, 0x24, 0x83 },
	{ 0x1d60e8, 0x19, 0x78 },
	{ 0x1d60e9, 0x54, 0x08 },
	{ 0x1d60ea, 0x24, 0x00 },
	{ 0x1d60eb, 0x04, 0x7f },
	{ 0x1d60ec, 0x58, 0x0e },
	{ 0x1d60ed, 0x5a, 0xa1 },
	{ 0x1d60ee, 0x89, 0x84 },
	{ 0x1d60ef, 0x45, 0x53 },
	{ 0x1d60f0, 0xd0, 0x68 },
	{ 0x1d60f1, 0x89, 0x00 },
	{ 0x1d60f2, 0x55, 0x8b },
	{ 0x1d60f3, 0xd4, 0x00 },
	{ 0x1d60f4, 0x83, 0xc7 },
	{ 0x1d60f5, 0x7d, 0x40 },
	{ 0x1d60f6, 0xd4, 0x08 },
	{ 0x1d60f7, 0x00, 0x01 },
	{ 0x1d60f8, 0x75, 0x00 },
	{ 0x1d60f9, 0x08, 0x00 },
	{ 0x1d60fa, 0x83, 0x00 },
	{ 0x1d60fb, 0x7d, 0xa1 },
	{ 0x1d60fc, 0xd0, 0x84 },
	{ 0x1d60fd, 0x00, 0x53 },
	{ 0x1d60fe, 0x73, 0x68 },
	{ 0x1d60ff, 0x14, 0x00 },
	{ 0x1d6100, 0xeb, 0x8b },
	{ 0x1d6101, 0x02, 0x00 },
	{ 0x1d6102, 0x7d, 0xff },
	{ 0x1d6103, 0x10, 0x70 },
	{ 0x1d6104, 0xc7, 0x08 },
	{ 0x1d6105, 0x45, 0xb8 },
	{ 0x1d6106, 0xc8, 0x40 },
	{ 0x1d6107, 0x00, 0x42 },
	{ 0x1d6108, 0x00, 0x0f },
	{ 0x1d610a, 0x00, 0x5a },
	{ 0x1d610b, 0xc7, 0x8b },
	{ 0x1d610c, 0x45, 0xca },
	{ 0x1d610d, 0xcc, 0x99 },
	{ 0x1d610e, 0x00, 0xf7 },
	{ 0x1d610f, 0x00, 0xf9 },
	{ 0x1d6110, 0x00, 0x99 },
	{ 0x1d6111, 0x00, 0x52 },
	{ 0x1d6112, 0xeb, 0x50 },
	{ 0x1d6113, 0x0c, 0x8b },
	{ 0x1d6114, 0x8b, 0x45 },
	{ 0x1d6115, 0x45, 0xf0 },
	{ 0x1d6116, 0xd0, 0x8b },
	{ 0x1d6117, 0x89, 0x55 },
	{ 0x1d6118, 0x45, 0xf4 },
	{ 0x1d6119, 0xc8, 0x2b },
	{ 0x1d611a, 0x8b, 0x45 },
	{ 0x1d611b, 0x45, 0xf8 },
	{ 0x1d611c, 0xd4, 0x1b },
	{ 0x1d611d, 0x89, 0x55 },
	{ 0x1d611e, 0x45, 0xfc },
	{ 0x1d611f, 0xcc, 0x29 },
	{ 0x1d6120, 0x8b, 0x04 },
	{ 0x1d6121, 0x45, 0x24 },
	{ 0x1d6122, 0xc8, 0x19 },
	{ 0x1d6123, 0x89, 0x54 },
	{ 0x1d6124, 0x45, 0x24 },
	{ 0x1d6125, 0xe8, 0x04 },
	{ 0x1d6126, 0x8b, 0x58 },
	{ 0x1d6127, 0x45, 0x5a },
	{ 0x1d6128, 0xcc, 0x89 },
	{ 0x1d6129, 0x89, 0x45 },
	{ 0x1d612a, 0x45, 0xd0 },
	{ 0x1d612b, 0xec, 0x89 },
	{ 0x1d612c, 0x83, 0x55 },
	{ 0x1d612d, 0x7d, 0xd4 },
	{ 0x1d612e, 0xec, 0x83 },
	{ 0x1d612f, 0x00, 0x7d },
	{ 0x1d6130, 0x75, 0xd4 },
	{ 0x1d6131, 0x0b, 0x00 },
	{ 0x1d6132, 0x81, 0x75 },
	{ 0x1d6133, 0x7d, 0x08 },
	{ 0x1d6134, 0xe8, 0x83 },
	{ 0x1d6135, 0x40, 0x7d },
	{ 0x1d6136, 0x42, 0xd0 },
	{ 0x1d6137, 0x0f, 0x00 },
	{ 0x1d6138, 0x00, 0x73 },
	{ 0x1d6139, 0x73, 0x14 },
	{ 0x1d613a, 0x12, 0xeb },
	{ 0x1d613b, 0xeb, 0x02 },
	{ 0x1d613c, 0x02, 0x7d },
	{ 0x1d613d, 0x7d, 0x10 },
	{ 0x1d613e, 0x0e, 0xc7 },
	{ 0x1d613f, 0x8b, 0x45 },
	{ 0x1d6140, 0x45, 0xc8 },
	{ 0x1d6141, 0xe8, 0x00 },
	{ 0x1d6142, 0x89, 0x00 },
	{ 0x1d6143, 0x45, 0x00 },
	{ 0x1d6144, 0xc0, 0x00 },
	{ 0x1d6145, 0x8b, 0xc7 },
	{ 0x1d6147, 0xec, 0xcc },
	{ 0x1d6148, 0x89, 0x00 },
	{ 0x1d6149, 0x45, 0x00 },
	{ 0x1d614a, 0xc4, 0x00 },
	{ 0x1d614b, 0xeb, 0x00 },
	{ 0x1d614c, 0x0e, 0xeb },
	{ 0x1d614d, 0xc7, 0x0c },
	{ 0x1d614e, 0x45, 0x8b },
	{ 0x1d614f, 0xc0, 0x45 },
	{ 0x1d6150, 0x40, 0xd0 },
	{ 0x1d6151, 0x42, 0x89 },
	{ 0x1d6152, 0x0f, 0x45 },
	{ 0x1d6153, 0x00, 0xc8 },
	{ 0x1d6154, 0xc7, 0x8b },
	{ 0x1d6156, 0xc4, 0xd4 },
	{ 0x1d6157, 0x00, 0x89 },
	{ 0x1d6158, 0x00, 0x45 },
	{ 0x1d6159, 0x00, 0xcc },
	{ 0x1d615a, 0x00, 0x8b },
	{ 0x1d615b, 0x8b, 0x45 },
	{ 0x1d615c, 0x45, 0xc8 },
	{ 0x1d615d, 0xc0, 0x89 },
	{ 0x1d615e, 0x89, 0x45 },
	{ 0x1d615f, 0x45, 0xe8 },
	{ 0x1d6160, 0xe8, 0x8b },
	{ 0x1d6161, 0x8b, 0x45 },
	{ 0x1d6162, 0x45, 0xcc },
	{ 0x1d6163, 0xc4, 0x89 },
	{ 0x1d6164, 0x89, 0x45 },
	{ 0x1d6165, 0x45, 0xec },
	{ 0x1d6166, 0xec, 0x83 },
	{ 0x1d6167, 0xff, 0x7d },
	{ 0x1d6168, 0x75, 0xec },
	{ 0x1d6169, 0xec, 0x00 },
	{ 0x1d616a, 0xff, 0x75 },
	{ 0x1d616b, 0x75, 0x0b },
	{ 0x1d616c, 0xe8, 0x81 },
	{ 0x1d616d, 0xe8, 0x7d },
	{ 0x1d616e, 0x0a, 0xe8 },
	{ 0x1d616f, 0xa8, 0x40 },
	{ 0x1d6170, 0xf5, 0x42 },
	{ 0x1d6171, 0xff, 0x0f },
	{ 0x1d6172, 0x8b, 0x00 },
	{ 0x1d6173, 0x45, 0x73 },
	{ 0x1d6174, 0xf0, 0x12 },
	{ 0x1d6175, 0x8b, 0xeb },
	{ 0x1d6176, 0x55, 0x02 },
	{ 0x1d6177, 0xf4, 0x7d },
	{ 0x1d6178, 0x03, 0x0e },
	{ 0x1d6179, 0x45, 0x8b },
	{ 0x1d617a, 0xe8, 0x45 },
	{ 0x1d617b, 0x13, 0xe8 },
	{ 0x1d617c, 0x55, 0x89 },
	{ 0x1d617d, 0xec, 0x45 },
	{ 0x1d617e, 0x89, 0xc0 },
	{ 0x1d617f, 0x45, 0x8b },
	{ 0x1d6180, 0xf8, 0x45 },
	{ 0x1d6181, 0x89, 0xec },
	{ 0x1d6182, 0x55, 0x89 },
	{ 0x1d6183, 0xfc, 0x45 },
	{ 0x1d6184, 0x8b, 0xc4 },
	{ 0x1d6185, 0x45, 0xeb },
	{ 0x1d6186, 0xf8, 0x0e },
	{ 0x1d6187, 0x8b, 0xc7 },
	{ 0x1d6188, 0x55, 0x45 },
	{ 0x1d6189, 0xfc, 0xc0 },
	{ 0x1d618a, 0x3b, 0x40 },
	{ 0x1d618b, 0x55, 0x42 },
	{ 0x1d618c, 0xe4, 0x0f },
	{ 0x1d618d, 0x75, 0x00 },
	{ 0x1d618e, 0x07, 0xc7 },
	{ 0x1d618f, 0x3b, 0x45 },
	{ 0x1d6190, 0x45, 0xc4 },
	{ 0x1d6191, 0xe0, 0x00 },
	{ 0x1d6192, 0x73, 0x00 },
	{ 0x1d6193, 0x10, 0x00 },
	{ 0x1d6194, 0xeb, 0x00 },
	{ 0x1d6195, 0x02, 0x8b },
	{ 0x1d6196, 0x7d, 0x45 },
	{ 0x1d6197, 0x0c, 0xc0 },
	{ 0x1d6198, 0x8b, 0x89 },
	{ 0x1d619a, 0xf8, 0xe8 },
	{ 0x1d619b, 0x89, 0x8b },
	{ 0x1d619d, 0xe0, 0xc4 },
	{ 0x1d619e, 0x8b, 0x89 },
	{ 0x1d61a0, 0xfc, 0xec },
	{ 0x1d61a1, 0x89, 0xff },
	{ 0x1d61a2, 0x45, 0x75 },
	{ 0x1d61a3, 0xe4, 0xec },
	{ 0x1d61a4, 0x6a, 0xff },
	{ 0x1d61a5, 0x00, 0x75 },
	{ 0x1d61a6, 0x68, 0xe8 },
	{ 0x1d61a7, 0x40, 0xe8 },
	{ 0x1d61a8, 0x42, 0xd0 },
	{ 0x1d61a9, 0x0f, 0xa7 },
	{ 0x1d61aa, 0x00, 0xf5 },
	{ 0x1d61ab, 0x8b, 0xff },
	{ 0x1d61ac, 0x45, 0x8b },
	{ 0x1d61ad, 0xf8, 0x45 },
	{ 0x1d61ae, 0x8b, 0xf0 },
	{ 0x1d61af, 0x55, 0x8b },
	{ 0x1d61b0, 0xfc, 0x55 },
	{ 0x1d61b1, 0xe8, 0xf4 },
	{ 0x1d61b2, 0xb6, 0x03 },
	{ 0x1d61b3, 0x29, 0x45 },
	{ 0x1d61b4, 0xe3, 0xe8 },
	{ 0x1d61b5, 0xff, 0x13 },
	{ 0x1d61b6, 0x52, 0x55 },
	{ 0x1d61b7, 0x50, 0xec },
	{ 0x1d61b8, 0x6a, 0x89 },
	{ 0x1d61b9, 0x00, 0x45 },
	{ 0x1d61ba, 0x68, 0xf8 },
	{ 0x1d61bb, 0x40, 0x89 },
	{ 0x1d61bc, 0x42, 0x55 },
	{ 0x1d61bd, 0x0f, 0xfc },
	{ 0x1d61be, 0x00, 0x8b },
	{ 0x1d61bf, 0x8b, 0x45 },
	{ 0x1d61c0, 0x45, 0xf8 },
	{ 0x1d61c1, 0xe0, 0x8b },
	{ 0x1d61c2, 0x8b, 0x55 },
	{ 0x1d61c3, 0x55, 0xfc },
	{ 0x1d61c4, 0xe4, 0x3b },
	{ 0x1d61c5, 0xe8, 0x55 },
	{ 0x1d61c6, 0xa2, 0xe4 },
	{ 0x1d61c7, 0x29, 0x75 },
	{ 0x1d61c8, 0xe3, 0x07 },
	{ 0x1d61c9, 0xff, 0x3b },
	{ 0x1d61ca, 0x3b, 0x45 },
	{ 0x1d61cb, 0x54, 0xe0 },
	{ 0x1d61cc, 0x24, 0x73 },
	{ 0x1d61cd, 0x04, 0x10 },
	{ 0x1d61ce, 0x75, 0xeb },
	{ 0x1d61cf, 0x09, 0x02 },
	{ 0x1d61d0, 0x3b, 0x7d },
	{ 0x1d61d1, 0x04, 0x0c },
	{ 0x1d61d2, 0x24, 0x8b },
	{ 0x1d61d3, 0x5a, 0x45 },
	{ 0x1d61d4, 0x58, 0xf8 },
	{ 0x1d61d5, 0x73, 0x89 },
	{ 0x1d61d6, 0x21, 0x45 },
	{ 0x1d61d7, 0xeb, 0xe0 },
	{ 0x1d61d8, 0x04, 0x8b },
	{ 0x1d61d9, 0x5a, 0x45 },
	{ 0x1d61da, 0x58, 0xfc },
	{ 0x1d61db, 0x7d, 0x89 },
	{ 0x1d61dc, 0x1b, 0x45 },
	{ 0x1d61dd, 0xa1, 0xe4 },
	{ 0x1d61de, 0x24, 0x6a },
	{ 0x1d61df, 0x49, 0x00 },
	{ 0x1d61e1, 0x00, 0x40 },
	{ 0x1d61e2, 0x8b, 0x42 },
	{ 0x1d61e3, 0x55, 0x0f },
	{ 0x1d61e4, 0xdc, 0x00 },
	{ 0x1d61e5, 0x89, 0x8b },
	{ 0x1d61e6, 0x10, 0x45 },
	{ 0x1d61e7, 0x33, 0xf8 },
	{ 0x1d61e8, 0xc0, 0x8b },
	{ 0x1d61e9, 0x89, 0x55 },
	{ 0x1d61ea, 0x45, 0xfc },
	{ 0x1d61eb, 0xdc, 0xe8 },
	{ 0x1d61ec, 0x8b, 0x7c },
	{ 0x1d61ed, 0x45, 0x29 },
	{ 0x1d61ee, 0xf8, 0xe3 },
	{ 0x1d61ef, 0x89, 0xff },
	{ 0x1d61f0, 0x45, 0x52 },
	{ 0x1d61f1, 0xe0, 0x50 },
	{ 0x1d61f2, 0x8b, 0x6a },
	{ 0x1d61f3, 0x45, 0x00 },
	{ 0x1d61f4, 0xfc, 0x68 },
	{ 0x1d61f5, 0x89, 0x40 },
	{ 0x1d61f6, 0x45, 0x42 },
	{ 0x1d61f7, 0xe4, 0x0f },
	{ 0x1d61f8, 0xff, 0x00 },
	{ 0x1d61f9, 0x45, 0x8b },
	{ 0x1d61fa, 0xdc, 0x45 },
	{ 0x1d61fb, 0xa1, 0xe0 },
	{ 0x1d61fc, 0x44, 0x8b },
	{ 0x1d61fd, 0x4c, 0x55 },
	{ 0x1d61fe, 0x68, 0xe4 },
	{ 0x1d61ff, 0x00, 0xe8 },
	{ 0x1d6200, 0x83, 0x68 },
	{ 0x1d6201, 0x38, 0x29 },
	{ 0x1d6202, 0xff, 0xe3 },
	{ 0x1d6203, 0x75, 0xff },
	{ 0x1d6204, 0x30, 0x3b },
	{ 0x1d6205, 0xa1, 0x54 },
	{ 0x1d6206, 0xc0, 0x24 },
	{ 0x1d6207, 0x51, 0x04 },
	{ 0x1d6208, 0x68, 0x75 },
	{ 0x1d6209, 0x00, 0x09 },
	{ 0x1d620a, 0x80, 0x3b },
	{ 0x1d620b, 0x38, 0x04 },
	{ 0x1d620c, 0x00, 0x24 },
	{ 0x1d620d, 0x74, 0x5a },
	{ 0x1d620e, 0x26, 0x58 },
	{ 0x1d620f, 0xe8, 0x73 },
	{ 0x1d6210, 0x5c, 0x21 },
	{ 0x1d6211, 0x81, 0xeb },
	{ 0x1d6212, 0x01, 0x04 },
	{ 0x1d6213, 0x00, 0x5a },
	{ 0x1d6214, 0xa1, 0x58 },
	{ 0x1d6215, 0x28, 0x7d },
	{ 0x1d6216, 0x4a, 0x1b },
	{ 0x1d6217, 0x68, 0xa1 },
	{ 0x1d6218, 0x00, 0x24 },
	{ 0x1d6219, 0x80, 0x49 },
	{ 0x1d621a, 0x38, 0x68 },
	{ 0x1d621c, 0x74, 0x8b },
	{ 0x1d621d, 0x12, 0x55 },
	{ 0x1d621e, 0xe8, 0xdc },
	{ 0x1d621f, 0xd9, 0x89 },
	{ 0x1d6220, 0xaf, 0x10 },
	{ 0x1d6221, 0xf5, 0x33 },
	{ 0x1d6222, 0xff, 0xc0 },
	{ 0x1d6223, 0xe8, 0x89 },
	{ 0x1d6224, 0xf4, 0x45 },
	{ 0x1d6225, 0x7b, 0xdc },
	{ 0x1d6226, 0x01, 0x8b },
	{ 0x1d6227, 0x00, 0x45 },
	{ 0x1d6228, 0xa1, 0xf8 },
	{ 0x1d6229, 0x28, 0x89 },
	{ 0x1d622a, 0x4a, 0x45 },
	{ 0x1d622b, 0x68, 0xe0 },
	{ 0x1d622c, 0x00, 0x8b },
	{ 0x1d622d, 0xc6, 0x45 },
	{ 0x1d622e, 0x00, 0xfc },
	{ 0x1d622f, 0x00, 0x89 },
	{ 0x1d6230, 0xe8, 0x45 },
	{ 0x1d6231, 0x1b, 0xe4 },
	{ 0x1d6232, 0x81, 0xff },
	{ 0x1d6233, 0x01, 0x45 },
	{ 0x1d6234, 0x00, 0xdc },
	{-1,0,0}
};

PatchByte inputlagpatch_81_140[] = {
	{ 0x206cff, 0xe8, 0xa1 },
	{ 0x206d00, 0x24, 0x48 },
	{ 0x206d01, 0x98, 0x8c },
	{ 0x206d02, 0xf5, 0x68 },
	{ 0x206d03, 0xff, 0x0 },
	{ 0x206d04, 0x89, 0x83 },
	{ 0x206d05, 0x45, 0x38 },
	{ 0x206d06, 0xf0, 0xff },
	{ 0x206d07, 0x89, 0x75 },
	{ 0x206d08, 0x55, 0x30 },
	{ 0x206d09, 0xf4, 0xa1 },
	{ 0x206d0a, 0x8b, 0xcc },
	{ 0x206d0b, 0x45, 0x91 },
	{ 0x206d0c, 0xf0, 0x68 },
	{ 0x206d0d, 0x8b, 0x0 },
	{ 0x206d0e, 0x55, 0x80 },
	{ 0x206d0f, 0xf4, 0x38 },
	{ 0x206d10, 0x3b, 0x0 },
	{ 0x206d11, 0x55, 0x74 },
	{ 0x206d12, 0xfc, 0x26 },
	{ 0x206d13, 0x75, 0xe8 },
	{ 0x206d14, 0x7, 0xc0 },
	{ 0x206d15, 0x3b, 0x85 },
	{ 0x206d16, 0x45, 0x1 },
	{ 0x206d17, 0xf8, 0x0 },
	{ 0x206d18, 0x73, 0xa1 },
	{ 0x206d19, 0x10, 0x38 },
	{ 0x206d1a, 0xeb, 0x8a },
	{ 0x206d1b, 0x2, 0x68 },
	{ 0x206d1c, 0x7d, 0x0 },
	{ 0x206d1d, 0xc, 0x80 },
	{ 0x206d1e, 0x8b, 0x38 },
	{ 0x206d1f, 0x45, 0x0 },
	{ 0x206d20, 0xf0, 0x74 },
	{ 0x206d21, 0x89, 0x12 },
	{ 0x206d22, 0x45, 0xe8 },
	{ 0x206d23, 0xf8, 0x19 },
	{ 0x206d24, 0x8b, 0xa2 },
	{ 0x206d25, 0x45, 0xf5 },
	{ 0x206d26, 0xf4, 0xff },
	{ 0x206d27, 0x89, 0xe8 },
	{ 0x206d28, 0x45, 0x58 },
	{ 0x206d29, 0xfc, 0x80 },
	{ 0x206d2a, 0xa1, 0x1 },
	{ 0x206d2b, 0x98, 0x0 },
	{ 0x206d2c, 0x93, 0xa1 },
	{ 0x206d2d, 0x68, 0x38 },
	{ 0x206d2e, 0x0, 0x8a },
	{ 0x206d2f, 0x8b, 0x68 },
	{ 0x206d31, 0x83, 0xc6 },
	{ 0x206d32, 0x78, 0x0 },
	{ 0x206d33, 0x8, 0x0 },
	{ 0x206d34, 0x0, 0xe8 },
	{ 0x206d36, 0xe, 0x85 },
	{ 0x206d37, 0xa1, 0x1 },
	{ 0x206d38, 0x98, 0x0 },
	{ 0x206d39, 0x93, 0xe8 },
	{ 0x206d3a, 0x68, 0xea },
	{ 0x206d3b, 0x0, 0x97 },
	{ 0x206d3c, 0x8b, 0xf5 },
	{ 0x206d3d, 0x0, 0xff },
	{ 0x206d3e, 0xc7, 0x89 },
	{ 0x206d3f, 0x40, 0x45 },
	{ 0x206d40, 0x8, 0xf0 },
	{ 0x206d41, 0x1, 0x89 },
	{ 0x206d42, 0x0, 0x55 },
	{ 0x206d43, 0x0, 0xf4 },
	{ 0x206d44, 0x0, 0x8b },
	{ 0x206d45, 0xa1, 0x45 },
	{ 0x206d46, 0x98, 0xf0 },
	{ 0x206d47, 0x93, 0x8b },
	{ 0x206d48, 0x68, 0x55 },
	{ 0x206d49, 0x0, 0xf4 },
	{ 0x206d4a, 0x8b, 0x3b },
	{ 0x206d4b, 0x0, 0x55 },
	{ 0x206d4c, 0xff, 0xfc },
	{ 0x206d4d, 0x70, 0x75 },
	{ 0x206d4e, 0x8, 0x7 },
	{ 0x206d4f, 0xb8, 0x3b },
	{ 0x206d50, 0x40, 0x45 },
	{ 0x206d51, 0x42, 0xf8 },
	{ 0x206d52, 0xf, 0x73 },
	{ 0x206d53, 0x0, 0x10 },
	{ 0x206d54, 0x5a, 0xeb },
	{ 0x206d55, 0x8b, 0x2 },
	{ 0x206d56, 0xca, 0x7d },
	{ 0x206d57, 0x99, 0xc },
	{ 0x206d58, 0xf7, 0x8b },
	{ 0x206d59, 0xf9, 0x45 },
	{ 0x206d5a, 0x99, 0xf0 },
	{ 0x206d5b, 0x52, 0x89 },
	{ 0x206d5c, 0x50, 0x45 },
	{ 0x206d5d, 0x8b, 0xf8 },
	{ 0x206d5e, 0x45, 0x8b },
	{ 0x206d5f, 0xf0, 0x45 },
	{ 0x206d60, 0x8b, 0xf4 },
	{ 0x206d61, 0x55, 0x89 },
	{ 0x206d62, 0xf4, 0x45 },
	{ 0x206d63, 0x2b, 0xfc },
	{ 0x206d64, 0x45, 0xa1 },
	{ 0x206d65, 0xf8, 0x98 },
	{ 0x206d66, 0x1b, 0x93 },
	{ 0x206d67, 0x55, 0x68 },
	{ 0x206d68, 0xfc, 0x0 },
	{ 0x206d69, 0x29, 0x8b },
	{ 0x206d6a, 0x4, 0x0 },
	{ 0x206d6b, 0x24, 0x83 },
	{ 0x206d6c, 0x19, 0x78 },
	{ 0x206d6d, 0x54, 0x8 },
	{ 0x206d6e, 0x24, 0x0 },
	{ 0x206d6f, 0x4, 0x7f },
	{ 0x206d70, 0x58, 0xe },
	{ 0x206d71, 0x5a, 0xa1 },
	{ 0x206d72, 0x89, 0x98 },
	{ 0x206d73, 0x45, 0x93 },
	{ 0x206d74, 0xd0, 0x68 },
	{ 0x206d75, 0x89, 0x0 },
	{ 0x206d76, 0x55, 0x8b },
	{ 0x206d77, 0xd4, 0x0 },
	{ 0x206d78, 0x83, 0xc7 },
	{ 0x206d79, 0x7d, 0x40 },
	{ 0x206d7a, 0xd4, 0x8 },
	{ 0x206d7b, 0x0, 0x1 },
	{ 0x206d7c, 0x75, 0x0 },
	{ 0x206d7d, 0x8, 0x0 },
	{ 0x206d7e, 0x83, 0x0 },
	{ 0x206d7f, 0x7d, 0xa1 },
	{ 0x206d80, 0xd0, 0x98 },
	{ 0x206d81, 0x0, 0x93 },
	{ 0x206d82, 0x73, 0x68 },
	{ 0x206d83, 0x14, 0x0 },
	{ 0x206d84, 0xeb, 0x8b },
	{ 0x206d85, 0x2, 0x0 },
	{ 0x206d86, 0x7d, 0xff },
	{ 0x206d87, 0x10, 0x70 },
	{ 0x206d88, 0xc7, 0x8 },
	{ 0x206d89, 0x45, 0xb8 },
	{ 0x206d8a, 0xc8, 0x40 },
	{ 0x206d8b, 0x0, 0x42 },
	{ 0x206d8c, 0x0, 0xf },
	{ 0x206d8e, 0x0, 0x5a },
	{ 0x206d8f, 0xc7, 0x8b },
	{ 0x206d90, 0x45, 0xca },
	{ 0x206d91, 0xcc, 0x99 },
	{ 0x206d92, 0x0, 0xf7 },
	{ 0x206d93, 0x0, 0xf9 },
	{ 0x206d94, 0x0, 0x99 },
	{ 0x206d95, 0x0, 0x52 },
	{ 0x206d96, 0xeb, 0x50 },
	{ 0x206d97, 0xc, 0x8b },
	{ 0x206d98, 0x8b, 0x45 },
	{ 0x206d99, 0x45, 0xf0 },
	{ 0x206d9a, 0xd0, 0x8b },
	{ 0x206d9b, 0x89, 0x55 },
	{ 0x206d9c, 0x45, 0xf4 },
	{ 0x206d9d, 0xc8, 0x2b },
	{ 0x206d9e, 0x8b, 0x45 },
	{ 0x206d9f, 0x45, 0xf8 },
	{ 0x206da0, 0xd4, 0x1b },
	{ 0x206da1, 0x89, 0x55 },
	{ 0x206da2, 0x45, 0xfc },
	{ 0x206da3, 0xcc, 0x29 },
	{ 0x206da4, 0x8b, 0x4 },
	{ 0x206da5, 0x45, 0x24 },
	{ 0x206da6, 0xc8, 0x19 },
	{ 0x206da7, 0x89, 0x54 },
	{ 0x206da8, 0x45, 0x24 },
	{ 0x206da9, 0xe8, 0x4 },
	{ 0x206daa, 0x8b, 0x58 },
	{ 0x206dab, 0x45, 0x5a },
	{ 0x206dac, 0xcc, 0x89 },
	{ 0x206dad, 0x89, 0x45 },
	{ 0x206dae, 0x45, 0xd0 },
	{ 0x206daf, 0xec, 0x89 },
	{ 0x206db0, 0x83, 0x55 },
	{ 0x206db1, 0x7d, 0xd4 },
	{ 0x206db2, 0xec, 0x83 },
	{ 0x206db3, 0x0, 0x7d },
	{ 0x206db4, 0x75, 0xd4 },
	{ 0x206db5, 0xb, 0x0 },
	{ 0x206db6, 0x81, 0x75 },
	{ 0x206db7, 0x7d, 0x8 },
	{ 0x206db8, 0xe8, 0x83 },
	{ 0x206db9, 0x40, 0x7d },
	{ 0x206dba, 0x42, 0xd0 },
	{ 0x206dbb, 0xf, 0x0 },
	{ 0x206dbc, 0x0, 0x73 },
	{ 0x206dbd, 0x73, 0x14 },
	{ 0x206dbe, 0x12, 0xeb },
	{ 0x206dbf, 0xeb, 0x2 },
	{ 0x206dc0, 0x2, 0x7d },
	{ 0x206dc1, 0x7d, 0x10 },
	{ 0x206dc2, 0xe, 0xc7 },
	{ 0x206dc3, 0x8b, 0x45 },
	{ 0x206dc4, 0x45, 0xc8 },
	{ 0x206dc5, 0xe8, 0x0 },
	{ 0x206dc6, 0x89, 0x0 },
	{ 0x206dc7, 0x45, 0x0 },
	{ 0x206dc8, 0xc0, 0x0 },
	{ 0x206dc9, 0x8b, 0xc7 },
	{ 0x206dcb, 0xec, 0xcc },
	{ 0x206dcc, 0x89, 0x0 },
	{ 0x206dcd, 0x45, 0x0 },
	{ 0x206dce, 0xc4, 0x0 },
	{ 0x206dcf, 0xeb, 0x0 },
	{ 0x206dd0, 0xe, 0xeb },
	{ 0x206dd1, 0xc7, 0xc },
	{ 0x206dd2, 0x45, 0x8b },
	{ 0x206dd3, 0xc0, 0x45 },
	{ 0x206dd4, 0x40, 0xd0 },
	{ 0x206dd5, 0x42, 0x89 },
	{ 0x206dd6, 0xf, 0x45 },
	{ 0x206dd7, 0x0, 0xc8 },
	{ 0x206dd8, 0xc7, 0x8b },
	{ 0x206dda, 0xc4, 0xd4 },
	{ 0x206ddb, 0x0, 0x89 },
	{ 0x206ddc, 0x0, 0x45 },
	{ 0x206ddd, 0x0, 0xcc },
	{ 0x206dde, 0x0, 0x8b },
	{ 0x206ddf, 0x8b, 0x45 },
	{ 0x206de0, 0x45, 0xc8 },
	{ 0x206de1, 0xc0, 0x89 },
	{ 0x206de2, 0x89, 0x45 },
	{ 0x206de3, 0x45, 0xe8 },
	{ 0x206de4, 0xe8, 0x8b },
	{ 0x206de5, 0x8b, 0x45 },
	{ 0x206de6, 0x45, 0xcc },
	{ 0x206de7, 0xc4, 0x89 },
	{ 0x206de8, 0x89, 0x45 },
	{ 0x206de9, 0x45, 0xec },
	{ 0x206dea, 0xec, 0x83 },
	{ 0x206deb, 0xff, 0x7d },
	{ 0x206dec, 0x75, 0xec },
	{ 0x206ded, 0xec, 0x0 },
	{ 0x206dee, 0xff, 0x75 },
	{ 0x206def, 0x75, 0xb },
	{ 0x206df0, 0xe8, 0x81 },
	{ 0x206df1, 0xe8, 0x7d },
	{ 0x206df2, 0xbe, 0xe8 },
	{ 0x206df3, 0x97, 0x40 },
	{ 0x206df4, 0xf5, 0x42 },
	{ 0x206df5, 0xff, 0xf },
	{ 0x206df6, 0x8b, 0x0 },
	{ 0x206df7, 0x45, 0x73 },
	{ 0x206df8, 0xf0, 0x12 },
	{ 0x206df9, 0x8b, 0xeb },
	{ 0x206dfa, 0x55, 0x2 },
	{ 0x206dfb, 0xf4, 0x7d },
	{ 0x206dfc, 0x3, 0xe },
	{ 0x206dfd, 0x45, 0x8b },
	{ 0x206dfe, 0xe8, 0x45 },
	{ 0x206dff, 0x13, 0xe8 },
	{ 0x206e00, 0x55, 0x89 },
	{ 0x206e01, 0xec, 0x45 },
	{ 0x206e02, 0x89, 0xc0 },
	{ 0x206e03, 0x45, 0x8b },
	{ 0x206e04, 0xf8, 0x45 },
	{ 0x206e05, 0x89, 0xec },
	{ 0x206e06, 0x55, 0x89 },
	{ 0x206e07, 0xfc, 0x45 },
	{ 0x206e08, 0x8b, 0xc4 },
	{ 0x206e09, 0x45, 0xeb },
	{ 0x206e0a, 0xf8, 0xe },
	{ 0x206e0b, 0x8b, 0xc7 },
	{ 0x206e0c, 0x55, 0x45 },
	{ 0x206e0d, 0xfc, 0xc0 },
	{ 0x206e0e, 0x3b, 0x40 },
	{ 0x206e0f, 0x55, 0x42 },
	{ 0x206e10, 0xe4, 0xf },
	{ 0x206e11, 0x75, 0x0 },
	{ 0x206e12, 0x7, 0xc7 },
	{ 0x206e13, 0x3b, 0x45 },
	{ 0x206e14, 0x45, 0xc4 },
	{ 0x206e15, 0xe0, 0x0 },
	{ 0x206e16, 0x73, 0x0 },
	{ 0x206e17, 0x10, 0x0 },
	{ 0x206e18, 0xeb, 0x0 },
	{ 0x206e19, 0x2, 0x8b },
	{ 0x206e1a, 0x7d, 0x45 },
	{ 0x206e1b, 0xc, 0xc0 },
	{ 0x206e1c, 0x8b, 0x89 },
	{ 0x206e1e, 0xf8, 0xe8 },
	{ 0x206e1f, 0x89, 0x8b },
	{ 0x206e21, 0xe0, 0xc4 },
	{ 0x206e22, 0x8b, 0x89 },
	{ 0x206e24, 0xfc, 0xec },
	{ 0x206e25, 0x89, 0xff },
	{ 0x206e26, 0x45, 0x75 },
	{ 0x206e27, 0xe4, 0xec },
	{ 0x206e28, 0x6a, 0xff },
	{ 0x206e29, 0x0, 0x75 },
	{ 0x206e2a, 0x68, 0xe8 },
	{ 0x206e2b, 0x40, 0xe8 },
	{ 0x206e2c, 0x42, 0x84 },
	{ 0x206e2d, 0xf, 0x97 },
	{ 0x206e2e, 0x0, 0xf5 },
	{ 0x206e2f, 0x8b, 0xff },
	{ 0x206e30, 0x45, 0x8b },
	{ 0x206e31, 0xf8, 0x45 },
	{ 0x206e32, 0x8b, 0xf0 },
	{ 0x206e33, 0x55, 0x8b },
	{ 0x206e34, 0xfc, 0x55 },
	{ 0x206e35, 0xe8, 0xf4 },
	{ 0x206e36, 0x32, 0x3 },
	{ 0x206e37, 0x1d, 0x45 },
	{ 0x206e38, 0xe0, 0xe8 },
	{ 0x206e39, 0xff, 0x13 },
	{ 0x206e3a, 0x52, 0x55 },
	{ 0x206e3b, 0x50, 0xec },
	{ 0x206e3c, 0x6a, 0x89 },
	{ 0x206e3d, 0x0, 0x45 },
	{ 0x206e3e, 0x68, 0xf8 },
	{ 0x206e3f, 0x40, 0x89 },
	{ 0x206e40, 0x42, 0x55 },
	{ 0x206e41, 0xf, 0xfc },
	{ 0x206e42, 0x0, 0x8b },
	{ 0x206e43, 0x8b, 0x45 },
	{ 0x206e44, 0x45, 0xf8 },
	{ 0x206e45, 0xe0, 0x8b },
	{ 0x206e46, 0x8b, 0x55 },
	{ 0x206e47, 0x55, 0xfc },
	{ 0x206e48, 0xe4, 0x3b },
	{ 0x206e49, 0xe8, 0x55 },
	{ 0x206e4a, 0x1e, 0xe4 },
	{ 0x206e4b, 0x1d, 0x75 },
	{ 0x206e4c, 0xe0, 0x7 },
	{ 0x206e4d, 0xff, 0x3b },
	{ 0x206e4e, 0x3b, 0x45 },
	{ 0x206e4f, 0x54, 0xe0 },
	{ 0x206e50, 0x24, 0x73 },
	{ 0x206e51, 0x4, 0x10 },
	{ 0x206e52, 0x75, 0xeb },
	{ 0x206e53, 0x9, 0x2 },
	{ 0x206e54, 0x3b, 0x7d },
	{ 0x206e55, 0x4, 0xc },
	{ 0x206e56, 0x24, 0x8b },
	{ 0x206e57, 0x5a, 0x45 },
	{ 0x206e58, 0x58, 0xf8 },
	{ 0x206e59, 0x73, 0x89 },
	{ 0x206e5a, 0x21, 0x45 },
	{ 0x206e5b, 0xeb, 0xe0 },
	{ 0x206e5c, 0x4, 0x8b },
	{ 0x206e5d, 0x5a, 0x45 },
	{ 0x206e5e, 0x58, 0xfc },
	{ 0x206e5f, 0x7d, 0x89 },
	{ 0x206e60, 0x1b, 0x45 },
	{ 0x206e61, 0xa1, 0xe4 },
	{ 0x206e62, 0x2c, 0x6a },
	{ 0x206e63, 0x89, 0x0 },
	{ 0x206e65, 0x0, 0x40 },
	{ 0x206e66, 0x8b, 0x42 },
	{ 0x206e67, 0x55, 0xf },
	{ 0x206e68, 0xdc, 0x0 },
	{ 0x206e69, 0x89, 0x8b },
	{ 0x206e6a, 0x10, 0x45 },
	{ 0x206e6b, 0x33, 0xf8 },
	{ 0x206e6c, 0xc0, 0x8b },
	{ 0x206e6d, 0x89, 0x55 },
	{ 0x206e6e, 0x45, 0xfc },
	{ 0x206e6f, 0xdc, 0xe8 },
	{ 0x206e70, 0x8b, 0xf8 },
	{ 0x206e71, 0x45, 0x1c },
	{ 0x206e72, 0xf8, 0xe0 },
	{ 0x206e73, 0x89, 0xff },
	{ 0x206e74, 0x45, 0x52 },
	{ 0x206e75, 0xe0, 0x50 },
	{ 0x206e76, 0x8b, 0x6a },
	{ 0x206e77, 0x45, 0x0 },
	{ 0x206e78, 0xfc, 0x68 },
	{ 0x206e79, 0x89, 0x40 },
	{ 0x206e7a, 0x45, 0x42 },
	{ 0x206e7b, 0xe4, 0xf },
	{ 0x206e7c, 0xff, 0x0 },
	{ 0x206e7d, 0x45, 0x8b },
	{ 0x206e7e, 0xdc, 0x45 },
	{ 0x206e7f, 0xa1, 0xe0 },
	{ 0x206e80, 0x48, 0x8b },
	{ 0x206e81, 0x8c, 0x55 },
	{ 0x206e82, 0x68, 0xe4 },
	{ 0x206e83, 0x0, 0xe8 },
	{ 0x206e84, 0x83, 0xe4 },
	{ 0x206e85, 0x38, 0x1c },
	{ 0x206e86, 0xff, 0xe0 },
	{ 0x206e87, 0x75, 0xff },
	{ 0x206e88, 0x30, 0x3b },
	{ 0x206e89, 0xa1, 0x54 },
	{ 0x206e8a, 0xcc, 0x24 },
	{ 0x206e8b, 0x91, 0x4 },
	{ 0x206e8c, 0x68, 0x75 },
	{ 0x206e8d, 0x0, 0x9 },
	{ 0x206e8e, 0x80, 0x3b },
	{ 0x206e8f, 0x38, 0x4 },
	{ 0x206e90, 0x0, 0x24 },
	{ 0x206e91, 0x74, 0x5a },
	{ 0x206e92, 0x26, 0x58 },
	{ 0x206e93, 0xe8, 0x73 },
	{ 0x206e94, 0x40, 0x21 },
	{ 0x206e95, 0x84, 0xeb },
	{ 0x206e96, 0x1, 0x4 },
	{ 0x206e97, 0x0, 0x5a },
	{ 0x206e98, 0xa1, 0x58 },
	{ 0x206e99, 0x38, 0x7d },
	{ 0x206e9a, 0x8a, 0x1b },
	{ 0x206e9b, 0x68, 0xa1 },
	{ 0x206e9c, 0x0, 0x2c },
	{ 0x206e9d, 0x80, 0x89 },
	{ 0x206e9e, 0x38, 0x68 },
	{ 0x206ea0, 0x74, 0x8b },
	{ 0x206ea1, 0x12, 0x55 },
	{ 0x206ea2, 0xe8, 0xdc },
	{ 0x206ea3, 0x99, 0x89 },
	{ 0x206ea4, 0xa0, 0x10 },
	{ 0x206ea5, 0xf5, 0x33 },
	{ 0x206ea6, 0xff, 0xc0 },
	{ 0x206ea7, 0xe8, 0x89 },
	{ 0x206ea8, 0xd8, 0x45 },
	{ 0x206ea9, 0x7e, 0xdc },
	{ 0x206eaa, 0x1, 0x8b },
	{ 0x206eab, 0x0, 0x45 },
	{ 0x206eac, 0xa1, 0xf8 },
	{ 0x206ead, 0x38, 0x89 },
	{ 0x206eae, 0x8a, 0x45 },
	{ 0x206eaf, 0x68, 0xe0 },
	{ 0x206eb0, 0x0, 0x8b },
	{ 0x206eb1, 0xc6, 0x45 },
	{ 0x206eb2, 0x0, 0xfc },
	{ 0x206eb3, 0x0, 0x89 },
	{ 0x206eb4, 0xe8, 0x45 },
	{ 0x206eb5, 0xff, 0xe4 },
	{ 0x206eb6, 0x83, 0xff },
	{ 0x206eb7, 0x1, 0x45 },
	{ 0x206eb8, 0x0, 0xdc },
	{-1,0,0}
};

PatchByte inputlagpatch_81_141[] = {
	{ 0x206d13, 0xe8, 0xa1 },
	{ 0x206d14, 0x10, 0x4c },
	{ 0x206d15, 0x98, 0x8c },
	{ 0x206d16, 0xf5, 0x68 },
	{ 0x206d17, 0xff, 0x0 },
	{ 0x206d18, 0x89, 0x83 },
	{ 0x206d19, 0x45, 0x38 },
	{ 0x206d1a, 0xf0, 0xff },
	{ 0x206d1b, 0x89, 0x75 },
	{ 0x206d1c, 0x55, 0x30 },
	{ 0x206d1d, 0xf4, 0xa1 },
	{ 0x206d1e, 0x8b, 0xd0 },
	{ 0x206d1f, 0x45, 0x91 },
	{ 0x206d20, 0xf0, 0x68 },
	{ 0x206d21, 0x8b, 0x0 },
	{ 0x206d22, 0x55, 0x80 },
	{ 0x206d23, 0xf4, 0x38 },
	{ 0x206d24, 0x3b, 0x0 },
	{ 0x206d25, 0x55, 0x74 },
	{ 0x206d26, 0xfc, 0x26 },
	{ 0x206d27, 0x75, 0xe8 },
	{ 0x206d28, 0x7, 0x30 },
	{ 0x206d29, 0x3b, 0x86 },
	{ 0x206d2a, 0x45, 0x1 },
	{ 0x206d2b, 0xf8, 0x0 },
	{ 0x206d2c, 0x73, 0xa1 },
	{ 0x206d2d, 0x10, 0x38 },
	{ 0x206d2e, 0xeb, 0x8a },
	{ 0x206d2f, 0x2, 0x68 },
	{ 0x206d30, 0x7d, 0x0 },
	{ 0x206d31, 0xc, 0x80 },
	{ 0x206d32, 0x8b, 0x38 },
	{ 0x206d33, 0x45, 0x0 },
	{ 0x206d34, 0xf0, 0x74 },
	{ 0x206d35, 0x89, 0x12 },
	{ 0x206d36, 0x45, 0xe8 },
	{ 0x206d37, 0xf8, 0x5 },
	{ 0x206d38, 0x8b, 0xa2 },
	{ 0x206d39, 0x45, 0xf5 },
	{ 0x206d3a, 0xf4, 0xff },
	{ 0x206d3b, 0x89, 0xe8 },
	{ 0x206d3c, 0x45, 0xb4 },
	{ 0x206d3d, 0xfc, 0x80 },
	{ 0x206d3e, 0xa1, 0x1 },
	{ 0x206d3f, 0x9c, 0x0 },
	{ 0x206d40, 0x93, 0xa1 },
	{ 0x206d41, 0x68, 0x38 },
	{ 0x206d42, 0x0, 0x8a },
	{ 0x206d43, 0x8b, 0x68 },
	{ 0x206d45, 0x83, 0xc6 },
	{ 0x206d46, 0x78, 0x0 },
	{ 0x206d47, 0x8, 0x0 },
	{ 0x206d48, 0x0, 0xe8 },
	{ 0x206d49, 0x7f, 0xef },
	{ 0x206d4a, 0xe, 0x85 },
	{ 0x206d4b, 0xa1, 0x1 },
	{ 0x206d4c, 0x9c, 0x0 },
	{ 0x206d4d, 0x93, 0xe8 },
	{ 0x206d4e, 0x68, 0xd6 },
	{ 0x206d4f, 0x0, 0x97 },
	{ 0x206d50, 0x8b, 0xf5 },
	{ 0x206d51, 0x0, 0xff },
	{ 0x206d52, 0xc7, 0x89 },
	{ 0x206d53, 0x40, 0x45 },
	{ 0x206d54, 0x8, 0xf0 },
	{ 0x206d55, 0x1, 0x89 },
	{ 0x206d56, 0x0, 0x55 },
	{ 0x206d57, 0x0, 0xf4 },
	{ 0x206d58, 0x0, 0x8b },
	{ 0x206d59, 0xa1, 0x45 },
	{ 0x206d5a, 0x9c, 0xf0 },
	{ 0x206d5b, 0x93, 0x8b },
	{ 0x206d5c, 0x68, 0x55 },
	{ 0x206d5d, 0x0, 0xf4 },
	{ 0x206d5e, 0x8b, 0x3b },
	{ 0x206d5f, 0x0, 0x55 },
	{ 0x206d60, 0xff, 0xfc },
	{ 0x206d61, 0x70, 0x75 },
	{ 0x206d62, 0x8, 0x7 },
	{ 0x206d63, 0xb8, 0x3b },
	{ 0x206d64, 0x40, 0x45 },
	{ 0x206d65, 0x42, 0xf8 },
	{ 0x206d66, 0xf, 0x73 },
	{ 0x206d67, 0x0, 0x10 },
	{ 0x206d68, 0x5a, 0xeb },
	{ 0x206d69, 0x8b, 0x2 },
	{ 0x206d6a, 0xca, 0x7d },
	{ 0x206d6b, 0x99, 0xc },
	{ 0x206d6c, 0xf7, 0x8b },
	{ 0x206d6d, 0xf9, 0x45 },
	{ 0x206d6e, 0x99, 0xf0 },
	{ 0x206d6f, 0x52, 0x89 },
	{ 0x206d70, 0x50, 0x45 },
	{ 0x206d71, 0x8b, 0xf8 },
	{ 0x206d72, 0x45, 0x8b },
	{ 0x206d73, 0xf0, 0x45 },
	{ 0x206d74, 0x8b, 0xf4 },
	{ 0x206d75, 0x55, 0x89 },
	{ 0x206d76, 0xf4, 0x45 },
	{ 0x206d77, 0x2b, 0xfc },
	{ 0x206d78, 0x45, 0xa1 },
	{ 0x206d79, 0xf8, 0x9c },
	{ 0x206d7a, 0x1b, 0x93 },
	{ 0x206d7b, 0x55, 0x68 },
	{ 0x206d7c, 0xfc, 0x0 },
	{ 0x206d7d, 0x29, 0x8b },
	{ 0x206d7e, 0x4, 0x0 },
	{ 0x206d7f, 0x24, 0x83 },
	{ 0x206d80, 0x19, 0x78 },
	{ 0x206d81, 0x54, 0x8 },
	{ 0x206d82, 0x24, 0x0 },
	{ 0x206d83, 0x4, 0x7f },
	{ 0x206d84, 0x58, 0xe },
	{ 0x206d85, 0x5a, 0xa1 },
	{ 0x206d86, 0x89, 0x9c },
	{ 0x206d87, 0x45, 0x93 },
	{ 0x206d88, 0xd0, 0x68 },
	{ 0x206d89, 0x89, 0x0 },
	{ 0x206d8a, 0x55, 0x8b },
	{ 0x206d8b, 0xd4, 0x0 },
	{ 0x206d8c, 0x83, 0xc7 },
	{ 0x206d8d, 0x7d, 0x40 },
	{ 0x206d8e, 0xd4, 0x8 },
	{ 0x206d8f, 0x0, 0x1 },
	{ 0x206d90, 0x75, 0x0 },
	{ 0x206d91, 0x8, 0x0 },
	{ 0x206d92, 0x83, 0x0 },
	{ 0x206d93, 0x7d, 0xa1 },
	{ 0x206d94, 0xd0, 0x9c },
	{ 0x206d95, 0x0, 0x93 },
	{ 0x206d96, 0x73, 0x68 },
	{ 0x206d97, 0x14, 0x0 },
	{ 0x206d98, 0xeb, 0x8b },
	{ 0x206d99, 0x2, 0x0 },
	{ 0x206d9a, 0x7d, 0xff },
	{ 0x206d9b, 0x10, 0x70 },
	{ 0x206d9c, 0xc7, 0x8 },
	{ 0x206d9d, 0x45, 0xb8 },
	{ 0x206d9e, 0xc8, 0x40 },
	{ 0x206d9f, 0x0, 0x42 },
	{ 0x206da0, 0x0, 0xf },
	{ 0x206da2, 0x0, 0x5a },
	{ 0x206da3, 0xc7, 0x8b },
	{ 0x206da4, 0x45, 0xca },
	{ 0x206da5, 0xcc, 0x99 },
	{ 0x206da6, 0x0, 0xf7 },
	{ 0x206da7, 0x0, 0xf9 },
	{ 0x206da8, 0x0, 0x99 },
	{ 0x206da9, 0x0, 0x52 },
	{ 0x206daa, 0xeb, 0x50 },
	{ 0x206dab, 0xc, 0x8b },
	{ 0x206dac, 0x8b, 0x45 },
	{ 0x206dad, 0x45, 0xf0 },
	{ 0x206dae, 0xd0, 0x8b },
	{ 0x206daf, 0x89, 0x55 },
	{ 0x206db0, 0x45, 0xf4 },
	{ 0x206db1, 0xc8, 0x2b },
	{ 0x206db2, 0x8b, 0x45 },
	{ 0x206db3, 0x45, 0xf8 },
	{ 0x206db4, 0xd4, 0x1b },
	{ 0x206db5, 0x89, 0x55 },
	{ 0x206db6, 0x45, 0xfc },
	{ 0x206db7, 0xcc, 0x29 },
	{ 0x206db8, 0x8b, 0x4 },
	{ 0x206db9, 0x45, 0x24 },
	{ 0x206dba, 0xc8, 0x19 },
	{ 0x206dbb, 0x89, 0x54 },
	{ 0x206dbc, 0x45, 0x24 },
	{ 0x206dbd, 0xe8, 0x4 },
	{ 0x206dbe, 0x8b, 0x58 },
	{ 0x206dbf, 0x45, 0x5a },
	{ 0x206dc0, 0xcc, 0x89 },
	{ 0x206dc1, 0x89, 0x45 },
	{ 0x206dc2, 0x45, 0xd0 },
	{ 0x206dc3, 0xec, 0x89 },
	{ 0x206dc4, 0x83, 0x55 },
	{ 0x206dc5, 0x7d, 0xd4 },
	{ 0x206dc6, 0xec, 0x83 },
	{ 0x206dc7, 0x0, 0x7d },
	{ 0x206dc8, 0x75, 0xd4 },
	{ 0x206dc9, 0xb, 0x0 },
	{ 0x206dca, 0x81, 0x75 },
	{ 0x206dcb, 0x7d, 0x8 },
	{ 0x206dcc, 0xe8, 0x83 },
	{ 0x206dcd, 0x40, 0x7d },
	{ 0x206dce, 0x42, 0xd0 },
	{ 0x206dcf, 0xf, 0x0 },
	{ 0x206dd0, 0x0, 0x73 },
	{ 0x206dd1, 0x73, 0x14 },
	{ 0x206dd2, 0x12, 0xeb },
	{ 0x206dd3, 0xeb, 0x2 },
	{ 0x206dd4, 0x2, 0x7d },
	{ 0x206dd5, 0x7d, 0x10 },
	{ 0x206dd6, 0xe, 0xc7 },
	{ 0x206dd7, 0x8b, 0x45 },
	{ 0x206dd8, 0x45, 0xc8 },
	{ 0x206dd9, 0xe8, 0x0 },
	{ 0x206dda, 0x89, 0x0 },
	{ 0x206ddb, 0x45, 0x0 },
	{ 0x206ddc, 0xc0, 0x0 },
	{ 0x206ddd, 0x8b, 0xc7 },
	{ 0x206ddf, 0xec, 0xcc },
	{ 0x206de0, 0x89, 0x0 },
	{ 0x206de1, 0x45, 0x0 },
	{ 0x206de2, 0xc4, 0x0 },
	{ 0x206de3, 0xeb, 0x0 },
	{ 0x206de4, 0xe, 0xeb },
	{ 0x206de5, 0xc7, 0xc },
	{ 0x206de6, 0x45, 0x8b },
	{ 0x206de7, 0xc0, 0x45 },
	{ 0x206de8, 0x40, 0xd0 },
	{ 0x206de9, 0x42, 0x89 },
	{ 0x206dea, 0xf, 0x45 },
	{ 0x206deb, 0x0, 0xc8 },
	{ 0x206dec, 0xc7, 0x8b },
	{ 0x206dee, 0xc4, 0xd4 },
	{ 0x206def, 0x0, 0x89 },
	{ 0x206df0, 0x0, 0x45 },
	{ 0x206df1, 0x0, 0xcc },
	{ 0x206df2, 0x0, 0x8b },
	{ 0x206df3, 0x8b, 0x45 },
	{ 0x206df4, 0x45, 0xc8 },
	{ 0x206df5, 0xc0, 0x89 },
	{ 0x206df6, 0x89, 0x45 },
	{ 0x206df7, 0x45, 0xe8 },
	{ 0x206df8, 0xe8, 0x8b },
	{ 0x206df9, 0x8b, 0x45 },
	{ 0x206dfa, 0x45, 0xcc },
	{ 0x206dfb, 0xc4, 0x89 },
	{ 0x206dfc, 0x89, 0x45 },
	{ 0x206dfd, 0x45, 0xec },
	{ 0x206dfe, 0xec, 0x83 },
	{ 0x206dff, 0xff, 0x7d },
	{ 0x206e00, 0x75, 0xec },
	{ 0x206e01, 0xec, 0x0 },
	{ 0x206e02, 0xff, 0x75 },
	{ 0x206e03, 0x75, 0xb },
	{ 0x206e04, 0xe8, 0x81 },
	{ 0x206e05, 0xe8, 0x7d },
	{ 0x206e06, 0xaa, 0xe8 },
	{ 0x206e07, 0x97, 0x40 },
	{ 0x206e08, 0xf5, 0x42 },
	{ 0x206e09, 0xff, 0xf },
	{ 0x206e0a, 0x8b, 0x0 },
	{ 0x206e0b, 0x45, 0x73 },
	{ 0x206e0c, 0xf0, 0x12 },
	{ 0x206e0d, 0x8b, 0xeb },
	{ 0x206e0e, 0x55, 0x2 },
	{ 0x206e0f, 0xf4, 0x7d },
	{ 0x206e10, 0x3, 0xe },
	{ 0x206e11, 0x45, 0x8b },
	{ 0x206e12, 0xe8, 0x45 },
	{ 0x206e13, 0x13, 0xe8 },
	{ 0x206e14, 0x55, 0x89 },
	{ 0x206e15, 0xec, 0x45 },
	{ 0x206e16, 0x89, 0xc0 },
	{ 0x206e17, 0x45, 0x8b },
	{ 0x206e18, 0xf8, 0x45 },
	{ 0x206e19, 0x89, 0xec },
	{ 0x206e1a, 0x55, 0x89 },
	{ 0x206e1b, 0xfc, 0x45 },
	{ 0x206e1c, 0x8b, 0xc4 },
	{ 0x206e1d, 0x45, 0xeb },
	{ 0x206e1e, 0xf8, 0xe },
	{ 0x206e1f, 0x8b, 0xc7 },
	{ 0x206e20, 0x55, 0x45 },
	{ 0x206e21, 0xfc, 0xc0 },
	{ 0x206e22, 0x3b, 0x40 },
	{ 0x206e23, 0x55, 0x42 },
	{ 0x206e24, 0xe4, 0xf },
	{ 0x206e25, 0x75, 0x0 },
	{ 0x206e26, 0x7, 0xc7 },
	{ 0x206e27, 0x3b, 0x45 },
	{ 0x206e28, 0x45, 0xc4 },
	{ 0x206e29, 0xe0, 0x0 },
	{ 0x206e2a, 0x73, 0x0 },
	{ 0x206e2b, 0x10, 0x0 },
	{ 0x206e2c, 0xeb, 0x0 },
	{ 0x206e2d, 0x2, 0x8b },
	{ 0x206e2e, 0x7d, 0x45 },
	{ 0x206e2f, 0xc, 0xc0 },
	{ 0x206e30, 0x8b, 0x89 },
	{ 0x206e32, 0xf8, 0xe8 },
	{ 0x206e33, 0x89, 0x8b },
	{ 0x206e35, 0xe0, 0xc4 },
	{ 0x206e36, 0x8b, 0x89 },
	{ 0x206e38, 0xfc, 0xec },
	{ 0x206e39, 0x89, 0xff },
	{ 0x206e3a, 0x45, 0x75 },
	{ 0x206e3b, 0xe4, 0xec },
	{ 0x206e3c, 0x6a, 0xff },
	{ 0x206e3d, 0x0, 0x75 },
	{ 0x206e3e, 0x68, 0xe8 },
	{ 0x206e3f, 0x40, 0xe8 },
	{ 0x206e40, 0x42, 0x70 },
	{ 0x206e41, 0xf, 0x97 },
	{ 0x206e42, 0x0, 0xf5 },
	{ 0x206e43, 0x8b, 0xff },
	{ 0x206e44, 0x45, 0x8b },
	{ 0x206e45, 0xf8, 0x45 },
	{ 0x206e46, 0x8b, 0xf0 },
	{ 0x206e47, 0x55, 0x8b },
	{ 0x206e48, 0xfc, 0x55 },
	{ 0x206e49, 0xe8, 0xf4 },
	{ 0x206e4a, 0x1e, 0x3 },
	{ 0x206e4b, 0x1d, 0x45 },
	{ 0x206e4c, 0xe0, 0xe8 },
	{ 0x206e4d, 0xff, 0x13 },
	{ 0x206e4e, 0x52, 0x55 },
	{ 0x206e4f, 0x50, 0xec },
	{ 0x206e50, 0x6a, 0x89 },
	{ 0x206e51, 0x0, 0x45 },
	{ 0x206e52, 0x68, 0xf8 },
	{ 0x206e53, 0x40, 0x89 },
	{ 0x206e54, 0x42, 0x55 },
	{ 0x206e55, 0xf, 0xfc },
	{ 0x206e56, 0x0, 0x8b },
	{ 0x206e57, 0x8b, 0x45 },
	{ 0x206e58, 0x45, 0xf8 },
	{ 0x206e59, 0xe0, 0x8b },
	{ 0x206e5a, 0x8b, 0x55 },
	{ 0x206e5b, 0x55, 0xfc },
	{ 0x206e5c, 0xe4, 0x3b },
	{ 0x206e5d, 0xe8, 0x55 },
	{ 0x206e5e, 0xa, 0xe4 },
	{ 0x206e5f, 0x1d, 0x75 },
	{ 0x206e60, 0xe0, 0x7 },
	{ 0x206e61, 0xff, 0x3b },
	{ 0x206e62, 0x3b, 0x45 },
	{ 0x206e63, 0x54, 0xe0 },
	{ 0x206e64, 0x24, 0x73 },
	{ 0x206e65, 0x4, 0x10 },
	{ 0x206e66, 0x75, 0xeb },
	{ 0x206e67, 0x9, 0x2 },
	{ 0x206e68, 0x3b, 0x7d },
	{ 0x206e69, 0x4, 0xc },
	{ 0x206e6a, 0x24, 0x8b },
	{ 0x206e6b, 0x5a, 0x45 },
	{ 0x206e6c, 0x58, 0xf8 },
	{ 0x206e6d, 0x73, 0x89 },
	{ 0x206e6e, 0x21, 0x45 },
	{ 0x206e6f, 0xeb, 0xe0 },
	{ 0x206e70, 0x4, 0x8b },
	{ 0x206e71, 0x5a, 0x45 },
	{ 0x206e72, 0x58, 0xfc },
	{ 0x206e73, 0x7d, 0x89 },
	{ 0x206e74, 0x1b, 0x45 },
	{ 0x206e75, 0xa1, 0xe4 },
	{ 0x206e76, 0x2c, 0x6a },
	{ 0x206e77, 0x89, 0x0 },
	{ 0x206e79, 0x0, 0x40 },
	{ 0x206e7a, 0x8b, 0x42 },
	{ 0x206e7b, 0x55, 0xf },
	{ 0x206e7c, 0xdc, 0x0 },
	{ 0x206e7d, 0x89, 0x8b },
	{ 0x206e7e, 0x10, 0x45 },
	{ 0x206e7f, 0x33, 0xf8 },
	{ 0x206e80, 0xc0, 0x8b },
	{ 0x206e81, 0x89, 0x55 },
	{ 0x206e82, 0x45, 0xfc },
	{ 0x206e83, 0xdc, 0xe8 },
	{ 0x206e84, 0x8b, 0xe4 },
	{ 0x206e85, 0x45, 0x1c },
	{ 0x206e86, 0xf8, 0xe0 },
	{ 0x206e87, 0x89, 0xff },
	{ 0x206e88, 0x45, 0x52 },
	{ 0x206e89, 0xe0, 0x50 },
	{ 0x206e8a, 0x8b, 0x6a },
	{ 0x206e8b, 0x45, 0x0 },
	{ 0x206e8c, 0xfc, 0x68 },
	{ 0x206e8d, 0x89, 0x40 },
	{ 0x206e8e, 0x45, 0x42 },
	{ 0x206e8f, 0xe4, 0xf },
	{ 0x206e90, 0xff, 0x0 },
	{ 0x206e91, 0x45, 0x8b },
	{ 0x206e92, 0xdc, 0x45 },
	{ 0x206e93, 0xa1, 0xe0 },
	{ 0x206e94, 0x4c, 0x8b },
	{ 0x206e95, 0x8c, 0x55 },
	{ 0x206e96, 0x68, 0xe4 },
	{ 0x206e97, 0x0, 0xe8 },
	{ 0x206e98, 0x83, 0xd0 },
	{ 0x206e99, 0x38, 0x1c },
	{ 0x206e9a, 0xff, 0xe0 },
	{ 0x206e9b, 0x75, 0xff },
	{ 0x206e9c, 0x30, 0x3b },
	{ 0x206e9d, 0xa1, 0x54 },
	{ 0x206e9e, 0xd0, 0x24 },
	{ 0x206e9f, 0x91, 0x4 },
	{ 0x206ea0, 0x68, 0x75 },
	{ 0x206ea1, 0x0, 0x9 },
	{ 0x206ea2, 0x80, 0x3b },
	{ 0x206ea3, 0x38, 0x4 },
	{ 0x206ea4, 0x0, 0x24 },
	{ 0x206ea5, 0x74, 0x5a },
	{ 0x206ea6, 0x26, 0x58 },
	{ 0x206ea7, 0xe8, 0x73 },
	{ 0x206ea8, 0xb0, 0x21 },
	{ 0x206ea9, 0x84, 0xeb },
	{ 0x206eaa, 0x1, 0x4 },
	{ 0x206eab, 0x0, 0x5a },
	{ 0x206eac, 0xa1, 0x58 },
	{ 0x206ead, 0x38, 0x7d },
	{ 0x206eae, 0x8a, 0x1b },
	{ 0x206eaf, 0x68, 0xa1 },
	{ 0x206eb0, 0x0, 0x2c },
	{ 0x206eb1, 0x80, 0x89 },
	{ 0x206eb2, 0x38, 0x68 },
	{ 0x206eb4, 0x74, 0x8b },
	{ 0x206eb5, 0x12, 0x55 },
	{ 0x206eb6, 0xe8, 0xdc },
	{ 0x206eb7, 0x85, 0x89 },
	{ 0x206eb8, 0xa0, 0x10 },
	{ 0x206eb9, 0xf5, 0x33 },
	{ 0x206eba, 0xff, 0xc0 },
	{ 0x206ebb, 0xe8, 0x89 },
	{ 0x206ebc, 0x34, 0x45 },
	{ 0x206ebd, 0x7f, 0xdc },
	{ 0x206ebe, 0x1, 0x8b },
	{ 0x206ebf, 0x0, 0x45 },
	{ 0x206ec0, 0xa1, 0xf8 },
	{ 0x206ec1, 0x38, 0x89 },
	{ 0x206ec2, 0x8a, 0x45 },
	{ 0x206ec3, 0x68, 0xe0 },
	{ 0x206ec4, 0x0, 0x8b },
	{ 0x206ec5, 0xc6, 0x45 },
	{ 0x206ec6, 0x0, 0xfc },
	{ 0x206ec7, 0x0, 0x89 },
	{ 0x206ec8, 0xe8, 0x45 },
	{ 0x206ec9, 0x6f, 0xe4 },
	{ 0x206eca, 0x84, 0xff },
	{ 0x206ecb, 0x1, 0x45 },
	{ 0x206ecc, 0x0, 0xdc },
	{-1,0,0}
};
