//
// Simple upright billboard, for instanced vegetation
// Waving in the wind... using auto_Time to animate the vegetation
//
// With shader controlled instances the vertex position is the origin of the instance
// the offset from the center is passed through in_TexCoord1
// 

//
// The vertex shader
//
vertexshader {

	// input from gile[s]
	attribute vec3 in_Position;	// Vertex Position
	attribute vec3 in_Normal;	// Vertex Normal
	attribute vec4 in_Tangent;	// Vertex Tangent
	attribute vec4 in_Color;	// Vertex Color + Alpha
	attribute vec2 in_TexCoord0;	// Vertex Tex Coord 0
	attribute vec2 in_TexCoord1;	// Vertex Tex Coord 1

	// automatically tracked uniforms from gile[s]
	uniform int	auto_LightMethod;
	uniform float	auto_Time;
	uniform vec3	auto_CameraPos;
	uniform mat4	auto_WorldMatrix;
	
	// output to fragment shader
	varying vec2 _texcoord0;
	varying vec2 _texcoord1;
	varying vec4 _color;
	
	void main(){
	
		_texcoord0 = in_TexCoord0;
		
		vec3 normal    = normalize(gl_NormalMatrix * in_Normal);

		vec3 front = normalize( in_Position - auto_CameraPos );
		vec3 right = cross( vec3( 0.0, 1.0, 0.0 ), front );

		float wave = sin(auto_Time + in_Position.x)*min(1.0,in_TexCoord1.y)*0.1;
		vec3 displace = (in_TexCoord1.x + wave) * right;

		vec4 tmp = vec4(in_Position+displace,1.0);
		tmp.y += in_TexCoord1.y;
		vec3 vpos  = vec3(gl_ModelViewMatrix * tmp);
		vec3 lpos  = gl_LightSource[0].position.xyz - (vpos*sign(gl_LightSource[0].position.w));

		lpos = normalize(lpos);
	
		_color	= gl_LightSource[0].diffuse * in_Color * dot(lpos,normal);
		_color += gl_LightModel.ambient;
		_color.a = in_Color.a;

		gl_Position = gl_ModelViewProjectionMatrix * tmp;
	}

}

//
// The fragment shader
//
fragmentshader {
	
	// user tweakables
	uniform sampler2D DiffuseMap;

	// Input from vertex shader
	varying vec2 _texcoord0;
	varying vec2 _texcoord1;
	varying vec4 _color;
	
	void main(){
	
		vec4 dif = texture2D(DiffuseMap, _texcoord0);
		vec4 final = _color*dif;

		gl_FragColor = final;
	
	}
	
}