
//
// The vertex shader
//
vertexshader {

	// input from gile[s]
	attribute vec3 in_Position;	// Vertex Position
	attribute vec3 in_Normal;	// Vertex Normal
	attribute vec4 in_Tangent;	// Vertex Tangent
	attribute vec4 in_Color;	// Vertex Color + Alpha
	attribute vec2 in_TexCoord0;	// Vertex Tex Coord 0
	attribute vec2 in_TexCoord1;	// Vertex Tex Coord 1 (typically for the lightmap)

	// automatically tracked uniforms from gile[s]
	uniform float	auto_Time;
	uniform mat4	auto_WorldMatrix;
	
	// output to fragment shader
	varying vec2 _texcoord0;
	varying vec2 _texcoord1;
	varying vec4 _color;
	varying vec3 _lightvec;
	varying vec3 _eyevec;
	
	void main(){
	
		_texcoord0 = in_TexCoord0;
		_texcoord1 = in_TexCoord1;

		vec3 normal    = normalize(gl_NormalMatrix * in_Normal);
		vec3 tangent   = normalize(gl_NormalMatrix * in_Tangent.xyz);
		vec3 binormal  = normalize(cross(normal,tangent) * in_Tangent.w);

		vec3 vpos  = vec3(gl_ModelViewMatrix * vec4(in_Position,1.0));
		vec3 lpos  = gl_LightSource[0].position.xyz - (vpos*sign(gl_LightSource[0].position.w));
	
		_lightvec.x = dot(lpos, tangent);
		_lightvec.y = dot(lpos, binormal);
		_lightvec.z = dot(lpos, normal);
	
		vpos = -vpos;
		_eyevec.x = dot(vpos, tangent);
		_eyevec.y = dot(vpos, binormal);
		_eyevec.z = dot(vpos, normal);
	
		_color = gl_LightSource[0].diffuse * in_Color;
		_color.a = in_Color.a;

		gl_Position = gl_ModelViewProjectionMatrix * vec4(in_Position,1.0);
	}

}

//
// The fragment shader
//
fragmentshader {
	
	// user tweakables
	uniform vec4 Color
	<
		default = vec4(1.0,1.0,1.0,1.0);
		color = true;
	>;

	uniform float Specular
	<
		default = 0.0;
		min = 0.0;
		max = 1.0;
		step = 0.1;
	>;
	uniform float Glossiness
	<
		default = 1.0;
		min = 1.0;
		max = 128.0;	
		step = 1.0;
	>;
	uniform sampler2D DiffuseMap;
	uniform sampler2D SpecularMap;
	uniform sampler2D NormalMap;
	// auto tracked!
	uniform sampler2D auto_Lightmap;
	uniform int	auto_LightMethod;

	// Input from vertex shader
	varying vec2 _texcoord0;
	varying vec2 _texcoord1;
	varying vec4 _color;
	varying vec3 _lightvec;
	varying vec3 _eyevec;
	
	void main(){
	
		vec3 vvec = normalize(_eyevec);
		vec3 lvec = normalize(_lightvec);
	
		vec4 dif = texture2D(DiffuseMap, _texcoord0);
		vec4 spc = texture2D(SpecularMap, _texcoord0);
		vec3 nor = normalize( texture2D(NormalMap, _texcoord0).xyz * 2.0 - 1.0);
		nor.y = -nor.y;
		nor.x = -nor.x;
	
		vec4 vAmbient = gl_LightModel.ambient * gl_FrontMaterial.ambient;
		vec4 ambOcc = vec4(1.0,1.0,1.0,1.0);
		if (auto_LightMethod == 2){
			// ambient occlusion lightmapping
			ambOcc = texture2D(auto_Lightmap, _texcoord1) * 2.0;
		}
	
		float diffuse = max( dot(lvec, nor), 0.0 );
		vec4 vDiffuse = _color * Color * diffuse;	
	
		float spec = pow(max(dot(reflect(-lvec, nor), vvec), 0.0), Glossiness );
		vec4 vSpec = gl_LightSource[0].specular * Specular * spec;	
	
		vec4 final = ( (vAmbient+vDiffuse)*dif + vSpec*spc ) * ambOcc;
		final.a = dif.a*_color.a*Color.a;

		gl_FragColor = final;
	
	}
	
}