
-- utility functions

-------------------------------------------------------------------------------
-- converts radians to degrees
function rad2deg(rads)
return (rads * 360 / (2 * PI))
end


-------------------------------------------------------------------------------
-- converts degrees to radians
function deg2rad(deg)
return ((2 * PI * deg) / 360)
end


-------------------------------------------------------------------------------
-- if the 1st parameter equals nil print an error
function assert(p, msg)
if not msg then msg = "Script Error." end
if not p then error(msg) end
end



-------------------------------------------------------------------------------
-- finds a joint by his id and returns the fxBone object if a joint with this
-- id exists, otherwise nil
function FindJoint(n)
local scene = GetScene()
local node = scene:GetFirstNode()
while (node)
	do
	if node:GetClassName() == "fxBone" then
		do
		local bone = tobone(node)
		if (bone:GetId() == n) then return bone end
		end	
	end	
	
	node = scene:GetNextNode()
	end
end


-------------------------------------------------------------------------------
-- finds the material with this id and returns a pointer
function FindMaterial(id)
local i
for i = 0, GetTextureCount()-1,1
	do
	local tex = GetTexture(i)
	if (tex:GetId() == id) then return tex end
	end
return nil
end


-------------------------------------------------------------------------------
-- iterates through all the nodes in the scene and calls callback with the node
-- as parameter
function IterateNodes(callback)
if callback then
	local Scene = GetScene()
	local Node = Scene:GetFirstNode()
	while Node
   	do
		callback(Node)
		Node = Scene:GetNextNode()
		end
	end
end


