
-- Saves the current scene

-- save one bone
------------------------------------------------------------------------------------------
function save_bone(parent, node)
local bone = tobone(node)
write(fh, "bone = scene:CreateBone()\n")

write(fh, 'bone:SetName("')
write(fh, bone:GetName())
write(fh, '")\n')

local r,g,b = bone:GetColor()
write(fh, "bone:SetColor(",r, ", ", g, ", ", b, ")\n")

write(fh, 'bone:SetIKChainEnd(', bone:IsIKChainEnd(), ')\n')
write(fh, 'bone:SetIKWeight(', bone:GetIKWeight(), ')\n')

local x_status, x_min, x_max
x_status = 1
x_min = 1
x_max = 1
x_status, x_min, x_max = bone:GetXConstraints(x_status, x_min, x_max)

local y_status, y_min, y_max
y_status = 1
y_min = 1
y_max = 1
y_status, y_min, y_max = bone:GetYConstraints(y_status, y_min, y_max)

local z_status, z_min, z_max
z_status = 1
z_min = 1
z_max = 1
z_status, z_min, z_max = bone:GetZConstraints(z_status, z_min, z_max)

write(fh, 'bone:SetXConstraints(', x_status, ', ', x_min, ', ', x_max, ')\n')
write(fh, 'bone:SetYConstraints(', y_status, ', ', y_min, ', ', y_max, ')\n')
write(fh, 'bone:SetZConstraints(', z_status, ', ', z_min, ', ', z_max, ')\n')

matrix = bone:GetLocalMatrix()
write(fh, "matrix = matrix44:new()\n")
write(fh, "matrix:set(")

for i = 0,3,1
	do
	for j = 0,3,1
		do
		write(fh,matrix:M(i,j))
		if ((i ~=3) or (j ~= 3)) then write(fh, ",") end
		end
	end
write(fh, ")\n")
write(fh, "bone:SetMatrix(matrix)\n")
write(fh, "matrix:delete()\n")

-- save keys
for i = 0, bone:GetKeyCount()-1,1
	do
	key = bone:GetKey(i)
	matrix = key.matrix
	write(fh, "matrix = matrix44:new()\n")
	write(fh, "matrix:set(")

	for i = 0,3,1
		do
		for j = 0,3,1
			do
			write(fh,matrix:M(i,j))
			if ((i ~=3) or (j ~= 3)) then write(fh, ",") end
			end
		end
	write(fh, ")\n")

	write(fh, "bone:SetKey(")
	write(fh, key.frame, ",")
	write(fh, "matrix,")
   write(fh, key.trans_tcb.x, ",")
   write(fh, key.trans_tcb.y, ",")
   write(fh, key.trans_tcb.z, ",")
   write(fh, key.rot_tcb.x, ",")
   write(fh, key.rot_tcb.y, ",")
   write(fh, key.rot_tcb.z, ")\n")
	write(fh, "matrix:delete()\n")
	end

write(fh, "bone:SetId(", bone:GetId(), ")\n")
write(fh, "bone",bone:GetId()," = bone\n")

classname = parent:GetClassName()
if (strfind(classname, "fxBone")) then
	do
	pbone = tobone(parent)
	write(fh, "bone",pbone:GetId(),":AttachChild(bone)\n")
	end
	else write(fh, "rootnode:AttachChild(bone)\n")
end

-- save children
local lauf = 0
for lauf = 0, bone:GetChildCount()-1,1
	do
	local node = bone:GetChild(lauf)
	local classname = node:GetClassName()
	if strfind(classname, "fxMesh") then save_mesh(bone, node) end
	if strfind(classname, "fxBone") then save_bone(bone, node) end
	end


end

-- save one fxMesh
------------------------------------------------------------------------------------------
function save_mesh(parent, node)
mesh = tomesh(node)
write(fh, "mesh = scene:CreateMesh()\n")

write(fh, "mesh:SetMaterial(",mesh:GetMaterial(), ")\n")

write(fh, 'mesh:SetName("')
write(fh, mesh:GetName())
write(fh, '")\n')

local r,g,b = mesh:GetColor()
write(fh, "mesh:SetColor(",r, ", ", g, ", ", b, ")\n")


matrix = mesh:GetMatrix()
write(fh, "matrix = matrix44:new()\n")
write(fh, "matrix:set(")
for i = 0,3,1
	do
	for j = 0,3,1
		do
		write(fh,matrix:M(i,j))
		if ((i ~=3) or (j ~= 3)) then write(fh, ",") end
		end
	end
write(fh, ")\n")
write(fh, "mesh:SetMatrix(matrix)\n")
write(fh, "matrix:delete()\n")

-- save the vertices
write(fh, "v = fxVertex:new()\n")
for i = 0, mesh:GetVertexCount()-1,1
	do
	v = mesh:GetVertex(i)
	write(fh, "v:set(")
        write(fh, "false,")
        write(fh, v.position.x, ",")
        write(fh, v.position.y, ",")
	write(fh, v.position.z, ",")
	write(fh, v.normal.x,   ",")
  	write(fh, v.normal.y,   ",")
	write(fh, v.normal.z,   ",")
	write(fh, v.texcoords.x,",")
	write(fh, v.texcoords.y,",")
	write(fh, v.bone[1],    ",")
	write(fh, v.bone[2],    ",")
	write(fh, v.bone[3],    ",")
	write(fh, v.bone[4],    ",")
	write(fh, v.weight[1],  ",")
	write(fh, v.weight[2],  ",")
  	write(fh, v.weight[3],  ",")
	write(fh, v.weight[4], ")\n")

	write(fh, "v",i," = mesh:AddVertex(v)", "\n")
	end
write(fh, "v:delete()\n")

-- save the faces

for i = 0, mesh:GetFaceCount()-1,1
	do
	f1, f2, f3 = mesh:GetFace(i)
	write(fh, "mesh:AddFace(v", f1, ",v", f2, ",v", f3, ")\n")
	end

--finally link the mesh into the scene
write(fh, "rootnode:AttachChild(mesh)\n")
end

-- save the materials
---------------------------------------------------------------------------------------------------
function save_materials()
local mat_count = GetTextureCount()
for i = 0,mat_count-1,1
	do
	mat = GetTexture(i)

	write(fh, 'mat = AddTexture("')
	write(fh, mat:GetFileName())
	write(fh, '")\n')
	write(fh, "if (mat) then mat:SetId(", mat:GetId(), ') else print("Texture not found: ',mat:GetFileName() ,'") end\n')

	end

end


-- saves the workspace
---------------------------------------------------------------------------------------------------
function save_viewports()
   local i
   write(fh, "CloseAllViewports()\n")
   for i = 0,GetViewportCount()-1,1
      do
      local vp = GetViewport(i)
      write(fh, "vp = CreateViewport()\n")
      local left, top, width, height = vp:GetRect()
      local s = format("%.8f, %.8f, %.8f, %.8f", left, top, width, height)
      write(fh, "vp:SetRect(",s,")\n")

      local data = vp:GetData1()
      write(fh, "vp:SetData1(", data.x, ", ", data.y, ", ", data.z,")\n")
      local data = vp:GetData2()
      write(fh, "vp:SetData2(", data.x, ", ", data.y, ", ", data.z,")\n")
      local data = vp:GetData3()
      write(fh, "vp:SetData3(", data.x, ", ", data.y, ", ", data.z,")\n")
      local data = vp:GetData4()
      write(fh, "vp:SetData4(", data.x, ", ", data.y, ", ", data.z,")\n")
      local data = vp:GetData5()
      write(fh, "vp:SetData5(", data.x, ", ", data.y, ", ", data.z,")\n")

      local proj = vp:GetProjection()
      write(fh, "vp:SetProjection(",proj,")\n")

      local drawmode = vp:GetDrawMode()
      write(fh, "vp:SetDrawMode(",drawmode,")\n")   

      local drawbf = vp:GetDrawBF()
      write(fh, "vp:SetDrawBF(",drawbf,")\n")

      local drawgrid = vp:GetDrawGrid()
      write(fh, "vp:SetDrawGrid(",drawgrid,")\n")

      write(fh, "RedrawViewports()\n")
      end
end


-- main function
---------------------------------------------------------------------------------------------------
function save(filename)
fh = openfile(filename, "wt")
if not fh then error("Could not create file!") end

write(fh, "CheckFileVersion(", GetFileVersion(), ")\n");

write(fh, "scene = GetScene()\n")
write(fh, "rootnode = scene:GetRootNode()\n")
write(fh, "SetTotalFrames(",GetTotalFrames(),")\n")
write(fh, "SetFrame(", GetFrame(), ")\n")
write(fh, "SetFrameRate(",GetFrameRate(),")\n")

save_viewports()

scene = GetScene()
root = scene:GetRootNode()

save_materials()

for i = 0, root:GetChildCount()-1,1
	do
	node = root:GetChild(i)
	classname = node:GetClassName()
	if strfind(classname, "fxMesh") then save_mesh(root, node) end
	if strfind(classname, "fxBone") then save_bone(root, node) end
	end

closefile(fh)
print("Scene saved.")
end
