
-- Quake2 md2 exporter

RegisterExporter("Quake2 Model (*.md2)", "*.md2", "md2.export")
md2 = {}

---------------------------------------------------------------------------------
function md2.procces_mesh(node)

	if node:GetClassName() == "fxMesh" then

		local mesh = tomesh(node)

		md2.num_meshes = md2.num_meshes + 1

		-- stream face info
		local i
		for i = 0, mesh:GetFaceCount()-1,1
			do
			local v1,v2,v3
			v1,v2,v3 = mesh:GetFace(i)
			md2_AddTriangle(v1,v2,v3)
			end

		-- stream vertices and step through animation
		ProgressWindowMinMax(1, GetTotalFrames())
		ProgressWindowSet(1)
		ProgressWindowShow()
		for i = 1, GetTotalFrames(),1
			do
			SetFrame(i)
			ProgressWindowSet(i)
			md2_BeginFrame()

			local v
			for v = 0, mesh:GetVertexCount()-1,1
				do
				local vertex = mesh:GetTransformedVertex(v)
				md2_AddVertex(vertex.position.x, vertex.position.y, vertex.position.z, vertex.normal.x, vertex.normal.y, vertex.normal.z, vertex.texcoords.x, vertex.texcoords.y)
				end

			md2_EndFrame()

			end
		ProgressWindowHide()

		end

end


function md2.CountMeshes()
   -- returns the number of meshes in the scene
   local scene = GetScene()
   local node = scene:GetFirstNode()
   md2.mesh_counter = 0
   while node
      do
      if (node:GetClassName() == "fxMesh") then
         do
         md2.mesh_counter = md2.mesh_counter + 1
         end
      end -- if
      node = scene:GetNextNode()
      end
   return md2.mesh_counter
end

---------------------------------------------------------------------------------
function md2.streamVertices()

print("streaming frames...")

ProgressWindowMinMax(1, GetTotalFrames())
ProgressWindowSet(1)
ProgressWindowShow()

for i = 1, GetTotalFrames(),1
  do
	SetFrame(i)
	ProgressWindowSet(i)
	md2_BeginFrame()

  scene = GetScene()
  node = scene:GetFirstNode()

  while node
    do
    if node:GetClassName() == "fxMesh" then
      local mesh = tomesh(node)
    	local v
    	for v = 0, mesh:GetVertexCount()-1,1
    		do
    		local vertex = mesh:GetTransformedVertex(v)
    		md2_AddVertex(vertex.position.x, vertex.position.y, vertex.position.z, vertex.normal.x, vertex.normal.y, vertex.normal.z, vertex.texcoords.x, vertex.texcoords.y)
    		end

      end --if
    node = scene:GetNextNode()
    end --while

	md2_EndFrame()

  end

ProgressWindowHide()

end

---------------------------------------------------------------------------------
function md2.streamFaceInfo()

print("streaming faces...")

scene = GetScene()
node = scene:GetFirstNode()

vertexCount = 0

while node
  do
  if node:GetClassName() == "fxMesh" then
    local mesh = tomesh(node)
    local i
		for i = 0, mesh:GetFaceCount()-1,1
			do
			local v1,v2,v3
			v1,v2,v3 = mesh:GetFace(i)
      v1 = v1 + vertexCount
      v2 = v2 + vertexCount
      v3 = v3 + vertexCount
			md2_AddTriangle(v1,v2,v3)
			end --for
    vertexCount = vertexCount + mesh:GetVertexCount()
    end --if
  node = scene:GetNextNode()
  end --while

end


---------------------------------------------------------------------------------
function md2.export(filename)

	local file = filename..".md2"

	local cframe = GetFrame()

	md2_BeginModel(file)

	md2.num_meshes = 0
  md2.streamFaceInfo()
  md2.streamVertices()
  
  --IterateNodes(md2.procces_mesh)

  --if md2.num_meshes > 1 then print("Warning: This model contains more than one mesh! The md2 format supports only one mesh.") end

	md2_EndModel()

	SetFrame(cframe)

end
