
-- WaveFront OBJ File support (import and export)

RegisterImporter("WaveFront (*.obj)", "*.obj", "ImportOBJ")
RegisterExporter("WaveFront (*.obj)", "*.obj", "ExportOBJ", 1)



function ImportOBJ(filename)


	-- Finds the first word in a string
	function FirstWord(s)
		if not s then return nil end
		if (s == "") then return nil end
		i = strfind(s, " ", 1, 1)
		if not i then return nil, s else return strsub(s,i+1) , strsub(s,1,i-1) end
	end

	-- Gets the first element of a string of the form : v/vt/vn and returns it
	-- as well as the rest of the string
	function GetFirstElement(s)
		if not s then return "" end
		i = strfind(s, "/",1,1)
		if not i then return s else return strsub(s,1,i-1), strsub(s, i+1) end
	end


	-- Import

	Scene = GetScene()
	RootNode = Scene:GetRootNode()
	Mesh = Scene:CreateMesh()

	-- Open the file
	filehandle = openfile(filename, "rt")
	if not filehandle then error("Error opening the file!") end

	v_array = {}
	vn_array = {}
	vt_array = {}

	v_count = 0
	vn_count = 0
	vt_count = 0

   face_read = 0
   first_face_read = 0
   flush_buffer = 0

   no_normals = 0

	local fsize = seek(filehandle, "end") 
	seek(filehandle, "set")

	ProgressWindowMinMax(1, fsize)
	ProgressWindowShow()

	w = read(filehandle, "*w")
	while (w) 
		do
		progress_v = seek(filehandle)
		if not progress_v then progress_v = 1 end
		ProgressWindowSet(progress_v)
		if (w == "v") then
			do

			-- this the position component, 3 numbers follow

         if (face_read == 1) and (flush_buffer == 1) then
            do
         	v_array = {}
         	vn_array = {}
         	vt_array = {}

         	v_count = 0
         	vn_count = 0
         	vt_count = 0

            face_read = 0
            flush_buffer = 0
            end
         end

			-- x component
			w = read(filehandle, "*n")
			if not w then error("Broken v statement!") end
			v_count = v_count + 1
			v_array[v_count] = w

			-- y component
			w = read(filehandle, "*n")
			if not w then error("Broken v statement!") end
			v_count = v_count + 1
			v_array[v_count] = w

			-- z component
			w = read(filehandle, "*n")
			if not w then error("Broken v statement!") end
			v_count = v_count + 1
			v_array[v_count] = w
			end
		end

		if (w == "vn") then
			do

			-- this a normal component, 3 numbers follow
         if (face_read == 1) and (flush_buffer == 1) then
            do
         	v_array = {}
         	vn_array = {}
         	vt_array = {}

         	v_count = 0
         	vn_count = 0
         	vt_count = 0

            face_read = 0
            flush_buffer = 0
            end
         end

			-- x component
			w = read(filehandle, "*n")
			if not w then error("Broken vn statement!") end
			vn_count = vn_count + 1
			vn_array[vn_count] = w

			-- y component
			w = read(filehandle, "*n")
			if not w then error("Broken vn statement!") end
			vn_count = vn_count + 1
			vn_array[vn_count] = w

			-- z component
			w = read(filehandle, "*n")
			if not w then error("Broken vn statement!") end
			vn_count = vn_count + 1
			vn_array[vn_count] = w
			end
		end

		if (w == "vt") then
			do

			-- this a texture coordinate, 2 numbers follow
         if (face_read == 1) and (flush_buffer == 1) then
            do
         	v_array = {}
         	vn_array = {}
         	vt_array = {}

         	v_count = 0
         	vn_count = 0
         	vt_count = 0

            face_read = 0
            flush_buffer = 0
            end
         end

			-- u component
			w = read(filehandle, "*n")
			if not w then error("Broken vt statement!") end
			vt_count = vt_count + 1
			vt_array[vt_count] = w

			-- v component
			w = read(filehandle, "*n")
			if not w then error("Broken vt statement!") end
			vt_count = vt_count + 1
			vt_array[vt_count] = w
			end
		end

      if (w == "g") then
         do
         -- a group definition
			w = read(filehandle, "*n")
         if first_face_read == 1 then
            do
            if no_normals == 1 then Mesh:GenerateNormals() end
         	RootNode:AttachChild(Mesh)
         	Mesh = Scene:CreateMesh()
            no_normals = 0
            end
         end --if
         flush_buffer = 1
         end
      end --if

		if (w == "f") then
			do
         face_read = 1
         first_face_read = 1
			-- this a face definition

			-- read the whole line into w
			w = read(filehandle, "*l")
			this_line = w

			-- delete leading white spaces
			while (strsub(w,1,1) == " ") do w = strsub(w, 2) end

			local f_array = {}
			local f_count = 0

			w, word = FirstWord(w)
			while (word)
				do
				v_index, word = GetFirstElement(word)
				vt_index, word = GetFirstElement(word)
				vn_index, word = GetFirstElement(word)

				if (v_index == "") then v_index = "0" end
				if (vt_index == "") then vt_index = "0" end
				if (vn_index == "") then vn_index = "0" end

				f_count = f_count + 1
				f_array[f_count] = v_index

				f_count = f_count + 1
				f_array[f_count] = vt_index

				f_count = f_count + 1
				f_array[f_count] = vn_index

				w, word = FirstWord(w)
				end

			-- we have read one face definition, now add that face to the mesh

			-- if it's not a triangle, print some error
			if (f_count ~= 9) then
				do
				print(format("%s%i%s%s", "Face with ", f_count / 3, " vertices detected! Line: ", this_line))
				error("This mesh is not triangulated!") 
				end
			end
				
			v1 = fxVertex:new()
			v1.position.x = v_array[3*f_array[1]-2+0]
			v1.position.y = v_array[3*f_array[1]-2+1]
			v1.position.z = v_array[3*f_array[1]-2+2]

			-- normals are optional, a "0" signals there is no normal
			if (f_array[3] ~= "0") then
				do
				v1.normal.x = vn_array[3*f_array[3]-2+0]
				v1.normal.y = vn_array[3*f_array[3]-2+1]
				v1.normal.z = vn_array[3*f_array[3]-2+2]
				end
            else no_normals = 1
			end
			-- texcoords are optiona, a "0" signals there is no texcoord
			if (f_array[2] ~= "0") then
				do
				v1.texcoords.x = vt_array[2*f_array[2]-1+0]
				v1.texcoords.y = vt_array[2*f_array[2]-1+1]
				end
			end
			v1_index = Mesh:AddVertex(v1)

			v2 = fxVertex:new()
			v2.position.x = v_array[3*f_array[4]-2+0]
			v2.position.y = v_array[3*f_array[4]-2+1]
			v2.position.z = v_array[3*f_array[4]-2+2]
			if (f_array[6] ~= "0") then
				do
				v2.normal.x = vn_array[3*f_array[6]-2+0]
				v2.normal.y = vn_array[3*f_array[6]-2+1]
				v2.normal.z = vn_array[3*f_array[6]-2+2]
				end
			end
			if (f_array[5] ~= "0") then
				do
				v2.texcoords.x = vt_array[2*f_array[5]-1+0]
				v2.texcoords.y = vt_array[2*f_array[5]-1+1]
				end
			end
			v2_index = Mesh:AddVertex(v2)

			v3 = fxVertex:new()
			v3.position.x = v_array[3*f_array[7]-2+0]
			v3.position.y = v_array[3*f_array[7]-2+1]
			v3.position.z = v_array[3*f_array[7]-2+2]
			if (f_array[9] ~= "0") then
				do
				v3.normal.x = vn_array[3*f_array[9]-2+0]
				v3.normal.y = vn_array[3*f_array[9]-2+1]
				v3.normal.z = vn_array[3*f_array[9]-2+2]
				end
			end
			if (f_array[8] ~= "0") then
				do
				v3.texcoords.x = vt_array[2*f_array[8]-1+0]
				v3.texcoords.y = vt_array[2*f_array[8]-1+1]
				end
			end
			v3_index = Mesh:AddVertex(v3)

			Mesh:AddFace(v1_index, v2_index, v3_index)

			v1:delete()
			v2:delete()
			v3:delete()

			end
		end

		w = read(filehandle, "*w")
		end

	-- link the created mesh into the scene
   if no_normals == 1 then Mesh:GenerateNormals() end
	RootNode:AttachChild(Mesh)

	closefile(filehandle)
ProgressWindowHide()
RedrawViewports()
end


function obj_save_file(file, mesh)
local meshhandle = file
assert(meshhandle)

for i = 0, mesh:GetVertexCount()-1,1
	do
	local v = mesh:GetTransformedVertex(i)
	write(meshhandle, "v " , v.position.x, " ", v.position.y, " ", v.position.z, "\n")
	write(meshhandle, "vn ", v.normal.x, " ", v.normal.y, " ", v.normal.z, "\n")
	write(meshhandle, "vt ", v.texcoords.x, " ", v.texcoords.y, "\n")
	end

write(meshhandle, "\ng Mesh", mesh_number, "\n\n")

for i = 0, mesh:GetFaceCount()-1,1
	do
	local f1, f2, f3 = mesh:GetFace(i)
	f1 = f1+1
	f2 = f2+1
	f3 = f3+1
	write(meshhandle, "f ",f1,"/",f1,"/",f1, " ", f2,"/",f2,"/",f2, " ", f3,"/",f3,"/",f3, "\n")
	end
end

function ExportOBJ(filename)
local Scene = GetScene()

mesh_number = 0

mesh_file = openfile(filename..".obj", "wt")


local node = Scene:GetFirstNode()
while node
	do
	local classname = node:GetClassName()
	if strfind(classname, "fxMesh") then
		do
		mesh_number = mesh_number + 1
		local mesh_node = tomesh(node)
		obj_save_file(mesh_file,mesh_node)
		end
	end

	node = Scene:GetNextNode()
	end

closefile(mesh_file)
end
