
-- MilkShape 3D support

RegisterImporter("MilkShape 3D ASCII (*.txt)", "*.txt", "MilkShape.Import")
RegisterExporter("MilkShape 3D ASCII (*.txt)", "*.txt", "MilkShape.Export")
MilkShape = {}

function ScanName()
	local t = ""

	local s = ""

	-- find the first "
	while (t ~= '"')
		do
		t = read(filehandle, 1)
		end

	t = read(filehandle, 1)

	-- read until next "
	while (t ~= '"')
		do
		s = s..t
		t = read(filehandle, 1)
		end

	return s

end


-- the exporter callback
function MilkShape.Export(filename)

   function MilkShape.FreeMem()
      -- first dereference all variables then run the garbage collector
      MilkShape.filehandle = nil
      MilkShape.JointTable = nil
      MilkShape.joint_counter = nil      
      MilkShape.mesh_counter = nil
      MilkShape.MaterialTable = nil
      collectgarbage()
   end

   function MilkShape.BuildJointTable()
   -- builds the joint table which which flattens the joint hierarchy
   -- indexed by joint id, contains the new id used for export
   MilkShape.JointTable = {}
   local scene = GetScene()
   local node = scene:GetFirstNode()
   MilkShape.joint_counter = 0
   while node
      do

      if (node:GetClassName() == "fxBone") then
         do
         local joint = tobone(node)
         MilkShape.JointTable[joint:GetId()] = MilkShape.joint_counter
         MilkShape.joint_counter = MilkShape.joint_counter + 1
         end
      end -- if

      node = scene:GetNextNode()
      end
   end

   function MilkShape.BuildMaterialTable()
   -- builds the material table, indexed by id, contains the new id used
   -- for export

   MilkShape.MaterialTable = {}

   local i
   local mat_counter = 0
   for i = 0, GetTextureCount()-1,1
      do
      tex = GetTexture(i)
      MilkShape.MaterialTable[tex:GetId()] = mat_counter
      end

   end


   function MilkShape.CountMeshes()
   -- returns the number of meshes in the scene
   local scene = GetScene()
   local node = scene:GetFirstNode()
   MilkShape.mesh_counter = 0
   while node
      do
      if (node:GetClassName() == "fxMesh") then
         do
         MilkShape.mesh_counter = MilkShape.mesh_counter + 1
         end
      end -- if
      node = scene:GetNextNode()
      end
   return MilkShape.mesh_counter
   end


   function MilkShape.CountBones()
   -- returns the number of bones in the scene
   local scene = GetScene()
   local node = scene:GetFirstNode()
   MilkShape.bone_counter = 0
   while node
      do
      if (node:GetClassName() == "fxBone") then
         do
         MilkShape.bone_counter = MilkShape.bone_counter + 1
         end
      end -- if
      node = scene:GetNextNode()
      end
   return MilkShape.bone_counter
   end


   function MilkShape.FindBestJoint(v)
   -- finds the joint with the highest influence on the vertex
   local i
   local best_joint = -1
   local best_weight = 0
   for i = 1,4,1
      do
      if (v.bone[i] > -1) then
         do
         if (v.weight[i] > best_weight) then
            do
            best_joint = v.bone[i]
            best_weight = v.weight[i]
            end
         end --if
         end
      end -- if
      end
   return best_joint
   end

   function MilkShape.SaveMesh(mesh)
   -- saves one mesh node
   local mat_index = MilkShape.MaterialTable[mesh:GetMaterial()]
   if not mat_index then mat_index = -1 end
   write(MilkShape.filehandle, '"', mesh:GetName(), '" 0 ',mat_index,'\n')
   write(MilkShape.filehandle, mesh:GetVertexCount(), "\n")

   -- vertices
   local i
   for i = 0, mesh:GetVertexCount()-1, 1
      do
      v = mesh:GetLocalVertex(i) -- vertex with modelview applied
      local joint_index = MilkShape.JointTable[MilkShape.FindBestJoint(v)]
      if not joint_index then joint_index = -1 end
      write(MilkShape.filehandle, "0 ", v.position.x, " ", v.position.y, " ", v.position.z, " ", v.texcoords.x, " ", 1-v.texcoords.y, " ", joint_index, "\n")
      end

   -- normals
   write(MilkShape.filehandle, mesh:GetVertexCount(), "\n")
   for i = 0, mesh:GetVertexCount()-1, 1
      do
      v = mesh:GetLocalVertex(i) -- vertex with modelview applied
      write(MilkShape.filehandle, v.normal.x, " ", v.normal.y, " ", v.normal.z,"\n")
      end

   -- faces
   write(MilkShape.filehandle, mesh:GetFaceCount(), "\n")
   for i = 0, mesh:GetFaceCount()-1, 1
      do
      local f1, f2, f3 = mesh:GetFace(i)
      write(MilkShape.filehandle, "0 ",f1, " ", f2, " ", f3, " ", f1, " ", f2, " ", f3, " 1\n")
      end

   end

   function MilkShape.SaveMaterials()
   write(MilkShape.filehandle, "Materials: ", GetTextureCount(), "\n")

   local i

   for i = 0, GetTextureCount()-1,1
      do
      tex = GetTexture(i)
      write(MilkShape.filehandle, '"Material', i, '"\n')
      write(MilkShape.filehandle, "0.200000 0.200000 0.200000 1.000000\n")      
      write(MilkShape.filehandle, "0.800000 0.800000 0.800000 1.000000\n")
      write(MilkShape.filehandle, "0.000000 0.000000 0.000000 1.000000\n")
      write(MilkShape.filehandle, "0.000000 0.000000 0.000000 1.000000\n")
      write(MilkShape.filehandle, "0.000000\n1.000000\n")      
      write(MilkShape.filehandle, '"',tex:GetAbsoluteFilename(),'"\n')
      write(MilkShape.filehandle, '""\n')
      end
   end


   function MilkShape.SaveBone(bone)
   write(MilkShape.filehandle, '"', bone:GetName(), '"\n')
   local parent = bone:GetParent()
   local parent_name = ""

   if parent then
      if parent:GetClassName() == "fxBone" then parent_name = tobone(parent):GetName() end
   end --if

   write(MilkShape.filehandle, '"', parent_name, '"\n')
   local modelview = bone:GetLocalMatrix()
   local pos = modelview:pos_component()
   local rot = modelview:get_eulers()

      -- fix for biped characters
      if bone:GetName() == "Bip01" then
         do
         --print(bone:GetName().." fixed.")
         --rot.x = -1.5707963
         --rot.z = 0
         end
      end --if

      if bone:GetName() == "Bip01 Pelvis" then
         do
         --print(bone:GetName().." fixed.")
         --rot.x =  -1.5707963
         --rot.z = 0
         end
      end --if

   write(MilkShape.filehandle, "0 ", pos.x, " ", pos.y, " ", pos.z, " ", rot.x, " ", rot.y, " ", rot.z, "\n")

   -- position keys
   write(MilkShape.filehandle, bone:GetKeyCount(), "\n")
   local i
   for i = 0,bone:GetKeyCount()-1, 1
      do
      key = bone:GetKey(i)

      m = bone:GetLocalMatrix():clone()
      m:clear_translation()
      m_inv = m:clone()
      m_inv:invert()

      m:mult_simple(key.matrix)
      m:mult_simple(m_inv);

      pos = m:pos_component()

      m:delete()
      m_inv:delete()

      write(MilkShape.filehandle, key.frame, " ", pos.x, " ", pos.y, " ", pos.z, "\n")
      end

   -- rotation keys
   write(MilkShape.filehandle, bone:GetKeyCount(), "\n")
   local i
   for i = 0,bone:GetKeyCount()-1, 1
      do
      key = bone:GetKey(i)

      m = bone:GetLocalMatrix():clone()
      m:clear_translation()
      m_inv = m:clone()
      m_inv:invert()

      m:mult_simple(key.matrix)
      m:mult_simple(m_inv);

      rot = m:get_eulers()

      m:delete()
      m_inv:delete()

      write(MilkShape.filehandle, key.frame, " ", rot.x, " ", rot.y, " ", rot.z, "\n")
      end

   end


-- main part
--------------------------------------------------------------------------------


   filename = filename..".txt"
   MilkShape.filehandle = openfile(filename, "wt")
   assert(MilkShape.filehandle)

   MilkShape.BuildJointTable()
   MilkShape.BuildMaterialTable()

   write(MilkShape.filehandle, "// MilkShape 3D ASCII\n\n")
   write(MilkShape.filehandle, "Frames: ", GetTotalFrames(), "\n")
   write(MilkShape.filehandle, "Frame: ", GetFrame(), "\n\n")   

   write(MilkShape.filehandle, "Meshes: ", MilkShape.CountMeshes(), "\n")

   -- save the meshes
   MilkShape.mesh_counter = 0
   local scene = GetScene()
   local node = scene:GetFirstNode()
   while node
      do
      if node:GetClassName() == "fxMesh" then
         do
         local mesh = tomesh(node)
         MilkShape.SaveMesh(mesh)
         MilkShape.mesh_counter = MilkShape.mesh_counter + 1
         end
      end -- if
      node = scene:GetNextNode()
      end

   MilkShape.SaveMaterials()

   write(MilkShape.filehandle, "Bones: ", MilkShape.CountBones(), "\n")

   local node = scene:GetFirstNode()
   while node
      do
      if node:GetClassName() == "fxBone" then
         do
         local bone = tobone(node)
         MilkShape.SaveBone(bone)
         end
      end -- if
      node = scene:GetNextNode()
      end


   closefile(MilkShape.filehandle)
end



-- the importer callback
--------------------------------------------------------------------------------
function MilkShape.Import(filename)

	function ScanName()
	local t = ""

	local s = ""

	-- find the first "
	while (t ~= '"')
		do
		t = read(filehandle, 1)
		end

	t = read(filehandle, 1)

	-- read until next "
	while (t ~= '"')
		do
		s = s..t
		t = read(filehandle, 1)
		end

	return s

	end

Scene = GetScene()
RootNode = Scene:GetRootNode()


-- Open the file
filehandle = openfile(filename, "rt")
if not filehandle then error("Error opening the file!") end

mode = "nothing"

w = read(filehandle, "*w")
while (w)
	do

	if (w == "Frames:") then
		do
		-- total frames of animation
		w = read(filehandle, "*w")
		SetTotalFrames(w)
		end
	end

	if (w == "Frame:") then
		do
		-- current frame
		w = read(filehandle, "*w")
		SetFrame(w)
		end
	end

	if (w == "Meshes:") then
		do
		mesh_count = read(filehandle, "*w")
		-- read the meshes
		for i = 1,mesh_count,1
			do

			v_array = {}
			vn_array = {}

			mesh = Scene:CreateMesh()

			-- skip the next 3 words
            -- w = read(filehandle, "*w")
            w = ScanName()
            mesh:SetName(w)
			w = read(filehandle, "*w")
			w = read(filehandle, "*w")

			num_verts = read(filehandle, "*w")
			for j = 1,num_verts,1
				do
				-- read one vertex line
				w = read(filehandle, "*w")
				x = read(filehandle, "*w")
				y = read(filehandle, "*w")
				z = read(filehandle, "*w")
				u = read(filehandle, "*w")
				v = read(filehandle, "*w")
				b = read(filehandle, "*w")		

				v = 1 - v

				v_array[j] = { x, y, z, u, v, b }
				end

			num_normals = read(filehandle, "*w")
			for j = 1,num_normals,1
				do
				-- read one normal
				x = read(filehandle, "*w")
				y = read(filehandle, "*w")
				z = read(filehandle, "*w")
				vn_array[j] = { x, y, z }
				end

			num_faces = read(filehandle, "*w")
			for j = 1,num_faces,1
				do
				w = read(filehandle, "*w")
				v1_index1 = read(filehandle, "*w")
				v2_index1 = read(filehandle, "*w")
				v3_index1 = read(filehandle, "*w")
				v1_index2 = read(filehandle, "*w")
				v2_index2 = read(filehandle, "*w")
				v3_index2 = read(filehandle, "*w")
				w = read(filehandle, "*w")
		
				v1 = fxVertex:new()
				v1.position.x = v_array[v1_index1+1][1]
				v1.position.y = v_array[v1_index1+1][2]
				v1.position.z = v_array[v1_index1+1][3]
				v1.texcoords.x = v_array[v1_index1+1][4]
				v1.texcoords.y = v_array[v1_index1+1][5]
				v1.bone[1] = v_array[v1_index1+1][6]
				v1.weight[1] = 1
				v1.normal.x = vn_array[v1_index2+1][1]
				v1.normal.y = vn_array[v1_index2+1][2]
				v1.normal.z = vn_array[v1_index2+1][3]
				v1_index = mesh:AddVertex(v1)

				v2 = fxVertex:new()
				v2.position.x = v_array[v2_index1+1][1]
				v2.position.y = v_array[v2_index1+1][2]
				v2.position.z = v_array[v2_index1+1][3]
				v2.texcoords.x = v_array[v2_index1+1][4]
				v2.texcoords.y = v_array[v2_index1+1][5]
				v2.bone[1] = v_array[v2_index1+1][6]
				v2.weight[1] = 1
				v2.normal.x = vn_array[v2_index2+1][1]
				v2.normal.y = vn_array[v2_index2+1][2]
				v2.normal.z = vn_array[v2_index2+1][3]
				v2_index = mesh:AddVertex(v2)

				v3 = fxVertex:new()
				v3.position.x = v_array[v3_index1+1][1]
				v3.position.y = v_array[v3_index1+1][2]
				v3.position.z = v_array[v3_index1+1][3]
				v3.texcoords.x = v_array[v3_index1+1][4]
				v3.texcoords.y = v_array[v3_index1+1][5]
				v3.bone[1] = v_array[v3_index1+1][6]
				v3.weight[1] = 1
				v3.normal.x = vn_array[v3_index2+1][1]
				v3.normal.y = vn_array[v3_index2+1][2]
				v3.normal.z = vn_array[v3_index2+1][3]
				v3_index = mesh:AddVertex(v3)

				mesh:AddFace(v1_index, v2_index, v3_index)
				
				v1:delete()
				v2:delete()
				v3:delete()
				end

			RootNode:AttachChild(mesh)
			RedrawViewports()
			end		
		end
	end


	if (w == "Bones:") then
		do
		bone_count = read(filehandle, "*w")

		bone_array = {}

		-- read the bones
		for i = 1,bone_count,1
			do

			bone = Scene:CreateBone()
			bone:SetId(i-1)
			bone_array[i] = bone

--			name = read(filehandle, "*w")
--			name = strsub(name, 2, -2)

			name = ScanName()

--			parent_name = read(filehandle, "*w")
--			parent_name = strsub(parent_name, 2, -2)

			parent_name = ScanName()

			bone:SetName(name)

			w = read(filehandle, "*w")
			tx = read(filehandle, "*w")
			ty = read(filehandle, "*w")
			tz = read(filehandle, "*w")

			rx = read(filehandle, "*w")
			ry = read(filehandle, "*w")
			rz = read(filehandle, "*w")

			-- construct the modelview matrix
			matrix = matrix44:new()

			matrix:rotate_x(rx)
			matrix:rotate_y(ry)
			matrix:rotate_z(rz)
			matrix:translate(tx, ty, tz)

			bone:SetMatrix(matrix)
			matrix:delete()

         -- attach the node now
			parent_node = RootNode

			-- try to find our parent bone
			for j = 1,i-1,1
				do
				pbone = bone_array[j]
				if pbone:GetName() == parent_name then parent_node = pbone end
				end

			parent_node:AttachChild(bone)

         RedrawViewports()

			num_tkeys = read(filehandle, "*w")
			for j = 1,num_tkeys,1
				do
				time = read(filehandle, "*w")
				ktx = read(filehandle, "*w")
				kty = read(filehandle, "*w")
				ktz = read(filehandle, "*w")

            local ref_m = bone:GetLocalMatrix()
            local x_axis = ref_m:x_component()
            local y_axis = ref_m:y_component()
            local z_axis = ref_m:z_component()

            x_axis:MulS(ktx)
            y_axis:MulS(kty)
            z_axis:MulS(ktz)

            local matrix = matrix44:new()

            matrix:ident()
            matrix:translate(x_axis.x, x_axis.y, x_axis.z)
            matrix:translate(y_axis.x, y_axis.y, y_axis.z)
            matrix:translate(z_axis.x, z_axis.y, z_axis.z)

            bone:SetKey(time, matrix)
            matrix:delete()

				end
			num_rkeys = read(filehandle, "*w")
			for j = 1,num_rkeys,1
				do
				time = read(filehandle, "*w")
				krx = read(filehandle, "*w")
				kry = read(filehandle, "*w")
				krz = read(filehandle, "*w")

            org_m = bone:GetLocalMatrix()
            rel_matrix = org_m:clone()
            inv_rel_matrix = org_m:clone()
            inv_rel_matrix:invert()
            inv_rel_matrix:clear_translation()
            rel_matrix:clear_translation()

            matrix = inv_rel_matrix

				matrix:rotate_x(krx)
				matrix:rotate_y(kry)
				matrix:rotate_z(krz)

            matrix:mult_simple(rel_matrix)

            local key_matrix = bone:GetKeyMatrix(time)
            if key_matrix then
               do
               key_translation = key_matrix:pos_component()
               matrix:translate(key_translation.x,key_translation.y,key_translation.z) 
               end
            end -- if
				bone:SetKey(time, matrix)

            matrix:delete()
            rel_matrix:delete()
				end

			end
		end
	end



	w = read(filehandle, "*w")
	end


end
