
RegisterPlugin("Mesh", "Generate Normals", "MeshTools.GenerateNormals()")
RegisterPlugin("Mesh", "Invert Normals", "MeshTools.InvertNormals()")
MeshTools = {}

--------------------------------------------------------------------------------
function MeshTools.InvertNormalsIterator(node)
if (node:GetClassName() == "fxMesh") and (node:GetSelected()) then
   local i
   local mesh = tomesh(node)
   for i = 0,mesh:GetVertexCount()-1,1
      do
      local v = mesh:GetVertex(i)
      v.normal:MulS(-1)
      end
   end -- if
end

--------------------------------------------------------------------------------
function MeshTools.InvertNormals()
IterateNodes(MeshTools.InvertNormalsIterator)
RedrawViewports()
end



--------------------------------------------------------------------------------
function MeshTools.GenerateNormals()
   local Scene = GetScene()
   local node = Scene:GetFirstNode()
   while node
      do
      if node:GetSelected() then
         do
         if node:GetClassName() == "fxMesh" then
            do
            local mesh = tomesh(node)
            mesh:GenerateNormals()
            end
         end -- if
         end
      end -- if

      node = Scene:GetNextNode()
      end
   RedrawViewports()
end