
-- Autodesk 3DS support

RegisterImporter("Autodesk 3DS (*.3ds)", "*.3ds", "autodesk.import")
RegisterExporter("Autodesk 3DS (*.3ds)", "*.3ds", "autodesk.export", 1)
autodesk = {}


function autodesk.export_mesh(mesh)
   mesh_handle = autodesk.out:BeginMesh(mesh:GetVertexCount(), mesh:GetFaceCount())

   mesh_mat = mesh:GetMaterial()
   mat_tex = FindMaterial(mesh_mat)
   if mat_tex then
        print("Writing Texture")
        autodesk.out:SetMaterial(mesh_handle, mat_tex:GetFileName())
        end

   local i
   for i = 0, mesh:GetVertexCount()-1,1
      do
      v = mesh:GetTransformedVertex(i)
      autodesk.out:AddVertex(mesh_handle, v.position.x,v.position.y,v.position.z,v.texcoords.x,v.texcoords.y)
      end

   for i = 0, mesh:GetFaceCount()-1,1
      do
      local v1,v2,v3
      v1,v2,v3 = mesh:GetFace(i)
      autodesk.out:AddFace(mesh_handle, v1,v2,v3)
      end

   autodesk.out:EndMesh(mesh_handle)

end


function autodesk.export(filename)

   filename = filename..".3ds"
   autodesk.out = Export3DS:new()
   autodesk.out:BeginExport(filename)

   local scene = GetScene()
   local node = scene:GetFirstNode()
   while node
      do
      if node:GetClassName() == "fxMesh" then
         do
         autodesk.export_mesh(tomesh(node))
         end
      end --if
      node = scene:GetNextNode()
      end

   autodesk.out:EndExport()
   autodesk.out:delete()

end

function autodesk.import(filename)
   autodesk.in = Import3DS:new()

   local success = autodesk.in:BeginImport(filename)
   if not success then error("Error reading the file!") end

   local i
   local total_work = 0
   for i = 0,autodesk.in:GetMeshCount()-1,1
      do
      local j
      total_work = total_work + autodesk.in:GetVertexCount(i)
      total_work = total_work + autodesk.in:GetFaceCount(i)
      end

   ProgressWindowMinMax(0,total_work)
   ProgressWindowSet(0)
   ProgressWindowShow()

   local progress = 0
   local i
   for i = 0,autodesk.in:GetMeshCount()-1,1
      do
      local scene = GetScene()
      local root = scene:GetRootNode()
      local mesh = scene:CreateMesh()

      local m = mesh:GetMatrix()
      
      for t1 = 0,3,1
         do
         for t2 = 0,3,1
            do
            m:S(t1,t2,autodesk.in:GetMatrix(i,t1,t2))
            end
         end

      local j
      for j = 0, autodesk.in:GetVertexCount(i)-1, 1
         do
         v = fxVertex:new()
         v.position.x, v.position.y, v.position.z = autodesk.in:GetVertex(i,j)
         v.texcoords.x,v.texcoords.y = autodesk.in:GetTexcoords(i,j)
         mesh:AddVertex(v,0)
         v:delete()
         progress = progress + 1
         ProgressWindowSet(progress)
         end

      for j = 0, autodesk.in:GetFaceCount(i)-1, 1
         do
         local v1,v2,v3
         v1,v2,v3 = autodesk.in:GetFace(i,j)
         mesh:AddFace(v1,v2,v3)
         progress = progress + 1
         ProgressWindowSet(progress)
         end

      mesh:GenerateNormals()
      root:AttachChild(mesh)
      RedrawViewports()
      end

   autodesk.in:EndImport()
   autodesk.in:delete()

end

