
RegisterPlugin("Animation", "Delete All Keyframes", "AnimTools.DeleteAllKeys()")
RegisterPlugin("Animation", "Reset Pose", "AnimTools.ResetPose()")
AnimTools = {}

function AnimTools.ResetPoseIterator(node)
   if node:GetClassName() == "fxBone" then
      local bone = tobone(node)
      bone:ResetOffset()
      end
end

function AnimTools.ResetPose()
   PushUndo("Reset Pose")
   IterateNodes(AnimTools.ResetPoseIterator)
   RedrawViewports()
end

function AnimTools.DeleteAllKeys()
   PushUndo("Delete All Keys")
   local Scene = GetScene()
   local node  = Scene:GetFirstNode()
   while node
      do
      if node:GetClassName() == "fxBone" then
         do
         local bone = tobone(node)
         while bone:GetKeyCount() > 0
            do
            bone:DeleteKeyIndex(0)
            print("l")
            end
         end
      end

      node = Scene:GetNextNode()
      end

   IterateNodes(AnimTools.ResetPoseIterator)
   RedrawViewports()
end
