string GetDescription()
{
	return "Creates a simple metronome tick pattern ( 1 sound per beat ).\nYou can set the pitch of the tick sound by the <pitch> param.";
}

void Render(RenderPart @p)
{
	int test = p.GetParam("pitch").toInt();
	if (test == 0) test = 37;

	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		for (int u = 0; u < p.GetUniquePart().GetMetrum(); u++)
		{		
			int vel = 127;
			if (u != 0) vel = 90;
			p.AddPercNote(CreateTime(i,u), CreateTime(i,u+0.5) , test, vel);
		}
	}
}