/*
 * SyntaxStyle.java - A simple text style class
 * Copyright (C) 1999 Slava Pestov
 *
 * You may use and modify this package for any purpose. Redistribution is
 * permitted, in both source and binary form, provided that this notice
 * remains intact in all source distributions of this package.
 */
package org.lateralgm.jedit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

/**
 * A simple text style class. It can specify the color, italic flag,
 * and bold flag of a run of text.
 * @author Slava Pestov
 */
public class SyntaxStyle
	{
	/**
	 * Creates a new SyntaxStyle.
	 * @param color The text color
	 * @param italic True if the text should be italics
	 * @param bold True if the text should be bold
	 */
	public SyntaxStyle(Color color, boolean italic, boolean bold)
		{
		this.color = color;
		this.italic = italic;
		this.bold = bold;
		}

	/**
	 * Returns the specified font, but with the style's bold and
	 * italic flags applied.
	 */
	public Font getStyledFont(Font font)
		{
		if (font == null) throw new NullPointerException("font param must not be null");
		if (font.equals(lastFont)) return lastStyledFont;
		lastFont = font;
		lastStyledFont = new Font(font.getFamily(),(bold ? Font.BOLD : 0) | (italic ? Font.ITALIC : 0),
				font.getSize());
		return lastStyledFont;
		}

	/**
	 * Sets the foreground color and font of the specified graphics
	 * context to that specified in this style.
	 * @param gfx The graphics context
	 * @param font The font to add the styles to
	 */
	public void setGraphicsFlags(Graphics gfx, Font font)
		{
		Font f = getStyledFont(font);
		gfx.setFont(f);
		gfx.setColor(color);
		}

	/**
	 * Returns a string representation of this object.
	 */
	public String toString()
		{
		return getClass().getName() + "[color=" + color + (italic ? ",italic" : "")
				+ (bold ? ",bold" : "") + "]";
		}

	// private members
	private Color color;
	private boolean italic;
	private boolean bold;
	private Font lastFont;
	private Font lastStyledFont;
	}
