library Xtreme3D;
(*--------------------------------------------------------------------------)
                       GMScene 1.0
                   Version Lib: 0.1[a.a]
                      Code: Rutraple
                       Delphi: 2007
                  GLScene: 1.1 (Aug 2010)
                   25 aug - ... 2011 year

[BUG] - ActorAddObject ( )
[BUG] - FontAddResource ( )
[BUG] - EngineCreate (      )     
[BUG] - EngineDestroy (  )

(--------------------------------------------------------------------------*)
uses
  //VCL
  Windows,Classes,SysUtils,
  //GLScene
  GLScene,GLCadencer,GLObjects,OpenGL1x,GLWin32Viewer,GLGraphics,Graphics,GLContext,
  GLVectorFileObjects,VectorGeometry,VectorTypes,GLColor,GLGeomObjects,GLMaterial,GLTexture,
  GLTextureFormat,GLHUDObjects,GLSpaceText,GLBitmapFont,GLWindowsFont,GLUtils,GLCoordinates,
  GLRenderContextInfo,GLSLShader,GLFBORenderer,GLShadowVolume,GLCollision,GeometryBB,SpatialPartitioning,
  GLVfsPAK,GLDCE,GLStrings,GLMesh,GLTeapot,GLSLog,
  Jpeg,TGA,DDS,
  //Anim File Format
  GLFileMD2,GLFileMD3,GLFileMD5,GLFileSMD,
  //Static File Format
  GLFile3DS,GLFileLWO,GLFileMS3D,GLFileObj,GLFileQ3BSP,
  //Other File Format
  GLFilePAK;

{$R *.res}



var
  SceneHWND              : HWND;
  SceneNode              : TGLScene;
  SceneCadencer          : TGLCadencer;
  SceneMaterialLibrary   : TGLMateriallibrary;
  SceneViewer            : TGLSceneViewer;
  //SceneLog               : TGLSLogger;
  FontList               : TStringList;


const
  //Caption
  WCaption               = 'Xtreme3D Warning...';
  ECaption               = 'Xtreme3D Error...';
  ICaption               = 'Xtreme3D Information...';
  //Button type
  WType                  = MB_OK + MB_ICONWARNING + MB_TASKMODAL;
  EType                  = MB_OK + MB_ICONERROR + MB_TASKMODAL;
  IType                  = MB_OK + MB_ICONINFORMATION + MB_TASKMODAL;

resourcestring
  glsUnknownErrorEngine  = 'Unknown error when using the engine. Sorry.';
  glsEngineBuild         = '0.1[a.a]';




(*---------------------------Dll Inside Function-----------------------------*)
procedure SceneFontDeleteAll;
 var
   i: Integer;
 begin
   if Assigned(FontList) then
     begin
       for i := 0 to FontList.Count-1 do begin
         RemoveFontResource(PChar(FontList.Names[i]));
         FontList.Delete(i);
       end;
     if FontList.Count <= 0 then
     begin
       FontList.Free;
     end;
   end;
 end;

procedure SceneViewerUpdateAll;
 begin
   SceneViewer.Invalidate;
   SceneViewer.Buffer.RenderingContext.Active := true;
 end;

procedure SceneViewerDeleteAll;
 begin
   SceneViewer.Destroy;
   SceneViewer.Free;
 end;


 
(*---------------------------------Engine------------------------------------*)
function EngineCreate(const hwnd: real): real; stdcall;
 begin
   try
     SceneNode := TGLScene.Create(nil);
     SceneCadencer := TGLCadencer.Create(nil);
     SceneCadencer.Scene := SceneNode;
     SceneCadencer.Mode := cmManual;
     SceneHWND := Cardinal(Trunc(hwnd));
   except
     on E: Exception do begin
       MessageBox(0, PAnsiChar(E.Message), ECaption, EType);
       Result := 0;
       Exit;
     end;
   end;
   Result := 1;
 end;

function EngineDestroy: real; stdcall;
 begin
   SceneFontDeleteAll; //    
   SceneCadencer.Enabled := false;
   SceneViewer.Enabled := false;
   SceneMaterialLibrary.Destroy;
   SceneMaterialLibrary.Free;
   SceneViewerDeleteAll;
   SceneNode.Destroy;
   Result := 1;
 end; 

function EngineUpdate(const delta: real): real; stdcall;
 begin
   try
     SceneNode.Progress(delta, delta);
     SceneViewerUpdateAll;
   except
     on E: Exception do begin
       MessageBox(0, PAnsiChar(E.Message), ECaption, EType);
       Halt;
     end;
   end;
   Result := 1;
 end;

function EngineSetVisibilityCulling(const mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0: SceneNode.VisibilityCulling := vcNone;
     1: SceneNode.VisibilityCulling := vcInherited;
     2: SceneNode.VisibilityCulling := vcObjectBased;
     3: SceneNode.VisibilityCulling := vcHierarchical;
   else
     SceneNode.VisibilityCulling := vcNone;
   end;
   Result := 1;
 end;

function EngineSetObjectSorting(const mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0: SceneNode.ObjectsSorting := osNone;
     1: SceneNode.ObjectsSorting := osInherited;
     2: SceneNode.ObjectsSorting := osRenderFarthestFirst;
     3: SceneNode.ObjectsSorting := osRenderBlendedLast;
     4: SceneNode.ObjectsSorting := osRenderNearestFirst;
   else
     SceneNode.ObjectsSorting := osNone;
   end;
   Result := 1;
 end;

function EngineGetMaxTextureSize: real; stdcall;
 begin
   Result := SceneNode.CurrentBuffer.LimitOf[limTextureSize];
 end;

function EngineGetMaxTextureUnits: real; stdcall;
 begin
   Result := SceneNode.CurrentBuffer.LimitOf[limNbTextureUnits];
 end;

function EngineGetBuild: PChar; stdcall;
 begin
   Result := PChar(glsEngineBuild);
 end; 

function EngineGetVBOSupported: real; stdcall;
 begin
   Result := Integer(GL_ARB_Vertex_Buffer_Object);
 end;

function EngineGetGLSLSupported: real; stdcall;
 begin
   Result := Integer(GL_ARB_vertex_program and GL_ARB_vertex_shader and GL_ARB_fragment_shader);
 end;
//todo
function EngineSetArchivePak(const fname: PChar): real; stdcall;
 var
   Archive : TGLvfsPAK;
 begin
   try
     Archive := TGLvfsPAK.Create(SceneNode);
     Archive.LoadFromFile(PChar(fname), fmOpenReadWrite or fmShareDenyWrite);
     Result := Integer(Archive);
   except
     on E: Exception do begin
       MessageBox(0, PAnsiChar(E.Message), ECaption, EType);
       Result := 0;
       Exit;
     end;
   end;
 end;



(*---------------------------------View--------------------------------------*)
function ViewerCreate(const x, y, width, height: real): real; stdcall;
 begin
    try
      SceneViewer := TGLSceneViewer.Create(nil);
      SceneViewer.Top := Trunc(x);
      SceneViewer.Left := Trunc(y);
      SceneViewer.Width := Trunc(width);
      SceneViewer.Height := Trunc(height);
      SceneViewer.Buffer.BackgroundColor := TColor(clGray);
      SceneViewer.Buffer.ShadeModel := smSmooth;
      SceneViewer.Buffer.DepthPrecision := dp24bits;
      SceneViewer.ParentWindow := SceneHWND;
      SceneViewer.Buffer.ContextOptions := [roDoubleBuffer, roStencilBuffer, roRenderToWindow];
    except
      on E: Exception do begin
        MessageBox(0, PAnsiChar(E.Message), ECaption, EType);
        Result := 0;
        Exit;
      end;
   end;
   Result := Integer(SceneViewer);
 end;

function ViewerSetLighting(const viewer, mode: real): real; stdcall;
 begin
   TGLSceneViewer(Trunc(viewer)).Buffer.Lighting := Boolean(Trunc(mode));
   Result := 1;
 end;

function ViewerSetCamera(const viewer, camera: real): real; stdcall;
 begin
    TGLSceneViewer(Trunc(viewer)).Camera := TGLCamera(Trunc(camera));
    Result := 1;
 end;

function ViewerSetAntiAliasing(const viewer, mode: real): real; stdcall;
  begin
    case Trunc(mode) of
      0:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aaNone;
      1:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aaDefault;
      2:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aa2x;
      3:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aa2xHQ;
      4:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aa4x;
      5:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aa4xHQ;
      6:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aa6x;
      7:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aa8x;
      8:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aa16x;
      //Coverage Sampling Antialiasing
      9:  TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := csa8x;
      10: TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := csa8xHQ;
      11: TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := csa16x;
      12: TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := csa16xHQ;
    else
      TGLSceneViewer(Trunc(viewer)).Buffer.AntiAliasing := aaNone;
    end;
    Result := 1;
  end;

function ViewerSetBackgroundColor(const viewer, color: real): real; stdcall;
 begin
   TGLSceneViewer(Trunc(viewer)).Buffer.BackgroundColor := TColor(Trunc(color));
   Result := 1;
 end;

function ViewerSetAmbientColor(const viewer, color: real): real; stdcall;
 begin
   TGLSceneViewer(Trunc(viewer)).Buffer.AmbientColor.AsWinColor := TColor(Trunc(color));
   Result := 1;
 end;

function ViewerSetFaceCulling(const viewer, mode: real): real; stdcall;
 begin
   TGLSceneViewer(Trunc(viewer)).Buffer.FaceCulling := Boolean(Trunc(mode));
   Result := 1;
 end;

function ViewerSetVSync(const viewer, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0: TGLSceneViewer(Trunc(viewer)).VSync := vsmNoSync;
     1: TGLSceneViewer(Trunc(viewer)).VSync := vsmSync;
   else
     TGLSceneViewer(Trunc(viewer)).VSync := vsmNoSync;
   end;
   Result := 1;
 end;

function ViewerGetPixelColor(const viewer, x, y: real): real; stdcall;
 begin
   Result := TGLSceneViewer(Trunc(viewer)).Buffer.GetPixelColor(Trunc(x), Trunc(y));
 end;

function ViewerGetPixelDepth(const viewer, x, y: real): real; stdcall;
  begin
    Result := TGLSceneViewer(Trunc(viewer)).Buffer.GetPixelDepth(Trunc(x), Trunc(y));
  end;

function ViewerScreenToWorld(const viewer, x, y, ind: real): real; stdcall;
 begin
   Result := TGLSceneViewer(Trunc(viewer)).Buffer.ScreenToWorld(Trunc(x), Trunc(y))[Trunc(ind)];
 end;

function ViewerWorldToScreen(const viewer, x, y, z, ind: real): real; stdcall;
 var
   vec : TAffineVector;
 begin
   SetVector(vec, x, y, z);
   Result := TGLSceneViewer(Trunc(viewer)).Buffer.WorldToScreen(vec)[Trunc(ind)];
 end;

function ViewerGetViewportSize(const viewer, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0: Result := TGLSceneViewer(Trunc(viewer)).Height;
     1: Result := TGLSceneViewer(Trunc(viewer)).Width;
   else
     Result := -1;
     Exit;
   end;
 end;



(*---------------------------------Dummycube----------------------------------*)
function DummycubeCreate(const parent: real): real; stdcall;
 var
   Dummy : TGLDummycube;
 begin
   Dummy := TGLDummycube.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then Dummy.Parent := TGLBaseSceneObject(Trunc(parent));
   Result := Integer(Dummy);
 end;

function DummycubeSetCubeSize(const dm, size: real): real; stdcall;
 begin
   TGLDummycube(Trunc(dm)).CubeSize := size;
   Result := 1;
 end;

function DummycubeSetEdgeColor(const dm, color: real): real; stdcall;
 begin
   TGLDummycube(Trunc(dm)).EdgeColor := TGLColor(Trunc(color));
   Result := 1;
 end;

function DummycubeSetVisible(const dm, mode: real): real; stdcall;
 begin
   TGLDummycube(Trunc(dm)).VisibleAtRunTime := Boolean(Trunc(mode));
   Result := 1;
 end;

function DummycubeSetAmalgamate(const dm, mode: real): real; stdcall;
 begin
   TGLDummycube(Trunc(dm)).Amalgamate := Boolean(Trunc(mode));
   Result := 1;
 end;

function DummycubeSetCamInvarianceMode(const dm, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     1: TGLDummycube(Trunc(dm)).CamInvarianceMode := cimNone;
     2: TGLDummycube(Trunc(dm)).CamInvarianceMode := cimPosition;
     3: TGLDummycube(Trunc(dm)).CamInvarianceMode := cimOrientation;
   else
     TGLDummycube(Trunc(dm)).CamInvarianceMode := cimNone;
   end;
   Result := 1;
 end;



(*---------------------------------Camera-------------------------------------*)
function CameraCreate(const parent: real): real; stdcall;
 var
   Camera: TGLCamera;
 begin
   Camera := TGLCamera.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then Camera.Parent := TGLBaseSceneObject(Trunc(parent));
   Camera.DepthOfView := 6000;
   Camera.FocalLength := 120;
   Camera.CameraStyle := csPerspective;
   Camera.SceneScale := 0.7;
   Camera.VisibilityCulling := SceneNode.VisibilityCulling;
   Result := Integer(Camera);
 end;

function CameraSetDepthOfView(const cam, depth: real): real; stdcall;
 begin
   TGLCamera(Trunc(cam)).DepthOfView := depth;
   Result := 1;
 end;

function CameraSetFocalLength(const cam, fov: real): real; stdcall;
 begin
   TGLCamera(Trunc(cam)).FocalLength := fov;
   Result := 1;
 end;

function CameraSetMoveAroundTarget(const cam, pdt, tdt: real): real; stdcall;
 begin
   TGLCamera(Trunc(cam)).MoveAroundTarget(pdt, tdt);
   Result := 1;
 end;

function CameraSetStyle(const cam, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0: TGLCamera(Trunc(cam)).CameraStyle := csPerspective;
     1: TGLCamera(Trunc(cam)).CameraStyle := csOrthogonal;
     2: TGLCamera(Trunc(cam)).CameraStyle := csOrtho2D;
     3: TGLCamera(Trunc(cam)).CameraStyle := csInfinitePerspective;
   else
     TGLCamera(Trunc(cam)).CameraStyle := csPerspective;
   end;
   Result := 1;
 end;

function CameraSetScaleScene(const cam, scale: real): real; stdcall;
 var
   Current: real;
 begin
   Current := TGLCamera(Trunc(cam)).SceneScale;
   TGLCamera(Trunc(cam)).SceneScale := current + scale;
   Result := 1;
 end;

function CameraSetTargetObject(const cam, obj: real): real; stdcall;
 begin
  TGLCamera(Trunc(cam)).TargetObject := TGLBaseSceneObject(Trunc(obj));
  Result := 1;
 end;

function CameraSetDistanceToTarget(const cam, dist: real): real; stdcall;
 begin
   TGLCamera(Trunc(cam)).AdjustDistanceToTarget(dist);
   Result := 1;
 end;

function CameraGetDistanceToTarget(const cam: real): real; stdcall;
 begin
   Result := TGLCamera(Trunc(cam)).DistanceToTarget;
 end;



(*---------------------------------Primitive----------------------------------*)
function CubeCreate(const w, h, d, parent: real): real; stdcall;
 var
   FCube  : TGLCube;
 begin
   FCube := TGLCube.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then FCube.Parent := TGLBaseSceneObject(Trunc(parent));
   FCube.CubeWidth := Trunc(w);
   FCube.CubeHeight := Trunc(h);
   FCube.CubeDepth := Trunc(d);
   Result := Integer(FCube);
 end;

function TeapotCreate(const parent: real): real; stdcall;
 var
   FTeapot  : TGLTeapot;
 begin
   FTeapot := TGLTeapot.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then FTeapot.Parent := TGLBaseSceneObject(Trunc(parent));
   //FTeapot.Name := ContainerAddName('Teapot');
   Result := Integer(FTeapot);
 end;

function PlaneCreate(const squad, w, h, xt, yt, parent: real): real;  stdcall;
 var
   FPlane  : TGLPlane;
 begin
   FPlane := TGLPlane.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then FPlane.Parent := TGLBaseSceneObject(Trunc(parent));
   case Trunc(squad) of
     0:  FPlane.Style := [psSingleQuad, psTileTexture];
     1:  FPlane.Style := [psTileTexture];
   end;
   FPlane.Height := h;
   FPlane.Width := w;
   FPlane.XTiles := Trunc(xt);
   FPlane.YTiles := Trunc(yt);
   Result := Integer(FPlane);
 end;

function CubeSetNormalDirection(const cube, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0: TGLCube(Trunc(cube)).NormalDirection := ndOutside;
     1: TGLCube(Trunc(cube)).NormalDirection := ndInside;
   else
     TGLCube(Trunc(cube)).NormalDirection := ndOutside;
   end;
   Result := 1;
 end;

function SphereCreate(const radius, slices, stacks, parent: real): real; stdcall;
 var
   FSphere  : TGLSphere;
 begin
   FSphere := TGLSphere.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then FSphere.Parent := TGLBaseSceneObject(Trunc(parent));
   FSphere.Radius := radius;
   FSphere.Slices := Trunc(slices);
   FSphere.Stacks := Trunc(stacks);
   Result := Integer(FSphere);
 end;

function CylinderCreate(const topradius, bottomradius, height, slices, stacks, loops, parent: real): real; stdcall;
 var
   FCylinder  : TGLCylinder;
 begin
   FCylinder := TGLCylinder.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then FCylinder.Parent := TGLBaseSceneObject(Trunc(parent));
   FCylinder.TopRadius := topradius;
   FCylinder.BottomRadius := bottomradius;
   FCylinder.Height := height;
   FCylinder.Slices := Trunc(slices);
   FCylinder.Stacks := Trunc(stacks);
   FCylinder.Loops := Trunc(loops);
   Result := Integer(FCylinder);
 end;

function ConeCreate(const bottomradius, height, slices, stacks, loops, parent: real): real; stdcall;
 var
   FCone  : TGLCone;
 begin
   FCone := TGLCone.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then FCone.Parent := TGLBaseSceneObject(Trunc(parent));
   FCone.BottomRadius := bottomradius;
   FCone.Height := height;
   FCone.Slices := Trunc(slices);
   FCone.Stacks := Trunc(stacks);
   FCone.Loops := Trunc(loops);
   Result := Integer(FCone);
 end;

function AnnulusCreate(const bottominnerradius, topouterradius, height, slices, stacks, loops, parent: real): real; stdcall;
 var
   FAnnulus  :  TGLAnnulus;
 begin
   FAnnulus := TGLAnnulus.CreateAsChild(SceneNode.Objects);
   TGLScene(SceneNode).Objects.AddChild(FAnnulus);
    if not (parent = 0) then FAnnulus.Parent := TGLBaseSceneObject(Trunc(parent));
   FAnnulus.BottomInnerRadius := bottominnerradius;
   FAnnulus.TopInnerRadius := topouterradius;
   FAnnulus.Height := height;
   FAnnulus.Slices := Trunc(slices);
   FAnnulus.Stacks := Trunc(stacks);
   FAnnulus.Loops := Trunc(loops);
   Result := Integer(FAnnulus);
 end;

function TorusCreate(const outerradius, innerradius, rings, sides, parent: real): real; stdcall;
 var
   FTorus  : TGLTorus;
 begin
   FTorus := TGLTorus.CreateAsChild(SceneNode.Objects);
   TGLScene(SceneNode).Objects.AddChild(FTorus);
    if not (parent = 0) then FTorus.Parent := TGLBaseSceneObject(Trunc(parent));
   FTorus.MinorRadius := outerradius;
   FTorus.MajorRadius := innerradius;
   FTorus.Rings := Trunc(rings);
   FTorus.Sides := Trunc(sides);
   Result := Integer(FTorus);
 end;

function DiskCreate(const inr, outr, starta, sweepa, loop, slic, parent: real): real; stdcall;
 var
   FDisk  : TGLDisk;
 begin
   FDisk := TGLDisk.CreateAsChild(SceneNode.Objects);
   TGLScene(SceneNode).Objects.AddChild(FDisk);
    if not (parent=0) then FDisk.Parent := TGLBaseSceneObject(Trunc(parent));
   FDisk.InnerRadius := inr;
   FDisk.OuterRadius := outr;
   FDisk.StartAngle := starta;
   FDisk.SweepAngle := sweepa;
   FDisk.Loops := Trunc(loop);
   FDisk.Slices := Trunc(slic);
   Result := Integer(FDisk);
 end;



(*----------------------------------Light-----------------------------------*)
function LightCreate(const slight, parent: real): real; stdcall;
 var
   Light  : TGLLightSource;
 begin
   Light := TGLLightSource.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then Light.Parent := TGLBaseSceneObject(Trunc(parent));
     case Trunc(slight) of
       0: Light.LightStyle := lsSpot;
       1: Light.LightStyle := lsOmni;
       2: Light.LightStyle := lsParallel;
     else
       Result := 0;
       Exit;
     end;
   Result := Integer(Light);
 end;

function LightSetAttenuated(const light, aconst, alinear, aquadratic: real): real; stdcall;
 begin
   TGLLightSource(Trunc(light)).ConstAttenuation := aconst;
   TGLLightSource(Trunc(light)).LinearAttenuation := alinear;
   TGLLightSource(Trunc(light)).QuadraticAttenuation := aquadratic;
   Result := 1;
 end;

function LightSetAmbientColor(const light, color: real): real; stdcall;
 begin
   TGLLightSource(Trunc(light)).Ambient.AsWinColor := TColor(Trunc(color));
   Result := 1;
 end;

function LightSetDiffuseColor(const light, color: real): real; stdcall;
 begin
   TGLLightSource(Trunc(light)).Diffuse.AsWinColor := TColor(Trunc(color));
   Result := 1;
 end;

function LightSetStyle(const light, style: real): real; stdcall;
 begin
   case Trunc(style) of
     0: TGLLightSource(Trunc(light)).LightStyle := lsSpot;
     1: TGLLightSource(Trunc(light)).LightStyle := lsOmni;
     2: TGLLightSource(Trunc(light)).LightStyle := lsParallel;
   else
     TGLLightSource(Trunc(light)).LightStyle := lsSpot;
   end;
   Result := 1;
 end;

function LightSetSpecularColor(const light, color: real): real; stdcall;
 begin
   TGLLightSource(Trunc(light)).Specular.AsWinColor := TColor(Trunc(color));
   Result := 1;
 end;

function LightSetShining(const light, mode: real): real; stdcall;
 begin
   TGLLightSource(Trunc(light)).Shining := boolean(Trunc(mode));
   Result := 1;
 end;

function LightSetSpotCutoff(const light, cutoff: real): real; stdcall;
 begin
   TGLLightSource(Trunc(light)).SpotCutOff := cutoff;
   Result := 1;
 end;

function LightSetSpotExponent(const light, exp: real): real; stdcall;
 begin
   TGLLightSource(Trunc(light)).SpotExponent := exp;
   Result := 1;
 end;

function LightSetSpotDirection(const light, x, y, z: real): real; stdcall;
 begin
   TGLLightSource(Trunc(light)).SpotDirection.SetVector(x, y, z);
   Result := 1;
 end;



(*----------------------------------HUD-------------------------------------*)
function HUDFontAddResource(const fname: PChar): real; stdcall;
 begin
   if Assigned(FontList) then
   begin
     FontList.Add(PChar(fname));
   end
     else
   begin
     FontList := TStringList.Create;
     FontList.Add(PChar(fname));
   end;
   Result := AddFontResource(PChar(fname));
 end;

function HUDFontCreate(const name: PChar; cstart, cend, height: real): real; stdcall;
 var
   HFont  : TGLWindowsBitmapFont;
 begin
   HFont := TGLWindowsBitmapFont.Create(SceneNode);
   HFont.Font.Name := name;
   HFont.Ranges[0].StartASCII := Char(Trunc(cstart));
   HFont.Ranges[0].StopASCII := Char(Trunc(cend));
   HFont.Font.Charset := RUSSIAN_CHARSET;
   HFont.Font.Height := Trunc(height);
   Result := Integer(HFont);
 end;

function HUDFontSetStyle(const font, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0:  TGLWindowsBitmapFont(Trunc(font)).Font.Style := [];
     1:  TGLWindowsBitmapFont(Trunc(font)).Font.Style := [fsItalic]; //
     2:  TGLWindowsBitmapFont(Trunc(font)).Font.Style := [fsUnderline]; //
     3:  TGLWindowsBitmapFont(Trunc(font)).Font.Style := [fsStrikeout]; //
     4:  TGLWindowsBitmapFont(Trunc(font)).Font.Style := [fsBold]; //
   end;
   Result := 1;
 end;

function HUDFontRemove(const fname: PChar): real; stdcall;
 begin
   Result := Integer(RemoveFontResource(PChar(fname)));
 end;

function HUDTextCreate(const font: real; str: PChar; parent: real): real; stdcall;
 var
   HText  : TGLHUDText;
 begin
   HText := TGLHUDText.Create(SceneNode);
    if not (parent = 0) then HText.Parent := TGLBaseSceneObject(Trunc(parent));
   HText.BitmapFont := TGLCustomBitmapFont(Trunc(font));
   HText.Text := str;
   Result := Integer(HText);
 end;

function HUDTextSetText(const text: real; str: PChar): real; stdcall;
 var
   HText: TGLHUDText;
 begin
   HText := TGLHUDText(Trunc(text));
   HText.Text := str;
   Result := 1;
 end;

function HUDTextSetColor(const text, color, alpha: real): real; stdcall;
 var
   HText: TGLHUDText;
 begin
   HText := TGLHUDText(Trunc(text));
   HText.ModulateColor.AsWinColor := TColor(Trunc(color));
   HText.ModulateColor.Alpha := alpha;
   Result := 1;
 end;

function HUDBillboardCreate(const mat: PChar; w, h, parent: real): real; stdcall;
 var
   HUDBillboard: TGLHUDSprite;
 begin
   HUDBillboard := TGLHUDSprite.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then HUDBillboard.Parent := TGLBaseSceneObject(Trunc(parent));
   HUDBillboard.Material.MaterialLibrary := SceneMaterialLibrary;
   HUDBillboard.Material.LibMaterialName := mat;
   HUDBillboard.Width := w;
   HUDBillboard.Height := h;
   Result := Integer(HUDBillboard);
 end;



(*---------------------------------Billboard---------------------------------*)
function BillboardCreate(const mat: PChar; w, h, parent: real): real; stdcall;
 var
   Billboard  : TGLSprite;
 begin
   Billboard := TGLSprite.CreateAsChild(SceneNode.Objects);
   TGLScene(SceneNode).Objects.AddChild(Billboard);
    if not (parent = 0) then Billboard.Parent := TGLBaseSceneObject(Trunc(parent));
   Billboard.Width := w;
   Billboard.Height := h;
   Billboard.Material.LibMaterialName := mat;
   Result := Integer(Billboard);
 end;

function BillboardSetSize(const bill, w, h: real): real; stdcall;
 begin
   TGLSprite(Trunc(bill)).SetSize(w, h);
   Result := 1;
 end;

function BillboardSetScale(const bill, u, v: real): real; stdcall;
 var
   Billboard : TGLSprite;
 begin
   Billboard := TGLSprite(Trunc(bill));
   Billboard.Scale.X := u;
   Billboard.Scale.Y := v;
   Result := 1;
 end;

function BillboardSetMirror(const bill, u, v: real): real; stdcall;
 begin
   if (Boolean(Trunc(u)) = true) then begin TGLSprite(Trunc(bill)).MirrorU := true; end else TGLSprite(Trunc(bill)).MirrorU := false;
   if (Boolean(Trunc(v)) = true) then begin TGLSprite(Trunc(bill)).MirrorV := true; end else TGLSprite(Trunc(bill)).MirrorV := false;
   Result := 1;
 end;

function BillboardSetSquareSize(const bill, size: real): real; stdcall;
 begin
   TGLSprite(Trunc(bill)).SetSquareSize(size);
   Result := 1;
 end;

function BillboardSetRotation(const bill, rot: real): real; stdcall;
 begin
   TGLSprite(Trunc(bill)).Rotation := rot;
   Result := 1;
 end;

function BillboardSetAlpha(const bill, alpha: real): real; stdcall;
 begin
   TGLSprite(Trunc(bill)).AlphaChannel := alpha;
   Result := 1;
 end;



(*-----------------------------------Mouse-----------------------------------*)
function MouseSetPosition(const mx, my: real): real; stdcall;
 begin
   setcursorPos(Trunc(mx), Trunc(my));
   Result := 1;
 end;

function MouseGetPositionX: real; stdcall;
 var
   mouse : TPoint;
 begin
   GetCursorPos(mouse);
   Result := Integer(mouse.X);
 end;

function MouseGetPositionY: real; stdcall;
 var
   mouse : TPoint;
 begin
   GetCursorPos(mouse);
   Result := Integer(mouse.Y);
 end;

function MouseShowCursor(const mode: real): real; stdcall;
 begin
   ShowCursor(LongBool(Trunc(mode)));
   Result := 1;
 end;



(*---------------------------------Material----------------------------------*)
function MaterialLibraryCreate: real; stdcall;
 var
   mlib: TGLMaterialLibrary;
 begin
   mlib := TGLMaterialLibrary.Create(SceneNode);
   Result := Integer(mlib);
 end;

function MaterialLibraryActivate(const mlib: real): real; stdcall;
 begin
   SceneMaterialLibrary := TGLMaterialLibrary(Trunc(mlib));
   Result := 1;
 end;

function MaterialLibrarySetTexturePaths(const mlb: real; path: PChar): real; stdcall;
 begin
   try
     if not Assigned(SceneMaterialLibrary) then raise Exception.Create(glsMatLibNotDefined);
     TGLMaterialLibrary(Trunc(mlb)).TexturePaths := PChar(path);
     Result := 1;
   except
     on E: Exception do begin
       MessageBox(0, PAnsiChar(E.Message), ECaption, EType);
       Result := 0;
       Exit;
     end;
   end;
 end;

function MaterialCreate(const mat, fname: PChar; mode: real): real; stdcall;
 begin
   try
     SceneMaterialLibrary.AddTextureMaterial(mat, fname, true);
     if Boolean(Trunc(mode)) = true then
     begin
       SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.BlendingMode := bmTransparency;
       SceneMaterialLibrary.TextureByName(mat).TextureMode := tmReplace
     end;
   except
     on E: Exception do begin
       MessageBox(0, PAnsiChar(Format(E.Message, [fname])), ECaption, EType);
       Result := 0;
       Exit;
     end;
   end;
   Result := 1;
 end;
//Todo II
function MaterialSetObject(const mat: PChar; obj: real): real; stdcall;
 begin
   if not (TGLSceneObject(Trunc(obj)) = nil) then
     begin
       TGLSceneObject(Trunc(obj)).Material.MaterialLibrary := SceneMaterialLibrary;
       TGLSceneObject(Trunc(obj)).Material.LibMaterialName := mat;
     end
   else
     begin
       Result := 0;
       Exit;
     end;
   Result := 1;
 end;

function MaterialSetTextureFilter(const mat: PChar; mi, ma: real): real; stdcall;
 begin
    if Assigned(SceneMaterialLibrary) then
     begin
       //Min Filter
       case Trunc(mi) of
         1: SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MinFilter := miNearest;
         2: SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MinFilter := miLinear;
         3: SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MinFilter := miNearestMipmapNearest;
         4: SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MinFilter := miLinearMipmapNearest;
         5: SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MinFilter := miNearestMipmapLinear;
         6: SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MinFilter := miLinearMipmapLinear;
       else
         SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MinFilter := miLinear;
       end;
       //Mag Filter
       case Trunc(ma) of
         1: SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MagFilter := maNearest;
         2: SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MagFilter := maLinear;
       else
         SceneMaterialLibrary.Materials.GetLibMaterialByName(mat).Material.Texture.MagFilter := maLinear;
       end;
      Result := 1;
     end else
     Result := 0;
     Exit;
 end;

function MaterialLibrarySetClear: real; stdcall;
 begin
   SceneMaterialLibrary.Materials.Clear;
   Result := 1;
 end;

function MaterialLibraryDeleteUnusedMaterials: real; stdcall;
 begin
  SceneMaterialLibrary.Materials.DeleteUnusedMaterials;
   Result := 1;
 end;

function MaterialSetTextureMappingMode(const mode: real; mat: PChar): real; stdcall;
 begin
   case Trunc(mode) of
     0: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.MappingMode := tmmUser;
     1: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.MappingMode := tmmObjectLinear;
     2: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.MappingMode := tmmEyeLinear;
     3: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.MappingMode := tmmSphere;
     4: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.MappingMode := tmmCubeMapReflection;
     5: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.MappingMode := tmmCubeMapNormal;
     6: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.MappingMode := tmmCubeMapLight0;
     7: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.MappingMode := tmmCubeMapCamera;
   else
     SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.MappingMode := tmmUser;
   end;
   Result := 1;
 end;

function MaterialSetTextureImageAlpha(const mode: real; mat: PChar): real; stdcall;
 begin
   case Trunc(mode) of
     0: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaDefault;
     1: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaAlphaFromIntensity;
     2: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaSuperBlackTransparent;
     3: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaLuminance;
     4: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaLuminanceSqrt;
     5: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaOpaque;
     6: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaTopLeftPointColorTransparent;
     7: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaInverseLuminance;
     8: SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaInverseLuminanceSqrt;
   else
     SceneMaterialLibrary.LibMaterialByName(mat).Material.Texture.ImageAlpha := tiaDefault;
   end;
   Result := 1;
 end;

function MaterialLibrarySetTextureScale(const mat: PChar; scalx, scaly, scalz: real): real; stdcall;
 begin
   SceneMaterialLibrary.LibMaterialByName(mat).TextureScale.X := scalx;
   SceneMaterialLibrary.LibMaterialByName(mat).TextureScale.Y := scaly;
   SceneMaterialLibrary.LibMaterialByName(mat).TextureScale.Z := scalz;
   Result := 1;
 end;



(*----------------------------------Object-----------------------------------*)
function ObjectSetPosition(const obj, x, y, z: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).Position.SetPoint(x, y, z);
   Result := 1;
 end;
//  ?
function ObjectSetRotation(const obj, rx, ry, rz: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).Rotation.SetVector(rx, ry, rz);
   Result := 1;
 end;

function ObjectGetPosition(const obj, vec: real): real; stdcall;
 begin
   case Trunc(vec) of
     0: Result := TGLSceneObject(Trunc(obj)).Position.X;
     1: Result := TGLSceneObject(Trunc(obj)).Position.Y;
     2: Result := TGLSceneObject(Trunc(obj)).Position.Z;
   else
     Result := -1;
   end;
 end;

function ObjectMove(const obj, adist: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).Move(adist);
   Result := 1;
 end;

function ObjectSlide(const obj, adist: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).Slide(adist);
   Result := 1;
 end;

function ObjectDestroy(const obj: real): real; stdcall;
 begin
   try
     TGLSceneObject(Trunc(obj)).Destroy;
   except
     on E: Exception do begin
       MessageBox(0, PAnsiChar(E.Message), ECaption, EType);
       Result := 0;
       Exit;
     end;
   end;
  Result := 1;
 end;

function ObjectRotate(const obj, p, t, r: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).Roll(r);
   TGLSceneObject(Trunc(obj)).Turn(t);
   TGLSceneObject(Trunc(obj)).Pitch(p);
   Result := 1;
 end;

function ObjectGetPitch(const obj: real): real; stdcall;
 begin
   Result := TGLSceneObject(Trunc(obj)).PitchAngle;
 end;

function ObjectSetPitchAngle(const obj, p: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).PitchAngle := p;
   Result := 1;
 end;

function ObjectSetTurnAngle(const obj, p: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).TurnAngle := p;
   Result := 1;
 end;

function ObjectSetScale(const obj, x, y, z: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).Scale.SetVector(x, y, z);
   Result := 1;
 end;

function ObjectSetVisible(const obj, mode: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).Visible := Boolean(Trunc(mode));
   Result := 1;
 end;

function ObjectSetShowAxes(const obj, mode: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).ShowAxes := Boolean(Trunc(mode));
   Result := 1;
 end;

function ObjectSetTranslate(const obj, tx, ty, tz: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).Translate(tx, ty, tz);
   Result := 1;
 end;

function ObjectSetDeleteChildren(const obj: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).DeleteChildren;
   Result := 1;
 end;

function ObjectSetDirection(const obj, x, y, z: real): real; stdcall;
 begin
   TGLSceneObject(Trunc(obj)).Direction.SetVector(x, y, z);
   Result := 1;
 end;
// ?
function ObjectGetScale(const obj, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0:  Result := TGLSceneObject(Trunc(obj)).Scale.X;
     1:  Result := TGLSceneObject(Trunc(obj)).Scale.Y;
     2:  Result := TGLSceneObject(Trunc(obj)).Scale.Z;
   else
     Result := 0;
     Exit;
   end;
 end;

function ObjectSetSorting(const obj, sort: real): real; stdcall;
 begin
   case Trunc(sort) of
     0: TGLSceneObject(Trunc(obj)).ObjectsSorting := osNone;
     1: TGLSceneObject(Trunc(obj)).ObjectsSorting := osInherited;
     2: TGLSceneObject(Trunc(obj)).ObjectsSorting := osRenderFarthestFirst;
     3: TGLSceneObject(Trunc(obj)).ObjectsSorting := osRenderBlendedLast;
     4: TGLSceneObject(Trunc(obj)).ObjectsSorting := osRenderNearestFirst;
   else
     Result := 0;
     Exit;
   end;
   Result := 1;
 end;

function ObjectIsVisible(const obj: real): real; stdcall;
 begin
   Result := Integer(TGLSceneObject(Trunc(obj)).Visible);
 end;
//todo II
function ObjectSetStyle(const obj, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0:  TGLSceneObject(Trunc(obj)).ObjectStyle := [osDirectDraw];
     1:  TGLSceneObject(Trunc(obj)).ObjectStyle := [osIgnoreDepthBuffer];
     2:  TGLSceneObject(Trunc(obj)).ObjectStyle := [osNoVisibilityCulling];
     3:  TGLSceneObject(Trunc(obj)).ObjectStyle := [osBuiltStage];
   end;
   Result := 1;
 end;
////
function ObjectSetVisibleCulling(const obj, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0: TGLSceneObject(Trunc(obj)).VisibilityCulling := vcNone;
     1: TGLSceneObject(Trunc(obj)).VisibilityCulling := vcInherited;
     2: TGLSceneObject(Trunc(obj)).VisibilityCulling := vcObjectBased;
     3: TGLSceneObject(Trunc(obj)).VisibilityCulling := vcHierarchical;
   else
     TGLSceneObject(Trunc(obj)).VisibilityCulling := SceneNode.VisibilityCulling;
   end;
   Result := 1;
 end;



(*----------------------------------Actor-------------------------------------*)
function ActorCreate(const name: PChar; parent: real): real; stdcall;
 var
    Actor : TGLActor;
 begin
   try
     Actor := TGLActor.CreateAsChild(SceneNode.Objects);
      if not (parent = 0) then Actor.Parent := TGLBaseSceneObject(Trunc(parent));
     Actor.LoadFromFile(name);
     Actor.MaterialLibrary := SceneMaterialLibrary;
     Actor.AnimationMode := aamLoop;
     Actor.Direction.Y := 90;
     Actor.MeshObjects.UseVBO := true;
   except
     on E: Exception do
     begin
        MessageBox(0, PAnsiChar(E.Message), ECaption, Etype);
        Result := 0;
        Exit;
     end;
   end;
   Result := Integer(Actor);
 end;

function ActorGetTriangleCount(const actor: real): real; stdcall;
 begin
   Result := TGLActor(Trunc(actor)).MeshObjects.TriangleCount;
 end;

function ActorCopy(const actor, parent: real): real; stdcall;
 var
   FActor1, FActor2: TGLActor;
 begin
   FActor1 := TGLActor(Trunc(actor));
   FActor2 := TGLActor.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then FActor2.Parent := TGLBaseSceneObject(Trunc(parent));
   FActor2.Assign(FActor1);
   Result := Integer(FActor2);
 end;

function ActorSetAnimationRange(const actor, astart, aend: real): real; stdcall;
 var
   FActor : TGLActor;
 begin
   FActor := TGLActor(Trunc(actor));
   FActor.StartFrame := Trunc(astart);
   FActor.EndFrame := Trunc(aend);
   Result := 1;
 end;

function ActorGetCurrentFrame(const actor: real): real; stdcall;
 begin
   Result := TGLActor(Trunc(actor)).CurrentFrame;
 end;

function ActorSwitchToAnimation(const actor, anim, smooth: real): real; stdcall;
 begin
   TGLActor(Trunc(actor)).SwitchToAnimation(Trunc(anim), Boolean(Trunc(smooth)));
   Result := 1;
 end;

function ActorSwitchToAnimationName(const actor: real; anim: pchar; smooth: real): real; stdcall;
 begin
  TGLActor(Trunc(actor)).SwitchToAnimation(anim, Boolean(Trunc(smooth)));
  Result := 1;
 end;

function ActorSetSynchronize(const actor1, actor2: real): real; stdcall;
 var
   FActor1, FActor2 : TGLActor;
 begin
   FActor1 := TGLActor(Trunc(actor1));
   FActor2 := TGLActor(Trunc(actor2));
   FActor1.Synchronize(FActor2);
   Result := 1;
 end;

function ActorSetInterval(const actor, interv: real): real; stdcall;
 begin
   TGLActor(Trunc(actor)).Interval := Trunc(interv);
   Result := 1;
 end;

function ActorSetAnimationMode(const actor, aam: real): real; stdcall;
 var
   FActor : TGLActor;
 begin
   FActor := TGLActor(Trunc(actor));
   case Trunc(aam) of
     0: FActor.AnimationMode := aamNone;
     1: FActor.AnimationMode := aamPlayOnce;
     2: FActor.AnimationMode := aamLoop;
     3: FActor.AnimationMode := aamBounceForward;
     4: FActor.AnimationMode := aamBounceBackward;
     5: FActor.AnimationMode := aamLoopBackward;
   else
     FActor.AnimationMode := aamNone;
   end;
   Result := 1;
 end;

function ActorSetFrameInterpolation(const actor, afp: real): real; stdcall;
 var
   FActor : TGLActor;
 begin
   FActor := TGLActor(Trunc(actor));
   case Trunc(afp) of
     0: FActor.FrameInterpolation := afpNone;
     1: FActor.FrameInterpolation := afpLinear;
   else
     FActor.FrameInterpolation := afpNone;
   end;
   Result := 1;
 end;

function ActorAddDataFromFile(const actor: real; fname: PChar): real; stdcall;
 begin
   TGLActor(Trunc(actor)).AddDataFromFile(fname);
   Result := 1;
 end;

function ActorGetCurrentAnimation(const actor: real): PChar; stdcall;
  var
   anim: string;
  begin
   anim := TGLActor(Trunc(actor)).CurrentAnimation;
   Result := PChar(anim);
  end;

function ActorGetFrameCount(const actor: real): real; stdcall;
 begin
   Result := TGLActor(Trunc(actor)).FrameCount;
 end;

function ActorGetBoneCount(const actor: real): real; stdcall;
 begin
   Result := TGLActor(Trunc(actor)).Skeleton.BoneCount;
 end;

function ActorGetBoneByName(const actor: real; name: pchar): real; stdcall;
 begin
   Result := TGLActor(Trunc(actor)).Skeleton.BoneByName(name).BoneID;;
 end;

function ActorGetBoneRotation(const actor, bone, ind: real): real; stdcall;
 var
   m     : TMatrix4f;
   index : integer;
 begin
   m := TGLActor(Trunc(actor)).Skeleton.BoneByID(Trunc(bone)).GlobalMatrix;
   index := Trunc(ind);
   Result := m[2][index];
 end;

function ActorGetBonePosition(const actor, bone, ind: real): real; stdcall;
 var
   m: TMatrix4f;
   index: integer;
 begin
   m := TGLActor(Trunc(actor)).Skeleton.BoneByID(Trunc(bone)).GlobalMatrix;
   index := trunc64(ind);
   Result := m[3][index];
 end;

function ActorShowSkeleton(const actor, mode: real): real; stdcall;
 begin
   TGLActor(Trunc(actor)).OverlaySkeleton := Boolean(Trunc(mode));
   Result := 1;
 end;



(*---------------------------------Freeform-----------------------------------*)
function FreeformCreate(const fname: PChar; parent: real): real; stdcall;
 var
   FFreeForm : TGLFreeForm;
 begin
   FFreeForm := TGLFreeForm.CreateAsChild(SceneNode.Objects);
    if not (parent = 0) then FFreeForm.Parent := TGLBaseSceneObject(Trunc(parent));
   FFreeForm.MaterialLibrary := SceneMaterialLibrary;
   FFreeForm.LightmapLibrary := SceneMaterialLibrary;
   FFreeForm.LoadFromFile(fname);
   FFreeForm.BuildOctree;
   FFreeForm.MeshObjects.UseVBO := true;
   Result := Integer(FFreeForm);
 end;

function FreeformPointInMesh(const freeform, x, y, z: real): real; stdcall;
 var
   vec: TVector4f;
 begin
   vec[0] := x;
   vec[1] := y;
   vec[2] := z;
   Result := Integer(TGLFreeForm(Trunc(freeform)).PointInObject(vec));
 end;

function FreeformGetTriangleCount(const freeform: real): real; stdcall;
 begin
   Result := TGLFreeForm(Trunc(freeform)).MeshObjects.TriangleCount;
 end;
////
function FreeformGetMeshCount(const freeform: real): real; stdcall;
 begin
   Result := Integer(TGLFreeForm(Trunc(freeform)).MeshObjects.Count);
 end;
////
function FreeformSetMeshVisible(const freeform, mesh, mode: real): real; stdcall;
begin
  TGLFreeForm(Trunc(freeform)).MeshObjects[Trunc(mesh)].Visible := Boolean(Trunc(mode));
  TGLFreeForm(Trunc(freeform)).StructureChanged;
  Result := 1;
end;
//todo
function FreeformToFreeforms(const freeform, start, count, mesh: real): real; stdcall;
 var
   FFreeform : TGLFreeForm;
   i: Integer;
 begin
   FFreeform := TGLFreeForm.CreateAsChild(SceneNode.Objects);
   FFreeform.MaterialLibrary := SceneMaterialLibrary;
   for i := Trunc(count) downto Trunc(start) do   // start -     count - - 
   begin
     FFreeform.MeshObjects.Add(FFreeform.MeshObjects[i]);
     FFreeform.StructureChanged;
   end;
   Result := 1;
end;
//todo
function FreeformSetMeshSecondCoords(const freform: real): real; stdcall;
begin
  //TGLFreeForm(Trunc(freform))
  Result := 1;
end;



(*---------------------------------DCE-----------------------------------*)
//Manager
function DceManagerCreate: real; stdcall;
 var
   DCEManager  : TGLDCEManager;
 begin
   DCEManager := TGLDCEManager.Create(SceneNode);
   Result := Integer(DCEManager);
 end;

function DceManagerStep(const man, dt: real): real; stdcall;
 begin
   TGLDCEManager(Trunc(man)).Step(dt);
   Result := 1;
 end;

function DceManagerSetGravity(const man, gv: real): real; stdcall;
 begin
   TGLDCEManager(Trunc(man)).Gravity := gv;
   Result := 1;
 end;

function DceManagerSetWorldDirection(const man, x, y, z: real): real; stdcall;
 begin
   TGLDCEManager(Trunc(man)).WorldDirection.X := x;
   TGLDCEManager(Trunc(man)).WorldDirection.Y := y;
   TGLDCEManager(Trunc(man)).WorldDirection.Z := z;
   Result := 1;
 end;

function DceManagerSetWorldScale(const man, scale: real): real; stdcall;
 begin
   TGLDCEManager(Trunc(man)).WorldScale := scale;
   Result := 1;
 end;

function DceManagerSetMovementScale(const man, scale: real): real; stdcall;
 begin
   TGLDCEManager(Trunc(man)).MovimentScale := scale;
   Result := 1;
 end;

function DceManagerSetLayers(const man, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0:  TGLDCEManager(Trunc(man)).StandardiseLayers := ccsDCEStandard;
     1:  TGLDCEManager(Trunc(man)).StandardiseLayers := ccsCollisionStandard;
     2:  TGLDCEManager(Trunc(man)).StandardiseLayers := ccsHybrid;
   else
     TGLDCEManager(Trunc(man)).StandardiseLayers := ccsDCEStandard;
   end;
   Result := 1;
 end;

function DceManagerSetManualStep(const man, mode: real): real; stdcall;
 begin
   TGLDCEManager(Trunc(man)).ManualStep := Boolean(Trunc(mode));
   Result := 1;
 end;

//Dynamic
function DceDynamicSetManager(const obj, man: real): real; stdcall;
 begin
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Manager := TGLDCEManager(Trunc(man));
   Result := 1;
 end;

function DceDynamicSetActive(const obj, mode: real): real; stdcall;
 begin
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Active := Boolean(Trunc(mode));
   Result := 1;
 end;

function DceDynamicIsActive(const obj: real): real; stdcall;
 begin
   Result := Integer(GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Active);
 end;

function DceDynamicSetUseGravity(const obj, mode: real): real; stdcall;
 begin
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).UseGravity := Boolean(Trunc(mode));
   Result := 1;
 end;

function DceDynamicSetLayer(const obj, layer: real): real; stdcall;
 begin
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Layer := Trunc(layer);
   Result := 1;
 end;

function DceDynamicGetLayer(const obj: real): real; stdcall;
 begin
   Result := Integer(GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Layer);
 end;

function DceDynamicSetSolid(const obj, mode: real): real; stdcall;
 begin
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Solid := Boolean(Trunc(mode));
   Result := 1;
 end;

function DceDynamicSetFriction(const obj, friction: real): real; stdcall;
 begin
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Friction := friction;
   Result := 1;
 end;

function DceDynamicSetBounce(const obj, bounce: real): real; stdcall;
 begin
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).BounceFactor := bounce;
   Result := 1;
 end;

function DceDynamicSetSize(const obj, x, y, z: real): real; stdcall;
 begin
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Size.X := x;
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Size.Y := y;
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).Size.Z := z;
   Result := 1;
 end;

function DceDynamicSetSlideOrBounce(const obj, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0: GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).SlideOrBounce := csbSlide;
     1: GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).SlideOrBounce := csbBounce;
   else
     GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).SlideOrBounce := csbSlide;
   end;
   Result := 1;
 end;

function DceDynamicApplyAcceleration(const obj, x, y, z: real): real; stdcall;
 var
   FForce : TVector3f;
 begin
   FForce[0] := x;
   FForce[1] := y;
   FForce[2] := z;
   GetOrCreateDCEDynamic(TGLBaseSceneObject(Trunc(obj))).ApplyAccel(FForce);
   Result := 1;
 end;

//Static
function DceStaticSetManager(const obj, man: real): real; stdcall;
 begin
   GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Manager := TGLDCEManager(Trunc(man));
   Result := 1;
 end;

function DceStaticSetActive(const obj, mode: real): real; stdcall;
 begin
   GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Active := Boolean(Trunc(mode));
   Result := 1;
 end;

function DceStaticSetShape(const obj, mode: real): real; stdcall;
 begin
   case Trunc(mode) of
     0: GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Shape := csFreeform;
     1: GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Shape := csTerrain;
     2: GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Shape := csEllipsoid;
     3: GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Shape := csBox;
   else
     Result := 0;
     Exit;
   end;
   Result := 1;
 end;

function DceStaticSetLayer(const obj, layer: real): real; stdcall;
 begin
   GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Layer := Trunc(layer);
   Result := 1;
 end;

function DceStaticSetSize(const obj, x, y, z: real): real; stdcall;
 begin
   GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Size.X := x;
   GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Size.Y := y;
   GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Size.Z := z;
   Result := 1;
 end;

function DceStaticSetSolid(const obj, mode: real): real; stdcall;
 begin
   GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Solid := Boolean(Trunc(mode));
   Result := 1;
 end;

function DceStaticSetFriction(const obj, friction: real): real; stdcall;
 begin
   GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).Friction := friction;
   Result := 1;
 end;

function DceStaticSetBounceFactor(const obj, bfactor: real): real; stdcall;
 begin
   GetOrCreateDCEStatic(TGLBaseSceneObject(Trunc(obj))).BounceFactor := bfactor;
   Result := 1;
 end;



 
exports
 //Engine
 EngineCreate, EngineDestroy, EngineUpdate,  EngineGetMaxTextureSize, EngineGetMaxTextureUnits,
 EngineGetBuild, EngineSetVisibilityCulling, EngineSetObjectSorting,
 EngineGetVBOSupported, EngineGetGLSLSupported, EngineSetArchivePak,

 //View
 ViewerCreate, ViewerSetCamera, ViewerSetLighting, ViewerSetAntiAliasing, ViewerSetBackgroundColor,
 ViewerSetAmbientColor, ViewerSetFaceCulling, ViewerSetVSync, ViewerGetPixelColor, ViewerGetPixelDepth,
 ViewerScreenToWorld, ViewerWorldToScreen, ViewerGetViewportSize,

 //Dummy
 DummycubeCreate,  DummycubeSetCubeSize, DummycubeSetEdgeColor, DummycubeSetVisible,
 DummycubeSetAmalgamate, DummycubeSetCamInvarianceMode,

 //Camera
 CameraCreate, CameraSetDepthOfView, CameraSetFocalLength, CameraSetMoveAroundTarget, CameraSetStyle,
 CameraSetScaleScene, CameraSetTargetObject, CameraSetDistanceToTarget, CameraGetDistanceToTarget,

 //Primitive
 CubeCreate, TeapotCreate, PlaneCreate, CubeSetNormalDirection, SphereCreate, CylinderCreate, ConeCreate,
 AnnulusCreate, TorusCreate, DiskCreate,

 //Light
 LightCreate, LightSetAttenuated, LightSetAmbientColor, LightSetDiffuseColor, LightSetStyle,
 LightSetSpecularColor, LightSetShining, LightSetSpotCutoff, LightSetSpotExponent, LightSetSpotDirection,

 //HUD
 HUDFontCreate, HUDTextCreate, HUDTextSetText, HUDTextSetColor, HUDBillboardCreate, HUDFontAddResource,
 HUDFontRemove, HUDFontSetStyle,

 //Billboard
 BillboardCreate, BillboardSetSize, BillboardSetScale, BillboardSetMirror, BillboardSetSquareSize,
 BillboardSetRotation, BillboardSetAlpha,

 //Mouse
 MouseSetPosition, MouseGetPositionX, MouseGetPositionY, MouseShowCursor,

 //Material
 MaterialLibraryCreate, MaterialLibraryActivate, MaterialLibrarySetTexturePaths, MaterialCreate,
 MaterialSetObject, MaterialSetTextureFilter, MaterialLibrarySetClear, MaterialLibraryDeleteUnusedMaterials,
 MaterialSetTextureMappingMode, MaterialSetTextureImageAlpha, MaterialLibrarySetTextureScale,

 //Object
 ObjectSetPosition, ObjectSetRotation, ObjectMove, ObjectSlide, ObjectGetPosition, ObjectDestroy,
 ObjectRotate, ObjectGetPitch, ObjectSetPitchAngle, ObjectSetTurnAngle, ObjectSetScale, ObjectSetVisible,
 ObjectSetShowAxes, ObjectSetTranslate, ObjectSetDeleteChildren, ObjectSetDirection, ObjectGetScale,
 ObjectSetStyle,

 //Actor
 ActorCreate, ActorGetTriangleCount, ActorCopy, ActorSetAnimationRange, ActorGetCurrentFrame,
 ActorSwitchToAnimation, ActorSwitchToAnimationName, ActorSetSynchronize, ActorSetInterval,
 ActorSetAnimationMode, ActorSetFrameInterpolation, ActorAddDataFromFile, ActorGetCurrentAnimation,
 ActorGetFrameCount, ActorGetBoneCount, ActorGetBoneByName, ActorGetBoneRotation, ActorGetBonePosition,
 ActorShowSkeleton, ObjectIsVisible, ObjectSetSorting,

 //Freeform
 FreeformCreate, FreeformPointInMesh, FreeformGetTriangleCount,

 //DCE
 //Manager
 DceManagerCreate, DceManagerStep, DceManagerSetWorldDirection, DceManagerSetWorldScale, DceManagerSetGravity,
 DceManagerSetLayers, DceManagerSetManualStep, DceDynamicSetManager, DceManagerSetMovementScale,
 //Dynamic
 DceDynamicSetActive, DceDynamicIsActive, DceDynamicSetUseGravity, DceDynamicSetLayer,
 DceDynamicGetLayer, DceDynamicSetSolid, DceDynamicSetFriction, DceDynamicSetBounce,
 DceDynamicSetSize, DceDynamicSetSlideOrBounce, DceDynamicApplyAcceleration,
 //Static
 DceStaticSetManager, DceStaticSetActive, DceStaticSetShape, DceStaticSetLayer, DceStaticSetSize,
 DceStaticSetSolid, DceStaticSetFriction, DceStaticSetBounceFactor;


begin
end.

