Xtreme3D
========
Xtreme3D is a cross-language 3D graphics engine for Windows based on [GLScene](https://github.com/GLScene/GLScene). It has a rich feature set, including custom shaders, wide variety of asset formats support, built-in effects, physics, collision and ray casting.

Xtreme3D originally was created for [Game Maker](https://gamemaker.io/) Classic. It makes possible to create full-featured 3D games with modern graphics and reasonable framerate with Game Maker that was intended mainly for 2D games and provides limited built-in 3D capabilities. Original Xtreme3D was a closed-source project, and it was abandoned by the author. Xtreme3D 2.0.2.0 (2006) was the last official release. So we in Russian Xtreme3D community made an attempt to rewrite the engine, maintaining the API as close to original as possible. This work began in 2009 and was completed in 2016. This project is not connected in any way with the original Xtreme3D developer, all code was written from scratch.

The engine is written in Delphi 12 and based on a modified version of GLScene 2.2. The code can be compiled with free Delphi Community Edition.

Visit Xtreme3D site at [https://xtreme3d.ru](https://xtreme3d.ru).

Screenshots
-----------
[![Screenshot3](/screenshots/pbr-thumb.jpg)](/screenshots/pbr.jpg)
[![Screenshot1](/screenshots/shadows-thumb.jpg)](/screenshots/shadows.jpg)
[![Screenshot4](/screenshots/water2-thumb.jpg)](/screenshots/water2.jpg)
[![Screenshot4](/screenshots/bumpshadows-thumb.jpg)](/screenshots/bumpshadows.jpg)
[![Screenshot4](/screenshots/x3d-3.0-rain-thumb.jpg)](/screenshots/x3d-3.0-rain.jpg)
[![Screenshot4](/screenshots/darkarts-thumb.jpg)](/screenshots/darkarts.jpg)

Features
--------
* Built for modern 64-bit GameMaker
* Can be used with any language that supports DLLs
* Scene graph with object hierarchy/pivoting
* Built-in primitives (such as box, sphere, cylinder, teapot, etc.)
* Materials and textures. Materials can be loaded from script files
* GLSL shaders
* Built-in easy to use shaders, including cel shader, bump/parallax shader, phong shader, multimaterial shader, etc.
* Multitexturing. Materials can have up to 8 texture slots accessible from shaders. Fixed-pipeline multipass multitexturing is also supported
* Popular image formats support for textures (BMP, JPG, PNG, TGA, DDS)
* Various 3D model formats support (3DS, OBJ, LWO, B3D, MD2, MD3, MD5, SMD and many other)
* Procedural mesh construction from vertex/normal/texcoord/index lists - you are free to design your own model format
* Model animation, per-vertex and skeletal
* Lightmapping and dynamic lighting
* Terrain with automatic LOD and real-time editing
* Dynamic water rendering
* Dynamic soft shadows
* Static and dynamic cubemaps
* Particle system for fire-like and lighting-like effects
* Lensflare effect
* 2D shapes, including rectangle, circle, line, and custom 2D mesh
* 2D sprites and text with TTF and Unicode support
* 3D text and billboards
* Skyboxes
* Procedural skydome with sun, stars and animated day/night cycle
* Procedural trees
* Lines and curves rendering (Cubic, Bezier, NURBS)
* Curves can be used to control object movement
* Discrete LOD system
* Offscreen rendering via p-buffers or FBOs
* Collision detection between bounding spheres, oriented bounding boxes and meshes
* Raycasting
* Built-in game-oriented collision systems (DCE, FPSManager)
* Integrated rigid body physics using [ODE](https://www.ode.org/) engine
* [Kraft](https://github.com/BeRo1985/kraft) physics engine integration
* Ragdolls
* Octree and quadtree to speed-up rendering and collision tests
* Loading resources from GLScene PAK archives
* Keyboard and mouse input
* Window creation and management
* ...plus a lot more!

Language Bindings
-----------------
Despite Xtreme3D was created primarily for GameMaker, it can be used with almost any language. Currently we provide autogenerated [C](https://github.com/xtreme3d/xtreme3d/tree/master/bindings/c) and [Python 3](https://github.com/xtreme3d/xtreme3d/tree/master/bindings/python3) bindings.

Documentation
-------------
Xtreme3D is fully documented in Russian, the help file is [here](https://github.com/xtreme3d/xtreme3d/tree/master/doc/ru).

Team & Credits
---------------
* Initial developer (before 3.0) - **Xception**
* Key developer of the 3.x-4.x branches - **Gecko**
* Xtreme3D 3.8 developer, author of the Pipe, TilePlane, VerletWorld functions, additional Viewer, Light, Grid, Material, Actor, Freeform, HUDSprite, Sprite, FireFX, Lines, Movement functions - **FireRun**
* Author of the DCE and Input functions - **Rutraple** aka **Hacker**
* Author of the Grid functions - **Ghost**
* Author of the WindowSetIcon function - **gadmaker**

Special thanks to **gadmaker**, **van88268**, **FireRun**, **JunkerKun**, **Alexander Demchenko** and other community members for bug reports, valuable ideas and suggestions. Also kudos to **Mike Lischke**, **Eric Grange**, **GLS Team** and all the contributors of GLScene project for creating such a wonderful free graphics library.

License
-------
Xtreme3D and corresponding [GLScene](https://glscene.org) fork are both distributed under [Mozilla Public License 1.1](https://www.mozilla.org/en-US/MPL/1.1/). This license allows you to create commercial closed-source applications with the engine.

ODE is distributed under [3-Clause BSD License](https://opensource.org/license/bsd-3-clause).

SDL2 is distributed under [zlib license](https://www.libsdl.org/license.php).
