#version 120
uniform mat4 invViewMatrix;
uniform mat4 shadowMatrix;
uniform bool hasNormalMap;

varying vec3 n;
varying vec3 position;
varying vec3 worldView;
varying vec3 e;
varying vec4 shadowCoord;

void main()
{
    gl_TexCoord[0] = gl_MultiTexCoord0;
    n = normalize(gl_NormalMatrix * gl_Normal);
    
    vec4 eyeVertex = gl_ModelViewMatrix * gl_Vertex;
    position = eyeVertex.xyz;
    
    vec3 worldPos = (invViewMatrix * eyeVertex).xyz;
    vec3 worldCamPos = (invViewMatrix[3]).xyz;
    worldView = normalize(worldPos - worldCamPos);
       
    e = -normalize(position);
    
    shadowCoord = shadowMatrix * eyeVertex;
    
    gl_Position = ftransform();
}
