<?php
namespace app\forms;

use system\DFFI;
use app\forms\xtreme3d;
use std, gui, framework, app;


class MainForm extends AbstractForm
{

    /**
     * @event button.click-Left 
     */
    function doButtonClickLeft(UXMouseEvent $e = null)
    {    
                
        global $timer, $x;
        $timeStep = 1.0 / 60;
        $screen   = UXScreen::getPrimary();
        $screenW  = $screen->bounds['width'];
        $screenH  = $screen->bounds['height'];
        $windowW  = $this->width;
        $windowH  = $this->height;
        $CenterW  = $screenW / 2 - $windowW / 2;
        $CenterH  = $screenH / 2 - $windowH / 2;
        
        $x = new xtreme3d;
        $x->EngineCreate();
        
        $handle = DFFI::FindWindow('', $this->title);
        
        
        $matlib = $x->MaterialLibraryCreate();
        $x->MaterialLibraryActivate($matlib);

        $view1 = $x->ViewerCreate(0, 0, $this->width, $this->height, $handle);
        $x->ViewerSetBackgroundColor($view1, $x->MakeColorRGB(128,128,128));
        $x->ViewerSetLighting($view1, true);
        $x->ViewerEnableFog($view1, true);
        $x->ViewerSetFogColor($view1, $x->MakeColorRGB(128,128,128));
        $x->ViewerSetFogDistance($view1, 50, 100);
        $x->ViewerSetAntiAliasing($view1, 0);
        
        //$loadingFront= $x->DummycubeCreate(0);
        
        //$loadingFont=$x->WindowsBitmapfontCreate('Arial',30,0,128);
        //$loadingText=$x->HUDTextCreate($loadingFont,'LOADING...',$loadingFront);
        //$x->HUDTextSetColor($loadingText,$x->MakeColorRGB(255,255,255),1.0);
        //$x->ObjectSetPosition($loadingText, viewWidth/2 - 60, viewHeight/2, 0);
        
        //$backAndScene=$x->DummycubeCreate(0);
        $back  = $x->DummycubeCreate(0);
        $scene = $x->DummycubeCreate(0);
        $front = $x->DummycubeCreate(0);
        //$fboFront= $x->DummycubeCreate(0);
        
        $camPos = $x->DummycubeCreate($scene);
        $x->ObjectSetPosition($camPos, 0, 0, 10);
        
        $camera = $x->CameraCreate($camPos);
        $x->ObjectSetPosition($camPos, 0, 3, 0);
        $x->CameraSetViewDepth($camera, 500);
        $x->CameraSetFocal($camera, 80);
        //$x->CameraSetNearPlaneBias($camera, 0.2);
        $x->ViewerSetCamera($view1, $camera);
        
        //$x->ViewerRenderEx($view1, $loadingFront, $true, $true, $true);
        
        $shadowCasters = $x->DummycubeCreate($scene);
        
        $shadowCam = $x->CameraCreate($scene);
        $x->CameraSetViewDepth($shadowCam, 500);
        $x->ObjectSetPosition($shadowCam, 0, 10, 0);
        $x->ObjectTurn($shadowCam, 270);
        $x->ObjectPitch($shadowCam, -45);
        $shadowRes = 1024;
        $sm = $x->ShadowMapCreate($shadowRes, $view1, $shadowCasters);
        $x->ShadowMapSetCamera($sm, $shadowCam);
        $x->ShadowMapSetProjectionSize($sm, 40);
        $x->ShadowMapSetZClippingPlanes($sm, -10.0, 200.0);
        
        $skyboxDir = 'data/sky';
        $skyboxExt = 'tga';
        $x->MaterialCreate('mSkyTop', 'data/sky/sky_top.tga');
        
        $x->MaterialCreate('mSkyBottom', 'data/sky/sky_bottom.tga');
        $x->MaterialCreate('mSkyLeft', 'data/sky/sky_left.tga');
        $x->MaterialCreate('mSkyRight', 'data/sky/sky_right.tga');
        $x->MaterialCreate('mSkyFront', 'data/sky/sky_front.tga');
        $x->MaterialCreate('mSkyBack', 'data/sky/sky_back.tga');
        $sky = $x->SkyboxCreate($back);
        $x->SkyboxSetMaterial($sky, 0, 'mSkyTop');
        $x->SkyboxSetMaterial($sky, 1, 'mSkyBottom');
        $x->SkyboxSetMaterial($sky, 2, 'mSkyLeft');
        $x->SkyboxSetMaterial($sky, 3, 'mSkyRight');
        $x->SkyboxSetMaterial($sky, 4, 'mSkyFront');
        $x->SkyboxSetMaterial($sky, 5, 'mSkyBack');
        
        $light = $x->LightCreate(2, $scene);
        $x->LightSetAmbientColor($light, $x->MakeColorRGB(128,128,128), 1.0);
        $x->LightSetDiffuseColor($light, $x->MakeColorRGB(211,211,211), 1.0);
        $x->LightSetSpecularColor($light, $x->MakeColorRGB(211,211,211), 1.0);
        $x->ObjectTurn($light, 80);
        $x->ObjectPitch($light, -20);
        
        $plane = $x->PlaneCreate(0, 30, 30, 5, 5, $scene);
        $x->ObjectPitch($plane, 90);
        
        $plane2 = $x->PlaneCreate(0, 30, 5, 5, 1, $shadowCasters);
        $x->ObjectSetPosition($plane2, 0, 2.5, -15);
        
        $plane3 = $x->PlaneCreate(0, 30, 5, 5, 1, $shadowCasters);
        $x->ObjectTurn($plane3, 180);
        $x->ObjectSetPosition($plane3, 0, 2.5, 15);
        
        $plane4 = $x->PlaneCreate(0, 30, 5, 5, 1, $shadowCasters);
        $x->ObjectTurn($plane4, 90);
        $x->ObjectSetPosition($plane4, 15, 2.5, 0);
        
        $plane5 = $x->PlaneCreate(0, 30, 5, 5, 1, $shadowCasters);
        $x->ObjectTurn($plane5, -90);
        $x->ObjectSetPosition($plane5, -15, 2.5, 0);
        
        $pbrObjects = $x->DummycubeCreate($shadowCasters);
        
        $ff = $x->FreeformCreate('data/cerberus/cerberus.obj', $matlib, $matlib, $pbrObjects);
        $x->FreeformUseMeshMaterials($ff, $false);
        $x->ObjectSetScale($ff, 0.3, 0.3, 0.3);
        $x->ObjectSetPosition($ff, 11, 2, 0);
        $x->ObjectTurn($ff, -90);
        
        $sph = $x->SphereCreate(1, 16, 16, $pbrObjects);
        $x->ObjectSetPosition($sph, 0, 1, -3);
        
        $cub = $x->CubeCreate(2, 2, 2, $pbrObjects);
        $x->ObjectSetPosition($cub, -3, 1, 3);
        
        $cub1 = $x->CubeCreate(2, 2, 2, $pbrObjects);
        $x->ObjectSetPosition($cub1, -3, 3, 3);
        $x->ObjectTurn($cub1, 30);
        
        $cubemapCam = $x->CameraCreate($sph);
        $x->MaterialAddCubeMap('mEnvmap');
        $x->MaterialCubeMapLoadImage('mEnvmap', 'data/sky/sky_left.tga', 0);
        $x->MaterialCubeMapLoadImage('mEnvmap', 'data/sky/sky_right.tga', 1);
        $x->MaterialCubeMapLoadImage('mEnvmap', 'data/sky/sky_top2.tga', 2);
        $x->MaterialCubeMapLoadImage('mEnvmap', 'data/sky/sky_bottom.tga', 3);
        $x->MaterialCubeMapLoadImage('mEnvmap', 'data/sky/sky_back.tga', 4);
        $x->MaterialCubeMapLoadImage('mEnvmap', 'data/sky/sky_front.tga', 5);
        $x->MaterialSetTextureFilter('mEnvmap', 5, 1);
        
        $vp1 = $x->TextRead('data/pbr/pbr-vp.glsl');
        $fp1 = $x->TextRead('data/pbr/pbr-fp.glsl');
        $pbrShader = $x->GLSLShaderCreate($vp1, $fp1);
        $pbrParamAlbedoMap = $x->GLSLShaderCreateParameter($pbrShader, 'albedoMap');
        $x->GLSLShaderSetParameterTexture($pbrParamAlbedoMap, '', 0);
        $pbrParamNormalMap = $x->GLSLShaderCreateParameter($pbrShader, 'normalMap');
        $x->GLSLShaderSetParameterTexture($pbrParamNormalMap, '', 1);
        $pbrParamRoughnessMap = $x->GLSLShaderCreateParameter($pbrShader, 'roughnessMap');
        $x->GLSLShaderSetParameterTexture($pbrParamRoughnessMap, '', 2);
        $pbrParamMetallicMap = $x->GLSLShaderCreateParameter($pbrShader, 'metallicMap');
        $x->GLSLShaderSetParameterTexture($pbrParamMetallicMap, '', 3);
        $pbrParamHeightMap = $x->GLSLShaderCreateParameter($pbrShader, 'heightMap');
        $x->GLSLShaderSetParameterTexture($pbrParamHeightMap, '', 4);
        $pbrParamEnvMap = $x->GLSLShaderCreateParameter($pbrShader, 'envMap');
        $x->GLSLShaderSetParameterTexture($pbrParamEnvMap, 'mEnvmap', 5);
        $pbrParamShadowMap = $x->GLSLShaderCreateParameter($pbrShader, 'shadowMap');
        $x->GLSLShaderSetParameterShadowTexture($pbrParamShadowMap, $sm, 6);
        
        $pbrParamViewMatrix = $x->GLSLShaderCreateParameter($pbrShader, 'viewMatrix');
        $x->GLSLShaderSetParameterViewMatrix($pbrParamViewMatrix);
        $pbrParamInvViewMatrix = $x->GLSLShaderCreateParameter($pbrShader, 'invViewMatrix');
        $x->GLSLShaderSetParameterInvViewMatrix($pbrParamInvViewMatrix);
        
        $pbrParamShadowMatrix = $x->GLSLShaderCreateParameter($pbrShader, 'shadowMatrix');
        $x->GLSLShaderSetParameterShadowMatrix($pbrParamShadowMatrix, $sm);
        
        $pbrParamHasAlbedoMap = $x->GLSLShaderCreateParameter($pbrShader, 'hasAlbedoMap');
        $x->GLSLShaderSetParameterHasTextureEx($pbrParamHasAlbedoMap, 0);
        $pbrParamHasNormalMap = $x->GLSLShaderCreateParameter($pbrShader, 'hasNormalMap');
        $x->GLSLShaderSetParameterHasTextureEx($pbrParamHasNormalMap, 1);
        $pbrParamHasRoughnessMap = $x->GLSLShaderCreateParameter($pbrShader, 'hasRoughnessMap');
        $x->GLSLShaderSetParameterHasTextureEx($pbrParamHasRoughnessMap, 2);
        $pbrParamHasMetallicMap = $x->GLSLShaderCreateParameter($pbrShader, 'hasMetallicMap');
        $x->GLSLShaderSetParameterHasTextureEx($pbrParamHasMetallicMap, 3);
        $pbrParamHasHeightMap = $x->GLSLShaderCreateParameter($pbrShader, 'hasHeightMap');
        $x->GLSLShaderSetParameterHasTextureEx($pbrParamHasHeightMap, 4);
        
        $x->MaterialCreate('mPBR4', '');
        $x->MaterialLoadTextureEx('mPBR4', 'data/stone2/stone2-albedo.png', 0);
        $x->MaterialLoadTextureEx('mPBR4', 'data/stone2/stone2-normal.png', 1);
        $x->MaterialLoadTextureEx('mPBR4', 'data/stone2/stone2-roughness.png', 2);
        $x->MaterialLoadTextureEx('mPBR4', 'data/stone2/stone2-metallic.png', 3);
        $x->MaterialLoadTextureEx('mPBR4', 'data/stone2/stone2-height.png', 4);
        $x->MaterialSetShader('mPBR4', $pbrShader);
        
        $x->MaterialCreate('mPBR5', '');
        $x->MaterialLoadTextureEx('mPBR5', 'data/brick/bricks-albedo.png', 0);
        $x->MaterialLoadTextureEx('mPBR5', 'data/brick/bricks-normal.png', 1);
        $x->MaterialLoadTextureEx('mPBR5', 'data/brick/bricks-roughness.png', 2);
        $x->MaterialLoadTextureEx('mPBR5', 'data/brick/bricks-metallic.png', 3);
        $x->MaterialSetShader('mPBR5', $pbrShader);
        
        $x->MaterialCreate('mPBR', '');
        $x->MaterialLoadTextureEx('mPBR', 'data/box/box-albedo.png', 0);
        $x->MaterialLoadTextureEx('mPBR', 'data/box/box-normal.png', 1);
        $x->MaterialLoadTextureEx('mPBR', 'data/box/box-roughness.png', 2);
        $x->MaterialLoadTextureEx('mPBR', 'data/box/box-metallic.png', 3);
        $x->MaterialSetShader('mPBR', $pbrShader);
        
        $x->MaterialCreate('mPBR2', '');
        $x->MaterialLoadTextureEx('mPBR2', 'data/cerberus/cerberus-albedo.png', 0);
        $x->MaterialLoadTextureEx('mPBR2', 'data/cerberus/cerberus-normal.png', 1);
        $x->MaterialLoadTextureEx('mPBR2', 'data/cerberus/cerberus-roughness.png', 2);
        $x->MaterialLoadTextureEx('mPBR2', 'data/cerberus/cerberus-metallic.png', 3);
        $x->MaterialSetShader('mPBR2', $pbrShader);
        
        $x->MaterialCreate('mPBR3', '');
        $x->MaterialSetDiffuseColor('mPBR3', $x->MakeColorRGB(128,128,128), 1.0);
        $x->MaterialSetShader('mPBR3', $pbrShader);
        
        $x->ObjectSetMaterial($sph, 'mPBR3');
        $x->ObjectSetMaterial($ff, 'mPBR2');
        $x->ObjectSetMaterial($cub, 'mPBR');
        $x->ObjectSetMaterial($cub1, 'mPBR');
        
        $x->ObjectSetMaterial($plane, 'mPBR4');
        $x->ObjectSetMaterial($plane2, 'mPBR5');
        $x->ObjectSetMaterial($plane3, 'mPBR5');
        $x->ObjectSetMaterial($plane4, 'mPBR5');
        $x->ObjectSetMaterial($plane5, 'mPBR5');
        
        
        
        $mx = ($screenW) / 2;
        $my = ($screenH) / 2;
        $x->MouseSetPosition($mx, $my);
        
        $font = $x->WindowsBitmapfontCreate('Arial', 20, 0, 128);
        $text = $x->HUDTextCreate($font, 'Test', $front);
        $x->HUDTextSetColor($text, $x->MakeColorRGB(255,255,255), 0.5);
        $x->ObjectSetPosition($text, 20, 20, 0);
        
      //  $text2 = $x->HUDTextCreate($font, 'Press 1 to switch SSAO' . chr(13) . 'Press 2 to switch FXAA', $front);
      //  $x->HUDTextSetColor($text2, $x->MakeColorRGB(255,255,255), 0.5);
      //  $x->ObjectSetPosition($text2, 20, 65, 0);
        $timer = new UXAnimationTimer(function() use ($x, $timeStep, $shadowCam, $ff, $zm, $scene, $window, $view1, $camPos, $text, $hud, $mx, $my, $camera, $MouseLook, $sm)
        {  
            $x->ObjectSetPosition($shadowCam, $x->ObjectGetAbsolutePosition($camPos, 0), 10, $x->ObjectGetAbsolutePosition($camPos, 2) + 10);
            
            $x->ObjectTurn($ff, 2 * $timeStep );
            
            //$x->OdeManagerStep($timeStep);
            //$x->KraftStep();
            $x->Update(0.01);
            $x->ShadowMapRender($sm);
            
            $x->ViewerRender($view1);
            
            $x->HUDTextSetText($text, "Xtreme3D 3.7 FPS:" . (int) $x->ViewerGetFramesPerSecond($view1));
            $x->ViewerResetPerformanceMonitor($viewer); 
             
            
            if ($x->KeyIsPressed(37)) { //Left 
                $x->ObjectStrafe($camPos, 1);
            }
            if ($x->KeyIsPressed(39)) { //Right
                $x->ObjectStrafe($camPos, -1);
            }
            if ($x->KeyIsPressed(40)) { //Up
                $x->ObjectMove($camPos, 1);
            }
            if ($x->KeyIsPressed(38)) { //Down
                $x->ObjectMove($camPos, -1);
            }
            
            
            //   if($MouseLook){
            //      $MouseLook = false;
            //   }else{
            //      $MouseLook = true;
            //  }
            // }            
            
            //   if ($MouseLook) {
            $deltax = ($mx - $x->MouseGetPositionX()) / 3;
            $deltay = ($my - $x->MouseGetPositionY()) / 3;
            
            $x->ObjectRotate($camera, $deltay, 0, 0);
            $x->ObjectRotate($camPos, 0, -$deltax, 0);
            $x->MouseSetPosition($mx, $my);
            // }
            
            
            
        });
        
        $timer->start(); // запускаем таймер 
    }

    /**
     * @event keyDown-Esc 
     */
    function doKeyDownEsc(UXKeyEvent $e = null)
    {    
        global $timer, $x;
        $timer->stop();
        //$x->EngineDestroy();
        App::shutdown(); 
    }

}
