library xtreme3d;
uses
  Windows, Messages, Classes, Controls, StdCtrls, ExtCtrls,
  GLScene, GLObjects, GLWin32FullScreenViewer, GLMisc, GLGraph,
  GLCollision, GLTexture, OpenGL1x, VectorGeometry, Graphics,
  GLVectorFileObjects, GLWin32Viewer, GLSpaceText, GLGeomObjects, GLCadencer,
  JPeg, Tga, GLProcTextures, Spin, GLVfsPAK, GLCanvas, GLGraphics, GLPortal,
  GLHUDObjects, GLBitmapFont, GLWindowsFont, GLImposter, VectorTypes, GLUtils,
  GLPolyhedron, GLTeapot, GLzBuffer, GLFile3DS, GLFileGTS, GLFileLWO, GLFileMD2,
  GLFileMD3, Q3MD3, GLFileMS3D, GLFileNMF, GLFileNurbs, GLFileObj, GLFileOCT,
  GLFilePLY, GLFileQ3BSP, GLFileSMD, GLFileSTL, GLFileTIN,
  GLFileLOD, GLPhongShader, VectorLists, GLThorFX, GLTexCombineShader,
  GLBumpShader, GLCelShader, GLContext, GLTerrainRenderer, GLHeightData,
  GLBlur;

type
   TEmpty = class(TComponent)
    private
   end;

var
  scene: TGLScene;
  matlib: TGLMaterialLibrary;
  memviewer: TGLMemoryViewer;
  cadencer: TGLCadencer;
  empty: TEmpty;

{$R *.res}

{$I 'engine'}
{$I 'viewer'}
{$I 'dummycube'}
{$I 'camera'}
{$I 'light'}
{$I 'fonttext'}
{$I 'sprite'}
{$I 'primitives'}
{$I 'memviewer'}
{$I 'zshadows'}
{$I 'actor'}
{$I 'freeform'}
{$I 'object'}
{$I 'material'}
{$I 'shaders'}
{$I 'thorfx'}

function InvertBitmap(Bitmap:TBitmap): TBitmap;
begin
  Bitmap.Canvas.CopyMode := cmDstInvert;
  Bitmap.Canvas.CopyRect(Bitmap.Canvas.ClipRect, Bitmap.Canvas, Bitmap.Canvas.ClipRect);
  Bitmap.Canvas.CopyMode := cmSrcCopy;
  Result := Bitmap;
end;

function BmpHDSCreate(img: pchar): real; stdcall;
var
  GLBitmapHDS1: TGLBitmapHDS;
begin
  GLBitmapHDS1:=TGLBitmapHDS.Create(scene);
  GLBitmapHDS1.Picture.Bitmap.LoadFromFile(img);
  GLBitmapHDS1.MaxPoolSize:=8*1024*1024;
  result:=Integer(GLBitmapHDS1);
end;

function BmpHDSSetInfiniteWarp(hds,iwarp: real): real; stdcall;
var
  GLBitmapHDS1: TGLBitmapHDS;
begin
  GLBitmapHDS1:=TGLBitmapHDS(trunc64(hds));
  GLBitmapHDS1.InfiniteWrap:=boolean(trunc64(iwarp));
  result:=1;
end;

function BmpHDSInvert(hds: real): real; stdcall;
var
  GLBitmapHDS1: TGLBitmapHDS;
begin
  GLBitmapHDS1:=TGLBitmapHDS(trunc64(hds));
  GLBitmapHDS1.Picture.Bitmap:=InvertBitmap(GLBitmapHDS1.Picture.Bitmap);
  result:=1;
end;

function TerrainCreate(parent: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer.Create(scene);
  TGLScene(scene).Objects.AddChild(TerrainRenderer1);
  if not (parent=0) then TerrainRenderer1.Parent:=TGLBaseSceneObject(trunc64(parent));
  result:=Integer(TerrainRenderer1);
end;

function TerrainSetHeightData(terrain,hds: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  TerrainRenderer1.HeightDataSource:=TGLBitmapHDS(trunc64(hds));
  result:=1;
end;

function TerrainSetTileSize(terrain,tsize: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  TerrainRenderer1.TileSize:=trunc64(tsize);
  result:=1;
end;

function TerrainSetTilesPerTexture(terrain,tpt: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  TerrainRenderer1.TilesPerTexture:=tpt;
  result:=1;
end;

function TerrainSetQualityDistance(terrain,qd: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  TerrainRenderer1.QualityDistance:=qd;
  result:=1;
end;

function TerrainSetQualityStyle(terrain,hrs: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  if hrs=0 then TerrainRenderer1.QualityStyle:=hrsFullGeometry;
  if hrs=1 then TerrainRenderer1.QualityStyle:=hrsTesselated;
  result:=1;
end;

function TerrainSetMaxCLodTriangles(terrain,tri: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  TerrainRenderer1.MaxCLODTriangles:=trunc64(tri);
  result:=1;
end;

function TerrainSetCLodPrecision(terrain,prec: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  TerrainRenderer1.CLODPrecision:=trunc64(prec);
  result:=1;
end;

function TerrainSetOcclusionFrameSkip(terrain,ofs: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  TerrainRenderer1.OcclusionFrameSkip:=trunc64(ofs);
  result:=1;
end;

function TerrainSetOcclusionTesselate(terrain,tot: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  if tot=0 then TerrainRenderer1.OcclusionTesselate:=totTesselateAlways;
  if tot=1 then TerrainRenderer1.OcclusionTesselate:=totTesselateIfVisible;
  result:=1;
end;

function TerrainGetHeightAtObjectPosition(terrain,obj: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
  Object1: TGLSceneObject;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  Object1:=TGLSceneObject(trunc64(obj));
  result:=TerrainRenderer1.InterpolatedHeight(Object1.Position.AsVector);
end;

function TerrainGetLastTriCount(terrain: real): real; stdcall;
var
  TerrainRenderer1: TGLTerrainRenderer;
begin
  TerrainRenderer1:=TGLTerrainRenderer(trunc64(terrain));
  result:=TerrainRenderer1.LastTriangleCount;
end;


function ObjectSetPositionY(obj,posy: real): real; stdcall;
var
  Object1: TGLSceneObject;
begin
  Object1:=TGLSceneObject(trunc64(obj));
  Object1.Position.Y:=posy;
  result:=1;
end;

function MaterialSetShininess(mtrl: pchar; shin: real): real; stdcall;
var
  mat:TGLLibMaterial;
begin
  mat:=matlib.Materials.GetLibMaterialByName(mtrl);
  mat.Material.FrontProperties.Shininess:=trunc64(shin);
  result:=1;
end;

function MaterialSetSpecularColor(mtrl: pchar; col: real): real; stdcall;
var
  mat:TGLLibMaterial;
begin
  mat:=matlib.Materials.GetLibMaterialByName(mtrl);
  mat.Material.FrontProperties.Specular.AsWinColor:=TColor(trunc64(col));
  result:=1;
end;

function BlurCreate(parent: real): real; stdcall;
var
  GLBlur1: TGLBlur;
begin
  //with empty do
  //begin
  GLBlur1:=TGLBlur.Create(empty);
  TGLScene(scene).Objects.AddChild(GLBlur1);
  //end;
  //TGLScene(scene).Objects.AddChild(GLBlur1);
  //if not (parent=0) then GLBlur1.Parent:=TGLBaseSceneObject(trunc64(parent));
  result:=Integer(GLBlur1);
  //result:=1;
end;

exports
//Engine
EngineCreate, EngineDestroy, EngineSetObjectsSorting, EngineSetCulling,
EngineGetMaxTextureUnits, EngineGetMaxTextureSize, SetPakArchive,
Update, TrisRendered,
//Viewer
ViewerCreate, ViewerSetCamera, ViewerEnableVSync, ViewerRender, ViewerRenderToFile,
ViewerResize, ViewerSetVisible, ViewerGetPixelColor, ViewerGetPixelDepth,
ViewerSetLighting, ViewerSetBackgroundColor, ViewerSetAmbientColor, ViewerEnableFog,
ViewerSetFogColor, ViewerSetFogDistance, ViewerScreenToWorld, ViewerWorldToScreen,
ViewerCopyToTexture, ViewerGetFramesPerSecond, ViewerGetPickedObject,
ViewerScreenToVector, ViewerVectorToScreen, ViewerPixelToDistance, ViewerGetPickedObjectsList,
ViewerSetAntiAliasing,
//Dummycube
DummycubeCreate, DummycubeAmalgamate, DummycubeSetCameraMode, DummycubeSetVisible,
DummycubeSetEdgeColor, DummycubeSetCubeSize,
//Camera
CameraCreate, CameraSetStyle, CameraSetFocal, CameraSetSceneScale,
CameraScaleScene, CameraSetViewDepth, CameraSetTargetObject,
CameraMoveAroundTarget, CameraSetDistanceToTarget, CameraGetDistanceToTarget,
CameraCopyToTexture, CameraGetNearPlane, CameraSetNearPlaneBias,
CameraAbsoluteVectorToTarget, CameraAbsoluteRightVectorToTarget, CameraAbsoluteUpVectorToTarget,
CameraZoomAll, CameraScreenDeltaToVector, CameraScreenDeltaToVectorXY, CameraScreenDeltaToVectorXZ,
CameraScreenDeltaToVectorYZ, CameraAbsoluteEyeSpaceVector, CameraSetAutoLeveling,
CameraMoveInEyeSpace, CameraMoveTargetInEyeSpace, CameraPointInFront, CameraGetFieldOfView,
//Light
LightCreate, LightSetAmbientColor, LightSetDiffuseColor, LightSetSpecularColor,
LightSetAttenuation, LightSetShining, LightSetSpotCutoff, LightSetSpotExponent,
LightSetSpotDirection, LightSetStyle,
//Font & Text
BmpFontCreate, BmpFontLoad, WindowsBitmapfontCreate, HUDTextCreate, FlatTextCreate,
HUDTextSetRotation, SpaceTextCreate, SpaceTextSetExtrusion, HUDTextSetFont,
FlatTextSetFont, SpaceTextSetFont, HUDTextSetColor, FlatTextSetColor, HUDTextSetText,
FlatTextSetText, SpaceTextSetText,
//Sprite
HUDSpriteCreate, SpriteCreate, SpriteSetSize, SpriteScale, SpriteSetRotation,
SpriteRotate, SpriteMirror, SpriteNoZWrite,    
//Primitives
CubeCreate, CubeSetNormalDirection, PlaneCreate, SphereCreate, SphereSetAngleLimits,
CylinderCreate, ConeCreate, AnnulusCreate, TorusCreate, DiskCreate, FrustrumCreate,
DodecahedronCreate, IcosahedronCreate, TeapotCreate,
//Memory Viewer
MemoryViewerCreate, MemoryViewerSetCamera, MemoryViewerRender,
//ZShadows
ZShadowsCreate,
ZShadowsSetFrustShadow, ZShadowsSetSkyShadow, ZShadowsSetColor, ZShadowsCast,
ZShadowsSetSoft, ZShadowsSetTolerance, ZShadowsSetDepthFade,
//Actor
ActorCreate, ActorCopy, ActorSetAnimationRange, ActorGetCurrentFrame, ActorSwitchToAnimation,
ActorSwitchToAnimationName, ActorSynchronize, ActorSetInterval, ActorSetAnimationMode,
ActorSetFrameInterpolation, ActorAddObject, ActorGetCurrentAnimation, ActorGetFrameCount,
ActorGetBoneCount, ActorGetBoneByName, ActorGetBoneRotation, ActorGetBonePosition,
ActorBoneExportMatrix, ActorMakeSkeletalTranslationStatic, ActorMakeSkeletalRotationDelta, 
ActorShowSkeleton, 
AnimationBlenderCreate, AnimationBlenderSetActor, AnimationBlenderSetAnimation,
AnimationBlenderSetRatio,
TagListCreate, ActorLoadQ3Animations, TagExportMatrix,
ActorMeshObjectsCount, ActorFaceGroupsCount, ActorFaceGroupGetMaterialName,
ActorFaceGroupSetMaterial,
//Freeform
FreeformCreate, FreeformMeshObjectsCount, FreeformMeshSetVisible,
FreeformMeshSetSecondCoords, FreeformMeshTriangleCount,  
FreeformFaceGroupsCount, FreeformFaceGroupTriangleCount,
//Terrain
BmpHDSCreate, BmpHDSSetInfiniteWarp, BmpHDSInvert,
TerrainCreate, TerrainSetHeightData, TerrainSetTileSize, TerrainSetTilesPerTexture,
TerrainSetQualityDistance, TerrainSetQualityStyle, TerrainSetMaxCLodTriangles,
TerrainSetCLodPrecision, TerrainSetOcclusionFrameSkip, TerrainSetOcclusionTesselate,
TerrainGetHeightAtObjectPosition, TerrainGetLastTriCount,
//Object
ObjectSetMaterial, ObjectSetPosition, ObjectMove, ObjectStrafe, ObjectRotate,
ObjectGetPitch, ObjectSetScale,
ObjectSetPositionY,  
ObjectExportMatrix, ObjectExportAbsoluteMatrix, 
//Material
MaterialLibraryCreate, MaterialLibraryActivate, MaterialLibrarySetTexturePaths,
MaterialCreate, MaterialSaveTexture, MaterialSetBlendingMode, MaterialSetOptions,
MaterialSetShader, MaterialSetSecondTexture,
MaterialSetShininess, MaterialSetSpecularColor,  
MaterialNoiseCreate, MaterialNoiseAnimate, MaterialNoiseSetDimensions,
MaterialNoiseSetMinCut, MaterialNoiseSetSharpness, MaterialNoiseSetSeamless,
MaterialNoiseRandomSeed,
//Shaders
ShaderEnable, 
PhongShaderCreate,
BumpShaderCreate, BumpShaderSetMethod, BumpShaderSetSpecularMode,
BumpShaderSetSpace, BumpShaderSetOptions, BumpShaderSetParallaxOffset,
CelShaderCreate, CelShaderSetLineColor, CelShaderSetLineWidth, CelShaderSetOptions, 
TexCombineShaderCreate, TexCombineShaderAddCombiner,
TexCombineShaderMaterial3, TexCombineShaderMaterial4,
//ThorFX
ThorFXManagerCreate, ThorFXSetColor, ThorFXEnableCore, ThorFXEnableGlow,
ThorFXSetMaxParticles, ThorFXSetGlowSize, ThorFXSetVibrate, ThorFXSetWildness,
ThorFXSetTarget, ThorFXCreate,
ObjectSetEffect,
//Blur
BlurCreate;

begin
end.
