function CubeCreate(w,h,d,parent: real): real; stdcall;
var
  GLCube1: TGLCube;
begin
  GLCube1:=TGLCube.Create(scene);
  TGLScene(scene).Objects.AddChild(GLCube1);
  if not (parent=0) then GLCube1.Parent:=TGLBaseSceneObject(trunc64(parent));
  GLCube1.CubeWidth:=w;
  GLCube1.CubeHeight:=h;
  GLCube1.CubeDepth:=d;
  result:=Integer(GLCube1);
end;

function CubeSetNormalDirection(cube,nd: real): real; stdcall;
var
  GLCube1: TGLCube;
begin
  GLCube1:=TGLCube(trunc64(cube));
  if nd=0 then GLCube1.NormalDirection:=ndOutside;
  if nd=1 then GLCube1.NormalDirection:=ndInside;
  result:=1;
end;

function PlaneCreate(squad,w,h,xt,yt,parent: real): real; stdcall;
var
  GLPlane1: TGLPlane;
begin
  GLPlane1:=TGLPlane.Create(scene);
  TGLScene(scene).Objects.AddChild(GLPlane1);
  if not (parent=0) then GLPlane1.Parent:=TGLBaseSceneObject(trunc64(parent));
  if squad=1 then GLPlane1.Style:=[psSingleQuad,psTileTexture];
  if squad=0 then GLPlane1.Style:=[psTileTexture];
  GLPlane1.Width:=w;
  GLPlane1.Height:=h;
  GLPlane1.XTiles:=trunc64(xt);
  GLPlane1.YTiles:=trunc64(yt);
  result:=Integer(GLPlane1);
end;

function SphereCreate(rad,slic,staks,parent: real): real; stdcall;
var
  GLSphere1: TGLSphere;
begin
  GLSphere1:=TGLSphere.Create(scene);
  TGLScene(scene).Objects.AddChild(GLSphere1);
  if not (parent=0) then GLSphere1.Parent:=TGLBaseSceneObject(trunc64(parent));
  GLSphere1.Radius:=rad;
  GLSphere1.Slices:=trunc64(slic);
  GLSphere1.Stacks:=trunc64(staks);
  result:=Integer(GLSphere1);
end;

function SphereSetAngleLimits(sphere,starta,stopa,topa,bottoma: real): real; stdcall;
var
  GLSphere1: TGLSphere;
begin
  GLSphere1:=TGLSphere(trunc64(sphere));
  GLSphere1.Start:=TAngleLimit2(trunc64(starta));
  GLSphere1.Stop:=TAngleLimit2(trunc64(stopa));
  GLSphere1.Top:=TAngleLimit1(trunc64(topa));
  GLSphere1.Bottom:=TAngleLimit1(trunc64(bottoma));
  result:=1;
end;

function CylinderCreate(topr,botr,h,slic,staks,loop,parent: real): real; stdcall;
var
  GLCylinder1: TGLCylinder;
begin
  GLCylinder1:=TGLCylinder.Create(scene);
  TGLScene(scene).Objects.AddChild(GLCylinder1);
  if not (parent=0) then GLCylinder1.Parent:=TGLBaseSceneObject(trunc64(parent));
  GLCylinder1.TopRadius:=topr;
  GLCylinder1.BottomRadius:=botr;
  GLCylinder1.Height:=h;
  GLCylinder1.Slices:=trunc64(slic);
  GLCylinder1.Stacks:=trunc64(staks);
  GLCylinder1.Loops:=trunc64(loop);
  result:=integer(GLCylinder1);
end;

function ConeCreate(botr,h,slic,staks,loop,parent: real): real; stdcall;
var
  GLCone1: TGLCone;
begin
  GLCone1:=TGLCone.Create(scene);
  TGLScene(scene).Objects.AddChild(GLCone1);
  if not (parent=0) then GLCone1.Parent:=TGLBaseSceneObject(trunc64(parent));
  GLCone1.BottomRadius:=botr;
  GLCone1.Height:=h;
  GLCone1.Slices:=trunc64(slic);
  GLCone1.Stacks:=trunc64(staks);
  GLCone1.Loops:=trunc64(loop);
  result:=integer(GLCone1);
end;

function AnnulusCreate(inr,outr,h,slic,staks,loop,parent: real): real; stdcall;
var
  GLAnnulus1: TGLAnnulus;
begin
  GLAnnulus1:=TGLAnnulus.Create(scene);
  TGLScene(scene).Objects.AddChild(GLAnnulus1);
  if not (parent=0) then GLAnnulus1.Parent:=TGLBaseSceneObject(trunc64(parent));
  GLAnnulus1.BottomInnerRadius:=inr;
  GLAnnulus1.TopInnerRadius:=inr;
  GLAnnulus1.BottomRadius:=outr;
  GLAnnulus1.TopRadius:=outr;
  GLAnnulus1.Height:=h;
  GLAnnulus1.Slices:=trunc64(slic);
  GLAnnulus1.Stacks:=trunc64(staks);
  GLAnnulus1.Loops:=trunc64(loop);
  result:=integer(GLAnnulus1);
end;

function TorusCreate(inr,outr,ring,side,parent: real): real; stdcall;
var
  GLTorus1: TGLTorus;
begin
  GLTorus1:=TGLTorus.Create(scene);
  TGLScene(scene).Objects.AddChild(GLTorus1);
  if not (parent=0) then GLTorus1.Parent:=TGLBaseSceneObject(trunc64(parent));
  GLTorus1.MinorRadius:=inr;
  GLTorus1.MajorRadius:=outr;
  GLTorus1.Rings:=trunc64(ring);
  GLTorus1.Sides:=trunc64(side);
  result:=integer(GLTorus1);
end;

function DiskCreate(inr,outr,starta,sweepa,loop,slic,parent: real): real; stdcall;
var
  GLDisk1: TGLDisk;
begin
  GLDisk1:=TGLDisk.Create(scene);
  TGLScene(scene).Objects.AddChild(GLDisk1);
  if not (parent=0) then GLDisk1.Parent:=TGLBaseSceneObject(trunc64(parent));
  GLDisk1.InnerRadius:=inr;
  GLDisk1.OuterRadius:=outr;
  GLDisk1.StartAngle:=starta;
  GLDisk1.SweepAngle:=sweepa;
  GLDisk1.Loops:=trunc64(loop);
  GLDisk1.Slices:=trunc64(slic);
  result:=integer(GLDisk1);
end;

function FrustrumCreate(basew,based,apexh,cuth,parent: real): real; stdcall;
var
  GLFrustrum1: TGLFrustrum;
begin
  GLFrustrum1:=TGLFrustrum.Create(scene);
  TGLScene(scene).Objects.AddChild(GLFrustrum1);
  if not (parent=0) then GLFrustrum1.Parent:=TGLBaseSceneObject(trunc64(parent));
  GLFrustrum1.BaseWidth:=basew;
  GLFrustrum1.BaseDepth:=based;
  GLFrustrum1.ApexHeight:=apexh;
  GLFrustrum1.Height:=cuth;
  result:=integer(GLFrustrum1);
end;

function DodecahedronCreate(parent: real): real; stdcall;
var
  GLDodecahedron1: TGLDodecahedron;
begin
  GLDodecahedron1:=TGLDodecahedron.Create(scene);
  TGLScene(scene).Objects.AddChild(GLDodecahedron1);
  if not (parent=0) then GLDodecahedron1.Parent:=TGLBaseSceneObject(trunc64(parent));
  result:=integer(GLDodecahedron1);
end;

function IcosahedronCreate(parent: real): real; stdcall;
var
  GLIcosahedron1: TGLIcosahedron;
begin
  GLIcosahedron1:=TGLIcosahedron.Create(scene);
  TGLScene(scene).Objects.AddChild(GLIcosahedron1);
  if not (parent=0) then GLIcosahedron1.Parent:=TGLBaseSceneObject(trunc64(parent));
  result:=integer(GLIcosahedron1);
end;

function TeapotCreate(parent: real): real; stdcall;
var
  GLTeapot1: TGLTeapot;
begin
  GLTeapot1:=TGLTeapot.Create(scene);
  TGLScene(scene).Objects.AddChild(GLTeapot1);
  if not (parent=0) then GLTeapot1.Parent:=TGLBaseSceneObject(trunc64(parent));
  result:=integer(GLTeapot1);
end;