function ObjectSetMaterial(obj:real; mat:pchar): real; stdcall;
var
  GLObject:TGLSCeneObject;
begin
  GLObject:=TGLSceneObject(trunc64(obj));
  GLObject.Material.MaterialLibrary:=matlib;
  GLObject.Material.LibMaterialName:=mat;
  result:=1;
end;

function ObjectSetPosition(obj,x,y,z:real): real; stdcall;
var
  GLObject:TGLSCeneObject;
begin
  GLObject:=TGLSceneObject(trunc64(obj));
  GLObject.Position.X:=x;
  GLObject.Position.Y:=y;
  GLObject.Position.Z:=z;
  result:=1;
end;

function ObjectMove(obj,spd:real): real; stdcall;
var
  GLObject:TGLSCeneObject;
begin
  GLObject:=TGLSceneObject(trunc64(obj));
  GLObject.Move(spd);
  result:=1;
end;

function ObjectStrafe(obj,spd:real): real; stdcall;
var
  GLObject:TGLSCeneObject;
begin
  GLObject:=TGLSceneObject(trunc64(obj));
  GLObject.Slide(spd);
  result:=1;
end;

function ObjectRotate(obj,p,t,r:real): real; stdcall;
var
  GLObject:TGLSCeneObject;
begin
  GLObject:=TGLSceneObject(trunc64(obj));
  GLObject.Roll(r);
  GLObject.Turn(t);
  GLObject.Pitch(p);
  result:=1;
end;

function ObjectGetPitch(obj:real): real; stdcall;
var
  GLObject:TGLSCeneObject;
  p: real;
begin
  GLObject:=TGLSceneObject(trunc64(obj));
  p:=GLObject.PitchAngle;
  result:=p;
end;

function ObjectSetScale(obj,x,y,z:real): real; stdcall;
var
  GLObject:TGLSCeneObject;
begin
  GLObject:=TGLSceneObject(trunc64(obj));
  GLObject.Scale.SetVector(x,y,z);
  result:=1;
end;

function ObjectExportMatrix(obj1,obj2: real): real; stdcall;
var
  GLObject1:TGLSCeneObject;
  GLObject2:TGLSceneObject;
  m: TMatrix4f;
begin
  GLObject1:=TGLSceneObject(trunc64(obj1));
  m:=GLObject1.Matrix;
  GLObject2:=TGLSceneObject(trunc64(obj2));
  GLObject2.Matrix:=m;
  result:=1;
end;

function ObjectExportAbsoluteMatrix(obj1,obj2: real): real; stdcall;
var
  GLObject1:TGLSCeneObject;
  GLObject2:TGLSceneObject;
  m: TMatrix4f;
begin
  GLObject1:=TGLSceneObject(trunc64(obj1));
  m:=GLObject1.AbsoluteMatrix;
  GLObject2:=TGLSceneObject(trunc64(obj2));
  GLObject2.Matrix:=m;
  result:=1;
end;