function MaterialLibraryCreate: real; stdcall;
var
  mlib:TGLMaterialLibrary;
begin
  mlib:=TGLMaterialLibrary.Create(scene);
  result:=Integer(mlib);
end;

function MaterialLibraryActivate(mlib:real): real; stdcall;
begin
  matlib:=TGLMaterialLibrary(trunc64(mlib));
  result:=1;
end;

function MaterialLibrarySetTexturePaths(mlb: real; path: pchar): real; stdcall;
var
  mlib:TGLMaterialLibrary;
begin
  mlib:=TGLMaterialLibrary(trunc64(mlb));
  mlib.TexturePaths:=path;
  result:=1;
end;

function MaterialCreate(mtrl,fname: pchar): real; stdcall;
begin
  matlib.AddTextureMaterial(mtrl,fname,true);
  result:=1;
end;

function MaterialSetBlendingMode(mtrl: pchar; bm: real): real; stdcall;
var
  mat:TGLLibMaterial;
begin
  mat:=matlib.Materials.GetLibMaterialByName(mtrl);
  if bm=0 then mat.Material.BlendingMode:=bmOpaque;
  if bm=1 then mat.Material.BlendingMode:=bmTransparency;
  if bm=2 then mat.Material.BlendingMode:=bmAdditive;
  if bm=3 then mat.Material.BlendingMode:=bmAlphaTest50;
  if bm=4 then mat.Material.BlendingMode:=bmAlphaTest100;
  if bm=5 then mat.Material.BlendingMode:=bmModulate;
  result:=1;
end;

function MaterialSetShader(mtrl: pchar; shd: real): real; stdcall;
var
  mat:TGLLibMaterial;
  shad: TGLShader;
begin
  mat:=matlib.Materials.GetLibMaterialByName(mtrl);
  shad:=TGLShader(trunc64(shd));
  mat.Shader:=shad;
  result:=1;
end;

function MaterialSaveTexture(mtrl,fname: pchar): real; stdcall;
var
  mat:TGLLibMaterial;
begin
  mat:=matlib.Materials.GetLibMaterialByName(mtrl);
  mat.Material.Texture.Image.SaveToFile(fname);
  result:=1;
end;

function MaterialSetOptions(mtrl: pchar; op1,op2: real): real; stdcall;
var
  mat:TGLLibMaterial;
begin
  mat:=matlib.Materials.GetLibMaterialByName(mtrl);
  if (op1=1) and (op2=1) then mat.Material.MaterialOptions:=[moIgnoreFog,moNoLighting];
  if (op1=1) and (op2=0) then mat.Material.MaterialOptions:=[moIgnoreFog];
  if (op1=0) and (op2=1) then mat.Material.MaterialOptions:=[moNoLighting];
  if (op1=0) and (op2=0) then mat.Material.MaterialOptions:=[];
  result:=1;
end;

function MaterialSetSecondTexture(mtrl,mtrl2: pchar): real; stdcall;
var
  mat:TGLLibMaterial;
begin
  mat:=matlib.Materials.GetLibMaterialByName(mtrl);
  mat.Texture2Name:=mtrl2;
  result:=1;
end;

function MaterialNoiseCreate(mtrl:pchar): real; stdcall;
var
  mat:TGLLibMaterial;
begin
  mat:=matlib.Materials.Add();
  mat.Name:=mtrl;
  mat.Material.Texture.Disabled:=false;
  mat.Material.Texture.Image:=TGLProcTextureNoise.Create(nil);
  result:=1;
end;

function MaterialNoiseSetDimensions(mtrl:pchar; w,h:real): real; stdcall;
begin
  with TGLProcTextureNoise(matlib.Materials.GetLibMaterialByName(mtrl).Material.Texture.Image) do
  begin
    Width:=trunc64(w);
    Height:=trunc64(h);
  end;
  result:=1;
end;

function MaterialNoiseAnimate(mtrl:pchar; speed:real): real; stdcall;
begin
  TGLProcTextureNoise(matlib.Materials.GetLibMaterialByName(mtrl).Material.Texture.Image).NoiseAnimate(speed);
  result:=1;
end;

function MaterialNoiseSetMinCut(mtrl:pchar; m:real): real; stdcall;
begin
  TGLProcTextureNoise(matlib.Materials.GetLibMaterialByName(mtrl).Material.Texture.Image).MinCut:=trunc64(m);
  result:=1;
end;

function MaterialNoiseSetSharpness(mtrl:pchar; s:real): real; stdcall;
begin
  TGLProcTextureNoise(matlib.Materials.GetLibMaterialByName(mtrl).Material.Texture.Image).NoiseSharpness:=s;
  result:=1;
end;

function MaterialNoiseSetSeamless(mtrl:pchar; mode:real): real; stdcall;
begin
  TGLProcTextureNoise(matlib.Materials.GetLibMaterialByName(mtrl).Material.Texture.Image).Seamless:=boolean(trunc64(mode));
  result:=1;
end;

function MaterialNoiseRandomSeed(mtrl:pchar; s:real): real; stdcall;
begin
  TGLProcTextureNoise(matlib.Materials.GetLibMaterialByName(mtrl).Material.Texture.Image).NoiseRandSeed:=trunc64(s);
  result:=1;
end;