function FreeformCreate(fname: pchar; matl1,matl2,parent: real): real; stdcall;
var
  GLFreeForm1: TGLFreeForm;
  ml: TGLMaterialLibrary;
  ml2: TGLMaterialLibrary;
begin
  ml:=TGLMaterialLibrary(trunc64(matl1));
  ml2:=TGLMaterialLibrary(trunc64(matl2));
  GLFreeForm1:=TGLFreeForm.Create(scene);
  TGLScene(scene).Objects.AddChild(GLFreeForm1);
  if not (parent=0) then GLFreeForm1.Parent:=TGLBaseSceneObject(trunc64(parent));
  GLFreeForm1.MaterialLibrary:=ml;
  GLFreeForm1.LightmapLibrary:=ml2;
  GLFreeForm1.LoadFromFile(fname);
  result:=Integer(GLFreeForm1);
end;

function FreeformMeshObjectsCount(ff: real): real; stdcall;
var
  GLFreeForm1: TGLFreeForm;
  mobj: integer;
begin
  GLFreeForm1:=TGLFreeForm(trunc64(ff));
  mobj:=GLFreeForm1.MeshObjects.Count;
  result:=mobj;
end;

function FreeformMeshSetVisible(ff,mesh,mode: real): real; stdcall;
var
  GLFreeForm1: TGLFreeForm;
begin
  GLFreeForm1:=TGLFreeForm(trunc64(ff));
  GLFreeForm1.MeshObjects[trunc64(mesh)].Visible:=boolean(trunc64(mode));
  GLFreeForm1.StructureChanged;
  result:=1;
end;

function FreeformMeshSetSecondCoords(ff1,mesh1,ff2,mesh2: real): real; stdcall;
var
  GLFreeForm1,GLFreeForm2: TGLFreeForm;
  tl: TAffineVectorList;
  sc: TTexPointList;
begin
  GLFreeForm1:=TGLFreeForm(trunc64(ff1));
  GLFreeForm2:=TGLFreeForm(trunc64(ff2));
  tl:=GLFreeForm2.MeshObjects[trunc64(mesh2)].TexCoords;
  sc:=TTexPointList(tl);
  GLFreeForm1.MeshObjects[trunc64(mesh1)].LightMapTexCoords:=sc;
  result:=1;
end;

function FreeformMeshTriangleCount(ff,mesh: real): real; stdcall;
var
  GLFreeForm1: TGLFreeForm;
  tri: integer;
begin
  GLFreeForm1:=TGLFreeForm(trunc64(ff));
  tri:=GLFreeForm1.MeshObjects[trunc64(mesh)].TriangleCount;
  result:=tri;
end;

function FreeformFaceGroupsCount(ff,mesh: real): real; stdcall;
var
  GLFreeForm1: TGLFreeForm;
  fgr: integer;
begin
  GLFreeForm1:=TGLFreeForm(trunc64(ff));
  fgr:=GLFreeForm1.MeshObjects[trunc64(mesh)].FaceGroups.Count;
  result:=fgr;
end;

function FreeformFaceGroupTriangleCount(ff,mesh,fgr: real): real; stdcall;
var
  GLFreeForm1: TGLFreeForm;
  tri: integer;
begin
  GLFreeForm1:=TGLFreeForm(trunc64(ff));
  tri:=GLFreeForm1.MeshObjects[trunc64(mesh)].FaceGroups[trunc64(fgr)].TriangleCount;
  result:=tri;
end;