/*
 * xtreme3d.h - main header file for the Xtreme3D engine
 * Version 1.0
 * 
 * Written by Timur Gafarov <clocktower89@mail.ru>
 * 
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is a part of the Xtreme3D C++ distribution.
 * 
 */

const double c_aqua    = 0xFFFF00;
const double c_black   = 0x000000;
const double c_blue    = 0xFF0000; 
const double c_dkgray  = 0x404040; 
const double c_fuchsia = 0xFF00FF; 
const double c_gray    = 0x808080; 
const double c_green   = 0x008000; 
const double c_lime    = 0x00FF00; 
const double c_ltgray  = 0xC0C0C0; 
const double c_maroon  = 0x000080; 
const double c_navy    = 0x800000; 
const double c_olive   = 0x008080; 
const double c_purple  = 0x800080; 
const double c_red     = 0x0000FF;  
const double c_silver  = 0xC0C0C0;
const double c_teal    = 0x808000;
const double c_white   = 0xFFFFFF;
const double c_yellow  = 0x00FFFF;
const double c_orange  = 0x0080FF;

const double osInherited                     = 0; 
const double osNone                          = 1; 
const double osRenderFarthestFirst           = 2; 
const double osRenderBlendedLast             = 3; 
const double osRenderNearestFirst            = 4; 

const double vcInherited                     = 0; 
const double vcNone                          = 1; 
const double vcObjectBased                   = 2; 
const double vcHierarchical                  = 3; 

const double vsmSync                         = 0; 
const double vsmNoSync                       = 1; 

const double cimNone                         = 0; 
const double cimPosition                     = 1; 
const double cimOrientation                  = 2; 

const double csPerspective                   = 0; 
const double csOrthogonal                    = 1; 
const double csOrtho2D                       = 2; 
const double csInfinitePerspective           = 3; 

const double lsSpot                          = 0; 
const double lsOmni                          = 1;
const double lsParallel                      = 2;

const double ndOutside                       = 0;
const double ndInside                        = 1; 

const double aamNone                         = 0; 
const double aamPlayOnce                     = 1; 
const double aamLoop                         = 2; 
const double aamBounceForward                = 3; 
const double aamBounceBackward               = 4; 
const double aamLoopBackward                 = 5; 

const double hrsFullGeometry                 = 0; 
const double hrsTesselated                   = 1; 

const double totTesselateAlways              = 0; 
const double totTesselateIfVisible           = 1; 

const double scNoOverlap                     = 0;
const double scContainsFully                 = 1; 
const double scContainsPartially             = 2; 

const double pmFill                          = 0; 
const double pmLines                         = 1; 
const double pmPoints                        = 2; 

const double tmmUser                         = 0; 
const double tmmObjectLinear                 = 1; 
const double tmmEyeLinear                    = 2; 
const double tmmSphere                       = 3; 
const double tmmCubeMapReflection            = 4; 
const double tmmCubeMapNormal                = 5; 
const double tmmCubeMapLight0                = 6;
const double tmmCubeMapCamera                = 7; 

const double tiaDefault                      = 0; 
const double tiaAlphaFromIntensity           = 1; 
const double tiaSuperBlackTransparent        = 2; 
const double tiaLuminance                    = 3; 
const double tiaLuminanceSqrt                = 4; 
const double tiaOpaque                       = 5; 
const double tiaTopLeftPointColorTransparent = 6; 
const double tiaInverseLuminance             = 7; 
const double tiaInverseLuminanceSqrt         = 8; 

const double tmDecal                         = 0; 
const double tmModulate                      = 1; 
const double tmBlend                         = 2; 
const double tmReplace                       = 3; 

const double bmOpaque                        = 0; 
const double bmTransparency                  = 1; 
const double bmAdditive                      = 2; 
const double bmAlphaTest50                   = 3; 
const double bmAlphaTest100                  = 4; 
const double bmModulate                      = 5; 

const double miNearest                       = 0; 
const double miLinear                        = 1; 
const double miNearestMipmapNearest          = 2; 
const double miLinearMipmapNearest           = 3; 
const double miNearestMipmapLinear           = 4; 
const double miLinearMipmapLinear            = 5; 

const double maNearest                       = 0; 
const double maLinear                        = 1; 

const double fcCull                          = 1; 
const double fcNoCull                        = 2; 

const double tfDefault                       = 0; 
const double tfRGB                           = 1; 
const double tfRGBA                          = 2; 
const double tfRGB16                         = 3; 
const double tfRGBA16                        = 4; 
const double tfAlpha                         = 5; 
const double tfLuminance                     = 6; 
const double tfLuminanceAlpha                = 7; 
const double tfIntensity                     = 8; 
const double tfNormalMap                     = 9; 
const double tfRGBAFloat16                   = 10;
const double tfRGBAFloat32                   = 11; 

const double tcDefault                       = 0; 
const double tcNone                          = 1; 
const double tcStandard                      = 2;
const double tcHighQuality                   = 3; 
const double tcHighSpeed                     = 4;
 
const double tfIsotropic                     = 0; 
const double tfAnisotropic                   = 1;

const double pNone                           = 0; 
const double pGlossy                         = 1; 
const double pBeastView                      = 2; 
const double pOceanDepth                     = 3; 
const double pDream                          = 4; 
const double pOverBlur                       = 5; 

const double sbmTop                          = 0; 
const double sbmBottom                       = 1; 
const double sbmLeft                         = 2; 

const double sbmRight                        = 3; 
const double sbmFront                        = 4; 
const double sbmBack                         = 5; 
const double sbmClouds                       = 6; 

const double sbsFull                         = 0; 
const double sbsTopHalf                      = 1; 
const double sbsBottomHalf                   = 2; 
const double sbsTopTwoThirds                 = 3; 
const double sbsTopHalfClamped               = 4; 

const double lsmLines                        = 0; 
const double lsmCubicSpline                  = 1; 
const double lsmBezierSpline                 = 2; 
const double lsmNURBSCurve                   = 3; 
const double lsmSegments                     = 4; 

const double lnaInvisible                    = 0; 
const double lnaAxes                         = 1; 
const double lnaCube                         = 2; 
const double lnaDodecahedron                 = 3; 

const double msUp                            = 0; 
const double msDirection                     = 1; 
const double msFaceCamera                    = 2; 

const double svmAccurate                     = 0; 
const double svmDarkening                    = 1; 
const double svmOff                          = 2; 

const double ccsDCEStandard                  = 0; 
const double ccsCollisionStandard            = 1; 
const double ccsHybrid                       = 1; 

const double csbSlide                        = 0; 
const double csbBounce                       = 1; 

const double csEllipsoid                     = 0; 
const double csBox                           = 1; 
const double csFreeform                      = 1; 

const double osmStep                         = 0; 
const double osmStepFast                     = 1; 
const double osmQuickStep                    = 1; 

const double cmFineCulling                   = 0; 
const double cmGrossCulling                  = 1; 

HMODULE hLibXtreme3D = LoadLibrary("Xtreme3D.dll");

typedef double (__stdcall * dFUNC)    ();
typedef double (__stdcall * dFUNC1d)  (double);
typedef double (__stdcall * dFUNC2d)  (double,double); 
typedef double (__stdcall * dFUNC3d)  (double,double,double); 
typedef double (__stdcall * dFUNC4d)  (double,double,double,double);
typedef double (__stdcall * dFUNC5d)  (double,double,double,double,double);
typedef double (__stdcall * dFUNC6d)  (double,double,double,double,double,double);
typedef double (__stdcall * dFUNC7d)  (double,double,double,double,double,double,double);
typedef double (__stdcall * dFUNC8d)  (double,double,double,double,double,double,double,double);
typedef double (__stdcall * dFUNC9d)  (double,double,double,double,double,double,double,double,double);
typedef double (__stdcall * dFUNC10d) (double,double,double,double,double,double,double,double,double,double);

typedef PCHAR  (__stdcall * pFUNC1d)  (double);
typedef double (__stdcall * dFUNC1p)  (PCHAR); 
typedef double (__stdcall * dFUNC2p)  (PCHAR,PCHAR); 
typedef double (__stdcall * dFUNCdp)  (double,PCHAR); 
typedef double (__stdcall * dFUNCpd)  (PCHAR,double); 
typedef double (__stdcall * dFUNCppd) (PCHAR,PCHAR,double); 
typedef double (__stdcall * dFUNCpdd) (PCHAR,double,double); 
typedef double (__stdcall * dFUNCddp) (double,double,PCHAR);
typedef double (__stdcall * dFUNCdpd) (double,PCHAR,double);
typedef double (__stdcall * dFUNCdpdd)(double,PCHAR,double,double);
typedef double (__stdcall * dFUNCpddd)(PCHAR,double,double,double);
typedef double (__stdcall * dFUNCdppp)(double,PCHAR,PCHAR,PCHAR);

static float GetFPS()
{
   static float FPSc = 0.0f;
   static float FPSr = 0.0f;
   float nextSecond = 0.0f;
   static float prevSecond = 0.0f;
   FPSc++;
   nextSecond = GetTickCount() * 0.001f;
   if(nextSecond - prevSecond > 1.0f)
      {
	  prevSecond = nextSecond;  
      FPSr = FPSc;
      FPSc = 0;
      }
   return FPSr;
}

